/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.cal;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ORMUtil;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.cal.CalculateUtils;

public class Cal4MultCurrencyObj {
    private static Log log = LogFactory.getLog(Cal4MultCurrencyObj.class);
    private String exRate = "exrate";
    private String entryquotatiton = "entryquotation";
    private Map<Long, DynamicObject> currMap = new HashMap<Long, DynamicObject>();

    public void calByQty(DynamicObject bill, String entryKey) {
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        String taxType = bill.getString("taxtype");
        for (DynamicObject entryCol : entryCols) {
            if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
                this.calEntryPriceOrTaxPrice(bill, entryCol);
                this.calEntryDiscountAmount(bill, entryCol);
                this.calEntryAmount(bill, entryCol);
                this.calEntryTax(bill, entryCol);
                this.calEntryTaxAmount(bill, entryCol);
                continue;
            }
            this.calEntryPriceOrTaxPrice(bill, entryCol);
            this.calEntryDiscountAmount(bill, entryCol);
            this.calEntryTaxAmount(bill, entryCol);
            this.calEntryTax(bill, entryCol);
            this.calEntryAmount(bill, entryCol);
        }
        this.calSum(bill, entryKey);
    }

    public void reCalBill(DynamicObject bill, String entryKey) {
        log.info(entryKey + "@Cal4MultCurrencyObj\u5f00\u59cb\u91cd\u7b97--------------------");
        String taxType = bill.getString("taxtype");
        boolean containTax = Cal4MultCurrencyObj.isContainTax(taxType);
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        for (DynamicObject entryCol : entryCols) {
            if (containTax) {
                this.calByTaxPrice(bill, entryCol);
                continue;
            }
            this.calByPrice(bill, entryCol);
        }
        this.calSum(bill, entryKey);
        log.info(entryKey + "@Cal4MultCurrencyObj\u91cd\u7b97\u7ed3\u675f--------------------");
    }

    public void calByPrice(DynamicObject bill, DynamicObject entry) {
        log.info("@Cal4MultCurrencyObj\u4e0d\u542b\u7a0e\u65f6-------------------------");
        this.calEntryPriceOrTaxPrice(bill, entry);
        this.calEntryDiscountAmount(bill, entry);
        this.calEntryAmount(bill, entry);
        this.calEntryTax(bill, entry);
        this.calEntryTaxAmount(bill, entry);
    }

    public void calByTaxPrice(DynamicObject bill, DynamicObject entry) {
        log.info("@Cal4MultCurrencyObj\u542b\u7a0e\u65f6\u8ba1\u7b97-------------------------");
        this.calEntryPriceOrTaxPrice(bill, entry);
        this.calEntryTaxAmount(bill, entry);
        this.calEntryTax(bill, entry);
        this.calEntryAmount(bill, entry);
        this.calEntryDiscountAmount(bill, entry);
    }

    public void calEntryPriceOrTaxPrice(DynamicObject bill, DynamicObject entry) {
        int scale = this.getPricePrecision(bill, entry);
        String taxType = bill.getString("taxtype");
        BigDecimal taxRate = CommonUtil.getBigDecimalPro(entry.get("taxrate"));
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxPrice = CommonUtil.getBigDecimalPro(entry.get("taxprice"));
            BigDecimal price = CalculateUtils.calPrice(taxPrice, taxRate, scale);
            entry.set("price", (Object)price);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxPrice = CommonUtil.getBigDecimalPro(entry.get("taxprice"));
            BigDecimal price = CalculateUtils.calPriceIsPriceInTax(taxRate, taxPrice, scale);
            entry.set("price", (Object)price);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal price = CommonUtil.getBigDecimalPro(entry.get("price"));
            BigDecimal taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
            entry.set("taxprice", (Object)taxPrice);
        }
    }

    public int getPricePrecision(DynamicObject bill, DynamicObject entry) {
        DynamicObject currency;
        DynamicObject currency2;
        long quotecurrId;
        int pricePrecision = 6;
        Object curr = entry.get("quotecurr");
        if (null == curr && (quotecurrId = entry.getLong("quotecurr_id")) != 0L && null != (currency2 = this.getCurrency(quotecurrId))) {
            return currency2.getInt("priceprecision");
        }
        if (curr instanceof DynamicObject) {
            DynamicObject currency3 = (DynamicObject)curr;
            pricePrecision = currency3.getInt("priceprecision");
        } else if (curr instanceof Long && null != (currency = this.getCurrency((Long)curr))) {
            pricePrecision = currency.getInt("priceprecision");
        }
        return pricePrecision;
    }

    public DynamicObject getCurrency(Long currId) {
        DynamicObject currency = this.currMap.get(currId);
        if (null == currency) {
            HashMap<String, Object> idMap = new HashMap<String, Object>(1);
            idMap.put("id", currId);
            currency = ORMUtil.querySingleByPro("bd_currency", "id,priceprecision,amtprecision", idMap);
            this.currMap.put(currId, currency);
        }
        return currency;
    }

    public void calEntryDiscountAmount(DynamicObject bill, DynamicObject entry) {
        BigDecimal qty = CommonUtil.getBigDecimalPro(entry.get("qty"));
        BigDecimal taxPrice = CommonUtil.getBigDecimalPro(entry.get("taxprice"));
        BigDecimal discountRate = CommonUtil.getBigDecimalPro(entry.get("dctrate"));
        BigDecimal discountAmount = CalConstant.BIGDECIMAL_ZERO;
        int scale = this.getAmtPrecision(bill, entry);
        discountAmount = CalculateUtils.calDiscountAmountByPercent(discountRate, qty, taxPrice, scale);
        entry.set("dctamount", (Object)discountAmount);
    }

    public int getAmtPrecision(DynamicObject bill, DynamicObject entry) {
        DynamicObject currency;
        int amtPrecision = 6;
        Object curr = entry.get("quotecurr");
        if (null != curr && curr instanceof DynamicObject) {
            DynamicObject currency2 = (DynamicObject)curr;
            amtPrecision = currency2.getInt("amtprecision");
        } else if (null != curr && curr instanceof Long && null != (currency = this.getCurrency((Long)curr))) {
            amtPrecision = currency.getInt("amtprecision");
        }
        return amtPrecision;
    }

    public void calEntryAmount(DynamicObject bill, DynamicObject entry) {
        BigDecimal amount = CalConstant.BIGDECIMAL_ZERO;
        int scale = this.getAmtPrecision(bill, entry);
        String taxType = bill.getString("taxtype");
        boolean containTax = Cal4MultCurrencyObj.isContainTax(taxType);
        if (containTax) {
            BigDecimal tax = CommonUtil.getBigDecimalPro(entry.get("tax"));
            BigDecimal taxAmount = CommonUtil.getBigDecimalPro(entry.get("taxamount"));
            amount = CalculateUtils.calAmountInTax(taxAmount, tax, scale);
        } else {
            BigDecimal qty = CommonUtil.getBigDecimalPro(entry.get("qty"));
            BigDecimal price = CommonUtil.getBigDecimalPro(entry.get("price"));
            BigDecimal discountRate = CommonUtil.getBigDecimalPro(entry.get("dctrate"));
            amount = CalculateUtils.calAmountByDiscountPercent(qty, price, discountRate, scale);
        }
        entry.set("amount", (Object)amount);
    }

    private static boolean isContainTax(String taxType) {
        boolean containTax = false;
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            containTax = true;
        }
        return containTax;
    }

    public void calEntryTax(DynamicObject bill, DynamicObject entry) {
        BigDecimal amount = CommonUtil.getBigDecimalPro(entry.get("amount"));
        BigDecimal taxRate = CommonUtil.getBigDecimalPro(entry.get("taxrate"));
        BigDecimal tax = CommonUtil.getBigDecimalPro(entry.get("tax"));
        BigDecimal taxAmount = CommonUtil.getBigDecimalPro(entry.get("taxamount"));
        String taxType = bill.getString("taxtype");
        int scale = this.getAmtPrecision(bill, entry);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceExludeTax(taxAmount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTax(amount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceInludeTax(taxAmount, taxRate, scale);
        }
        entry.set("tax", (Object)tax);
    }

    public void calEntryTaxAmount(DynamicObject bill, DynamicObject entry) {
        BigDecimal taxAmount = CalConstant.BIGDECIMAL_ZERO;
        BigDecimal discountRate = CommonUtil.getBigDecimalPro(entry.get("dctrate"));
        int scale = this.getAmtPrecision(bill, entry);
        String taxType = bill.getString("taxtype");
        boolean containTax = Cal4MultCurrencyObj.isContainTax(taxType);
        if (containTax) {
            BigDecimal qty = CommonUtil.getBigDecimalPro(entry.get("qty"));
            BigDecimal taxPrice = CommonUtil.getBigDecimalPro(entry.get("taxprice"));
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent(qty, taxPrice, discountRate, scale);
        } else {
            BigDecimal amount = CommonUtil.getBigDecimalPro(entry.get("amount"));
            BigDecimal tax = CommonUtil.getBigDecimalPro(entry.get("tax"));
            taxAmount = CalculateUtils.calTaxAmount(amount, tax, scale);
        }
        entry.set("taxamount", (Object)taxAmount);
    }

    public void calSum(DynamicObject bill, String entryKey) {
        BigDecimal[] sum = this.calAndGetSum(bill, entryKey, this.exRate, this.entryquotatiton);
        if (sum != null && sum.length == 3) {
            bill.set("sumtax", (Object)sum[0]);
            bill.set("sumamount", (Object)sum[1]);
            bill.set("sumtaxamount", (Object)sum[2]);
        }
    }

    public BigDecimal[] calAndGetSum(DynamicObject bill, String entryKey, String exrate) {
        return this.calAndGetSum(bill, entryKey, exrate, null);
    }

    public BigDecimal[] calAndGetSum(DynamicObject bill, String entryKey, String exrate, String quotation) {
        BigDecimal[] sum = new BigDecimal[]{CalConstant.BIGDECIMAL_ZERO, CalConstant.BIGDECIMAL_ZERO, CalConstant.BIGDECIMAL_ZERO};
        BigDecimal sumTax = CalConstant.BIGDECIMAL_ZERO;
        BigDecimal sumAmount = CalConstant.BIGDECIMAL_ZERO;
        BigDecimal sumTaxAmount = CalConstant.BIGDECIMAL_ZERO;
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        BigDecimal rate = null;
        BigDecimal midValue = null;
        for (DynamicObject entryCol : entryCols) {
            rate = entryCol.getBigDecimal(exrate);
            String entryquotation = null;
            if (quotation != null) {
                entryquotation = entryCol.getString(quotation);
            }
            midValue = entryCol.getBigDecimal("amount");
            int scale = this.getCurrAmPrecision(bill);
            midValue = this.convertByExrate(midValue, rate, scale, entryquotation);
            sumAmount = sumAmount.add(midValue);
            midValue = CommonUtil.getBigDecimalPro(entryCol.get("tax"));
            midValue = this.convertByExrate(midValue, rate, scale, entryquotation);
            sumTax = sumTax.add(midValue);
            midValue = CommonUtil.getBigDecimalPro(entryCol.get("taxamount"));
            midValue = this.convertByExrate(midValue, rate, scale, entryquotation);
            sumTaxAmount = sumTaxAmount.add(midValue);
        }
        sum[0] = sumTax;
        sum[1] = sumAmount;
        sum[2] = sumTaxAmount;
        return sum;
    }

    public BigDecimal convertByExrate(BigDecimal value, BigDecimal exrate, int scale) {
        if (exrate != null && BigDecimal.ZERO.compareTo(exrate) != 0 && value != null) {
            return value.setScale(scale, 4).multiply(exrate).setScale(scale, 4);
        }
        return value;
    }

    public BigDecimal convertByExrate(BigDecimal value, BigDecimal exrate, int scale, String quotation) {
        if (exrate != null && BigDecimal.ZERO.compareTo(exrate) != 0 && value != null) {
            value = quotation != null && quotation.equals("1") ? value.divide(exrate, scale, 4) : this.convertByExrate(value, exrate, scale);
        }
        return value;
    }

    public static void calCost(DynamicObject bill, String entryKey) {
        bill.set("sumcost", (Object)"0");
        bill.set("totalamount", (Object)bill.getBigDecimal("sumtaxamount"));
    }

    public int getCurrAmPrecision(DynamicObject bill) {
        DynamicObject currency;
        int amtPrecision = 6;
        Object curr = bill.get("curr");
        if (null != curr && curr instanceof DynamicObject) {
            DynamicObject currency2 = (DynamicObject)curr;
            amtPrecision = currency2.getInt("amtprecision");
        } else if (null != curr && curr instanceof Long && null != (currency = this.getCurrency((Long)curr))) {
            amtPrecision = currency.getInt("amtprecision");
        }
        return amtPrecision;
    }
}

