/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.cal;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.ORMUtil;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.cal.CalculateUtils;

public class Cal4PlainDynamicObj {
    private static Log log = LogFactory.getLog(Cal4PlainDynamicObj.class);
    private static Map<Long, DynamicObject> currMap = new HashMap<Long, DynamicObject>();

    public static void calByQty(DynamicObjectCollection cols, String entryKey) {
        for (DynamicObject col : cols) {
            Cal4PlainDynamicObj.calEntryPriceOrTaxPrice(col);
            Cal4PlainDynamicObj.calEntryDiscountAmount(col);
            Cal4PlainDynamicObj.calEntryTaxAmount(col);
            Cal4PlainDynamicObj.calEntryTax(col);
            Cal4PlainDynamicObj.calEntryAmount(col);
        }
        Cal4PlainDynamicObj.releaseData();
    }

    public static void calByTaxAmount(DynamicObjectCollection cols, String entryKey) {
        for (DynamicObject col : cols) {
            Cal4PlainDynamicObj.calEntryTaxAmount(col);
            Cal4PlainDynamicObj.calEntryPriceOrTaxPrice(col);
            Cal4PlainDynamicObj.calEntryTax(col);
        }
        Cal4PlainDynamicObj.releaseData();
    }

    public static void reCalBill(DynamicObjectCollection cols, String entryKey) {
        log.info(entryKey + "@\u5f00\u59cb\u91cd\u7b97--------------------");
        for (DynamicObject col : cols) {
            String taxType = col.getString("taxtype");
            boolean containTax = Cal4PlainDynamicObj.isContainTax(taxType);
            if (containTax) {
                Cal4PlainDynamicObj.calByTaxPrice(col);
                continue;
            }
            Cal4PlainDynamicObj.calByPrice(col);
        }
        Cal4PlainDynamicObj.releaseData();
        log.info(entryKey + "@\u91cd\u7b97\u7ed3\u675f--------------------");
    }

    public static void calByPrice(DynamicObject col) {
        log.info("@\u4e0d\u542b\u7a0e\u65f6-------------------------");
        Cal4PlainDynamicObj.calEntryPriceOrTaxPrice(col);
        Cal4PlainDynamicObj.calEntryDiscountAmount(col);
        Cal4PlainDynamicObj.calEntryAmount(col);
        Cal4PlainDynamicObj.calEntryTax(col);
        Cal4PlainDynamicObj.calEntryTaxAmount(col);
    }

    public static void calByTaxPrice(DynamicObject col) {
        log.info("@\u542b\u7a0e\u65f6\u8ba1\u7b97-------------------------");
        Cal4PlainDynamicObj.calEntryPriceOrTaxPrice(col);
        Cal4PlainDynamicObj.calEntryTaxAmount(col);
        Cal4PlainDynamicObj.calEntryTax(col);
        Cal4PlainDynamicObj.calEntryAmount(col);
        Cal4PlainDynamicObj.calEntryDiscountAmount(col);
    }

    public static void calEntryPriceOrTaxPrice(DynamicObject col) {
        int scale = Cal4PlainDynamicObj.getPricePrecision(col);
        String taxType = col.getString("taxtype");
        BigDecimal taxRate = CommonUtil.getBigDecimalPro(col.get("taxrate"));
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxPrice = CommonUtil.getBigDecimalPro(col.get("taxprice"));
            BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
            price = CalculateUtils.calPrice(taxPrice, taxRate, scale);
            col.set("price", (Object)price);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxPrice = CommonUtil.getBigDecimalPro(col.get("taxprice"));
            BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
            price = CalculateUtils.calPriceIsPriceInTax(taxRate, taxPrice, scale);
            col.set("price", (Object)price);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal price = CommonUtil.getBigDecimalPro(col.get("price"));
            BigDecimal taxPrice = CalConstant.BIGDECIMAL_ZERO;
            taxPrice = CalculateUtils.calTaxPrice(price, taxRate, scale);
            col.set("taxprice", (Object)taxPrice);
        }
    }

    public static void calEntryDiscountAmount(DynamicObject col) {
        BigDecimal qty = CommonUtil.getBigDecimalPro(col.get("qty"));
        BigDecimal taxPrice = CommonUtil.getBigDecimalPro(col.get("taxprice"));
        BigDecimal discountRate = CommonUtil.getBigDecimalPro(col.get("dctrate"));
        BigDecimal discountAmount = CalConstant.BIGDECIMAL_ZERO;
        int scale = Cal4PlainDynamicObj.getAmtPrecision(col);
        discountAmount = CalculateUtils.calDiscountAmountByPercent(discountRate, qty, taxPrice, scale);
        col.set("dctamount", (Object)discountAmount);
    }

    public static void calEntryTaxAmount(DynamicObject col) {
        BigDecimal taxAmount = CalConstant.BIGDECIMAL_ZERO;
        BigDecimal discountRate = CommonUtil.getBigDecimalPro(col.get("dctrate"));
        int scale = Cal4PlainDynamicObj.getAmtPrecision(col);
        String taxType = col.getString("taxtype");
        boolean containTax = Cal4PlainDynamicObj.isContainTax(taxType);
        if (containTax) {
            BigDecimal qty = CommonUtil.getBigDecimalPro(col.get("qty"));
            BigDecimal taxPrice = CommonUtil.getBigDecimalPro(col.get("taxprice"));
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent(qty, taxPrice, discountRate, scale);
        } else {
            BigDecimal amount = CommonUtil.getBigDecimalPro(col.get("amount"));
            BigDecimal tax = CommonUtil.getBigDecimalPro(col.get("tax"));
            taxAmount = CalculateUtils.calTaxAmount(amount, tax, scale);
        }
        col.set("taxamount", (Object)taxAmount);
    }

    public static void calEntryTax(DynamicObject col) {
        BigDecimal amount = CommonUtil.getBigDecimalPro(col.get("amount"));
        BigDecimal taxRate = CommonUtil.getBigDecimalPro(col.get("taxrate"));
        BigDecimal tax = CommonUtil.getBigDecimalPro(col.get("tax"));
        BigDecimal taxAmount = CommonUtil.getBigDecimalPro(col.get("taxamount"));
        String taxType = col.getString("taxtype");
        int scale = Cal4PlainDynamicObj.getAmtPrecision(col);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceExludeTax(taxAmount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTax(amount, taxRate, scale);
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            tax = CalculateUtils.calTaxWhenPriceInludeTax(taxAmount, taxRate, scale);
        }
        col.set("tax", (Object)tax);
    }

    public static void calEntryAmount(DynamicObject col) {
        BigDecimal amount = CalConstant.BIGDECIMAL_ZERO;
        int scale = Cal4PlainDynamicObj.getAmtPrecision(col);
        String taxType = col.getString("taxtype");
        boolean containTax = Cal4PlainDynamicObj.isContainTax(taxType);
        if (containTax) {
            BigDecimal tax = CommonUtil.getBigDecimalPro(col.get("tax"));
            BigDecimal taxAmount = CommonUtil.getBigDecimalPro(col.get("taxamount"));
            amount = CalculateUtils.calAmountInTax(taxAmount, tax, scale);
        } else {
            BigDecimal qty = CommonUtil.getBigDecimalPro(col.get("qty"));
            BigDecimal price = CommonUtil.getBigDecimalPro(col.get("price"));
            BigDecimal discountRate = CommonUtil.getBigDecimalPro(col.get("dctrate"));
            amount = CalculateUtils.calAmountByDiscountPercent(qty, price, discountRate, scale);
        }
        col.set("amount", (Object)amount);
    }

    private static boolean isContainTax(String taxType) {
        boolean containTax = false;
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            containTax = true;
        }
        return containTax;
    }

    public static void calSum(DynamicObject bill, String entryKey) {
        DynamicObjectCollection entryCols = bill.getDynamicObjectCollection(entryKey);
        BigDecimal sumTax = CalConstant.BIGDECIMAL_ZERO;
        BigDecimal sumAmount = CalConstant.BIGDECIMAL_ZERO;
        BigDecimal sumTaxAmount = CalConstant.BIGDECIMAL_ZERO;
        for (DynamicObject entryCol : entryCols) {
            BigDecimal tax = CommonUtil.getBigDecimalPro(entryCol.get("tax"));
            BigDecimal taxAmount = CommonUtil.getBigDecimalPro(entryCol.get("taxamount"));
            BigDecimal amount = CommonUtil.getBigDecimalPro(entryCol.get("amount"));
            sumTax = sumTax.add(tax);
            sumAmount = sumAmount.add(amount);
            sumTaxAmount = sumTaxAmount.add(taxAmount);
        }
        bill.set("sumtax", (Object)sumTax);
        bill.set("sumtaxamount", (Object)sumTaxAmount);
        bill.set("sumamount", (Object)sumAmount);
    }

    public static int getScale(DynamicObject col) {
        return 6;
    }

    public static int getAmtPrecision(DynamicObject col) {
        int amtPrecision = 6;
        Object curr = col.get("curr");
        if (null != curr && curr instanceof DynamicObject) {
            DynamicObject currency = (DynamicObject)curr;
            amtPrecision = currency.getInt("amtprecision");
        } else if (null != curr && curr instanceof Long) {
            DynamicObject currency = Cal4PlainDynamicObj.getCurrency((Long)curr);
            amtPrecision = currency.getInt("amtprecision");
        }
        return amtPrecision;
    }

    public static int getPricePrecision(DynamicObject col) {
        int pricePrecision = 6;
        Object curr = col.get("curr");
        if (null != curr && curr instanceof DynamicObject) {
            DynamicObject currency = (DynamicObject)curr;
            pricePrecision = currency.getInt("priceprecision");
        } else if (null != curr && curr instanceof Long) {
            DynamicObject currency = Cal4PlainDynamicObj.getCurrency((Long)curr);
            pricePrecision = currency.getInt("priceprecision");
        }
        return pricePrecision;
    }

    public static void calCost(DynamicObject bill, String entryKey) {
        bill.set("sumcost", (Object)"0");
    }

    public static DynamicObject getCurrency(Long currId) {
        DynamicObject currency = currMap.get(currId);
        if (null == currency) {
            HashMap<String, Object> idMap = new HashMap<String, Object>(1);
            idMap.put("id", currId);
            currency = ORMUtil.querySingleByPro("bd_currency", "id,priceprecision,amtprecision", idMap);
            currMap.put(currId, currency);
        }
        return currency;
    }

    public static void releaseData() {
        currMap.clear();
    }
}

