/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.cal;

import java.math.BigDecimal;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.NumberUtils;

public final class CalculateUtils {
    private static BigDecimal ZERO = CalConstant.BIGDECIMAL_ZERO;
    private static BigDecimal ONE = CalConstant.BIGDECIMAL_ONE;
    private static BigDecimal ONEHUNDRED = CalConstant.BIGDECIMAL_ONEHUNDRED;

    private CalculateUtils() {
    }

    private static int getScale(BigDecimal num) {
        return num.scale() + 2;
    }

    private static int getScale(int scale) {
        return scale + 8;
    }

    public static BigDecimal calDiscountAmountByTaxAmount(BigDecimal taxPrice, BigDecimal qty, BigDecimal taxAmount, int scale) {
        return NumberUtils.effectualNumeric(taxPrice).multiply(NumberUtils.effectualNumeric(qty)).subtract(NumberUtils.effectualNumeric(taxAmount)).setScale(scale, 4);
    }

    public static BigDecimal calDiscountRateByActualTaxPrice(BigDecimal actualTaxPrice, BigDecimal taxPrice, int scale) {
        BigDecimal discountRate = ONE;
        if (!NumberUtils.equalsZero(taxPrice)) {
            discountRate = ONE.subtract(NumberUtils.effectualNumeric(actualTaxPrice).divide(NumberUtils.effectualNumeric(taxPrice), 10, 4));
        }
        discountRate = discountRate.multiply(ONEHUNDRED).setScale(scale, 4);
        return discountRate;
    }

    public static BigDecimal calDiscountAmountByPercentNoScale(String discountType, BigDecimal discount, BigDecimal qty, BigDecimal taxPrice, String taxType, BigDecimal taxRate, int scale) {
        if (discount == null || qty == null || taxPrice == null) {
            return ZERO;
        }
        if ("B".equals(discountType)) {
            if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
                BigDecimal discountAmount = discount.multiply(qty);
                return discountAmount;
            }
            taxRate = taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4);
            BigDecimal discountAmount = discount.multiply(qty).multiply(ONE.add(taxRate));
            return discountAmount;
        }
        return CalculateUtils.calDiscountAmountByPercentNoScale(discount, qty, taxPrice, scale);
    }

    public static BigDecimal calDiscountAmountByPercentNoScale(BigDecimal discount, BigDecimal qty, BigDecimal taxPrice, int scale) {
        if (discount == null || qty == null || taxPrice == null) {
            return ZERO;
        }
        discount = discount.divide(ONEHUNDRED, CalculateUtils.getScale(discount), 4);
        BigDecimal discountAmount = ZERO;
        discountAmount = taxPrice.multiply(qty).multiply(discount);
        return discountAmount;
    }

    public static BigDecimal calDiscountAmountByPercent(BigDecimal discount, BigDecimal qty, BigDecimal taxPrice, int scale) {
        BigDecimal discountAmount = CalculateUtils.calDiscountAmountByPercentNoScale(discount, qty, taxPrice, scale);
        discountAmount = discountAmount.setScale(scale, 4);
        return discountAmount;
    }

    public static BigDecimal calDiscountByPercentByExTax(String discountType, BigDecimal discountAmount, BigDecimal qty, BigDecimal taxPrice, BigDecimal taxRate, int scale) {
        if (discountAmount == null || qty == null || taxPrice == null) {
            return ZERO;
        }
        if ("B".equals(discountType)) {
            discountAmount = NumberUtils.effectualNumeric(discountAmount);
            taxPrice = NumberUtils.effectualNumeric(taxPrice);
            BigDecimal taxRateAdd1 = ONE.add(taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4));
            BigDecimal discount = NumberUtils.effectualNumeric(discountAmount).divide(taxRateAdd1.multiply(qty), scale, 4);
            discount = discount.setScale(scale, 4);
            return discount;
        }
        return CalculateUtils.calDiscountByPercent(discountAmount, qty, taxPrice, scale);
    }

    public static BigDecimal calDiscountByPercent(String discountType, BigDecimal discountAmount, BigDecimal qty, BigDecimal taxPrice, int scale) {
        if (discountAmount == null || qty == null || taxPrice == null) {
            return ZERO;
        }
        if ("B".equals(discountType)) {
            discountAmount = NumberUtils.effectualNumeric(discountAmount);
            BigDecimal discount = discountAmount.divide(qty, scale, 4);
            return discount;
        }
        return CalculateUtils.calDiscountByPercent(discountAmount, qty, taxPrice, scale);
    }

    public static BigDecimal calDiscountByPercent(BigDecimal discountAmount, BigDecimal qty, BigDecimal taxPrice, int scale) {
        if (discountAmount == null || qty == null || taxPrice == null) {
            return ZERO;
        }
        BigDecimal discount = ZERO;
        if (qty.compareTo(ZERO) > 0 && taxPrice.compareTo(ZERO) > 0) {
            discount = NumberUtils.effectualNumeric(discountAmount).multiply(ONEHUNDRED).divide(NumberUtils.effectualNumeric(taxPrice).multiply(qty), scale, 4);
        }
        return discount;
    }

    public static BigDecimal calDiscountAmountByPerunit(BigDecimal discountRate, BigDecimal qty, BigDecimal taxRate, int scale, boolean isInTax) {
        if (taxRate == null) {
            taxRate = ZERO;
        }
        if (discountRate == null || qty == null || taxRate == null) {
            return ZERO;
        }
        BigDecimal discountAmount = null;
        discountAmount = qty.multiply(discountRate);
        if (!isInTax) {
            discountAmount = discountAmount.multiply(ONE.add(taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4)));
        }
        discountAmount = discountAmount.setScale(scale, 4);
        return discountAmount;
    }

    public static BigDecimal calTaxPrice(BigDecimal price, BigDecimal taxRate, int scale) {
        BigDecimal taxPrice = CalculateUtils.calTaxPriceNoScale(price, taxRate, scale);
        taxPrice = taxPrice.setScale(scale, 4);
        return taxPrice;
    }

    public static BigDecimal calTaxPriceNoScale(BigDecimal price, BigDecimal taxRate, int scale) {
        if (price == null) {
            return ZERO;
        }
        taxRate = NumberUtils.effectualNumeric(taxRate);
        BigDecimal taxPrice = null;
        taxRate = taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4);
        taxPrice = price.multiply(ONE.add(taxRate));
        return taxPrice;
    }

    public static BigDecimal calTaxPriceInTax(BigDecimal price, BigDecimal taxRate, int scale) {
        if (price == null) {
            return ZERO;
        }
        taxRate = NumberUtils.effectualNumeric(taxRate);
        BigDecimal taxPrice = null;
        taxRate = taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4);
        taxPrice = price.setScale(scale, 4).divide(ONE.subtract(taxRate), scale, 4);
        return taxPrice;
    }

    public static BigDecimal calTaxAmountByAmount(BigDecimal amount, BigDecimal taxRate, int scale) {
        amount = NumberUtils.effectualNumeric(amount);
        taxRate = NumberUtils.effectualNumeric(taxRate);
        BigDecimal totalTaxAmount = null;
        taxRate = taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4);
        totalTaxAmount = amount.multiply(ONE.add(taxRate));
        totalTaxAmount = totalTaxAmount.setScale(scale, 4);
        return totalTaxAmount;
    }

    public static BigDecimal calTaxAmountByPrice(String discountType, BigDecimal qty, BigDecimal price, BigDecimal discount, BigDecimal taxRate, int scale) {
        price = NumberUtils.effectualNumeric(price);
        qty = NumberUtils.effectualNumeric(qty);
        BigDecimal totalTaxAmount = null;
        taxRate = taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4);
        BigDecimal taxAmount = BigDecimal.ZERO;
        if ("B".equals(discountType)) {
            discount = NumberUtils.effectualNumeric(discount);
            taxAmount = qty.multiply(price.subtract(discount));
        } else {
            discount = discount.divide(ONEHUNDRED, CalculateUtils.getScale(discount), 4);
            taxAmount = qty.multiply(price).multiply(ONE.subtract(discount));
        }
        taxAmount = taxAmount.setScale(scale, 4);
        BigDecimal tax = taxAmount.multiply(taxRate).setScale(scale, 4);
        totalTaxAmount = taxAmount.add(tax);
        return totalTaxAmount;
    }

    public static BigDecimal calTaxPrice(String discountType, BigDecimal taxAmount, BigDecimal qty, BigDecimal discountRate, int scale) {
        BigDecimal taxPrice = CalculateUtils.calTaxPriceNoScale(discountType, taxAmount, qty, discountRate, scale);
        taxPrice = taxPrice.setScale(scale, 4);
        return taxPrice;
    }

    public static BigDecimal calTaxPriceNoScale(String discountType, BigDecimal taxAmount, BigDecimal qty, BigDecimal discountRate, int scale) {
        if (qty == null || qty.compareTo(ZERO) == 0) {
            return ZERO;
        }
        if (taxAmount == null || ZERO.compareTo(taxAmount) == 0) {
            return ZERO;
        }
        if ("B".equals(discountType)) {
            discountRate = NumberUtils.effectualNumeric(discountRate);
            taxAmount = NumberUtils.effectualNumeric(taxAmount);
            BigDecimal taxPrice = taxAmount.divide(qty, CalculateUtils.getScale(scale), 4).add(discountRate);
            return taxPrice;
        }
        taxAmount = NumberUtils.effectualNumeric(taxAmount);
        discountRate = NumberUtils.effectualNumeric(discountRate);
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal subRate = ONE.subtract(discountRate = discountRate.divide(ONEHUNDRED, CalculateUtils.getScale(discountRate), 4));
        if (subRate == null || ZERO.compareTo(subRate) == 0) {
            return ZERO;
        }
        taxPrice = taxAmount.divide(qty, CalculateUtils.getScale(scale), 4).divide(subRate, CalculateUtils.getScale(scale), 4);
        return taxPrice;
    }

    public static BigDecimal calTaxPrice(BigDecimal taxAmount, BigDecimal qty, BigDecimal discountRate, int scale) {
        if (qty == null || qty.compareTo(ZERO) == 0) {
            return ZERO;
        }
        if (taxAmount == null || ZERO.compareTo(taxAmount) == 0) {
            return ZERO;
        }
        taxAmount = NumberUtils.effectualNumeric(taxAmount);
        discountRate = NumberUtils.effectualNumeric(discountRate);
        BigDecimal taxPrice = null;
        BigDecimal subRate = ONE.subtract(discountRate = discountRate.divide(ONEHUNDRED, CalculateUtils.getScale(discountRate), 4));
        if (subRate == null || ZERO.compareTo(subRate) == 0) {
            return ZERO;
        }
        taxPrice = taxAmount.divide(qty, CalculateUtils.getScale(scale), 4).divide(subRate, CalculateUtils.getScale(scale), 4);
        taxPrice = taxPrice.setScale(scale, 4);
        return taxPrice;
    }

    public static BigDecimal calActualPrice(BigDecimal amount, BigDecimal qty, int scale) {
        amount = NumberUtils.effectualNumeric(amount);
        if ((qty = NumberUtils.effectualNumeric(qty)).compareTo(ZERO) == 0) {
            return ZERO;
        }
        return amount.divide(qty, scale, 4);
    }

    public static BigDecimal calActualTaxPrice(BigDecimal taxAmount, BigDecimal qty, int scale) {
        taxAmount = NumberUtils.effectualNumeric(taxAmount);
        if ((qty = NumberUtils.effectualNumeric(qty)).compareTo(ZERO) == 0) {
            return ZERO;
        }
        BigDecimal actualPrice = taxAmount.divide(qty, scale, 4);
        return actualPrice;
    }

    public static BigDecimal calActualPriceByPercent(BigDecimal discountRate, BigDecimal price, int scale) {
        if (price == null) {
            return ZERO;
        }
        discountRate = NumberUtils.effectualNumeric(discountRate);
        discountRate = discountRate.divide(ONEHUNDRED, CalculateUtils.getScale(discountRate), 4);
        BigDecimal actualPrice = null;
        actualPrice = price.multiply(ONE.subtract(discountRate));
        actualPrice = actualPrice.setScale(scale, 4);
        return actualPrice;
    }

    public static BigDecimal calActualTaxPriceByPercent(BigDecimal taxPrice, BigDecimal discountRate, int scale) {
        if (taxPrice == null) {
            return ZERO;
        }
        discountRate = NumberUtils.effectualNumeric(discountRate);
        discountRate = discountRate.divide(ONEHUNDRED, CalculateUtils.getScale(discountRate), 4);
        BigDecimal discountTaxPrice = taxPrice.multiply(ONE.subtract(discountRate));
        discountTaxPrice = discountTaxPrice.setScale(scale, 4);
        return discountTaxPrice;
    }

    public static BigDecimal calAmount(BigDecimal qty, BigDecimal actualPrice, int scale) {
        if (qty == null || actualPrice == null) {
            return ZERO;
        }
        BigDecimal amount = NumberUtils.effectualNumeric(qty).multiply(NumberUtils.effectualNumeric(actualPrice));
        amount = amount.setScale(scale, 4);
        return amount;
    }

    public static BigDecimal calAmountInTax(BigDecimal taxAmount, BigDecimal tax, int scale) {
        BigDecimal amount = CalculateUtils.calAmountInTaxNoScale(taxAmount, tax, scale);
        amount = amount.setScale(scale, 4);
        return amount;
    }

    public static BigDecimal calAmountInTaxNoScale(BigDecimal taxAmount, BigDecimal tax, int scale) {
        taxAmount = NumberUtils.effectualNumeric(taxAmount);
        tax = NumberUtils.effectualNumeric(tax);
        BigDecimal amount = taxAmount.subtract(tax);
        return amount;
    }

    public static BigDecimal calAmountByDiscountPercent(String discountType, BigDecimal qty, BigDecimal price, BigDecimal discountRate, int scale) {
        BigDecimal amount = CalculateUtils.calAmountByDiscountPercentNoScale(discountType, qty, price, discountRate, scale);
        amount = amount.setScale(scale, 4);
        return amount;
    }

    public static BigDecimal calAmountByDiscountPercentNoScale(String discountType, BigDecimal qty, BigDecimal price, BigDecimal discountRate, int scale) {
        if ("B".equals(discountType)) {
            discountRate = NumberUtils.effectualNumeric(discountRate);
            qty = NumberUtils.effectualNumeric(qty);
            price = NumberUtils.effectualNumeric(price);
            BigDecimal discountAmount = qty.multiply(price.subtract(discountRate));
            return discountAmount;
        }
        return CalculateUtils.calAmountByDiscountPercentNoScale(qty, price, discountRate, scale);
    }

    public static BigDecimal calAmountByDiscountPercent(BigDecimal qty, BigDecimal price, BigDecimal discountRate, int scale) {
        BigDecimal amount = CalculateUtils.calAmountByDiscountPercentNoScale(qty, price, discountRate, scale);
        amount = amount.setScale(scale, 4);
        return amount;
    }

    public static BigDecimal calAmountByDiscountPercentNoScale(BigDecimal qty, BigDecimal price, BigDecimal discountRate, int scale) {
        qty = NumberUtils.effectualNumeric(qty);
        price = NumberUtils.effectualNumeric(price);
        discountRate = NumberUtils.effectualNumeric(discountRate);
        discountRate = discountRate.divide(ONEHUNDRED, CalculateUtils.getScale(discountRate), 4);
        BigDecimal amount = qty.multiply(price).multiply(ONE.subtract(discountRate));
        return amount;
    }

    public static BigDecimal calTaxNoScale(BigDecimal amount, BigDecimal taxRate, int scale) {
        if (amount == null || taxRate == null) {
            return ZERO;
        }
        taxRate = NumberUtils.effectualNumeric(taxRate);
        taxRate = taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4);
        BigDecimal tax = amount.multiply(taxRate);
        return tax;
    }

    public static BigDecimal calTax(BigDecimal amount, BigDecimal taxRate, int scale) {
        BigDecimal tax = CalculateUtils.calTaxNoScale(amount, taxRate, scale);
        tax = tax.setScale(scale, 4);
        return tax;
    }

    public static BigDecimal calTaxWhenPriceExludeTaxNoScale(BigDecimal taxAmount, BigDecimal taxRate, int scale) {
        taxAmount = NumberUtils.effectualNumeric(taxAmount);
        taxRate = NumberUtils.effectualNumeric(taxRate);
        taxRate = taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4);
        BigDecimal tax = ZERO;
        if (taxRate.compareTo(ONE) != 0) {
            tax = taxAmount.divide(ONE.add(taxRate), CalculateUtils.getScale(scale), 4).multiply(taxRate);
        }
        return tax;
    }

    public static BigDecimal calTaxWhenPriceExludeTax(BigDecimal taxAmount, BigDecimal taxRate, int scale) {
        BigDecimal tax = CalculateUtils.calTaxWhenPriceExludeTaxNoScale(taxAmount, taxRate, scale);
        tax = tax.setScale(scale, 4);
        return tax;
    }

    public static BigDecimal calTaxWhenPriceInludeTaxNoScale(BigDecimal taxAmount, BigDecimal taxRate, int scale) {
        taxAmount = NumberUtils.effectualNumeric(taxAmount);
        taxRate = NumberUtils.effectualNumeric(taxRate);
        taxRate = taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4);
        BigDecimal tax = taxAmount.multiply(taxRate);
        return tax;
    }

    public static BigDecimal calTaxWhenPriceInludeTax(BigDecimal taxAmount, BigDecimal taxRate, int scale) {
        BigDecimal tax = CalculateUtils.calTaxWhenPriceInludeTaxNoScale(taxAmount, taxRate, scale);
        tax = tax.setScale(scale, 4);
        return tax;
    }

    public static BigDecimal calTaxAmount(BigDecimal amount, BigDecimal tax, int scale) {
        amount = NumberUtils.effectualNumeric(amount);
        tax = NumberUtils.effectualNumeric(tax);
        BigDecimal totalTaxAmount = amount.add(tax);
        return totalTaxAmount;
    }

    public static BigDecimal calTaxAmountByDiscountPercent(String discountType, BigDecimal qty, BigDecimal taxPrice, BigDecimal discountRate, int scale) {
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        qty = NumberUtils.effectualNumeric(qty);
        taxPrice = NumberUtils.effectualNumeric(taxPrice);
        if ("B".equals(discountType)) {
            discountRate = NumberUtils.effectualNumeric(discountRate);
            BigDecimal discountAmount = qty.multiply(discountRate).setScale(scale, 4);
            totalTaxAmount = qty.multiply(taxPrice).subtract(discountAmount);
        } else {
            discountRate = NumberUtils.effectualNumeric(discountRate);
            discountRate = discountRate.divide(ONEHUNDRED, CalculateUtils.getScale(discountRate), 4);
            BigDecimal discountAmount = qty.multiply(taxPrice).multiply(discountRate).setScale(scale, 4);
            totalTaxAmount = qty.multiply(taxPrice).subtract(discountAmount);
        }
        return totalTaxAmount;
    }

    public static BigDecimal calTaxAmountByDiscountPercent(BigDecimal qty, BigDecimal taxPrice, BigDecimal discountRate, int scale) {
        qty = NumberUtils.effectualNumeric(qty);
        taxPrice = NumberUtils.effectualNumeric(taxPrice);
        discountRate = NumberUtils.effectualNumeric(discountRate);
        BigDecimal totalTaxAmount = qty.multiply(taxPrice).multiply(ONE.subtract(discountRate.divide(ONEHUNDRED, CalculateUtils.getScale(discountRate), 4)));
        totalTaxAmount = totalTaxAmount.setScale(scale, 4);
        return totalTaxAmount;
    }

    public static BigDecimal calPrepayment(BigDecimal totalTaxAmount, BigDecimal prepaymentRate, int scale) {
        BigDecimal rate = NumberUtils.effectualNumeric(prepaymentRate);
        rate = rate.divide(ONEHUNDRED, CalculateUtils.getScale(rate), 4);
        BigDecimal prepayment = ZERO;
        if (!NumberUtils.equalsZero(totalTaxAmount) && !NumberUtils.equalsZero(rate)) {
            prepayment = NumberUtils.effectualNumeric(rate).multiply(NumberUtils.effectualNumeric(totalTaxAmount)).setScale(NumberUtils.effectualPrecision(scale), 4);
        }
        return prepayment;
    }

    public static BigDecimal calPrepayment(BigDecimal[] totalTaxAmounts, BigDecimal prepaymentRate, int scale) {
        if (prepaymentRate == null || totalTaxAmounts == null || totalTaxAmounts.length == 0) {
            return ZERO;
        }
        BigDecimal totalTaxAmount = ZERO;
        int num = totalTaxAmounts.length;
        for (int i = 0; i < num; ++i) {
            if (totalTaxAmounts[i] == null) continue;
            totalTaxAmount = totalTaxAmount.add(totalTaxAmounts[i]);
        }
        prepaymentRate = prepaymentRate.divide(ONEHUNDRED, CalculateUtils.getScale(prepaymentRate), 4);
        BigDecimal prepayment = prepaymentRate.multiply(totalTaxAmount).setScale(scale, 4);
        return prepayment;
    }

    public static BigDecimal calPrice(BigDecimal taxPrice, BigDecimal taxRate, int scale) {
        BigDecimal price = CalculateUtils.calPriceNoScale(taxPrice, taxRate, scale);
        price = price.setScale(scale, 4);
        return price;
    }

    public static BigDecimal calPriceNoScale(BigDecimal taxPrice, BigDecimal taxRate, int scale) {
        if (taxPrice == null) {
            return ZERO;
        }
        taxRate = NumberUtils.effectualNumeric(taxRate);
        BigDecimal price = null;
        price = taxPrice.divide(ONE.add(taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4)), CalculateUtils.getScale(scale), 4);
        return price;
    }

    public static BigDecimal calPriceNoScale(String discountType, BigDecimal amount, BigDecimal qty, BigDecimal discount, int scale) {
        if (amount == null || qty == null || qty.compareTo(ZERO) == 0) {
            return ZERO;
        }
        if ("B".equals(discountType)) {
            discount = NumberUtils.effectualNumeric(discount);
            BigDecimal price = null;
            price = amount.divide(qty, CalculateUtils.getScale(scale), 4).add(discount);
            return price;
        }
        return CalculateUtils.calPriceNoScale(amount, qty, discount, scale);
    }

    public static BigDecimal calPrice(String discountType, BigDecimal amount, BigDecimal qty, BigDecimal discount, int scale) {
        BigDecimal price = CalculateUtils.calPriceNoScale(discountType, amount, qty, discount, scale);
        price = price.setScale(scale, 4);
        return price;
    }

    public static BigDecimal calPriceNoScale(BigDecimal amount, BigDecimal qty, BigDecimal discount, int scale) {
        if (amount == null || qty == null || qty.compareTo(ZERO) == 0) {
            return ZERO;
        }
        if ((discount = NumberUtils.effectualNumeric(discount)) == null || discount.compareTo(ONEHUNDRED) == 0) {
            discount = ZERO;
        }
        if (discount.compareTo(ZERO) != 0) {
            discount = discount.divide(ONEHUNDRED, CalculateUtils.getScale(discount), 4);
        }
        BigDecimal price = null;
        price = amount.divide(qty, CalculateUtils.getScale(scale), 4).divide(ONE.subtract(discount), CalculateUtils.getScale(scale), 4);
        return price;
    }

    public static BigDecimal calPrice(BigDecimal amount, BigDecimal qty, BigDecimal discount, int scale) {
        BigDecimal price = CalculateUtils.calPriceNoScale(amount, qty, discount, scale);
        price = price.setScale(scale, 4);
        return price;
    }

    public static BigDecimal calPriceIsPriceInTax(BigDecimal taxRate, BigDecimal taxPrice, int scale) {
        BigDecimal price = CalculateUtils.calPriceIsPriceInTaxNoScale(taxRate, taxPrice, scale);
        price = price.setScale(scale, 4);
        return price;
    }

    public static BigDecimal calPriceIsPriceInTaxNoScale(BigDecimal taxRate, BigDecimal taxPrice, int scale) {
        taxRate = NumberUtils.effectualNumeric(taxRate);
        taxRate = taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4);
        taxPrice = NumberUtils.effectualNumeric(taxPrice);
        BigDecimal price = taxPrice.multiply(ONE.subtract(taxRate));
        return price;
    }

    public static BigDecimal calLocalAmount(BigDecimal amount, BigDecimal exchangerate, int scale) {
        if (amount == null || exchangerate == null) {
            return ZERO;
        }
        BigDecimal localeAmount = amount.multiply(exchangerate);
        localeAmount = localeAmount.setScale(scale, 4);
        return localeAmount;
    }

    public static BigDecimal calTaxPriceByPurchaseCost(BigDecimal price, BigDecimal taxRate, int scale) {
        if (price == null) {
            return ZERO;
        }
        taxRate = NumberUtils.effectualNumeric(taxRate);
        BigDecimal taxPrice = ZERO;
        taxRate = taxRate.divide(ONEHUNDRED, CalculateUtils.getScale(taxRate), 4);
        taxPrice = NumberUtils.effectualNumeric(price).divide(ONE.subtract(taxRate), scale, 4);
        return taxPrice;
    }
}

