/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.cal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.cal.AbstractCal;
import kd.scm.common.util.cal.CalculateUtils;

public class MultCurrencyCalImpl
extends AbstractCal {
    private static Log log = LogFactory.getLog(MultCurrencyCalImpl.class);
    private boolean isNeedChange = true;
    private String curr = "quotecurr";
    private String exRate = "exrate";
    private String qty = "qty";
    private String sumqty = "sumqty";

    public void setCurr(String curr) {
        this.curr = curr;
    }

    @Override
    protected void initFiledValue() {
    }

    @Override
    public void needChange(boolean isNeedChange) {
        this.isNeedChange = isNeedChange;
    }

    public boolean isNeedChange() {
        return this.isNeedChange;
    }

    @Override
    public void proChanged(IDataModel datamodel, String entryKey, String propertyName) {
        if (propertyName.equals(this.getQTY())) {
            this.calByEntryQtyChange(datamodel, entryKey);
        } else if (propertyName.equals(this.getPRICE())) {
            this.calByEntryPriceChange(datamodel, entryKey);
        } else if (propertyName.equals(this.getTAXPRICE())) {
            this.calByEntryTaxPriceChange(datamodel, entryKey);
        } else if (propertyName.equals(this.getAMOUNT())) {
            this.calByEntryAmountChange(datamodel, entryKey);
        } else if (propertyName.equals(this.getTAXAMOUNT())) {
            this.calByEntryTaxAmountChange(datamodel, entryKey);
        } else if (propertyName.equals(this.getDISCOUNTRATE())) {
            this.calByEntryDiscountRateChange(datamodel, entryKey);
        } else if (propertyName.equals(this.getDISCOUNTAMOUNT())) {
            this.calByEntryDiscountAmountChange(datamodel, entryKey);
        } else if (propertyName.equals(this.getTAXRATE())) {
            this.calByEntryTaxRateChange(datamodel, entryKey);
        } else if (propertyName.equals(this.getTAX())) {
            this.calByEntryTaxChange(datamodel, entryKey);
        }
    }

    @Override
    public void calByEntryAmountChange(IDataModel datamodel, String entryKey) {
        this.calEntryPriceByAmount(datamodel, entryKey);
        this.calEntryTaxPriceByPrice(datamodel, entryKey);
        this.calEntryDiscountAmount(datamodel, entryKey);
        this.calEntryTaxAmount(datamodel, entryKey);
        this.calEntryTax(datamodel, entryKey);
        this.calEntryActualPrice(datamodel, entryKey);
        this.calEntryActualTaxPrice(datamodel, entryKey);
        this.calSum(datamodel, entryKey);
    }

    @Override
    public void calEntryPriceByAmount(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.getAMOUNT());
        BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTRATE());
        BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
        int scale = this.getPricePrecision(datamodel, entryKey);
        BigDecimal price = CalculateUtils.calPrice(amount, qty, discountRate, scale);
        datamodel.setValue(this.getPRICE(), (Object)price, index);
    }

    @Override
    public void calEntryTaxPriceByPrice(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal price = this.getEntryBigDecimalValue(datamodel, index, this.getPRICE());
        BigDecimal taxRate = this.getEntryBigDecimalValue(datamodel, index, this.getTAXRATE());
        this.calEntryTaxPriceByPrice(datamodel, index, price, taxRate);
    }

    public void calEntryTaxPriceByPrice(IDataModel datamodel, int index, BigDecimal price, BigDecimal taxRate) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        BigDecimal taxPrice = null;
        int scale = this.getPricePrecision(datamodel, index);
        taxPrice = TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType) ? CalculateUtils.calTaxPriceInTax(price, taxRate, scale) : CalculateUtils.calTaxPrice(price, taxRate, scale);
        datamodel.setValue(this.getTAXPRICE(), (Object)taxPrice, index);
    }

    @Override
    public void calByEntryPriceChange(IDataModel datamodel, String entryKey) {
        this.calEntryTaxPriceByPrice(datamodel, entryKey);
        this.calEntryDiscountAmount(datamodel, entryKey);
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        if (this.isContainTax(taxType)) {
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
        } else {
            this.calEntryAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
        }
        this.calEntryActualPrice(datamodel, entryKey);
        this.calEntryActualTaxPrice(datamodel, entryKey);
        this.calSum(datamodel, entryKey);
    }

    @Override
    public void calByEntryTaxPriceChange(IDataModel datamodel, String entryKey) {
        this.calEntryPriceByTaxPrice(datamodel, entryKey);
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        if (this.isContainTax(taxType)) {
            this.calEntryTaxAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryAmount(datamodel, entryKey);
        } else {
            this.calEntryAmount(datamodel, entryKey);
            this.calEntryTax(datamodel, entryKey);
            this.calEntryTaxAmount(datamodel, entryKey);
        }
        this.calEntryActualPrice(datamodel, entryKey);
        this.calEntryActualTaxPrice(datamodel, entryKey);
        this.calEntryDiscountAmount(datamodel, entryKey);
        this.calSum(datamodel, entryKey);
    }

    @Override
    public void calEntryPriceByTaxPrice(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.getTAXPRICE());
        BigDecimal taxRate = this.getEntryBigDecimalValue(datamodel, index, this.getTAXRATE());
        this.calEntryPriceByTaxPrice(datamodel, index, taxPrice, taxRate);
    }

    public void calEntryPriceByTaxPrice(IDataModel datamodel, int index, BigDecimal taxPrice, BigDecimal taxRate) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        int scale = this.getPricePrecision(datamodel, index);
        BigDecimal price = null;
        price = TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType) ? CalculateUtils.calPriceIsPriceInTax(taxRate, taxPrice, scale) : CalculateUtils.calPrice(taxPrice, taxRate, scale);
        datamodel.setValue(this.getPRICE(), (Object)price, index);
    }

    @Override
    protected int getPricePrecision(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        return this.getPricePrecision(datamodel, index);
    }

    protected int getPricePrecision(IDataModel dataModel, int index) {
        int pricePrecision = 6;
        Object quotecurr = dataModel.getValue(this.curr, index);
        if (null != quotecurr && quotecurr instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)quotecurr;
            pricePrecision = curr.getInt("priceprecision");
        }
        return pricePrecision;
    }

    public static BigDecimal convertByExrate(BigDecimal value, BigDecimal exrate, int scale) {
        return MultCurrencyCalImpl.convertByExrate(value, exrate, scale, null);
    }

    public static BigDecimal convertByExrate(BigDecimal value, BigDecimal exrate, int scale, String quotation) {
        if (exrate != null && BigDecimal.ZERO.compareTo(exrate) != 0 && value != null) {
            if (quotation != null && quotation.equals("1")) {
                return value.setScale(scale, 4).divide(exrate, scale, RoundingMode.HALF_UP);
            }
            return value.setScale(scale, 4).multiply(exrate).setScale(scale, 4);
        }
        return value;
    }

    public static BigDecimal getExrate(Long quoteCurr, Long curr, Date ratedate, DynamicObject exchtype) {
        if (quoteCurr != null && curr != null && exchtype != null) {
            if (quoteCurr.compareTo(curr) == 0) {
                return BigDecimal.ONE;
            }
            return BaseDataServiceHelper.getExchangeRate((Long)exchtype.getLong("id"), (Long)quoteCurr, (Long)curr, (Date)ratedate);
        }
        return null;
    }

    @Override
    protected int getAmtPrecision(IDataModel datamodel, String entryKey) {
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        return this.getAmtPrecision(datamodel, index);
    }

    protected int getAmtPrecision(IDataModel datamodel, int index) {
        int amtPrecision = 6;
        Object quotecurr = datamodel.getValue("quotecurr", index);
        if (null != quotecurr && quotecurr instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)quotecurr;
            amtPrecision = curr.getInt("amtprecision");
        }
        return amtPrecision;
    }

    @Override
    public void calSumAmount(IDataModel datamodel, String entryKey) {
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal midAmount = null;
        BigDecimal rate = null;
        int scale = super.getAmtPrecision(datamodel, entryKey);
        DynamicObjectCollection col = datamodel.getEntryEntity(entryKey);
        for (DynamicObject entry : col) {
            rate = entry.getBigDecimal(this.exRate);
            String quotation = entry.getString("entryquotation");
            midAmount = entry.getBigDecimal(this.getAMOUNT());
            midAmount = MultCurrencyCalImpl.convertByExrate(midAmount, rate, scale, quotation);
            sumAmount = sumAmount.add(midAmount);
        }
        datamodel.setValue(this.getHEAD_AMOUNT(), (Object)sumAmount);
    }

    @Override
    public void calSumTax(IDataModel datamodel, String entryKey) {
        BigDecimal sumTax = BigDecimal.ZERO;
        BigDecimal midSumTax = null;
        BigDecimal rate = null;
        int scale = super.getAmtPrecision(datamodel, entryKey);
        DynamicObjectCollection col = datamodel.getEntryEntity(entryKey);
        for (DynamicObject entry : col) {
            rate = entry.getBigDecimal(this.exRate);
            String quotation = entry.getString("entryquotation");
            midSumTax = entry.getBigDecimal(this.getTAX());
            midSumTax = MultCurrencyCalImpl.convertByExrate(midSumTax, rate, scale, quotation);
            sumTax = sumTax.add(midSumTax);
        }
        datamodel.setValue(this.getHEAD_TAX(), (Object)sumTax);
    }

    @Override
    public void calSumTaxAmount(IDataModel datamodel, String entryKey) {
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        BigDecimal midSumTaxAmount = null;
        BigDecimal rate = null;
        int scale = super.getAmtPrecision(datamodel, entryKey);
        DynamicObjectCollection col = datamodel.getEntryEntity(entryKey);
        for (DynamicObject entry : col) {
            rate = entry.getBigDecimal(this.exRate);
            String quotation = entry.getString("entryquotation");
            midSumTaxAmount = entry.getBigDecimal(this.getTAXAMOUNT());
            midSumTaxAmount = MultCurrencyCalImpl.convertByExrate(midSumTaxAmount, rate, scale, quotation);
            sumTaxAmount = sumTaxAmount.add(midSumTaxAmount);
        }
        datamodel.setValue(this.getHEAD_TAXAMOUNT(), (Object)sumTaxAmount);
    }

    @Override
    public void calSumQty(IDataModel datamodel, String entryKey) {
        BigDecimal sumQty = BigDecimal.ZERO;
        BigDecimal midSumQty = null;
        DynamicObjectCollection col = datamodel.getEntryEntity(entryKey);
        for (DynamicObject entry : col) {
            midSumQty = entry.getBigDecimal(this.qty);
            sumQty = sumQty.add(midSumQty);
        }
        datamodel.setValue(this.sumqty, (Object)sumQty);
    }

    @Override
    public void calEntryTaxAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        boolean containTax = this.isContainTax(taxType);
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal taxAmount = null;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        if (containTax) {
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
            BigDecimal taxPrice = this.getEntryBigDecimalValue(datamodel, index, this.getTAXPRICE());
            BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTRATE());
            taxAmount = CalculateUtils.calTaxAmountByDiscountPercent(qty, taxPrice, discountRate, scale);
        } else {
            BigDecimal amount = this.getEntryBigDecimalValue(datamodel, index, this.getAMOUNT());
            BigDecimal taxRate = this.getEntryBigDecimalValue(datamodel, index, this.getTAXRATE());
            BigDecimal tax = amount.multiply(taxRate.divide(CalConstant.BIGDECIMAL_ONEHUNDRED, scale, 4));
            taxAmount = CalculateUtils.calTaxAmount(amount, tax, scale);
        }
        datamodel.setValue(this.getTAXAMOUNT(), (Object)taxAmount, index);
    }

    @Override
    public void calEntryAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, this.getTAXTYPE());
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        BigDecimal amount = BigDecimal.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxamount = this.getEntryBigDecimalValue(datamodel, index, this.getTAXAMOUNT());
            BigDecimal tax = this.getEntryBigDecimalValue(datamodel, index, this.getTAX());
            amount = CalculateUtils.calAmountInTax(taxamount, tax, scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, this.getDISCOUNTRATE());
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, this.getQTY());
            BigDecimal price = this.getEntryBigDecimalValue(datamodel, index, this.getPRICE());
            amount = CalculateUtils.calAmountByDiscountPercent(qty, price, discountRate, scale);
        }
        datamodel.setValue(this.getAMOUNT(), (Object)amount, index);
    }

    public static BigDecimal calAmount(DynamicObject info, String taxType, String prev, int scale) {
        if (info == null) {
            return BigDecimal.ZERO;
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("qty", "qty" + prev);
        propMap.put("taxrate", "taxrate" + prev);
        propMap.put("taxprice", "taxprice" + prev);
        propMap.put("price", "price" + prev);
        return MultCurrencyCalImpl.calAmount(info, taxType, propMap, scale);
    }

    public static BigDecimal calCfmAmount(DynamicObject info, String taxType, String prev, int scale) {
        if (info == null) {
            return BigDecimal.ZERO;
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("qty", "cfmqty" + prev);
        propMap.put("taxrate", "cfmtaxrate" + prev);
        propMap.put("taxprice", "cfmtaxprice" + prev);
        propMap.put("price", "cfmprice" + prev);
        return MultCurrencyCalImpl.calAmount(info, taxType, propMap, scale);
    }

    public static BigDecimal calAmount(DynamicObject info, String taxType, Map<String, String> propMap, int scale) {
        if (info == null || propMap == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal qty = info.getBigDecimal(propMap.get("qty"));
        BigDecimal tax = info.getBigDecimal(propMap.get("taxrate"));
        tax = tax.divide(CalConstant.BIGDECIMAL_ONEHUNDRED, scale, 4);
        if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal value = info.getBigDecimal(propMap.get("taxprice"));
            BigDecimal taxAmount = value.setScale(scale, 4).multiply(qty);
            tax = taxAmount.setScale(scale, 4).multiply(tax);
            return CalculateUtils.calAmountInTax(taxAmount, tax, scale);
        }
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            log.info("calAmount:");
            BigDecimal value = info.getBigDecimal(propMap.get("taxprice"));
            log.info("taxprice:" + value.toPlainString());
            BigDecimal taxAmount = value.setScale(scale, 4).multiply(qty);
            log.info("taxAmount:" + taxAmount.toPlainString());
            tax = taxAmount.divide(BigDecimal.ONE.add(tax), 10, 4).multiply(tax).setScale(scale, 4);
            log.info("tax:" + tax.toPlainString());
            log.info("scale:" + scale);
            return CalculateUtils.calAmountInTax(taxAmount, tax, scale);
        }
        BigDecimal value = info.getBigDecimal(propMap.get("price"));
        return CalculateUtils.calAmountByDiscountPercent(qty, value, BigDecimal.ZERO, scale);
    }

    public static BigDecimal calTaxAmount(DynamicObject info, String taxType, String prev, int scale) {
        if (info == null) {
            return BigDecimal.ZERO;
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("qty", "qty" + prev);
        propMap.put("taxprice", "taxprice" + prev);
        propMap.put("price", "price" + prev);
        propMap.put("taxrate", "taxrate" + prev);
        return MultCurrencyCalImpl.calTaxAmount(info, taxType, propMap, scale);
    }

    public static BigDecimal calCfmTaxAmount(DynamicObject info, String taxType, String prev, int scale) {
        if (info == null) {
            return BigDecimal.ZERO;
        }
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("qty", "cfmqty" + prev);
        propMap.put("taxprice", "cfmtaxprice" + prev);
        propMap.put("price", "cfmprice" + prev);
        propMap.put("taxrate", "cfmtaxrate" + prev);
        return MultCurrencyCalImpl.calTaxAmount(info, taxType, propMap, scale);
    }

    public static BigDecimal calTaxAmount(DynamicObject info, String taxType, Map<String, String> propMap, int scale) {
        if (info == null || propMap == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal qty = info.getBigDecimal(propMap.get("qty"));
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal value = info.getBigDecimal(propMap.get("taxprice"));
            return CalculateUtils.calTaxAmountByDiscountPercent(qty, value, BigDecimal.ZERO, scale);
        }
        BigDecimal value = info.getBigDecimal(propMap.get("price"));
        BigDecimal amount = value.multiply(qty).setScale(scale, 4);
        BigDecimal tax = info.getBigDecimal(propMap.get("taxrate"));
        tax = tax.divide(CalConstant.BIGDECIMAL_ONEHUNDRED, tax.scale(), 4);
        tax = amount.multiply(tax);
        return CalculateUtils.calTaxAmount(amount, tax, scale);
    }
}

