/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.excel;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelDataEntity {
    public static final int REDFONT = 4;
    private Workbook workbook;
    private String pattern;
    private String fileName;
    private List<String> columnKeyList;
    private List<String> columnNameList;
    private String entityKey;
    private String entryKey;
    private boolean isAddColumnKeyToHeader = false;

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    public String getEntryKey() {
        return this.entryKey;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    public boolean isAddColumnKeyToHeader() {
        return this.isAddColumnKeyToHeader;
    }

    public void setAddColumnKeyToHeader(boolean isAddColumnKeyToHeader) {
        this.isAddColumnKeyToHeader = isAddColumnKeyToHeader;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<String> getColumnNameList() {
        return Collections.unmodifiableList(this.columnNameList);
    }

    public void setColumnNameList(List<String> columnNameList) {
        this.columnNameList = Collections.unmodifiableList(columnNameList);
    }

    public List<String> getColumnKeyList() {
        return Collections.unmodifiableList(this.columnKeyList);
    }

    public void setColumnKeyList(List<String> columnKeyList) {
        this.columnKeyList = Collections.unmodifiableList(columnKeyList);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setExcelHeader(List<String> coloumnTitleList) throws IOException {
        ArrayList<String> header = new ArrayList<String>();
        header.addAll(coloumnTitleList);
        this.createRow(0, 0);
        this.setRowValue(0, header, 0);
        for (int i = 0; i < coloumnTitleList.size(); ++i) {
            this.setStyle(0, 0, i, this.makeStyle(1));
        }
    }

    public void setExcelHeaderWithControlAp(List<ControlAp<?>> items) throws IOException {
        this.setExcelHeaderWithControlAp(items, false);
    }

    public void setExcelHeaderWithControlAp(List<ControlAp<?>> items, boolean isComboItem) throws IOException {
        this.createRow(0, 0);
        Sheet sheet = this.workbook.getSheetAt(0);
        Row row = sheet.getRow(0);
        for (int i = 0; i < items.size(); ++i) {
            ControlAp<?> controlAp = items.get(i);
            if (controlAp == null) continue;
            Cell cell = row.createCell(i);
            cell.setCellValue(items.get(i).getName().getLocaleValue());
            Field info = ((EntryFieldAp)items.get(i)).getField();
            if (info.isMustInput()) {
                List items1;
                cell.setCellStyle(this.makeStyle(4));
                if (!(info instanceof ComboField) || !isComboItem || null == (items1 = ((ComboField)info).getItems()) || items1.size() <= 0) continue;
                CellRangeAddressList regions = new CellRangeAddressList(1, 65535, i, i);
                DataValidationHelper helper = sheet.getDataValidationHelper();
                ArrayList<String> arrays = new ArrayList<String>(items1.size());
                for (ComboItem comboItem : items1) {
                    arrays.add(comboItem.getCaption().getLocaleValue());
                }
                DataValidationConstraint constraint = helper.createExplicitListConstraint(arrays.toArray(new String[0]));
                XSSFDataValidation validation = (XSSFDataValidation)helper.createValidation(constraint, regions);
                sheet.addValidationData((DataValidation)validation);
                continue;
            }
            cell.setCellStyle(this.makeStyle(1));
        }
    }

    public void setExcelHeaderStyle(int colIndex, int styleType) throws IOException {
        this.setStyle(0, 0, colIndex, this.makeStyle(styleType));
    }

    public ExcelDataEntity() {
        this.workbook = new SXSSFWorkbook(null, -1);
    }

    public ExcelDataEntity(Workbook workboook) {
        this.workbook = workboook;
    }

    public ExcelDataEntity(InputStream is, String version) throws IOException {
        this.workbook = "2003".equals(version) ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
    }

    public String toString() {
        return MessageFormat.format(ResManager.loadKDString((String)"\u5171\u6709{0}\u4e2asheet\u9875\uff01", (String)"ExcelDataEntity_0", (String)"scm-common", (Object[])new Object[0]), this.getSheetCount());
    }

    public String toString(int sheetIx) throws IOException {
        return MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u4e2asheet \u9875\uff0c\u540d\u79f0\uff1a{1}\uff0c\u5171 {2}\u884c\uff01", (String)"ExcelDataEntity_1", (String)"scm-common", (Object[])new Object[0]), sheetIx + 1, this.getSheetName(sheetIx), this.getRowCount(sheetIx));
    }

    public static boolean isExcel(String pathname) {
        if (pathname == null) {
            return false;
        }
        return pathname.endsWith(".xls") || pathname.endsWith(".xlsx");
    }

    public List<List<String>> read() throws Exception {
        return this.read(0, 0, this.getRowCount(0) - 1);
    }

    public List<List<String>> read(int sheetIx) throws Exception {
        return this.read(sheetIx, 0, this.getRowCount(sheetIx) - 1);
    }

    public List<List<String>> read(int sheetIx, int start, int end) throws Exception {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        ArrayList<List<String>> list = new ArrayList<List<String>>(end);
        if (end > this.getRowCount(sheetIx)) {
            end = this.getRowCount(sheetIx);
        }
        int cols = sheet.getRow(0).getLastCellNum();
        for (int i = start; i <= end; ++i) {
            ArrayList<String> rowList = new ArrayList<String>();
            Row row = sheet.getRow(i);
            for (int j = 0; j < cols; ++j) {
                if (row == null) {
                    rowList.add(null);
                    continue;
                }
                rowList.add(this.getCellValueToString(row.getCell(j)));
            }
            list.add(rowList);
        }
        return list;
    }

    public boolean write(List<List<String>> rowData) throws IOException {
        return this.write(0, rowData, 0);
    }

    public boolean write(List<List<String>> rowData, String sheetName, boolean isNewSheet) throws IOException {
        Sheet sheet = null;
        sheet = isNewSheet ? this.workbook.createSheet(sheetName) : this.workbook.createSheet();
        int sheetIx = this.workbook.getSheetIndex(sheet);
        return this.write(sheetIx, rowData, 0);
    }

    public boolean write(int sheetIx, List<List<String>> rowData, boolean isAppend) throws IOException {
        if (isAppend) {
            return this.write(sheetIx, rowData, this.getRowCount(sheetIx));
        }
        this.clearSheet(sheetIx);
        return this.write(sheetIx, rowData, 0);
    }

    public boolean write(int sheetIx, List<List<String>> rowData, int startRow) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        int dataSize = rowData.size();
        if (this.getRowCount(sheetIx) > 0) {
            sheet.shiftRows(startRow, this.getRowCount(sheetIx), dataSize);
        }
        for (int i = 0; i < dataSize; ++i) {
            Row row = sheet.createRow(i + startRow);
            for (int j = 0; j < rowData.get(i).size(); ++j) {
                Cell cell = row.createCell(j);
                cell.setCellValue(rowData.get(i).get(j) + "");
            }
        }
        return true;
    }

    public boolean setStyle(int sheetIx, int rowIndex, int colIndex, CellStyle style) throws IOException {
        this.setStyle(sheetIx, rowIndex, colIndex, style, 4000);
        return true;
    }

    public boolean setStyle(int sheetIx, int rowIndex, int colIndex, CellStyle style, int width) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        sheet.setColumnWidth(colIndex, width);
        Row row = sheet.getRow(rowIndex);
        if (null != row) {
            Cell cell = row.getCell(colIndex);
            cell.setCellStyle(style);
            return true;
        }
        return false;
    }

    public CellStyle makeStyle(int type) {
        CellStyle style = this.workbook.createCellStyle();
        DataFormat format = this.workbook.createDataFormat();
        style.setDataFormat(format.getFormat("@"));
        style.setAlignment(HorizontalAlignment.CENTER);
        Font font = this.workbook.createFont();
        if (type == 1) {
            style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setAlignment(HorizontalAlignment.GENERAL);
        }
        if (type == 2) {
            style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setAlignment(HorizontalAlignment.GENERAL);
        }
        if (type == 3) {
            style.setFillForegroundColor(IndexedColors.SKY_BLUE.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setAlignment(HorizontalAlignment.GENERAL);
        }
        if (type == 4) {
            font.setColor(IndexedColors.RED.getIndex());
            style.setFont(font);
            style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            style.setAlignment(HorizontalAlignment.GENERAL);
        }
        style.setFont(font);
        return style;
    }

    public void region(int sheetIx, int firstRow, int lastRow, int firstCol, int lastCol) {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public boolean isRowNull(int sheetIx, int rowIndex) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        return sheet.getRow(rowIndex) == null;
    }

    public boolean createRow(int sheetIx, int rowIndex) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        sheet.createRow(rowIndex);
        return true;
    }

    public boolean isCellNull(int sheetIx, int rowIndex, int colIndex) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        if (!this.isRowNull(sheetIx, rowIndex)) {
            return false;
        }
        Row row = sheet.getRow(rowIndex);
        return row.getCell(colIndex) == null;
    }

    public boolean createCell(int sheetIx, int rowIndex, int colIndex) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        Row row = sheet.getRow(rowIndex);
        row.createCell(colIndex);
        return true;
    }

    public int getRowCount(int sheetIx) {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        if (sheet.getPhysicalNumberOfRows() == 0) {
            return 0;
        }
        return sheet.getLastRowNum() + 1;
    }

    public int getColumnCount(int sheetIx, int rowIndex) {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        Row row = sheet.getRow(rowIndex);
        return row == null ? -1 : (int)row.getLastCellNum();
    }

    public boolean setValueAt(int sheetIx, int rowIndex, int colIndex, String value) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        sheet.getRow(rowIndex).getCell(colIndex).setCellValue(value);
        return true;
    }

    public String getValueAt(int sheetIx, int rowIndex, int colIndex) {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        return this.getCellValueToString(sheet.getRow(rowIndex).getCell(colIndex));
    }

    public boolean setRowValue(int sheetIx, List<String> rowData, int rowIndex) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        CellStyle cellStyle = this.workbook.createCellStyle();
        DataFormat dataFormat = this.workbook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("@"));
        Row row = sheet.getRow(rowIndex);
        for (int i = 0; i < rowData.size(); ++i) {
            Cell cell = row.createCell(i);
            String value = rowData.get(i);
            if (this.contentContainFormulaKeyForXls(value)) {
                cell.setCellStyle(cellStyle);
            }
            cell.setCellValue(rowData.get(i));
        }
        return true;
    }

    private boolean contentContainFormulaKeyForXls(String content) {
        return content != null && (content.contains("cmd") || content.contains("_PID_HLINKS") || content.contains("IMPORTXML"));
    }

    public List<String> getRowValue(int sheetIx, int rowIndex) {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        Row row = sheet.getRow(rowIndex);
        ArrayList<String> list = new ArrayList<String>();
        if (row == null) {
            list.add(null);
        } else {
            for (int i = 0; i < row.getLastCellNum(); ++i) {
                list.add(this.getCellValueToString(row.getCell(i)));
            }
        }
        return list;
    }

    public List<String> getColumnValue(int sheetIx, int rowIndex, int colIndex) {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = rowIndex; i < this.getRowCount(sheetIx); ++i) {
            Row row = sheet.getRow(i);
            if (row == null) {
                list.add(null);
                continue;
            }
            list.add(this.getCellValueToString(sheet.getRow(i).getCell(colIndex)));
        }
        return list;
    }

    public int getSheetCount() {
        return this.workbook.getNumberOfSheets();
    }

    public void createSheet() {
        this.workbook.createSheet();
    }

    public boolean setSheetName(int sheetIx, String name) throws IOException {
        this.workbook.setSheetName(sheetIx, name);
        return true;
    }

    public String getSheetName(int sheetIx) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        return sheet.getSheetName();
    }

    public int getSheetIndex(String name) {
        return this.workbook.getSheetIndex(name);
    }

    public boolean removeSheetAt(int sheetIx) throws IOException {
        this.workbook.removeSheetAt(sheetIx);
        return true;
    }

    public boolean removeRow(int sheetIx, int rowIndex) throws IOException {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        sheet.shiftRows(rowIndex + 1, this.getRowCount(sheetIx), -1);
        Row row = sheet.getRow(this.getRowCount(sheetIx) - 1);
        sheet.removeRow(row);
        return true;
    }

    public void setSheetOrder(String sheetname, int sheetIx) {
        this.workbook.setSheetOrder(sheetname, sheetIx);
    }

    public boolean clearSheet(int sheetIx) throws IOException {
        String sheetname = this.getSheetName(sheetIx);
        this.removeSheetAt(sheetIx);
        this.workbook.createSheet(sheetname);
        this.setSheetOrder(sheetname, sheetIx);
        return true;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void close() throws IOException {
        this.workbook.close();
    }

    private String getCellValueToString(Cell cell) {
        String strCell = "";
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case BOOLEAN: {
                strCell = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    if (this.pattern != null) {
                        SimpleDateFormat sdf = new SimpleDateFormat(this.pattern);
                        strCell = sdf.format(date);
                        break;
                    }
                    strCell = date.toString();
                    break;
                }
                cell.setCellType(CellType.STRING);
                strCell = cell.toString();
                break;
            }
            case STRING: {
                strCell = cell.getStringCellValue();
                break;
            }
        }
        return strCell;
    }

    public void setDataFormatForNumberic(int sheetIx, int col, int startrow, int endrow) {
        Sheet sheet = this.workbook.getSheetAt(sheetIx);
        if (null == sheet) {
            return;
        }
        CellStyle cellStyle = this.workbook.createCellStyle();
        DataFormat format = this.workbook.createDataFormat();
        cellStyle.setDataFormat(format.getFormat("0.00"));
        for (int i = startrow; i < endrow + 1; ++i) {
            Cell cell;
            Row row = sheet.getRow(i);
            if (null == row || null == (cell = row.getCell(col))) continue;
            cell.setCellStyle(cellStyle);
        }
    }
}

