/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.webApi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.api.client.ApiClient;
import kd.bos.api.client.ApiClientFactory;
import kd.bos.api.client.ApiRequest;
import kd.bos.api.client.ApiResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.scm.common.eip.errorcode.EipErrorCode;
import kd.scm.common.webApi.GetServiceNameFromDB;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class WebApiUtil {
    private static Log log = LogFactory.getLog(WebApiUtil.class);
    private static String DEFAULT_P = "1234567";

    public static Map<String, Object> intenalApiTest(String apiName) throws UnsupportedEncodingException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.FALSE);
        resultMap.put("title", MessageFormat.format(ResManager.loadKDString((String)"API\uff1a{0}\u6d4b\u8bd5\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\uff1a", (String)"WebApiUtil_0", (String)"scm-common", (Object[])new Object[0]), apiName));
        if (apiName == null || apiName.equals("")) {
            resultMap.put("message", ResManager.loadKDString((String)"API\u540d\u79f0\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u6d4b\u8bd5\uff01", (String)"WebApiUtil_1", (String)"scm-common", (Object[])new Object[0]));
            return resultMap;
        }
        Map<String, Object> apiServiceMap = GetServiceNameFromDB.getInstance().getServiceName(apiName);
        if (apiServiceMap == null) {
            resultMap.put("message", MessageFormat.format(ResManager.loadKDString((String)"API\u540d\u79f0\uff1a{0}\u6ca1\u6709\u627e\u5230\u670d\u52a1\u7aef\u7684\u76f8\u5e94\u670d\u52a1\uff0c\u53ef\u80fd\u662f\u672a\u5b9a\u4e49\u670d\u52a1\uff0c\u6216\u670d\u52a1\u63d2\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5 API\u670d\u52a1\u6ce8\u518c\u8868\uff01", (String)"WebApiUtil_2", (String)"scm-common", (Object[])new Object[0]), apiName));
            return resultMap;
        }
        String appCode = apiServiceMap.get("appid").toString();
        String apiOpCode = apiServiceMap.get("apiopid").toString();
        String url = UrlService.getDomainContextUrl() + "/kapi/app/" + appCode + "/" + apiOpCode;
        ApiRequest request = new ApiRequest("post", url);
        request.setCharacterEncoding("utf-8");
        request.setContentType("Application/Json");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("apiname", apiName);
        JSONObject body = (JSONObject)JSONObject.toJSON(data);
        request.setPostData((Object)body);
        ApiResult apiResult = WebApiUtil.invokeIntenalApi(request);
        StringBuilder sb = new StringBuilder();
        if (apiResult != null) {
            if (apiResult.isOk()) {
                JSONObject jsonObj;
                String obj = apiResult.getData();
                JSONObject returnMap = jsonObj = JSONObject.parseObject((String)obj);
                resultMap.put("succed", Boolean.TRUE);
                resultMap.put("title", MessageFormat.format(ResManager.loadKDString((String)"API\uff1a{0}\u6d4b\u8bd5\u6210\u529f\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\uff1a", (String)"WebApiUtil_3", (String)"scm-common", (Object[])new Object[0]), apiName));
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u4fe1\u606f\uff1a{0}", (String)"WebApiUtil_4", (String)"scm-common", (Object[])new Object[0]), returnMap.get("message"))).append('\n');
                sb.append(MessageFormat.format(ResManager.loadKDString((String)"\u6570\u636e\uff1a{0}", (String)"WebApiUtil_5", (String)"scm-common", (Object[])new Object[0]), returnMap.get("data"))).append('\n');
            }
            sb.append("url:").append(url).append('\n');
            sb.append("body:").append(body).append('\n');
        }
        resultMap.put("message", sb);
        return resultMap;
    }

    public static Map<String, Object> apiTest(String apiName) throws UnsupportedEncodingException {
        return new HashMap<String, Object>();
    }

    private static ApiResult invokeApi(ApiRequest request) {
        ApiClient.Option option = new ApiClient.Option();
        option.connectTimeout = 50000;
        option.readTimeout = 50000;
        ApiClient client = null;
        ApiResult apiResult = null;
        try {
            client = ApiClientFactory.getExternal((ApiClient.Option)option);
            apiResult = client.execute(request);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDException(EipErrorCode.INVOKE_FAILED, new Object[]{e.getMessage()});
        }
        return apiResult;
    }

    private static ApiResult invokeIntenalApi(ApiRequest request) {
        ApiClient client = null;
        ApiResult apiResult = null;
        try {
            client = ApiClientFactory.getInternal();
            apiResult = client.execute(request);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDException(EipErrorCode.INVOKE_FAILED, new Object[]{e.getMessage()});
        }
        finally {
            if (null != client) {
                client.close();
            }
        }
        return apiResult;
    }

    public static String getAccessToken(String url, Map<String, String> data) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().build();
        HttpPost httpPost = new HttpPost(url);
        String resultStr = null;
        Map retMap = null;
        try {
            JSONObject bodyJson = (JSONObject)JSONObject.toJSON(data);
            StringEntity e1 = new StringEntity(bodyJson.toString(), "UTF-8");
            e1.setContentType("text/json");
            httpPost.setEntity((HttpEntity)e1);
            httpPost.setHeader("referer", url);
            httpPost.setHeader("api", "true");
            HttpResponse response1 = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response1.getEntity();
            if (responseEntity != null && (retMap = (Map)JSON.parseObject((String)(resultStr = EntityUtils.toString((HttpEntity)responseEntity)), Map.class)) != null) {
                retMap = (Map)retMap.get("data");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (retMap != null) {
            return String.valueOf(retMap.get("access_token"));
        }
        return null;
    }
}

