/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.webApi.extApi;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.webApi.extApi.ExtApiContext;
import kd.scm.common.webApi.extApi.ExtApiUtil;
import kd.scm.common.webApi.extApi.IExtWebApiService;

public class ExtApiServiceFactory {
    private static Log log = LogFactory.getLog(ExtApiServiceFactory.class);

    public List<IExtWebApiService> getService(ExtApiContext extApiContext) {
        String operate = extApiContext.getOperateKey();
        String entityNumber = extApiContext.getEntityNumber();
        List<String> pluginList = ExtApiUtil.getApiPlugins(entityNumber, operate);
        ArrayList<IExtWebApiService> apiServiceList = new ArrayList<IExtWebApiService>();
        for (String plugin : pluginList) {
            try {
                IExtWebApiService apiService = (IExtWebApiService)Class.forName(plugin).newInstance();
                apiServiceList.add(apiService);
            }
            catch (InstantiationException e) {
                log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error((Throwable)e);
            }
        }
        return apiServiceList;
    }

    private ExtApiServiceFactory() {
    }

    public static ExtApiServiceFactory getInstance() {
        return SingletonHolder.sInstance;
    }

    private static class SingletonHolder {
        private static final ExtApiServiceFactory sInstance = new ExtApiServiceFactory();

        private SingletonHolder() {
        }
    }
}

