/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.webApi.extApi;

import java.text.MessageFormat;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.webApi.extApi.ExtApiContext;
import kd.scm.common.webApi.extApi.IExtWebApiService;

public class ExtApiUtil {
    private ExtApiUtil() {
    }

    public static List<String> getApiPlugins(String entityNumber, String operate) {
        DynamicObjectCollection apiCols = ExtApiUtil.getExtApi(entityNumber, operate);
        List<Long> apiIdList = DynamicObjectUtil.array2ListId((DynamicObject[])apiCols.toArray((Object[])new DynamicObject[0]), "id");
        if (null == apiIdList || apiIdList.size() == 0) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u8868\u5355\uff1a{0}\u64cd\u4f5c\uff1a{1}\u6ca1\u6709\u6ce8\u518c\u5bf9\u5e94\u7684API\u3002", (String)"ExtApiUtil_0", (String)"scm-common", (Object[])new Object[0]), entityNumber, operate));
        }
        DynamicObjectCollection schemeCols = ExtApiUtil.getExtApiScheme(apiIdList);
        List<String> pluginList = DynamicObjectUtil.getProVal2List((DynamicObject[])schemeCols.toArray((Object[])new DynamicObject[0]), "apiplugin");
        return pluginList;
    }

    public static List<String> getApiPlugins(String apiNumber) {
        DynamicObjectCollection apiCols = ExtApiUtil.getExtApi(apiNumber);
        List<Long> apiIdList = DynamicObjectUtil.array2ListId((DynamicObject[])apiCols.toArray((Object[])new DynamicObject[0]), "id");
        if (null == apiIdList || apiIdList.size() == 0) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a{0}\u7684\u5916\u90e8API\u3002", (String)"ExtApiUtil_1", (String)"scm-common", (Object[])new Object[0]), apiNumber));
        }
        DynamicObjectCollection schemeCols = ExtApiUtil.getExtApiScheme(apiIdList);
        List<String> pluginList = DynamicObjectUtil.getProVal2List((DynamicObject[])schemeCols.toArray((Object[])new DynamicObject[0]), "apiplugin");
        return pluginList;
    }

    public static DynamicObjectCollection getExtApi(String entityNumber, String operate) {
        QFilter extApiFilter = new QFilter("entryentity.entityoperate", "=", (Object)operate);
        extApiFilter.and("entryentity.billform", "=", (Object)entityNumber);
        extApiFilter.and("entryentity.isenable", "=", (Object)"1");
        extApiFilter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"pbd_extapi", (String)"id,number", (QFilter[])new QFilter[]{extApiFilter});
    }

    public static DynamicObjectCollection getExtApi(String apiNumber) {
        QFilter extApiFilter = new QFilter("number", "=", (Object)apiNumber);
        extApiFilter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.query((String)"pbd_extapi", (String)"id,number", (QFilter[])new QFilter[]{extApiFilter});
    }

    public static DynamicObjectCollection getExtApiScheme(List<Long> apiIdList) {
        QFilter apiSchemeFilter = new QFilter("entryentity.extapi", "in", apiIdList);
        apiSchemeFilter.and("entryentity.isenable", "=", (Object)"1");
        apiSchemeFilter.and("enable", "=", (Object)"1");
        String selectFields = "id,number,entryentity.apiplugin apiplugin";
        DynamicObjectCollection schemeCols = QueryServiceHelper.query((String)"pbd_apischeme", (String)selectFields, (QFilter[])new QFilter[]{apiSchemeFilter});
        return schemeCols;
    }

    public static boolean doService(List<IExtWebApiService> serviceList, ExtApiContext context) {
        for (IExtWebApiService iExtWebApiService : serviceList) {
            iExtWebApiService.doService(context);
        }
        return true;
    }
}

