/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.common.helper.apiconnector.api.ApiParam;
import kd.scm.common.helper.apiconnector.api.util.Parser;

public class ApiMetaUtil {
    public static String getInputParamSimpleString(ApiParam paramMeta) {
        Map<String, Object> map = ApiMetaUtil.parseParma(paramMeta);
        return JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
    }

    public static String getOutputParamSimpleString(ApiParam paramMeta) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("data", ApiMetaUtil.parseParma(paramMeta));
        map.put("success", Boolean.TRUE);
        map.put("errorCode", "success");
        return JSON.toJSONString(map, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
    }

    public static Map<String, Object> parseParma(ApiParam paramMeta) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        List<ApiParam.Field> fields = paramMeta.getFields();
        if (fields.isEmpty()) {
            return ret;
        }
        for (ApiParam.Field field : fields) {
            if (field.getSchema() != null) {
                Map<String, Object> innerMap = ApiMetaUtil.parseParma(field.getSchema());
                ApiMetaUtil.dealList(field, ret, innerMap);
                continue;
            }
            ApiMetaUtil.dealList(field, ret, ApiMetaUtil.getDefaultValue(field));
        }
        return ret;
    }

    private static void dealList(ApiParam.Field field, Map<String, Object> ret, Object obj) {
        if (field.isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(obj);
            ret.put(field.getName(), list);
        } else {
            ret.put(field.getName(), obj);
        }
    }

    private static Object getDefaultValue(ApiParam.Field field) {
        Object defaultValue = field.getDefaultValue();
        boolean hasdefault = StringUtils.isNotBlank((Object)defaultValue);
        switch (field.getDataType()) {
            case "string": {
                return hasdefault ? Parser.toString(defaultValue) : "";
            }
            case "int": {
                return hasdefault ? Parser.toInt(defaultValue) : 0;
            }
            case "long": {
                return hasdefault ? Parser.toLong(defaultValue) : 0L;
            }
            case "decimal": {
                return hasdefault ? Parser.toBigDecimal(defaultValue) : BigDecimal.ZERO;
            }
            case "datetime": {
                return hasdefault ? Parser.toTimestamp(defaultValue) : Parser.toTimestamp(new Date());
            }
            case "boolean": {
                return hasdefault ? Boolean.valueOf(Parser.toBoolean(defaultValue)) : Boolean.FALSE;
            }
            case "ENUM": {
                return field.getDefaultValue();
            }
            case "STRUCT": {
                return field.getDefaultValue();
            }
        }
        return null;
    }
}

