/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.apiconnector.api.util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.entity.GoodsInfo;
import kd.scm.common.ecapi.entity.ImageInfo;
import kd.scm.common.ecapi.entity.OrderTrackDTO;
import kd.scm.common.ecapi.entity.PriceInfo;
import kd.scm.common.ecapi.entity.StockInfo;
import kd.scm.common.ecapi.jd.enums.AfterSaleServiceTypeEnum;
import kd.scm.common.helper.apiconnector.api.ApiAccessor;

public class EcGroupApiUtil {
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String LEVEL = "level";
    private static final Log log = LogFactory.getLog((String)EcGroupApiUtil.class.getName());

    public static Map<String, Map<String, PriceInfo>> getEcPrice(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_GETPRICE", params);
        HashMap<String, Map<String, PriceInfo>> priceMap = new HashMap<String, Map<String, PriceInfo>>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Throwable) continue;
            priceMap.put(entry.getKey(), (Map)value);
        }
        return priceMap;
    }

    public static Map<String, Map<String, PriceInfo>> getEcPriceMap(Map<String, List<String>> source_skuIdsMap, String cityId) {
        Map<String, Map<String, PriceInfo>> priceMap = new HashMap<String, Map<String, PriceInfo>>();
        if (null == source_skuIdsMap || source_skuIdsMap.isEmpty()) {
            return priceMap;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> commonParam = new HashMap<String, String>(1);
        commonParam.put("cityId", cityId);
        params.put("common_params", commonParam);
        params.putAll(EcGroupApiUtil.getSkuIdsMap(source_skuIdsMap, "skuIds"));
        priceMap = EcGroupApiUtil.getEcPrice(params);
        return priceMap;
    }

    public static Map<String, BigDecimal> getEcFreight(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_GETFREIGHT", params);
        HashMap<String, BigDecimal> freightMap = new HashMap<String, BigDecimal>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Throwable)) {
                freightMap.put(entry.getKey(), (BigDecimal)value);
                continue;
            }
            throw new KDBizException(((Throwable)entry.getValue()).getMessage());
        }
        return freightMap;
    }

    public static Map<String, BigDecimal> getEcFreightMap(Map<String, Map<String, Object>> source_skuNumsMap, String addresId, String addrDetail, String paymentType) {
        Map<String, BigDecimal> freightMap = new HashMap<String, BigDecimal>();
        if (null == source_skuNumsMap || source_skuNumsMap.isEmpty()) {
            return freightMap;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> commonParam = new HashMap<String, String>(4);
        commonParam.putAll(EcGroupApiUtil.getAddrLevelMap(addresId));
        commonParam.put("paymentType", paymentType);
        commonParam.put("addrDetail", addrDetail);
        params.put("common_params", commonParam);
        params.putAll(EcGroupApiUtil.getSkuIdsMap(source_skuNumsMap, "skuNums"));
        freightMap = EcGroupApiUtil.getEcFreight(params);
        return freightMap;
    }

    public static Map<String, Map<String, String>> getEcSkuState(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_GETSKUSTATE", params);
        HashMap<String, Map<String, String>> skuStateMap = new HashMap<String, Map<String, String>>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Throwable) continue;
            skuStateMap.put(entry.getKey(), (Map)value);
        }
        return skuStateMap;
    }

    public static Map<String, Map<String, String>> getEcSkuStateMap(Map<String, List<String>> source_skuIdsMap) {
        Map<String, Map<String, String>> skuStateMap = new HashMap<String, Map<String, String>>();
        if (null == source_skuIdsMap || source_skuIdsMap.isEmpty()) {
            return skuStateMap;
        }
        Map<String, Object> params = EcGroupApiUtil.getSkuIdsMap(source_skuIdsMap, "skuIds");
        skuStateMap = EcGroupApiUtil.getEcSkuState(params);
        return skuStateMap;
    }

    public static Map<String, Map<String, List<ImageInfo>>> getEcSkuImg(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_GETIMGPATH", params);
        HashMap<String, Map<String, List<ImageInfo>>> imgMap = new HashMap<String, Map<String, List<ImageInfo>>>();
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Throwable) continue;
            imgMap.put(entry.getKey(), (Map)value);
        }
        return imgMap;
    }

    public static Map<String, Map<String, List<ImageInfo>>> getEcSkuImgMap(Map<String, List<String>> source_skuIdsMap) {
        Map<String, Map<String, List<ImageInfo>>> imgMap = new HashMap<String, Map<String, List<ImageInfo>>>();
        if (null == source_skuIdsMap || source_skuIdsMap.isEmpty()) {
            return imgMap;
        }
        Map<String, Object> params = EcGroupApiUtil.getSkuIdsMap(source_skuIdsMap, "skuIds");
        imgMap = EcGroupApiUtil.getEcSkuImg(params);
        return imgMap;
    }

    public static Map<String, Boolean> confirmEcOrder(Map<String, String> source_orderIdMap) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_CONFIRMORDER", EcGroupApiUtil.getOrderIdMap(source_orderIdMap, "orderId"));
        HashMap<String, Boolean> confirmRes = new HashMap<String, Boolean>(source_orderIdMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Throwable) continue;
            confirmRes.put(entry.getKey(), (Boolean)value);
        }
        return confirmRes;
    }

    public static Map<String, Boolean> cancelEcOrder(Map<String, String> source_orderIdMap) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_CANCELORDER", EcGroupApiUtil.getOrderIdMap(source_orderIdMap, "orderId"));
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(source_orderIdMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Throwable) continue;
            result.put(entry.getKey(), (Boolean)value);
        }
        return result;
    }

    public static Map<String, Map<String, String>> confirmOrderReceive(Map<String, String> skuConfirmMap, String pOrderId, String source) {
        HashMap<String, Map<String, String>> confirmMap = new HashMap(2);
        HashMap<String, Object> diffParams = new HashMap<String, Object>(2);
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        diffParams.put("orderId", pOrderId);
        diffParams.put("skuConfirmMap", skuConfirmMap);
        params.put(source, diffParams);
        confirmMap = EcGroupApiUtil.confirmOrderReceive(params);
        return confirmMap;
    }

    public static Map<String, Map<String, String>> confirmOrderReceive(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_CONFIRM_RECEIVED", params);
        HashMap<String, Map<String, String>> confirmMap = new HashMap<String, Map<String, String>>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Throwable)) {
                confirmMap.put(entry.getKey(), (Map)value);
                continue;
            }
            throw new KDBizException(((Throwable)entry.getValue()).getMessage());
        }
        return confirmMap;
    }

    public static Map<String, Map<String, StockInfo>> getEcStock(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_GETSTOCK", params);
        HashMap<String, Map<String, StockInfo>> stockMap = new HashMap<String, Map<String, StockInfo>>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Throwable)) {
                stockMap.put(entry.getKey(), (Map)value);
                continue;
            }
            log.warn("getEcStock=" + ((Throwable)entry.getValue()).getMessage());
        }
        return stockMap;
    }

    public static Map<String, Map<String, StockInfo>> getEcStock(Map<String, Map<String, Object>> source_skuNumsMap, String addresId) {
        Map<String, Map<String, StockInfo>> stockMap = new HashMap<String, Map<String, StockInfo>>();
        if (null == source_skuNumsMap || source_skuNumsMap.isEmpty()) {
            return stockMap;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> commonParam = new HashMap<String, String>(4);
        commonParam.putAll(EcGroupApiUtil.getAddrLevelMap(addresId));
        params.put("common_params", commonParam);
        params.putAll(EcGroupApiUtil.getSkuIdsMap(source_skuNumsMap, "skuNums"));
        stockMap = EcGroupApiUtil.getEcStock(params);
        return stockMap;
    }

    private static Map<String, String> getAddrLevelMap(String addresId) {
        HashMap<String, String> addrMap = new HashMap<String, String>(1);
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(addresId));
        DynamicObject data = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)LEVEL, (QFilter[])new QFilter[]{filter});
        if (null != data && StringUtils.isNotBlank((CharSequence)data.getString(LEVEL))) {
            if (data.get(LEVEL).toString().equalsIgnoreCase("3")) {
                addrMap.put("countyId", addresId);
            } else {
                addrMap.put("townId", addresId);
            }
        }
        return addrMap;
    }

    private static Map<String, Object> getSkuIdsMap(Map<String, ?> source_skuIdsMap, String key) {
        HashMap<String, Object> params = new HashMap<String, Object>(source_skuIdsMap.size());
        for (Map.Entry<String, ?> entry : source_skuIdsMap.entrySet()) {
            HashMap malParams = new HashMap(1);
            malParams.put(key, entry.getValue());
            params.put(entry.getKey(), malParams);
        }
        return params;
    }

    private static Map<String, Object> getOrderIdMap(Map<String, String> source_orderIdMap, String key) {
        HashMap<String, Object> params = new HashMap<String, Object>(source_orderIdMap.size());
        for (Map.Entry<String, String> entry : source_orderIdMap.entrySet()) {
            HashMap<String, String> malParams = new HashMap<String, String>(1);
            malParams.put(key, entry.getValue());
            params.put(entry.getKey(), malParams);
        }
        return params;
    }

    public static Map<String, Map<String, Object>> addInvoice(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_ADDINVOICE", params);
        HashMap<String, Map<String, Object>> invoiceStateMap = new HashMap<String, Map<String, Object>>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Throwable)) {
                invoiceStateMap.put(entry.getKey(), (Map)value);
                continue;
            }
            throw new KDBizException(((Throwable)entry.getValue()).getMessage());
        }
        if (invoiceStateMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7535\u5546\u53ef\u80fd\u5df2\u505c\u7528\uff0c\u8bf7\u5230\u5546\u57ce\u7ba1\u7406-\u57fa\u7840\u8bbe\u7f6e-\u7535\u5546\u6388\u6743\u68c0\u67e5\u5f00\u901a\u72b6\u6001\u3002", (String)"EcGroupApiUtil_0", (String)"scm-common-helper", (Object[])new Object[0]));
        }
        return invoiceStateMap;
    }

    public static Map<String, Map<String, Object>> queryInvoice(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_QUERYINVOICE", params);
        HashMap<String, Map<String, Object>> invoiceMap = new HashMap<String, Map<String, Object>>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Throwable)) {
                invoiceMap.put(entry.getKey(), (Map)value);
                continue;
            }
            throw new KDBizException(((Throwable)entry.getValue()).getMessage());
        }
        return invoiceMap;
    }

    public static Map<String, List<Map<String, Object>>> queryEInvoice(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_QUERYEINVOICE", params);
        HashMap<String, List<Map<String, Object>>> invoiceMap = new HashMap<String, List<Map<String, Object>>>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Throwable)) {
                invoiceMap.put(entry.getKey(), (List)value);
                continue;
            }
            throw new KDBizException(((Throwable)entry.getValue()).getMessage());
        }
        return invoiceMap;
    }

    public static Map<String, List<Map<String, String>>> queryInvoicelogist(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_QUERYEINVOICELOGIST", params);
        HashMap<String, List<Map<String, String>>> logistMap = new HashMap<String, List<Map<String, String>>>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Throwable)) {
                logistMap.put(entry.getKey(), (List)((Map)value).get("result"));
                continue;
            }
            throw new KDBizException(((Throwable)entry.getValue()).getMessage());
        }
        return logistMap;
    }

    public static Map<String, Map<String, GoodsInfo>> getEcProdDetail(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_GETPRODDETAIL", params);
        HashMap<String, Map<String, GoodsInfo>> prodMap = new HashMap<String, Map<String, GoodsInfo>>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Throwable) continue;
            prodMap.put(entry.getKey(), (Map)value);
        }
        return prodMap;
    }

    public static Map<String, Map<String, OrderTrackDTO>> getEcOrderTrack(Map<String, String> orderTrack, String pOrderId, String source) {
        HashMap<String, Map<String, OrderTrackDTO>> logisticsMap = new HashMap(2);
        HashMap<String, Object> diffParams = new HashMap<String, Object>(2);
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        diffParams.put("orderId", pOrderId);
        diffParams.put("skuOrderMap", orderTrack);
        params.put(source, diffParams);
        logisticsMap = EcGroupApiUtil.getEcOrderTrack(params);
        return logisticsMap;
    }

    public static Map<String, Map<String, OrderTrackDTO>> getEcOrderTrack(Map<String, Object> params) {
        Map<String, Object> resMap = ApiAccessor.invokeGroup("SRM_EC_GETORDERTRACK", params);
        HashMap<String, Map<String, OrderTrackDTO>> logisticsMap = new HashMap<String, Map<String, OrderTrackDTO>>(resMap.size());
        for (Map.Entry<String, Object> entry : resMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Throwable) continue;
            logisticsMap.put(entry.getKey(), (Map)value);
        }
        return logisticsMap;
    }

    public static Map<String, Object> getEcOrderStatusMap(String orderId, String source) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("orderId", orderId);
        params.put(source, param);
        return ApiAccessor.invokeGroup("SRM_EC_ORDER_STATUS", params);
    }

    public static Map<String, Object> getEcOrderDetail(String orderId, String source) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("orderId", orderId);
        params.put(source, param);
        return ApiAccessor.invokeGroup("SRM_EC_ORDER_DETAIL", params);
    }

    public static Map<String, Map<String, List<AfterSaleServiceTypeEnum>>> getEcAfterServce(Map<String, Object> sourceAfterSaleParamMap) {
        HashMap<String, Map<String, List<AfterSaleServiceTypeEnum>>> result = new HashMap<String, Map<String, List<AfterSaleServiceTypeEnum>>>();
        Map<String, Object> res = ApiAccessor.invokeGroup("SRM_EC_QUERYAFTERSERVICE", sourceAfterSaleParamMap);
        res.forEach((key, value) -> {
            if (value instanceof Throwable) {
                throw new KDBizException(((Throwable)value).getMessage());
            }
            result.put((String)key, (Map)value);
        });
        return result;
    }

    public static Map<String, Object> queryEcCheckOrder(Map<String, Object> sourceCheckOrderGroupParamMap) {
        return ApiAccessor.invokeGroup("SRM_EC_CHECKORDER", sourceCheckOrderGroupParamMap);
    }
}

