/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.businesstracking;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.helper.businesstracking.SRMBillRelationSchemeHelper;
import kd.scm.common.helper.businesstracking.design.BillRelationDesignLinkInfo;

public final class SRMBusinessTrackerExecuteHelper {
    private static final Log log = LogFactory.getLog(SRMBusinessTrackerExecuteHelper.class);

    public static LinkedHashMap<String, Collection<Long>> assembleTrackerList(String executebillrelationid, String executeEntityNumber, Long executebillid) {
        LinkedHashMap<String, Collection<Long>> collectionLinkedHashMap = new LinkedHashMap<String, Collection<Long>>(16);
        DynamicObject executebillrelation = SRMBillRelationSchemeHelper.getBillRelationCache(executebillrelationid);
        LinkedHashMap<String, Collection<BillRelationDesignLinkInfo>> billDesignSchemeData = SRMBillRelationSchemeHelper.assembleBillDesignSchemeData(executebillrelation);
        if ("pur_order".equals(executeEntityNumber) || "scp_order".equals(executeEntityNumber)) {
            HashSet<Object> poEntryIdSet = new HashSet<Object>(64);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"pur_order", (String)"materialentry.poentryid poentryid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)executebillid)}, (String)"id");
            Object object = null;
            try {
                DataSet groupDataSet = dataSet.groupBy(new String[]{"poentryid"}).finish();
                while (groupDataSet.hasNext()) {
                    Row row2 = groupDataSet.next();
                    String poEntryId = row2.getString("poentryid");
                    if (poEntryId == null || poEntryId.trim().isEmpty()) continue;
                    poEntryIdSet.add(poEntryId);
                }
                groupDataSet.close();
            }
            catch (Throwable groupDataSet) {
                object = groupDataSet;
                throw groupDataSet;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable groupDataSet) {
                            ((Throwable)object).addSuppressed(groupDataSet);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            if (!poEntryIdSet.isEmpty()) {
                Collection<BillRelationDesignLinkInfo> directEntityInfo = billDesignSchemeData.get(executeEntityNumber);
                for (BillRelationDesignLinkInfo targetDesignNodeInfo : directEntityInfo) {
                    targetDesignNodeInfo.setLinkValues(poEntryIdSet);
                    targetDesignNodeInfo.getSourceInfo().addBillId(executebillid);
                }
            }
            for (Map.Entry<String, Collection<BillRelationDesignLinkInfo>> entry : billDesignSchemeData.entrySet()) {
                Collection<BillRelationDesignLinkInfo> directEntityInfo = entry.getValue();
                HashSet<Long> stepBillIds = new HashSet<Long>(1024);
                if (directEntityInfo.isEmpty()) continue;
                BillRelationDesignLinkInfo billRelationDesignLinkInfo = directEntityInfo.stream().findFirst().get();
                stepBillIds.addAll(billRelationDesignLinkInfo.getSourceInfo().getBillIds());
                for (BillRelationDesignLinkInfo designInfo : directEntityInfo) {
                    String designInfoDefineLink = designInfo.getDefineLink();
                    if ("3DNB1TJBXL99".equals(designInfoDefineLink)) {
                        HashSet<Long> stepBillIdSet = new HashSet<Long>(64);
                        QFilter qFilter = new QFilter("materialentry.poentryid", "in", designInfo.getLinkValues());
                        try (DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"", (String)designInfo.getTargetInfo().getMajorEntityNumber(), (String)"id", (QFilter[])new QFilter[]{SRMBusinessTrackerExecuteHelper.getCustomQFilter(designInfo.getTargetInfo().getMajorEntityNumber(), qFilter)}, (String)"id");){
                            DataSet groupDataSet = dataSet2.groupBy(new String[]{"id"}).finish();
                            while (groupDataSet.hasNext()) {
                                Row row3 = groupDataSet.next();
                                Long billId = row3.getLong("id");
                                stepBillIdSet.add(billId);
                            }
                            groupDataSet.close();
                        }
                        if (stepBillIdSet.isEmpty()) continue;
                        designInfo.getTargetInfo().addAllBillIds(stepBillIdSet);
                        collectionLinkedHashMap.put(designInfo.getTargetInfo().getMajorEntityNumber(), stepBillIdSet);
                        Collection<BillRelationDesignLinkInfo> relationDesignLinkInfos = billDesignSchemeData.get(designInfo.getTargetInfo().getMajorEntityNumber());
                        if (relationDesignLinkInfos == null || relationDesignLinkInfos.isEmpty()) continue;
                        relationDesignLinkInfos.forEach(row -> {
                            row.setLinkValues(poEntryIdSet);
                            row.getSourceInfo().addAllBillIds(stepBillIdSet);
                        });
                        continue;
                    }
                    if (!"3DNB6+0FIY5L".equals(designInfoDefineLink)) continue;
                    Map targetBillMap = BFTrackerServiceHelper.findTargetBills((String)designInfo.getSourceInfo().getExecuteEntityNumber(), (Long[])stepBillIds.toArray(new Long[0]));
                    targetBillMap.putAll(BFTrackerServiceHelper.findTargetBills((String)designInfo.getSourceInfo().getMajorEntityNumber(), (Long[])stepBillIds.toArray(new Long[0])));
                    String entityNumber = designInfo.getTargetInfo().getExecuteEntityNumber();
                    Set targetBillIds = (Set)targetBillMap.get(entityNumber);
                    if (targetBillIds == null || targetBillIds.isEmpty()) continue;
                    collectionLinkedHashMap.put(designInfo.getTargetInfo().getMajorEntityNumber(), targetBillIds);
                    designInfo.getTargetInfo().addAllBillIds(targetBillIds);
                }
            }
        }
        return collectionLinkedHashMap;
    }

    private static QFilter getCustomQFilter(String entityNumber, QFilter qFilter) {
        switch (entityNumber) {
            case "pur_receipt": 
            case "scp_receipt": {
                qFilter.and(new QFilter("isreturn", "=", (Object)Boolean.FALSE));
                break;
            }
            case "pur_receipt_return": 
            case "scp_return_receipt": {
                qFilter.and(new QFilter("isreturn", "=", (Object)Boolean.TRUE));
            }
        }
        return qFilter;
    }
}

