/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.businesstracking.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scm.common.helper.SRMBillEntityTypeHelper;
import kd.scm.common.helper.businesstracking.SRMBillRelationSchemeHelper;
import kd.scm.common.helper.businesstracking.design.BillRelationDesignLinkInfo;

final class BusinessTrackingEngine {
    BusinessTrackingEngine() {
    }

    public LinkedHashMap<String, Collection<BillRelationDesignLinkInfo>> assembleBillSchemeData(DynamicObject executeBillRelation, String executeEntityNumber, Long executeBillId) {
        Map<String, Integer> billRelationGraphSet = SRMBillRelationSchemeHelper.getBillRelationGraphSet(executeBillRelation);
        Integer executeEntitySeq = billRelationGraphSet.get(executeEntityNumber);
        LinkedList sourceEntitys = new LinkedList();
        LinkedList targetEntitys = new LinkedList();
        billRelationGraphSet.forEach((k, v) -> {
            if (executeEntitySeq.compareTo((Integer)v) > 0) {
                sourceEntitys.addFirst(k);
            } else if (executeEntitySeq.compareTo((Integer)v) < 0) {
                targetEntitys.addLast(k);
            }
        });
        LinkedHashMap<String, Collection<BillRelationDesignLinkInfo>> billDesignSchemeData = SRMBillRelationSchemeHelper.assembleBillDesignSchemeData(executeBillRelation);
        Collection<BillRelationDesignLinkInfo> currencyInfo = this.assembleCurrency(executeEntityNumber, "all", billDesignSchemeData);
        Collection<String> assembleFields = this.assembleFields(executeEntityNumber, currencyInfo);
        String entityFields = SRMBillEntityTypeHelper.getEntityFields(executeEntityNumber, assembleFields);
        Optional<BillRelationDesignLinkInfo> infoOptional = currencyInfo.stream().filter(row -> row.getTargetInfo().getEntryDim() != false || row.getSourceInfo().getEntryDim() != false).findFirst();
        BillRelationDesignLinkInfo relationDesignLinkInfo = null;
        if (infoOptional.isPresent()) {
            relationDesignLinkInfo = infoOptional.get();
            String entryNumber = relationDesignLinkInfo.getSourceInfo().getEntryNumber();
            entityFields = entryNumber + ".id entryid," + entityFields;
        }
        Map<String, Collection<Object>> linkStepValue = this.assembleLinkStepValue(executeEntityNumber, entityFields, new QFilter("id", "=", (Object)executeBillId));
        this.assembleDirectNode(executeEntityNumber, linkStepValue, currencyInfo);
        for (String entityNumber : sourceEntitys) {
            this.assembleLinkNode(entityNumber, "up", billDesignSchemeData);
        }
        for (String entityNumber : targetEntitys) {
            this.assembleLinkNode(entityNumber, "down", billDesignSchemeData);
        }
        return billDesignSchemeData;
    }

    private void assembleLinkNode(String executeEntityNumber, String huntDirect, LinkedHashMap<String, Collection<BillRelationDesignLinkInfo>> billDesignSchemeData) {
        Collection<BillRelationDesignLinkInfo> allInfo = this.assembleCurrency(executeEntityNumber, "all", billDesignSchemeData);
        HashMap<String, Collection<Object>> filterStepValue = new HashMap<String, Collection<Object>>(1024);
        HashSet<Long> allBillValues = new HashSet<Long>(1024);
        Collection stepLinkValues = null;
        for (BillRelationDesignLinkInfo designLinkInfo : allInfo) {
            ArrayList linkLongValues;
            Class<?> fieldKeyClass;
            Collection<Long> billIds;
            Collection<Object> linkValues = designLinkInfo.getLinkValues();
            if (executeEntityNumber.equals(designLinkInfo.getTargetInfo().getMajorEntityNumber())) {
                billIds = designLinkInfo.getTargetInfo().getBillIds();
                if (billIds != null && !billIds.isEmpty()) {
                    allBillValues.addAll(billIds);
                }
                if (linkValues == null || linkValues.isEmpty()) continue;
                fieldKeyClass = designLinkInfo.getTargetInfo().getFieldKeyClass();
                stepLinkValues = (Collection)filterStepValue.get(designLinkInfo.getTargetInfo().getFullFiledKey());
                if (TextProp.class.equals(fieldKeyClass)) {
                    ArrayList linkStringValues = new ArrayList(linkValues.size());
                    linkValues.forEach(row -> linkStringValues.add(row.toString()));
                    if (stepLinkValues != null) {
                        linkStringValues.addAll(stepLinkValues);
                    }
                    filterStepValue.put(designLinkInfo.getTargetInfo().getFullFiledKey(), linkStringValues);
                    continue;
                }
                if (BigIntProp.class.equals(fieldKeyClass) || LongProp.class.equals(fieldKeyClass)) {
                    linkLongValues = new ArrayList(linkValues.size());
                    linkValues.forEach(row -> linkLongValues.add(Long.parseLong(row.toString())));
                    if (stepLinkValues != null) {
                        linkLongValues.addAll(stepLinkValues);
                    }
                    filterStepValue.put(designLinkInfo.getTargetInfo().getFullFiledKey(), linkLongValues);
                    continue;
                }
                if (stepLinkValues != null) {
                    linkValues.addAll(stepLinkValues);
                }
                filterStepValue.put(designLinkInfo.getTargetInfo().getFullFiledKey(), linkValues);
                continue;
            }
            if (!executeEntityNumber.equals(designLinkInfo.getSourceInfo().getMajorEntityNumber())) continue;
            billIds = designLinkInfo.getSourceInfo().getBillIds();
            if (billIds != null && !billIds.isEmpty()) {
                allBillValues.addAll(billIds);
            }
            if (linkValues == null || linkValues.isEmpty()) continue;
            fieldKeyClass = designLinkInfo.getSourceInfo().getFieldKeyClass();
            if (LongProp.class.equals(fieldKeyClass)) {
                linkLongValues = new ArrayList(linkValues.size());
                linkValues.forEach(row -> linkLongValues.add(Long.parseLong(row.toString())));
                if (stepLinkValues != null) {
                    linkLongValues.addAll(stepLinkValues);
                }
                filterStepValue.put(designLinkInfo.getSourceInfo().getFullFiledKey(), linkLongValues);
                continue;
            }
            if (stepLinkValues != null) {
                linkValues.addAll(stepLinkValues);
            }
            filterStepValue.put(designLinkInfo.getSourceInfo().getFullFiledKey(), linkValues);
        }
        Optional<BillRelationDesignLinkInfo> isEntryDimOptional = allInfo.stream().filter(row -> row.getSourceInfo().getEntryDim() != false || row.getTargetInfo().getEntryDim() != false).findAny();
        Optional<BillRelationDesignLinkInfo> atLeastOptional = allInfo.stream().filter(row -> row.getSourceInfo().getMajorEntityNumber().equals(executeEntityNumber) || row.getTargetInfo().getMajorEntityNumber().equals(executeEntityNumber)).findAny();
        boolean isEntryDim = Boolean.FALSE;
        if (isEntryDimOptional.isPresent()) {
            isEntryDim = true;
        }
        BillRelationDesignLinkInfo relationDesignLinkInfo = null;
        if (atLeastOptional.isPresent()) {
            relationDesignLinkInfo = atLeastOptional.get();
        }
        if (relationDesignLinkInfo != null) {
            Collection<String> assembleFields = this.assembleFields(executeEntityNumber, allInfo);
            QFilter qFilter = new QFilter("id", "in", allBillValues);
            QFilter linkValueFilter = null;
            if (!filterStepValue.isEmpty()) {
                for (Map.Entry entry : filterStepValue.entrySet()) {
                    if (linkValueFilter == null) {
                        linkValueFilter = new QFilter((String)entry.getKey(), "in", entry.getValue());
                        continue;
                    }
                    linkValueFilter.or(new QFilter((String)entry.getKey(), "in", entry.getValue()));
                }
            }
            if (linkValueFilter != null) {
                qFilter.or(linkValueFilter);
            }
            String entityFields = SRMBillEntityTypeHelper.getEntityFields(executeEntityNumber, assembleFields);
            if (isEntryDim) {
                String entryNumber = relationDesignLinkInfo.getSourceInfo().getEntryNumber();
                entityFields = entryNumber + ".id entryid," + entityFields;
            }
            Map<String, Collection<Object>> linkStepValue = this.assembleLinkStepValue(executeEntityNumber, entityFields, qFilter);
            HashSet<Long> stepBillIds = new HashSet<Long>(1024);
            Collection<Object> linkBillIds = linkStepValue.get("id");
            if (linkBillIds != null && !linkBillIds.isEmpty()) {
                linkBillIds.forEach(row -> stepBillIds.add(Long.parseLong(row.toString())));
            }
            stepBillIds.addAll(allBillValues);
            for (BillRelationDesignLinkInfo designLinkInfo : allInfo) {
                Collection<Object> stepValue;
                String fieldKey = null;
                if ("down".equals(huntDirect) && executeEntityNumber.equals(designLinkInfo.getTargetInfo().getMajorEntityNumber())) {
                    fieldKey = designLinkInfo.getTargetInfo().getFiledKey();
                    stepValue = linkStepValue.get(fieldKey);
                    if (stepValue == null || stepValue.isEmpty()) {
                        fieldKey = designLinkInfo.getTargetInfo().getFiledKey();
                        stepValue = linkStepValue.get(fieldKey);
                    }
                    if (stepValue != null && !stepValue.isEmpty()) {
                        designLinkInfo.setLinkValues(stepValue);
                    }
                    designLinkInfo.getTargetInfo().addAllBillIds(stepBillIds);
                    continue;
                }
                if (!"up".equals(huntDirect) || !executeEntityNumber.equals(designLinkInfo.getSourceInfo().getMajorEntityNumber())) continue;
                fieldKey = designLinkInfo.getSourceInfo().getFiledKey();
                stepValue = linkStepValue.get(fieldKey);
                if (stepValue == null || stepValue.isEmpty()) {
                    fieldKey = designLinkInfo.getSourceInfo().getFiledKey();
                    stepValue = linkStepValue.get(fieldKey);
                }
                if (stepValue != null && !stepValue.isEmpty()) {
                    designLinkInfo.setLinkValues(stepValue);
                }
                designLinkInfo.getSourceInfo().addAllBillIds(stepBillIds);
            }
            Collection<BillRelationDesignLinkInfo> currencyInfo = this.assembleCurrency(executeEntityNumber, huntDirect, billDesignSchemeData);
            this.assembleDirectNode(executeEntityNumber, linkStepValue, currencyInfo);
            String nextEntityNumber = null;
            String lastEntityNumber = null;
            for (BillRelationDesignLinkInfo designLinkInfo : currencyInfo) {
                lastEntityNumber = designLinkInfo.getSourceInfo().getMajorEntityNumber();
                nextEntityNumber = designLinkInfo.getTargetInfo().getMajorEntityNumber();
                if ("down".equals(huntDirect)) {
                    this.assembleLinkNode(nextEntityNumber, huntDirect, billDesignSchemeData);
                    continue;
                }
                if (!"up".equals(huntDirect)) continue;
                this.assembleLinkNode(lastEntityNumber, huntDirect, billDesignSchemeData);
            }
        }
    }

    private void assembleDirectNode(String executeEntityNumber, Map<String, Collection<Object>> linkStepValue, Collection<BillRelationDesignLinkInfo> currencyInfo) {
        HashSet<Long> stepBillIds = new HashSet<Long>(1024);
        Collection<Object> linkBillIds = linkStepValue.get("id");
        if (linkBillIds != null && !linkBillIds.isEmpty()) {
            linkBillIds.forEach(row -> stepBillIds.add(Long.parseLong(row.toString())));
        }
        for (BillRelationDesignLinkInfo designLinkInfo : currencyInfo) {
            String entityNumber;
            String fieldKey = null;
            String designInfoDefineLink = designLinkInfo.getDefineLink();
            if ("3DNB1TJBXL99".equals(designInfoDefineLink)) {
                Collection<Object> stepValue;
                if (executeEntityNumber.equals(designLinkInfo.getTargetInfo().getMajorEntityNumber())) {
                    fieldKey = designLinkInfo.getTargetInfo().getFiledKey();
                    stepValue = linkStepValue.get(fieldKey);
                    if (stepValue == null || stepValue.isEmpty()) {
                        fieldKey = designLinkInfo.getSourceInfo().getFiledKey();
                        stepValue = linkStepValue.get(fieldKey);
                    }
                    designLinkInfo.setLinkValues(stepValue);
                    designLinkInfo.getTargetInfo().addAllBillIds(stepBillIds);
                    continue;
                }
                if (!executeEntityNumber.equals(designLinkInfo.getSourceInfo().getMajorEntityNumber())) continue;
                fieldKey = designLinkInfo.getSourceInfo().getFiledKey();
                stepValue = linkStepValue.get(fieldKey);
                if (stepValue == null || stepValue.isEmpty()) {
                    fieldKey = designLinkInfo.getTargetInfo().getFiledKey();
                    stepValue = linkStepValue.get(fieldKey);
                }
                designLinkInfo.setLinkValues(stepValue);
                designLinkInfo.getSourceInfo().addAllBillIds(stepBillIds);
                continue;
            }
            if (!"3DNB6+0FIY5L".equals(designInfoDefineLink)) continue;
            HashMap targetBillMap = new HashMap(16);
            Set targetBillIds = null;
            Set sourceBillIds = null;
            if (executeEntityNumber.equals(designLinkInfo.getSourceInfo().getMajorEntityNumber())) {
                designLinkInfo.getSourceInfo().addAllBillIds(stepBillIds);
                targetBillMap.putAll(BFTrackerServiceHelper.findTargetBills((String)designLinkInfo.getSourceInfo().getExecuteEntityNumber(), (Long[])stepBillIds.toArray(new Long[0])));
                targetBillMap.putAll(BFTrackerServiceHelper.findTargetBills((String)designLinkInfo.getSourceInfo().getMajorEntityNumber(), (Long[])stepBillIds.toArray(new Long[0])));
                entityNumber = designLinkInfo.getTargetInfo().getExecuteEntityNumber();
                targetBillIds = (Set)targetBillMap.get(entityNumber);
            } else if (executeEntityNumber.equals(designLinkInfo.getTargetInfo().getMajorEntityNumber())) {
                designLinkInfo.getTargetInfo().addAllBillIds(stepBillIds);
                targetBillMap.putAll(BFTrackerServiceHelper.findSourceBills((String)designLinkInfo.getTargetInfo().getExecuteEntityNumber(), (Long[])stepBillIds.toArray(new Long[0])));
                targetBillMap.putAll(BFTrackerServiceHelper.findSourceBills((String)designLinkInfo.getTargetInfo().getMajorEntityNumber(), (Long[])stepBillIds.toArray(new Long[0])));
                entityNumber = designLinkInfo.getSourceInfo().getExecuteEntityNumber();
                sourceBillIds = (Set)targetBillMap.get(entityNumber);
            }
            if (targetBillIds != null && !targetBillIds.isEmpty()) {
                designLinkInfo.getTargetInfo().addAllBillIds(targetBillIds);
            }
            if (sourceBillIds != null && !sourceBillIds.isEmpty()) {
                designLinkInfo.getSourceInfo().addAllBillIds(sourceBillIds);
            }
            designLinkInfo.setLinkValues(linkStepValue.get("id"));
        }
    }

    private Collection<BillRelationDesignLinkInfo> assembleCurrency(String executeNumber, String huntDirect, LinkedHashMap<String, Collection<BillRelationDesignLinkInfo>> billDesignSchemeData) {
        HashSet all = new HashSet(64);
        billDesignSchemeData.forEach((key, value) -> all.addAll(value));
        ArrayList<BillRelationDesignLinkInfo> resultInfo = new ArrayList<BillRelationDesignLinkInfo>(64);
        ArrayList<BillRelationDesignLinkInfo> nextInfo = new ArrayList<BillRelationDesignLinkInfo>(64);
        Collection<BillRelationDesignLinkInfo> directLinkInfo = billDesignSchemeData.get(executeNumber);
        if (directLinkInfo != null && !directLinkInfo.isEmpty()) {
            nextInfo.addAll(directLinkInfo);
        }
        ArrayList<BillRelationDesignLinkInfo> lastInfo = new ArrayList<BillRelationDesignLinkInfo>(64);
        if (!all.isEmpty()) {
            for (BillRelationDesignLinkInfo designLinkInfo : all) {
                if (!designLinkInfo.getTargetInfo().getMajorEntityNumber().equals(executeNumber)) continue;
                lastInfo.add(designLinkInfo);
            }
        }
        switch (huntDirect) {
            case "all": {
                resultInfo.addAll(nextInfo);
                resultInfo.addAll(lastInfo);
                break;
            }
            case "up": {
                resultInfo.addAll(lastInfo);
                break;
            }
            case "down": {
                resultInfo.addAll(nextInfo);
            }
        }
        return resultInfo;
    }

    private Collection<String> assembleCurrencyGraph(String executeNumber, String huntDirect, Map<String, Collection<String>> entityGraphMap) {
        ArrayList lastInfo = new ArrayList(1024);
        entityGraphMap.forEach((key, value) -> {
            if (value != null && value.contains(executeNumber)) {
                lastInfo.add(key);
            }
        });
        ArrayList<String> resultInfo = new ArrayList<String>(1024);
        ArrayList<String> nextInfo = new ArrayList<String>(1024);
        Collection<String> directLinkInfo = entityGraphMap.get(executeNumber);
        if (directLinkInfo != null && !directLinkInfo.isEmpty()) {
            nextInfo.addAll(directLinkInfo);
        }
        switch (huntDirect) {
            case "up": {
                resultInfo.addAll(lastInfo);
                break;
            }
            case "down": {
                resultInfo.addAll(nextInfo);
            }
        }
        return resultInfo;
    }

    private Collection<String> assembleFields(String executeEntityNumber, Collection<BillRelationDesignLinkInfo> linkInfoCollection) {
        HashSet<String> selectField = new HashSet<String>(64);
        for (BillRelationDesignLinkInfo designLinkInfo : linkInfoCollection) {
            if (designLinkInfo.getSourceInfo().getMajorEntityNumber().equals(executeEntityNumber)) {
                selectField.add(designLinkInfo.getSourceInfo().getFiledKey());
                continue;
            }
            if (!designLinkInfo.getTargetInfo().getMajorEntityNumber().equals(executeEntityNumber)) continue;
            selectField.add(designLinkInfo.getTargetInfo().getFiledKey());
        }
        return selectField;
    }

    private Map<String, Collection<Object>> assembleLinkStepValue(String entityNumber, String entityFields, QFilter qFilter) {
        HashMap<String, Collection<Object>> fieldValueMap = new HashMap<String, Collection<Object>>(1024);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BusinessTrackingEngine#Query", (String)entityNumber, (String)entityFields, (QFilter[])new QFilter[]{this.getCustomQFilter(entityNumber, qFilter)}, (String)"id");){
            String[] fieldNames = dataSet.getRowMeta().getFieldNames();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                for (String fieldName : fieldNames) {
                    Object fieldValue;
                    HashSet<Object> stepValue = (HashSet<Object>)fieldValueMap.get(fieldName);
                    if (stepValue == null) {
                        stepValue = new HashSet<Object>(1024);
                    }
                    if ((fieldValue = row.get(fieldName)) != null) {
                        if (fieldValue instanceof String) {
                            String fieldString = fieldValue.toString();
                            if (!fieldString.isEmpty() && !"0".equals(fieldString)) {
                                stepValue.add(fieldValue);
                            }
                        } else if (fieldValue instanceof Long) {
                            if (!fieldValue.equals(0L)) {
                                stepValue.add(fieldValue);
                            }
                        } else {
                            stepValue.add(fieldValue);
                        }
                    }
                    fieldValueMap.put(fieldName, stepValue);
                }
            }
        }
        return fieldValueMap;
    }

    private Map<String, Collection<Object>> getLinkSourceData(BillRelationDesignLinkInfo relationDesignLinkInfo) {
        HashMap<String, Collection<Object>> linkStepValue = new HashMap<String, Collection<Object>>(1024);
        HashSet stepBillIds = new HashSet(1024);
        Collection<Object> linkValues = relationDesignLinkInfo.getLinkValues();
        Map targetBillMap = BFTrackerServiceHelper.findSourceBills((String)relationDesignLinkInfo.getSourceInfo().getExecuteEntityNumber(), (Long[])stepBillIds.toArray(new Long[0]));
        targetBillMap.putAll(BFTrackerServiceHelper.findSourceBills((String)relationDesignLinkInfo.getSourceInfo().getMajorEntityNumber(), (Long[])stepBillIds.toArray(new Long[0])));
        String entityNumber = relationDesignLinkInfo.getTargetInfo().getExecuteEntityNumber();
        Set targetBillIds = (Set)targetBillMap.get(entityNumber);
        if (targetBillIds != null && !targetBillIds.isEmpty()) {
            relationDesignLinkInfo.getTargetInfo().addAllBillIds(targetBillIds);
        }
        return linkStepValue;
    }

    private Map<String, Collection<Object>> getLinkTargetData(BillRelationDesignLinkInfo relationDesignLinkInfo) {
        HashMap<String, Collection<Object>> linkStepValue = new HashMap<String, Collection<Object>>(1024);
        HashSet stepBillIds = new HashSet(1024);
        Collection<Object> linkValues = relationDesignLinkInfo.getLinkValues();
        Map targetBillMap = BFTrackerServiceHelper.findTargetBills((String)relationDesignLinkInfo.getSourceInfo().getExecuteEntityNumber(), (Long[])stepBillIds.toArray(new Long[0]));
        targetBillMap.putAll(BFTrackerServiceHelper.findTargetBills((String)relationDesignLinkInfo.getSourceInfo().getMajorEntityNumber(), (Long[])stepBillIds.toArray(new Long[0])));
        String entityNumber = relationDesignLinkInfo.getTargetInfo().getExecuteEntityNumber();
        Set targetBillIds = (Set)targetBillMap.get(entityNumber);
        if (targetBillIds != null && !targetBillIds.isEmpty()) {
            relationDesignLinkInfo.getTargetInfo().addAllBillIds(targetBillIds);
        }
        return linkStepValue;
    }

    private QFilter getCustomQFilter(String entityNumber, QFilter qFilter) {
        switch (entityNumber) {
            case "pur_receipt": 
            case "scp_receipt": {
                qFilter.and(new QFilter("isreturn", "=", (Object)Boolean.FALSE));
                break;
            }
            case "pur_receipt_return": 
            case "scp_return_receipt": {
                qFilter.and(new QFilter("isreturn", "=", (Object)Boolean.TRUE));
                break;
            }
            case "pur_saloutstock": 
            case "scp_saloutstock": {
                qFilter.and(new QFilter("tarbilltype", "=", (Object)"1"));
                break;
            }
            case "pur_accept_apply": 
            case "scp_accept_apply": {
                qFilter.and(new QFilter("tarbilltype", "=", (Object)"2"));
                break;
            }
            case "src_project": 
            case "src_bidpublish": 
            case "src_decision": 
            case "src_contract": {
                qFilter.and(new QFilter("bizstatus", "!=", (Object)"A")).and(new QFilter("bizstatus", "!=", (Object)" "));
            }
        }
        return qFilter;
    }
}

