/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.businesstracking.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.common.helper.businesstracking.SRMBillRelationSchemeHelper;
import kd.scm.common.helper.businesstracking.design.BillRelationDesignLinkInfo;
import kd.scm.common.helper.businesstracking.runtime.BusinessTrackingEngine;

final class BusinessTrackingListService {
    BusinessTrackingListService() {
    }

    public LinkedHashMap<String, Collection<Long>> assembleBillListData(String executeBillRelationId, String executeEntityNumber, Long executeBillId) {
        LinkedHashMap<String, Collection<Long>> collectionLinkedHashMap = new LinkedHashMap<String, Collection<Long>>(16);
        DynamicObject executeBillRelation = SRMBillRelationSchemeHelper.getBillRelationCache(executeBillRelationId);
        BusinessTrackingEngine businessTrackingEngine = new BusinessTrackingEngine();
        LinkedHashMap<String, Collection<BillRelationDesignLinkInfo>> billSchemeData = businessTrackingEngine.assembleBillSchemeData(executeBillRelation, executeEntityNumber, executeBillId);
        billSchemeData.keySet().forEach(row -> {
            Collection cfr_ignored_0 = collectionLinkedHashMap.put((String)row, new HashSet(1024));
        });
        Collection<Long> stepSourceBillIds = null;
        Collection<Long> stepTargetBillIds = null;
        HashSet all = new HashSet(1024);
        billSchemeData.forEach((key, value) -> all.addAll(value));
        for (BillRelationDesignLinkInfo designLinkInfo : all) {
            Collection<Long> billIds;
            Collection<Long> sourceBillIds;
            String sourceEntity = designLinkInfo.getSourceInfo().getMajorEntityNumber();
            String targetEntity = designLinkInfo.getTargetInfo().getMajorEntityNumber();
            stepSourceBillIds = collectionLinkedHashMap.get(sourceEntity);
            if (stepSourceBillIds == null) {
                stepSourceBillIds = new HashSet<Long>();
            }
            if ((sourceBillIds = designLinkInfo.getSourceInfo().getBillIds()) != null && !sourceBillIds.isEmpty()) {
                stepSourceBillIds.addAll(sourceBillIds);
            }
            collectionLinkedHashMap.put(sourceEntity, stepSourceBillIds);
            stepTargetBillIds = collectionLinkedHashMap.get(targetEntity);
            if (stepTargetBillIds == null) {
                stepTargetBillIds = new HashSet<Long>();
            }
            if ((billIds = designLinkInfo.getTargetInfo().getBillIds()) != null && !billIds.isEmpty()) {
                stepTargetBillIds.addAll(billIds);
            }
            collectionLinkedHashMap.put(targetEntity, stepTargetBillIds);
        }
        return collectionLinkedHashMap;
    }
}

