/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.datahandle;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.ReadWhere;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.datahandle.PurDataHandleContext;
import kd.scm.common.helper.datahandle.TaskStatusEnum;
import kd.scm.common.helper.datahandle.entity.PurDataHandleResultEntryRow;
import kd.scm.common.helper.datahandle.entity.PurDataHandleResultHeader;
import kd.scm.common.helper.datahandle.utils.TimeUtils;

public class PurDataHandleResult {
    protected static final Log logger = LogFactory.getLog(PurDataHandleResult.class);
    private IDataEntityType resultHeadType;
    private IDataEntityType resultEntryType;
    private PurDataHandleResultHeader purDataHandleResult;

    public IDataEntityType getResultHeadType() {
        if (this.resultHeadType == null) {
            this.resultHeadType = OrmUtils.getDataEntityType(PurDataHandleResultHeader.class);
        }
        return this.resultHeadType;
    }

    public IDataEntityType getResultEntryType() {
        if (this.resultEntryType == null) {
            this.resultEntryType = OrmUtils.getDataEntityType(PurDataHandleResultEntryRow.class);
        }
        return this.resultEntryType;
    }

    public PurDataHandleResultHeader getPurDataHandleResult() {
        return this.purDataHandleResult;
    }

    public PurDataHandleResultHeader loadOrCreateResult(PurDataHandleContext context) {
        Long resultId = context.getInputArgs().getHandleDataResultId();
        if (resultId == null || Long.compare(0L, resultId) == 0) {
            resultId = DBServiceHelper.genGlobalLongId();
        } else {
            this.purDataHandleResult = this.loadHandleResult(resultId);
            if (this.purDataHandleResult != null) {
                return this.purDataHandleResult;
            }
        }
        this.purDataHandleResult = this.createAndSaveResult(context, resultId);
        context.getInputArgs().setHandleDataResultId(resultId);
        return this.purDataHandleResult;
    }

    public void upatePurDataHandleResult(int mProgess, String status) {
        if (this.purDataHandleResult == null) {
            return;
        }
        int totalProgress = this.purDataHandleResult.getProgress() + mProgess;
        if (mProgess >= 100) {
            this.purDataHandleResult.setProgress(100);
        } else if (totalProgress >= 100) {
            this.purDataHandleResult.setProgress(99);
        } else {
            this.purDataHandleResult.setProgress(totalProgress);
        }
        this.purDataHandleResult.setTime(TimeUtils.getSecond(this.purDataHandleResult.getStartTime(), TimeServiceHelper.now()));
        this.purDataHandleResult.setStatus(status);
        this.purDataHandleResult.setDirtyFlag("Progress");
        this.purDataHandleResult.setDirtyFlag("Time");
        this.purDataHandleResult.setDirtyFlag("Status");
        BusinessDataWriter.update((IDataEntityType)this.getResultHeadType(), (Object[])new Object[]{this.purDataHandleResult});
    }

    public void saveHeader() {
        if (this.purDataHandleResult != null) {
            BusinessDataWriter.update((IDataEntityType)this.getResultHeadType(), (Object[])new Object[]{this.purDataHandleResult});
        }
    }

    public void upatePurDataHandleResultDetail(Long subTaskId, String status) {
        if (this.purDataHandleResult == null || subTaskId == null) {
            return;
        }
        PurDataHandleResultEntryRow resultEntryRow = this.purDataHandleResult.getEntryRows().get(subTaskId);
        if (resultEntryRow == null) {
            return;
        }
        resultEntryRow.setSubStatus(status);
        resultEntryRow.setDirtyFlag("SubStatus");
        if (TaskStatusEnum.TASK_DOING.getValue().equals(status)) {
            resultEntryRow.setSubStartTime(TimeServiceHelper.now());
            resultEntryRow.setDirtyFlag("SubStartTime");
            resultEntryRow.setDetail("");
            resultEntryRow.setDirtyFlag("Detail");
        }
        if (TaskStatusEnum.TASK_SUCCESS.getValue().equals(status)) {
            long oldTime = resultEntryRow.getSubTime();
            Long subTime = TimeUtils.getMilliSecond(resultEntryRow.getSubStartTime(), TimeServiceHelper.now());
            resultEntryRow.setSubTime(subTime + oldTime);
            resultEntryRow.setDirtyFlag("SubTime");
        }
        BusinessDataWriter.update((IDataEntityType)this.getResultEntryType(), (Object[])new Object[]{resultEntryRow});
    }

    private PurDataHandleResultHeader createAndSaveResult(PurDataHandleContext context, Long resultId) {
        DynamicObject taskConfig = context.getTaskConfig();
        PurDataHandleResultHeader resultHeader = new PurDataHandleResultHeader();
        Date startTime = TimeServiceHelper.now();
        resultHeader.setId(resultId);
        resultHeader.setTaskId(context.getTaskConfigId());
        resultHeader.setStartTime(startTime);
        resultHeader.setTime(0L);
        resultHeader.setStatus(TaskStatusEnum.TASK_DOING.getValue());
        resultHeader.setProgress(0);
        resultHeader.setExecutor(RequestContext.get().getCurrUserId());
        resultHeader.setCreateTime(startTime);
        resultHeader.setCreator(RequestContext.get().getCurrUserId());
        resultHeader.setModifyTime(startTime);
        resultHeader.setModifier(RequestContext.get().getCurrUserId());
        resultHeader.setSourceBillId(context.getInputArgs().getSourceBillId());
        resultHeader.setSourceBillType(context.getInputArgs().getSourceBillType());
        DynamicObjectCollection taskConfigEntrys = taskConfig.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject entry : taskConfigEntrys) {
            if (!entry.getBoolean("valid")) continue;
            PurDataHandleResultEntryRow resultRow = new PurDataHandleResultEntryRow();
            resultRow.setEntryId(DBServiceHelper.genGlobalLongId());
            resultRow.setId(resultId);
            resultRow.setSeq(seq);
            resultRow.setTaskId(entry.getLong("task.id"));
            resultRow.setSubStatus(TaskStatusEnum.TASK_NOSTART.getValue());
            if (seq == 1) {
                resultRow.setSubStartTime(startTime);
            }
            resultHeader.getEntryRows().put(resultRow.getTaskId(), resultRow);
            ++seq;
        }
        SaveServiceHelper.save((IDataEntityType)this.getResultHeadType(), (Object[])new Object[]{resultHeader});
        if (!resultHeader.getEntryRows().isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)this.getResultEntryType(), (Object[])resultHeader.getEntryRows().values().toArray());
        }
        return resultHeader;
    }

    private PurDataHandleResultHeader loadHandleResult(Long resultId) {
        Object[] entryObjs;
        Object[] resultObjs = BusinessDataServiceHelper.load((Object[])new Object[]{resultId}, (IDataEntityType)this.getResultHeadType());
        if (resultObjs == null || resultObjs.length == 0) {
            return null;
        }
        PurDataHandleResultHeader resultHeader = (PurDataHandleResultHeader)resultObjs[0];
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)this.getResultEntryType());
        dataManager.setSelectHeadOnly(true);
        ArrayList<SqlParameter> sqlParams = new ArrayList<SqlParameter>(1);
        sqlParams.add(new SqlParameter("fid", -5, (Object)resultId));
        ReadWhere where = new ReadWhere("fid = ?", sqlParams);
        for (Object entryObj : entryObjs = dataManager.read(where)) {
            PurDataHandleResultEntryRow entryRow = (PurDataHandleResultEntryRow)entryObj;
            resultHeader.getEntryRows().put(entryRow.getTaskId(), entryRow);
        }
        return resultHeader;
    }

    public void resetDataHandleResultHeader() {
        Date startTime = TimeServiceHelper.now();
        this.purDataHandleResult.setStartTime(startTime);
        this.purDataHandleResult.setTime(0L);
        this.purDataHandleResult.setStatus(TaskStatusEnum.TASK_DOING.getValue());
        this.purDataHandleResult.setProgress(0);
        this.purDataHandleResult.setExecutor(RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((IDataEntityType)this.getResultHeadType(), (Object[])new Object[]{this.purDataHandleResult});
    }
}

