/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.multisystemjoint.AbstractMultiSystemJointDataHandleService;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.business.MultiDataExecuteSchemeConfigHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.exception.MultiSystemJointError;
import kd.scm.common.helper.multisystemjoint.param.MultiCustomParam;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;

public class OperationSystemJointDataHandleService
extends AbstractMultiSystemJointDataHandleService {
    protected static final Log log = LogFactory.getLog(OperationSystemJointDataHandleService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MultiDataHandleResult executeOperationDataHandle(String entityNumber, String operateKey, String executeInterface, Map<Long, String> billJointDataMap, MultiCustomParam customParam) {
        MultiDataHandleResult multiDataHandleResult = new MultiDataHandleResult();
        try {
            HashMap<Long, ScDataMultiJointChannelInfo> defaultStrategyMap = new HashMap<Long, ScDataMultiJointChannelInfo>(1024);
            defaultStrategyMap.putAll(this.getMultiChannelInfoJointChannelData(entityNumber, billJointDataMap));
            LinkedHashMap<String, ArrayList<Long>> channelGroupBillMap = new LinkedHashMap<String, ArrayList<Long>>(16);
            LinkedHashMap channelIdDataMap = new LinkedHashMap(16);
            for (Map.Entry entry : defaultStrategyMap.entrySet()) {
                String channelId = ((ScDataMultiJointChannelInfo)entry.getValue()).getChannelId();
                Long billId = (Long)entry.getKey();
                channelIdDataMap.putIfAbsent(channelId, entry.getValue());
                ArrayList<Long> groupBillIds = (ArrayList<Long>)channelGroupBillMap.get(channelId);
                if (groupBillIds == null) {
                    groupBillIds = new ArrayList<Long>(1024);
                    groupBillIds.add(billId);
                } else {
                    groupBillIds.add(billId);
                }
                channelGroupBillMap.put(channelId, groupBillIds);
            }
            for (Map.Entry entry : channelGroupBillMap.entrySet()) {
                List groupBillIds = (List)entry.getValue();
                ScDataMultiJointChannelInfo scDataMultiJointChannelInfo = (ScDataMultiJointChannelInfo)channelIdDataMap.get(entry.getKey());
                List<DynamicObject> dataExecuteConfig = MultiDataExecuteSchemeConfigHelper.getExecuteSchemeConfig(entityNumber, operateKey, executeInterface, scDataMultiJointChannelInfo.getChannelId());
                if (!dataExecuteConfig.isEmpty()) {
                    multiDataHandleResult = this.doExecuteDataHandle(scDataMultiJointChannelInfo, dataExecuteConfig, groupBillIds.toArray(new Long[0]), customParam);
                    continue;
                }
                multiDataHandleResult.setFinishedTime(TimeServiceHelper.now());
                multiDataHandleResult.setMessage("not exits executescheme.");
            }
        }
        catch (KDException exception) {
            multiDataHandleResult.setExceptionMessage(exception.getMessage());
            multiDataHandleResult.setFinishedTime(TimeServiceHelper.now());
        }
        catch (MultiSystemJointError e) {
            multiDataHandleResult.setExceptionMessage(e.getErrorMessage());
            multiDataHandleResult.setFinishedTime(TimeServiceHelper.now());
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)e);
        }
        finally {
            log.debug("execute end");
        }
        return multiDataHandleResult;
    }

    @Override
    protected MultiDataHandleResult executeSourceDataHandle(String sourceNumber, List<DynamicObject> dynamicObjects, String keyField, String jointChannelField, MultiCustomParam multiCustomParam) {
        return null;
    }
}

