/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.multisystemjoint.AbstractMultiSystemJointDataHandleService;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.business.MultiDataExecuteSchemeConfigHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.exception.MultiSystemJointError;
import kd.scm.common.helper.multisystemjoint.param.MultiCustomParam;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;

public class SceneSystemJointDataHandleService
extends AbstractMultiSystemJointDataHandleService {
    protected static final Log log = LogFactory.getLog(SceneSystemJointDataHandleService.class);

    @Override
    protected MultiDataHandleResult executeOperationDataHandle(String entityNumber, String operateKey, String executeInterface, Map<Long, String> billJointDataMap, MultiCustomParam customParam) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MultiDataHandleResult executeSourceDataHandle(String sourceNumber, List<DynamicObject> dynamicObjects, String keyField, String jointChannelField, MultiCustomParam multiCustomParam) {
        MultiDataHandleResult multiDataHandleResult = new MultiDataHandleResult();
        try {
            DynamicObject sceneCache = BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_scenedefine", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)sourceNumber)});
            String entityNumber = sceneCache.getString("entity.number");
            Map<Long, ScDataMultiJointChannelInfo> scDataChannelInfoMap = this.getMultiChannelInfoJointChannelFiled(entityNumber, dynamicObjects, keyField, jointChannelField);
            LinkedHashMap<String, ArrayList<Long>> channelGroupBillMap = new LinkedHashMap<String, ArrayList<Long>>(1024);
            LinkedHashMap<String, ScDataMultiJointChannelInfo> channelIdDataMap = new LinkedHashMap<String, ScDataMultiJointChannelInfo>(16);
            for (Map.Entry<Long, ScDataMultiJointChannelInfo> entry : scDataChannelInfoMap.entrySet()) {
                String channelId = entry.getValue().getChannelId();
                Long billId = entry.getKey();
                channelIdDataMap.putIfAbsent(channelId, entry.getValue());
                ArrayList<Long> groupBillIds = (List)channelGroupBillMap.get(channelId);
                if (groupBillIds == null) {
                    groupBillIds = new ArrayList<Long>(1024);
                    groupBillIds.add(billId);
                } else {
                    groupBillIds.add(billId);
                }
                channelGroupBillMap.put(channelId, groupBillIds);
            }
            ArrayList<DynamicObject> currencyData = null;
            for (Map.Entry entry : channelGroupBillMap.entrySet()) {
                List groupBillIds = (List)entry.getValue();
                currencyData = new ArrayList<DynamicObject>(groupBillIds.size());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    Long keyValue = dynamicObject.getLong(keyField);
                    if (!groupBillIds.contains(keyValue)) continue;
                    currencyData.add(dynamicObject);
                }
                ScDataMultiJointChannelInfo scDataMultiJointChannelInfo = (ScDataMultiJointChannelInfo)channelIdDataMap.get(entry.getKey());
                List<DynamicObject> dataExecuteConfig = MultiDataExecuteSchemeConfigHelper.getUniqueManualExecuteSchemeConfig(sourceNumber, scDataMultiJointChannelInfo.getChannelId());
                if (!dataExecuteConfig.isEmpty()) {
                    multiDataHandleResult = this.doExecuteDataHandle(scDataMultiJointChannelInfo, dataExecuteConfig, currencyData, multiCustomParam);
                    continue;
                }
                multiDataHandleResult.setFinishedTime(TimeServiceHelper.now());
                multiDataHandleResult.setMessage("not exits executescheme.");
            }
        }
        catch (KDException exception) {
            multiDataHandleResult.setExceptionMessage(exception.getMessage());
            multiDataHandleResult.setFinishedTime(TimeServiceHelper.now());
        }
        catch (MultiSystemJointError multiSystemJointError) {
            multiDataHandleResult.setExceptionMessage(multiSystemJointError.getErrorMessage());
            multiDataHandleResult.setFinishedTime(TimeServiceHelper.now());
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)multiSystemJointError);
        }
        finally {
            log.debug("execute end");
        }
        return multiDataHandleResult;
    }
}

