/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiChannelTypeFactoryHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiSystemJointStrategyMatchHelper;
import kd.scm.common.helper.multisystemjoint.business.ScDataMultiJointChannelMetaHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.exception.MultiSystemJointError;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;

public final class MultiDataChannelHelper {
    private static final Log log = LogFactory.getLog(MultiDataChannelHelper.class);

    public static ScDataMultiJointChannelInfo getSingleStableChannelInfo() throws MultiSystemJointError {
        ScDataMultiJointChannelInfo scDataMultiJointChannelInfo = null;
        DynamicObject scdatachannelcache = SystemJointChannelHelper.getDefaultJointChannelData();
        if (scdatachannelcache != null) {
            scDataMultiJointChannelInfo = ScDataMultiJointChannelMetaHelper.convertScDataChannelInfoCache(scdatachannelcache);
            ScDataMultiJointChannelMetaHelper.putScDataChannelInfoCache(scDataMultiJointChannelInfo.getChannelNumber(), scDataMultiJointChannelInfo);
        }
        if (scDataMultiJointChannelInfo == null) {
            String errorMessage = "\u534f\u540c\u65e0\u6cd5\u5904\u7406\u5f53\u524d\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u7cfb\u7edf\u5bf9\u63a5\u4fe1\u606f\u3002";
            throw new KDException(new ErrorCode("multisystemjointexception", errorMessage), new Object[0]);
        }
        return scDataMultiJointChannelInfo;
    }

    public static String getCosmicJointDataChannelId() {
        String jointDataChannelId = null;
        DynamicObject scdatachannelcache = SystemJointChannelHelper.getCosmicJointDataChannel();
        if (scdatachannelcache != null) {
            jointDataChannelId = scdatachannelcache.getString("id");
        }
        return jointDataChannelId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScDataMultiJointChannelInfo getMultiScDataChannelInfo(String channelId) throws MultiSystemJointError {
        ScDataMultiJointChannelInfo scDataMultiJointChannelInfo = null;
        if (channelId.isEmpty()) return MultiDataChannelHelper.getSingleStableChannelInfo();
        Map scdatachannelcaches = BusinessDataServiceHelper.loadFromCache((String)"pbd_scdatachannel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)channelId).and(new QFilter("enable", "=", (Object)"1"))});
        if (scdatachannelcaches.isEmpty()) throw new KDException(new ErrorCode("multisystemjointexception", ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6e20\u9053\u5bf9\u63a5\u4fe1\u606f\uff0c\u5bf9\u63a5\u7cfb\u7edf\u65e0\u6cd5\u5904\u7406\u672c\u6b21\u8bf7\u6c42\u3002", (String)"", (String)"", (Object[])new Object[0])), new Object[0]);
        Iterator iterator = scdatachannelcaches.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DynamicObject scdatachannelcache = (DynamicObject)entry.getValue();
            if (scdatachannelcache == null) continue;
            scDataMultiJointChannelInfo = ScDataMultiJointChannelMetaHelper.convertScDataChannelInfoCache(scdatachannelcache);
            ScDataMultiJointChannelMetaHelper.putScDataChannelInfoCache(scDataMultiJointChannelInfo.getChannelNumber(), scDataMultiJointChannelInfo);
        }
        return scDataMultiJointChannelInfo;
    }

    public static Map<Long, ScDataMultiJointChannelInfo> getMultiScDataChannelInfo(Map<Long, String> defaultStrategy) throws MultiSystemJointError {
        LinkedHashMap<Long, ScDataMultiJointChannelInfo> billOfChannelMap = new LinkedHashMap<Long, ScDataMultiJointChannelInfo>();
        HashMap<String, ScDataMultiJointChannelInfo> dataChannelInfoMap = new HashMap<String, ScDataMultiJointChannelInfo>(16);
        if (!defaultStrategy.isEmpty()) {
            Map scdatachannelcaches = BusinessDataServiceHelper.loadFromCache((String)"pbd_scdatachannel", (QFilter[])new QFilter[]{new QFilter("id", "in", defaultStrategy.values()).and(new QFilter("enable", "=", (Object)"1"))});
            if (!scdatachannelcaches.isEmpty()) {
                for (Map.Entry entry : scdatachannelcaches.entrySet()) {
                    DynamicObject scdatachannelcache = (DynamicObject)entry.getValue();
                    String channelNumber = scdatachannelcache.getString("number");
                    ScDataMultiJointChannelInfo scDataMultiJointChannelInfo = ScDataMultiJointChannelMetaHelper.getScDataChannelInfo(channelNumber);
                    if (scDataMultiJointChannelInfo != null) {
                        dataChannelInfoMap.put(scDataMultiJointChannelInfo.getChannelId(), scDataMultiJointChannelInfo);
                        continue;
                    }
                    scDataMultiJointChannelInfo = ScDataMultiJointChannelMetaHelper.convertScDataChannelInfoCache(scdatachannelcache);
                    ScDataMultiJointChannelMetaHelper.putScDataChannelInfoCache(scDataMultiJointChannelInfo.getChannelNumber(), scDataMultiJointChannelInfo);
                    dataChannelInfoMap.put(scDataMultiJointChannelInfo.getChannelId(), scDataMultiJointChannelInfo);
                }
            } else {
                throw new KDException(new ErrorCode("multisystemjointexception", ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6e20\u9053\u5bf9\u63a5\u4fe1\u606f\uff0c\u5bf9\u63a5\u7cfb\u7edf\u65e0\u6cd5\u5904\u7406\u672c\u6b21\u8bf7\u6c42\u3002", (String)"", (String)"", (Object[])new Object[0])), new Object[0]);
            }
            for (Map.Entry<Object, Object> entry : defaultStrategy.entrySet()) {
                Long billId = (Long)entry.getKey();
                String entryValue = (String)entry.getValue();
                billOfChannelMap.put(billId, (ScDataMultiJointChannelInfo)dataChannelInfoMap.get(entryValue));
            }
        }
        return billOfChannelMap;
    }

    public static Map<Long, ScDataMultiJointChannelInfo> getMultiChannelInfoJointChannelData(String entityNumber, Map<Long, String> billJointDataMap) throws MultiSystemJointError {
        HashMap<Long, ScDataMultiJointChannelInfo> defaultStrategyMap = new HashMap<Long, ScDataMultiJointChannelInfo>(56);
        boolean containEmptyJointChannelId = billJointDataMap.values().stream().anyMatch(row -> row.isEmpty() || row.trim().isEmpty());
        if (!containEmptyJointChannelId) {
            defaultStrategyMap.putAll(MultiDataChannelHelper.getMultiScDataChannelInfo(billJointDataMap));
        } else {
            ArrayList<Long> emptyJointChannelBillIds = new ArrayList<Long>();
            HashMap<Long, String> billJointMap = new HashMap<Long, String>();
            billJointDataMap.forEach((key, value) -> {
                if (value.isEmpty()) {
                    emptyJointChannelBillIds.add((Long)key);
                }
                if (!value.isEmpty() && !value.trim().isEmpty()) {
                    billJointMap.put((Long)key, (String)value);
                }
            });
            defaultStrategyMap.putAll(MultiDataChannelHelper.getMultiScDataChannelInfo(billJointMap));
            if (!emptyJointChannelBillIds.isEmpty()) {
                defaultStrategyMap.putAll(MultiDataChannelHelper.calStrategyConfigJointChannel(entityNumber, emptyJointChannelBillIds));
            }
        }
        return defaultStrategyMap;
    }

    public static Map<Long, ScDataMultiJointChannelInfo> calStrategyConfigJointChannel(String entityNumber, List<Long> emptyJointBillIds) throws MultiSystemJointError {
        HashMap<Long, ScDataMultiJointChannelInfo> scDataChannelInfoMap;
        block6: {
            ScDataMultiJointChannelInfo scDataMultiJointChannelInfo;
            block5: {
                scDataChannelInfoMap = new HashMap<Long, ScDataMultiJointChannelInfo>();
                scDataMultiJointChannelInfo = MultiDataChannelHelper.getSingleStableChannelInfo();
                Map<String, String> filterStrategy = MultiSystemJointStrategyMatchHelper.getFilterStrategy(entityNumber);
                if (filterStrategy.isEmpty()) break block5;
                ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(1024);
                dynamicObjects.addAll(Arrays.asList(BusinessDataServiceHelper.load((Object[])emptyJointBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber))));
                for (Map.Entry<String, String> entry : filterStrategy.entrySet()) {
                    String filterExpression = entry.getValue();
                    String configJointId = entry.getKey();
                    ScDataMultiJointChannelInfo multiScDataMultiJointChannelInfo = MultiDataChannelHelper.getMultiScDataChannelInfo(configJointId);
                    List<Long> filterData = MultiSystemJointStrategyMatchHelper.filterData(entityNumber, dynamicObjects, filterExpression);
                    for (Long billId : filterData) {
                        ScDataMultiJointChannelInfo dataChannelInfo = (ScDataMultiJointChannelInfo)scDataChannelInfoMap.get(billId);
                        if (dataChannelInfo != null) {
                            throw new KDException(new ErrorCode("multisystemjointexception", ResManager.loadKDString((String)"\u6839\u636e\u5339\u914d\u89c4\u5219\uff0c\u5355\u4e00\u6570\u636e\u6ee1\u8db3\u591a\u4e2a\u89c4\u5219\uff0c\u7cfb\u7edf\u5bf9\u63a5\u6e20\u9053\u65e0\u6cd5\u5904\u7406\u3002", (String)"", (String)"", (Object[])new Object[0])), new Object[0]);
                        }
                        scDataChannelInfoMap.putIfAbsent(billId, multiScDataMultiJointChannelInfo);
                    }
                }
                List<Long> notMatchBillIds = null;
                notMatchBillIds = scDataChannelInfoMap.isEmpty() ? emptyJointBillIds : emptyJointBillIds.stream().filter(row -> !scDataChannelInfoMap.containsKey(row)).collect(Collectors.toList());
                if (notMatchBillIds.isEmpty()) break block6;
                for (Long billId : notMatchBillIds) {
                    scDataChannelInfoMap.put(billId, scDataMultiJointChannelInfo);
                }
                break block6;
            }
            for (Long billId : emptyJointBillIds) {
                scDataChannelInfoMap.put(billId, scDataMultiJointChannelInfo);
            }
        }
        return scDataChannelInfoMap;
    }

    public static String getChannelDataId(Long iscDataSourceId, Long iscDataLinkId) {
        String dataChannelId = null;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"pbd_scdatachannel", (QFilter[])new QFilter[]{new QFilter("iscdatasource", "=", (Object)iscDataSourceId)});
        if (dynamicObject != null) {
            Long channelIscLink = dynamicObject.getLong("isclink.id");
            if (iscDataLinkId.equals(channelIscLink)) {
                dataChannelId = dynamicObject.getString("id");
            } else {
                Long currUserId = null;
                try {
                    currUserId = RequestContext.get().getCurrUserId();
                }
                catch (RuntimeException runtimeException) {
                    currUserId = 1L;
                }
                dynamicObject.set("isclink_id", (Object)iscDataLinkId);
                dynamicObject.set("modifier_id", (Object)currUserId);
                dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
                dataChannelId = MultiDataChannelHelper.updateChannelData(dynamicObject);
            }
        } else {
            dataChannelId = MultiDataChannelHelper.saveChannelData(iscDataSourceId);
        }
        return dataChannelId;
    }

    public static String getChannelDataId(Long iscDataSourceId) {
        String dataChannelId = null;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"pbd_scdatachannel", (String)"id,iscdatasource,iscdatalink", (QFilter[])new QFilter[]{new QFilter("iscdatasource", "=", (Object)iscDataSourceId)});
        dataChannelId = dynamicObject != null ? dynamicObject.getString("id") : MultiDataChannelHelper.saveChannelData(iscDataSourceId);
        return dataChannelId;
    }

    public static String updateChannelData(DynamicObject dynamicObject) {
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject.getString("id");
    }

    public static String saveChannelData(Long iscDataSourceId) {
        String dataChannelId = null;
        DynamicObject channelData = BusinessDataServiceHelper.newDynamicObject((String)"pbd_scdatachannel");
        DynamicObject iscDataSource = BusinessDataServiceHelper.loadSingleFromCache((Object)iscDataSourceId, (String)"isc_data_source");
        channelData.set("name", (Object)iscDataSource.getString("name"));
        channelData.set("iscdatasource_id", (Object)iscDataSourceId);
        channelData.set("isclink_id", (Object)iscDataSource.getLong("dblink.id"));
        channelData.set("enable", (Object)"1");
        DynamicObject channelType = MultiChannelTypeFactoryHelper.getStdJointSystemType(iscDataSource.getString("connection_type"));
        if (channelType == null) {
            throw new KDException(new ErrorCode("multisystemjointexception", ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6b64\u79cd\u8fde\u63a5\u7c7b\u578b\u7684\u4e1a\u52a1\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u652f\u6301\u3002", (String)"", (String)"", (Object[])new Object[0])), new Object[0]);
        }
        channelData.set("jointchanneltype", (Object)channelType.getString("id"));
        channelData.set("channelfactoryclass", (Object)channelType.getString("jointchannelfactoryclass"));
        String jointsystemtype = channelType.getString("jointsystemtype");
        channelData.set("channelclass", (Object)MultiChannelTypeFactoryHelper.getStdJointSystemTypeChannelClass(jointsystemtype));
        Long currUserId = null;
        try {
            currUserId = RequestContext.get().getCurrUserId();
        }
        catch (RuntimeException runtimeException) {
            currUserId = 1L;
        }
        channelData.set("creator", (Object)currUserId);
        channelData.set("createtime", (Object)TimeServiceHelper.now());
        try {
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"pbd_scdatachannel", (DynamicObject[])new DynamicObject[]{channelData}, (OperateOption)OperateOption.create());
            if (operationResult != null && operationResult.isSuccess()) {
                dataChannelId = operationResult.getSuccessPkIds().get(0).toString();
            }
        }
        catch (RuntimeException exception) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)exception);
            throw new KDBizException(new ErrorCode("", String.valueOf(exception.getMessage())), new Object[]{exception});
        }
        return dataChannelId;
    }

    public static String checkBillReference(String channelId) {
        StringBuilder checkMessage = new StringBuilder();
        if (channelId != null && !channelId.trim().isEmpty()) {
            if (QueryServiceHelper.exists((String)"pur_order", (QFilter[])new QFilter[]{new QFilter("materialentry.jointdatachannelid", "=", (Object)channelId)})) {
                checkMessage.append(ResManager.loadKDString((String)"\u6e20\u9053\u6570\u636e\u5df2\u7ecf\u88ab\u91c7\u8d2d\u8ba2\u5355\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"", (String)"", (Object[])new Object[0]));
            }
            if (checkMessage.length() == 0 && QueryServiceHelper.exists((String)"pur_receipt", (QFilter[])new QFilter[]{new QFilter("materialentry.jointdatachannelid", "=", (Object)channelId)})) {
                checkMessage.append(ResManager.loadKDString((String)"\u6e20\u9053\u6570\u636e\u5df2\u7ecf\u88ab\u91c7\u8d2d\u6536\u8d27\u5355\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"", (String)"", (Object[])new Object[0]));
            }
            if (checkMessage.length() == 0 && QueryServiceHelper.exists((String)"pur_instock", (QFilter[])new QFilter[]{new QFilter("materialentry.jointdatachannelid", "=", (Object)channelId)})) {
                checkMessage.append(ResManager.loadKDString((String)"\u6e20\u9053\u6570\u636e\u5df2\u7ecf\u88ab\u91c7\u8d2d\u5165\u5e93\u5355\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"", (String)"", (Object[])new Object[0]));
            }
        }
        return checkMessage.toString();
    }
}

