/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.business;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScMultiDataExecuteSchemeInfo;
import kd.scm.common.helper.multisystemjoint.entity.ScMultiExecuteSchemeEntryInfo;

public final class MultiDataExecuteSchemeConfigHelper {
    private static Log log = LogFactory.getLog(MultiDataExecuteSchemeConfigHelper.class);

    private static IAppCache getAppCache() {
        return AppCache.get((String)"dataexecutescheme");
    }

    public static Boolean verifyExecuteScheme(String entityNumber, String operateKey, String executeInterface) {
        Map dataExecuteSchemeCaches = BusinessDataServiceHelper.loadFromCache((String)"pbd_dataexecutescheme", (QFilter[])new QFilter[]{new QFilter("entity.number", "=", (Object)entityNumber).and(new QFilter("operatekey", "=", (Object)operateKey)).and(new QFilter("executeinterface", "=", (Object)executeInterface)).and(new QFilter("executetype", "=", (Object)"operateevent")).and("enable", "=", (Object)"1")});
        return !dataExecuteSchemeCaches.isEmpty();
    }

    public static List<DynamicObject> getExecuteSchemeConfig(String entityNumber, String operateKey, String executeInterface, String dataChannelId) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(56);
        Map dataExecuteSchemeCaches = BusinessDataServiceHelper.loadFromCache((String)"pbd_dataexecutescheme", (QFilter[])new QFilter[]{new QFilter("entity.number", "=", (Object)entityNumber).and(new QFilter("executechannel", "=", (Object)dataChannelId)).and(new QFilter("operatekey", "=", (Object)operateKey)).and(new QFilter("executeinterface", "=", (Object)executeInterface)).and("enable", "=", (Object)"1")});
        if (!dataExecuteSchemeCaches.isEmpty()) {
            dynamicObjects.addAll(dataExecuteSchemeCaches.values());
        }
        return dynamicObjects;
    }

    public static List<DynamicObject> getUniqueManualExecuteSchemeConfig(String sceneNumber, String executeChannelId) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(56);
        Map dataExecuteSchemeCaches = BusinessDataServiceHelper.loadFromCache((String)"pbd_dataexecutescheme", (QFilter[])new QFilter[]{new QFilter("executescene.number", "in", (Object)sceneNumber).and(new QFilter("executechannel", "=", (Object)executeChannelId)).and(new QFilter("enable", "=", (Object)"1"))});
        if (!dataExecuteSchemeCaches.isEmpty()) {
            dynamicObjects.addAll(dataExecuteSchemeCaches.values());
        }
        return dynamicObjects;
    }

    public static ScMultiDataExecuteSchemeInfo getMultiDataExecuteSchemeInfo(List<DynamicObject> dataExecuteConfigs) {
        ScMultiDataExecuteSchemeInfo multiDataExecuteSchemeInfo = new ScMultiDataExecuteSchemeInfo();
        for (DynamicObject dataExecuteConfig : dataExecuteConfigs) {
            multiDataExecuteSchemeInfo.setIsv(dataExecuteConfig.getString("isv"));
            multiDataExecuteSchemeInfo.setOperateKey(dataExecuteConfig.getString("operatekey"));
            multiDataExecuteSchemeInfo.setEntityNumber(dataExecuteConfig.getString("entity.number"));
            DynamicObjectCollection entryentity = dataExecuteConfig.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryentity) {
                DynamicObject executeservice;
                ScMultiExecuteSchemeEntryInfo executeSchemeEntryInfo = new ScMultiExecuteSchemeEntryInfo();
                DynamicObject executescene = dataExecuteConfig.getDynamicObject("executescene");
                if (executescene != null) {
                    executeSchemeEntryInfo.setExecuteSceneId(executescene.getString("id"));
                    executeSchemeEntryInfo.setExecuteSceneNumber(executescene.getString("number"));
                    executeSchemeEntryInfo.setSceneEntityNumber(executescene.getString("entity.number"));
                }
                if ((executeservice = dataExecuteConfig.getDynamicObject("executeservice")) != null) {
                    executeSchemeEntryInfo.setExecuteServiceId(executeservice.getString("id"));
                    executeSchemeEntryInfo.setExecuteServiceNumber(executeservice.getString("number"));
                    executeSchemeEntryInfo.setExecuteServiceType(executeservice.getString("servicetype"));
                }
                executeSchemeEntryInfo.setFailStrategy(dataExecuteConfig.getString("failstrategy"));
                executeSchemeEntryInfo.setExecuteSchemeId(dataExecuteConfig.getString("id"));
                executeSchemeEntryInfo.setExecuteSchemeName(dataExecuteConfig.getString("name"));
                executeSchemeEntryInfo.setExecuteSchemeNumber(dataExecuteConfig.getString("number"));
                String entryId = row.getString("id");
                executeSchemeEntryInfo.setExecuteEntryId(entryId);
                executeSchemeEntryInfo.setExecuteServiceConfig(row.getString("executeserviceconfig"));
                multiDataExecuteSchemeInfo.putExecuteSchemeEntryInfo(entryId, executeSchemeEntryInfo);
            }
        }
        return multiDataExecuteSchemeInfo;
    }
}

