/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.business;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scm.common.helper.multisystemjoint.entity.MultiJointFailTaskWorker;
import kd.scm.common.helper.multisystemjoint.entity.MultiJointStoreDataHandleMessageInfo;

public final class MultiJointFailTaskHelper {
    private static final MultiJointFailTaskWorker queue;
    private static final ThreadPool failWorkerThreadPool;
    private static final int MIN_BATCH_SIZE;

    public static Map<String, Object> executeTask(MultiJointStoreDataHandleMessageInfo jointStoreDataHandleMessageInfo) {
        queue.submitThread(jointStoreDataHandleMessageInfo);
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> batchExecuteTask(final Set<MultiJointStoreDataHandleMessageInfo> jointStoreDataHandleMessageInfoColl) {
        if (jointStoreDataHandleMessageInfoColl != null && !jointStoreDataHandleMessageInfoColl.isEmpty()) {
            if (jointStoreDataHandleMessageInfoColl.size() > MIN_BATCH_SIZE) {
                failWorkerThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        for (MultiJointStoreDataHandleMessageInfo multiJointStoreDataHandleMessageInfo : jointStoreDataHandleMessageInfoColl) {
                            MultiJointFailTaskHelper.singleExecuteTask(multiJointStoreDataHandleMessageInfo);
                        }
                    }
                });
            } else {
                for (MultiJointStoreDataHandleMessageInfo multiJointStoreDataHandleMessageInfo : jointStoreDataHandleMessageInfoColl) {
                    MultiJointFailTaskHelper.singleExecuteTask(multiJointStoreDataHandleMessageInfo);
                }
            }
        }
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> singleExecuteTask(MultiJointStoreDataHandleMessageInfo jointStoreDataHandleMessageInfo) {
        queue.submit(jointStoreDataHandleMessageInfo, RequestContext.get());
        return new HashMap<String, Object>();
    }

    static {
        int minBatchSize;
        int count;
        failWorkerThreadPool = ThreadPools.newCachedThreadPool((String)"SCM_MULTI_JOINT_FAIL_WORKER", (int)3, (int)9);
        try {
            count = Integer.parseInt(System.getProperty("SCM_SC_TASK_THREADS"));
            if (count <= 0) {
                count = 16;
            }
        }
        catch (Exception var2) {
            count = 16;
        }
        try {
            minBatchSize = Integer.parseInt(System.getProperty("SCM_SC_MIN_BATCH_SIZE"));
            if (minBatchSize <= 0) {
                minBatchSize = 10;
            }
        }
        catch (Exception var2) {
            minBatchSize = 10;
        }
        queue = new MultiJointFailTaskWorker(Math.max(5, count));
        MIN_BATCH_SIZE = Math.max(10, minBatchSize);
    }
}

