/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.business;

import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.multisystemjoint.param.api.IMultiParamDefineService;
import kd.scm.common.helper.multisystemjoint.param.engine.MultiCosmicParamService;
import kd.scm.common.helper.multisystemjoint.param.engine.MultiCustomPluginParamService;
import kd.scm.common.helper.multisystemjoint.param.engine.MultiIscCosmicParamService;
import kd.scm.common.helper.scdatahandle.util.CacheKeyUtil;

public final class MultiJointParamServiceHelper {
    private static IAppCache getAppCache() {
        return AppCache.get((String)"SCM_PUR_PARAMSERVICE");
    }

    public static void register(String serviceDefineNumber, String className) {
        String makeCacheKey = MultiJointParamServiceHelper.getCacheKey(serviceDefineNumber);
        MultiJointParamServiceHelper.getAppCache().put(makeCacheKey, (Object)className);
    }

    private static String getCacheKey(String serviceDefineNumber) {
        return CacheKeyUtil.makeCacheKey("pur", serviceDefineNumber);
    }

    public static Class<IMultiParamDefineService> getParamDefineService(String serviceDefineNumber) {
        String makeCacheKey = MultiJointParamServiceHelper.getCacheKey(serviceDefineNumber);
        String paramClassSting = (String)MultiJointParamServiceHelper.getAppCache().get(makeCacheKey, String.class);
        if (paramClassSting == null || paramClassSting.trim().isEmpty()) {
            DynamicObject chache = BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_servicedefine", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)serviceDefineNumber)});
            paramClassSting = chache.getString("implementation");
            MultiJointParamServiceHelper.register(serviceDefineNumber, paramClassSting);
        }
        return TypesContainer.getOrRegister((String)paramClassSting);
    }

    static {
        MultiJointParamServiceHelper.register("613CA21E", MultiCustomPluginParamService.class.getName());
        MultiJointParamServiceHelper.register("CAB64757", MultiCosmicParamService.class.getName());
        MultiJointParamServiceHelper.register("5E88E793", MultiIscCosmicParamService.class.getName());
    }
}

