/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.business;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiJointParamServiceHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.entity.ScMultiDataExecuteSchemeInfo;
import kd.scm.common.helper.multisystemjoint.entity.ScMultiExecuteSchemeEntryInfo;
import kd.scm.common.helper.multisystemjoint.exception.MultiSystemJointError;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicIscParamArgs;
import kd.scm.common.helper.multisystemjoint.param.api.IMultiParamDefineService;

public final class MultiJointParamServiceProxyHelper {
    private static final Log log = LogFactory.getLog(MultiJointParamServiceProxyHelper.class);

    public static Map<String, IMultiParamDefineService> getJointParamServicePool(ScMultiDataExecuteSchemeInfo scMultiDataExecuteSchemeInfo) throws MultiSystemJointError {
        LinkedHashMap<String, IMultiParamDefineService> defineServiceMap = new LinkedHashMap<String, IMultiParamDefineService>(4);
        Map<String, ScMultiExecuteSchemeEntryInfo> schemeEntryInfoMap = scMultiDataExecuteSchemeInfo.getExecuteSchemeEntryInfoMap();
        for (Map.Entry<String, ScMultiExecuteSchemeEntryInfo> entry : schemeEntryInfoMap.entrySet()) {
            String entryKey = entry.getKey();
            ScMultiExecuteSchemeEntryInfo schemeEntryInfo = entry.getValue();
            String executeServiceNumber = schemeEntryInfo.getExecuteServiceNumber();
            Class<IMultiParamDefineService> paramDefineService = MultiJointParamServiceHelper.getParamDefineService(executeServiceNumber);
            Constructor<IMultiParamDefineService> serviceConstructor = null;
            try {
                serviceConstructor = paramDefineService.getConstructor(String.class, ScMultiExecuteSchemeEntryInfo.class);
            }
            catch (RuntimeException runtimeException) {
                log.warn((Throwable)runtimeException);
            }
            catch (NoSuchMethodException e) {
                throw new MultiSystemJointError(e.getMessage(), e);
            }
            if (serviceConstructor == null) {
                Constructor<?>[] serviceConstructors;
                for (Constructor<?> constructor : serviceConstructors = paramDefineService.getConstructors()) {
                    Class<?> parameterType;
                    int parameterCount = constructor.getParameterCount();
                    if (parameterCount != 1 || !(parameterType = constructor.getParameterTypes()[0]).equals(String.class)) continue;
                    serviceConstructor = constructor;
                }
            }
            try {
                if (serviceConstructor == null) continue;
                IMultiParamDefineService multiParamDefineService = serviceConstructor.newInstance(scMultiDataExecuteSchemeInfo.getEntityNumber(), schemeEntryInfo);
                defineServiceMap.put(entryKey, multiParamDefineService);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
                String message = null;
                Throwable throwable = null;
                if (exception instanceof InvocationTargetException) {
                    Throwable targetException = ((InvocationTargetException)exception).getTargetException();
                    message = targetException instanceof MultiSystemJointError ? ((MultiSystemJointError)targetException).getErrorMessage() : targetException.getClass().getName() + ":" + targetException.getMessage();
                    throwable = targetException;
                } else {
                    message = exception.getClass().getName() + ":" + exception.getMessage();
                    throwable = exception;
                }
                throw new MultiSystemJointError(message, throwable);
            }
        }
        return defineServiceMap;
    }

    public static ScMultiCosmicIscParamArgs modifyIscJointParamArgs(ScMultiCosmicIscParamArgs multiCosmicIscParamArgs, ScDataMultiJointChannelInfo scDataMultiJointChannelInfo, String facadeService) {
        DynamicObject metaDataCache = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_metadata_schema", (QFilter[])new QFilter[]{new QFilter("full_name", "=", (Object)facadeService).and(new QFilter("group.number", "=", (Object)scDataMultiJointChannelInfo.getIscDataSourceNumber()))});
        if (metaDataCache != null) {
            String fullName = metaDataCache.getString("full_name");
            multiCosmicIscParamArgs.getStdDelegate().setServiceName("IscMetaSchemaService");
            multiCosmicIscParamArgs.getStdDelegate().setMethodName("callService");
            multiCosmicIscParamArgs.setIscSourceNumber(metaDataCache.getString("number"));
            multiCosmicIscParamArgs.setIscSourceFullName(fullName);
            multiCosmicIscParamArgs.setIscExecuteServiceNumber(scDataMultiJointChannelInfo.getIscDataSourceNumber());
        } else {
            multiCosmicIscParamArgs.getStdDelegate().setServiceName("ISCDataCopyService");
            multiCosmicIscParamArgs.getStdDelegate().setMethodName("callService");
            multiCosmicIscParamArgs.setIscSourceFullName(facadeService);
            multiCosmicIscParamArgs.setIscExecuteServiceNumber(scDataMultiJointChannelInfo.getIscLinkNumber());
        }
        if (log.isInfoEnabled()) {
            log.info("MultiJointParamServiceProxyHelper#modifyIscJointParamArgs#multiCosmicIscParamArgs:{}", (Object)SerializationUtils.toJsonString((Object)multiCosmicIscParamArgs));
        }
        return multiCosmicIscParamArgs;
    }
}

