/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;

public final class MultiJointSceneDefineHelper {
    private static final Log log = LogFactory.getLog(MultiJointSceneDefineHelper.class);

    public static DynamicObject getStdScenseDefinePluginByChannel(String jointChannelId, String sceneDefineId) {
        DynamicObject singleFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_jointsceneplugin", (QFilter[])new QFilter[]{new QFilter("pluginchannel", "=", (Object)jointChannelId).and(new QFilter("pluginscene", "in", (Object)sceneDefineId))});
        return singleFromCache;
    }

    public static DynamicObject getStdSceneDefinePluginByJointType(String jointSystemType, String sceneDefineId) {
        DynamicObject singleFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_jointsceneplugin", (QFilter[])new QFilter[]{new QFilter("pluginchannel", "=", (Object)jointSystemType).and(new QFilter("pluginscene", "in", (Object)sceneDefineId))});
        return singleFromCache;
    }

    public static DynamicObject getStdSceneDefineData(String sceneNumber) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_jointsceneplugin", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)sceneNumber)});
    }

    public static void callExecuteSceneCount(Set<String> executeSchemeIds) {
        DynamicObject[] sceneDefines;
        for (DynamicObject sceneDefine : sceneDefines = BusinessDataServiceHelper.load((Object[])executeSchemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pbd_dataexecutescheme"))) {
            String sceneId = sceneDefine.getString("id");
            try (DLock dLock = DLock.create((String)sceneId);){
                if (!dLock.tryLock()) continue;
                Date date = TimeServiceHelper.now();
                sceneDefine.set("executetime", (Object)date);
                sceneDefine.set("executestamp", (Object)date.getTime());
                sceneDefine.set("executeuser", (Object)RequestContext.get().getUserName());
                sceneDefine.set("executecount", (Object)sceneDefine.getBigDecimal("executecount").add(BigDecimal.ONE));
            }
            catch (RuntimeException runtimeException) {
                log.warn((Throwable)runtimeException);
            }
        }
        SRMStoreDataTraceHelper.updateStoreData((DynamicObject[])sceneDefines);
    }
}

