/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;

public final class MultiSystemJointStrategyMatchHelper {
    private static final Log log = LogFactory.getLog(MultiSystemJointStrategyMatchHelper.class);
    public static final String JOINTDATACHANNELID = "jointdatachannelid";

    public static boolean isContainJointDataChannelFiled(String entityNumber) {
        IDataEntityProperty dataEntityProperty;
        boolean checkFlag = false;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allFields = mainEntityType.getAllFields();
        if (allFields != null && !allFields.isEmpty() && (dataEntityProperty = (IDataEntityProperty)allFields.get(JOINTDATACHANNELID)) != null && !dataEntityProperty.isDbIgnore()) {
            checkFlag = true;
        }
        return checkFlag;
    }

    public static Map<Long, String> getDefaultStrategy(DynamicObjectCollection dynamicObjectCollection) {
        LinkedHashMap<Long, String> resultMap = new LinkedHashMap<Long, String>(dynamicObjectCollection.size());
        for (DynamicObject bill : dynamicObjectCollection) {
            Long billId = bill.getLong("id");
            resultMap.put(billId, MultiSystemJointStrategyMatchHelper.getSingleDefaultStrategy(bill, JOINTDATACHANNELID));
        }
        log.debug("resultMap:{}", (Object)SerializationUtils.toJsonString(resultMap));
        return resultMap;
    }

    public static Map<Long, String> getDefaultStrategy(List<DynamicObject> dynamicObjects, String keyField, String jointChannelField) {
        LinkedHashMap<Long, String> resultMap = new LinkedHashMap<Long, String>(dynamicObjects.size());
        for (DynamicObject bill : dynamicObjects) {
            Long billId = bill.getLong(keyField);
            resultMap.put(billId, MultiSystemJointStrategyMatchHelper.getSingleDefaultStrategy(bill, jointChannelField));
        }
        log.debug("resultMap:{}", (Object)SerializationUtils.toJsonString(resultMap));
        return resultMap;
    }

    public static String getSingleDefaultStrategy(DynamicObject bill, String jointChannelField) {
        String jointdatachannelid = "";
        try {
            jointdatachannelid = bill.getString(jointChannelField);
            if (jointdatachannelid == null || jointdatachannelid.trim().isEmpty()) {
                jointdatachannelid = "";
            }
        }
        catch (RuntimeException runtimeException) {
            SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
        }
        return jointdatachannelid;
    }

    public static Map<String, String> getFilterStrategy(String entityNumber) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1024);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"pbd_strategyconfig", (String)"filterformula_tag filterformula,group", (QFilter[])new QFilter[]{new QFilter("entity", "=", (Object)entityNumber).and(new QFilter("enable", "=", (Object)"1"))}, (String)"id");){
            DataSet dataSetGroup = dataSet.groupBy(new String[]{"group", "filterformula"}).finish();
            while (dataSetGroup.hasNext()) {
                Row row = dataSetGroup.next();
                String group = row.getString("group");
                String filterformula = row.getString("filterformula");
                if (filterformula == null || filterformula.trim().isEmpty()) continue;
                map.put(group, filterformula);
            }
            dataSetGroup.close();
        }
        return map;
    }

    public static List<Long> filterData(String entityNumber, List<DynamicObject> dynamicObjects, String filterExpression) {
        ArrayList<Long> filltervalues = new ArrayList<Long>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            RowDataModel rowDataModel = new RowDataModel(entityType.getName(), entityType);
            rowDataModel.setRowContext(dynamicObject);
            ExpressionParameter expressionParameter = new ExpressionParameter(filterExpression, rowDataModel);
            Set vars = expressionParameter.getBOSExpression().getVars();
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            for (String var : vars) {
                Object value = rowDataModel.getValue(var);
                params.put(var, value);
            }
            if (!((Boolean)FormulaEngine.execExcelFormula((String)filterExpression, params)).booleanValue()) continue;
            filltervalues.add(dynamicObject.getLong("id"));
        }
        return filltervalues;
    }
}

