/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.mq;

import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleException;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleLogInfo;
import kd.scm.common.util.ExceptionUtil;

public class ScDataHandleLogConsumer
implements MessageConsumer {
    private final Log logger = LogFactory.getLog(ScDataHandleLogConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean b, MessageAcker messageAcker) {
        if (body instanceof ScDataHandleLogInfo) {
            ScDataHandleLogInfo scDataHandleLogInfo = (ScDataHandleLogInfo)body;
            this.logger.info("FailLogData" + scDataHandleLogInfo.toString());
            try {
                String failDataHandle = scDataHandleLogInfo.getFailDataHandle();
                DynamicObject logData = BusinessDataServiceHelper.newDynamicObject((String)"pbd_scdatahandlelog");
                if (failDataHandle != null && !failDataHandle.trim().isEmpty()) {
                    DynamicObject[] scFailLogs = BusinessDataServiceHelper.load((Object[])new Object[]{failDataHandle}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pbd_scdatahandlefail"));
                    for (DynamicObject failData : scFailLogs) {
                        failData.set("state", (Object)scDataHandleLogInfo.getState());
                        failData.set("retry", (Object)(failData.getInt("retry") + 1));
                        scDataHandleLogInfo.setLogType(failData.getString("logtype"));
                        scDataHandleLogInfo.setFailDataHandle(failData.getString("id"));
                        scDataHandleLogInfo.setEntityDesc(failData.getString("entitydesc"));
                        scDataHandleLogInfo.setOperateDesc(failData.getString("operatedesc"));
                        scDataHandleLogInfo.setConfig(failData.getString("config"));
                        scDataHandleLogInfo.setConfigTag(failData.getString("config_tag"));
                        scDataHandleLogInfo.setParams(failData.getString("params"));
                        scDataHandleLogInfo.setParamsTag(failData.getString("params_tag"));
                    }
                    SaveServiceHelper.save((DynamicObject[])scFailLogs);
                } else if ("faillog".equals(scDataHandleLogInfo.getLogType())) {
                    DynamicObject scdataresult = BusinessDataServiceHelper.newDynamicObject((String)"pbd_scdatahandlefail");
                    scdataresult.set("id", (Object)scDataHandleLogInfo.getId());
                    scdataresult.set("username", (Object)RequestContext.get().getUserName());
                    scdataresult.set("creator_id", (Object)RequestContext.get().getCurrUserId());
                    scdataresult.set("entitydesc", (Object)scDataHandleLogInfo.getEntityDesc());
                    scdataresult.set("operatedesc", (Object)scDataHandleLogInfo.getOperateDesc());
                    scdataresult.set("logtype", (Object)scDataHandleLogInfo.getLogType());
                    scdataresult.set("state", (Object)scDataHandleLogInfo.getState());
                    scdataresult.set("traceid", (Object)scDataHandleLogInfo.getTraceId());
                    scdataresult.set("params", (Object)scDataHandleLogInfo.getParams());
                    scdataresult.set("params_tag", (Object)scDataHandleLogInfo.getParamsTag());
                    scdataresult.set("config", (Object)scDataHandleLogInfo.getConfig());
                    scdataresult.set("config_tag", (Object)scDataHandleLogInfo.getConfigTag());
                    scdataresult.set("result", (Object)scDataHandleLogInfo.getResult());
                    scdataresult.set("result_tag", (Object)scDataHandleLogInfo.getResultTag());
                    scdataresult.set("retry", (Object)scDataHandleLogInfo.getRetry());
                    scdataresult.set("definescene", (Object)scDataHandleLogInfo.getDefinescene());
                    scdataresult.set("scdatahandle_id", (Object)scDataHandleLogInfo.getScDataHandle());
                    scDataHandleLogInfo.setFailDataHandle(scDataHandleLogInfo.getId());
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("ishasright", String.valueOf(true));
                    OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"pbd_scdatahandlefail", (DynamicObject[])new DynamicObject[]{scdataresult}, (OperateOption)operateOption);
                    if (saveOperate != null) {
                        if (saveOperate.isSuccess() && saveOperate.getSuccessPkIds().size() > 0) {
                            messageAcker.ack(messageId);
                        } else {
                            StringBuilder message = new StringBuilder();
                            message.append(saveOperate.getMessage());
                            saveOperate.getAllErrorOrValidateInfo().forEach(row -> message.append(row.getMessage()));
                            this.logger.info("\u6b64\u65f6\u6d88\u606f\u88ab\u91cd\u8bd5\uff0cmessageId\uff1a" + messageId + message);
                            messageAcker.deny(messageId);
                        }
                    } else {
                        this.logger.info("\u6b64\u65f6\u6d88\u606f\u88ab\u91cd\u8bd5\uff0cmessageId\uff1a" + messageId + "\u4fdd\u5b58\u64cd\u4f5c\u65e0\u8fd4\u56de\u503c");
                        messageAcker.discard(messageId);
                    }
                }
                try {
                    TXHandle txHandle = TX.requiresNew();
                    Object object = null;
                    try {
                        this.logger.info("logData" + scDataHandleLogInfo.toString());
                        logData.set("username", (Object)scDataHandleLogInfo.getUserName());
                        logData.set("opname", (Object)scDataHandleLogInfo.getOperateDesc());
                        logData.set("opdesc", (Object)(scDataHandleLogInfo.getEntityDesc() + scDataHandleLogInfo.getOperateDesc()));
                        logData.set("opdate", (Object)scDataHandleLogInfo.getCreateTime());
                        logData.set("datahandlefailid", (Object)scDataHandleLogInfo.getFailDataHandle());
                        logData.set("scdatahandle", (Object)scDataHandleLogInfo.getScDataHandle());
                        if ("successlog".equals(scDataHandleLogInfo.getLogType())) {
                            logData.set("config", (Object)scDataHandleLogInfo.getConfig());
                            logData.set("config_tag", (Object)scDataHandleLogInfo.getConfigTag());
                            logData.set("params", (Object)scDataHandleLogInfo.getParams());
                            logData.set("params_tag", (Object)scDataHandleLogInfo.getParamsTag());
                        }
                        logData.set("logappid", (Object)scDataHandleLogInfo.getLogAppId());
                        logData.set("logdim", (Object)scDataHandleLogInfo.getLogDim());
                        logData.set("traceid", (Object)scDataHandleLogInfo.getTraceId());
                        logData.set("result", (Object)scDataHandleLogInfo.getResult());
                        logData.set("result_tag", (Object)scDataHandleLogInfo.getResultTag());
                        LogORM logORM = LogORM.create();
                        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(1);
                        arrayList.add(logData);
                        logORM.insert(arrayList);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (txHandle != null) {
                            if (object != null) {
                                try {
                                    txHandle.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                txHandle.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn(e.getMessage() + ExceptionUtil.getStackTrace((Throwable)e));
                }
            }
            catch (ScDataHandleException e) {
                this.logger.error(ExceptionUtil.getStackTrace((Throwable)e));
                this.logger.info("\u6b64\u65f6\u6d88\u606f\u88ab\u91cd\u8bd5\uff0cmessageId\uff1a" + messageId);
                messageAcker.deny(messageId);
            }
            catch (Throwable e) {
                this.logger.error(ExceptionUtil.getStackTrace((Throwable)e));
                this.logger.info("\u6b64\u65f6\u6d88\u606f\u88ab\u4e22\u5f03\uff0cmessageId\uff1a" + messageId);
                messageAcker.discard(messageId);
            }
            finally {
                this.logger.info("\u8bb0\u5f55\u534f\u540c\u6570\u636e\u5904\u7406\u65e5\u5fd7\u961f\u5217\u6267\u884c\u6570\u636e\u7ed3\u675f");
            }
        }
    }
}

