/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.multisystemjoint.param.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.param.MultiCustomParam;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.plugin.ICustomParamPlugin;

public abstract class AbstractCustomParamPlugin
implements ICustomParamPlugin {
    protected Log logger = LogFactory.getLog(AbstractCustomParamPlugin.class);
    private MultiDataHandleResult scDataHandleResult;
    private ScDataMultiJointChannelInfo scDataMultiJointChannelInfo;
    private MultiCustomParam multiCustomParam;
    private String entityNumber;
    private String sceneEntityNumber;
    private String valueProperty;
    private final Set<String> valueOptions = new HashSet<String>(16);

    public final void initializeOperationResult(ScDataMultiJointChannelInfo scDataMultiJointChannelInfo, MultiDataHandleResult scDataHandleResult, MultiCustomParam multiCustomParam) {
        this.scDataMultiJointChannelInfo = scDataMultiJointChannelInfo;
        this.scDataHandleResult = scDataHandleResult;
        this.multiCustomParam = multiCustomParam;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("AbstractCustomParamPlugin#scDataChannelInfo:{},scDataHandleResult:{}", (Object)SerializationUtils.toJsonString((Object)scDataMultiJointChannelInfo), (Object)SerializationUtils.toJsonString((Object)scDataHandleResult));
        }
    }

    public final void initEntityInfoVar(String entityNumber, String sceneEntityNumber) {
        this.entityNumber = entityNumber;
        this.sceneEntityNumber = sceneEntityNumber;
    }

    public void initValuePropertyAndOptionVar(Map<String, String> customConfigMap) {
        String valueOption;
        String valueProperty = customConfigMap.get("valueproperty");
        if (valueProperty != null && !valueProperty.trim().isEmpty()) {
            this.valueProperty = customConfigMap.get("valueproperty");
        }
        if ((valueOption = customConfigMap.get("valueoption")) != null && !valueOption.trim().isEmpty()) {
            this.addValueOption(customConfigMap.get("valueoption"));
        }
    }

    protected Collection<String> getProperty() {
        return new HashSet<String>();
    }

    protected Set<String> getGroupKeys() {
        return null;
    }

    protected Boolean verifyEnable(List<DynamicObject> dynamicObjects) {
        return Boolean.TRUE;
    }

    public List<DynamicObject> getDynamicObjects(Long[] pkIds) {
        return this.queryDynamicObjects(pkIds);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final List<DynamicObject> queryDynamicObjects(Long[] pkIds) {
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(pkIds.length);
        HashSet<String> propertySet = new HashSet<String>();
        propertySet.add("id");
        propertySet.add("billno");
        propertySet.addAll(this.getProperty());
        String selectProperty = StringUtils.join((Object[])propertySet.toArray(new String[0]), (String)",");
        Set<String> groupKeys = this.getGroupKeys();
        QFilter qFilter = new QFilter("id", "in", (Object)pkIds);
        if (groupKeys != null && groupKeys.size() > 0) {
            ORM orm = ORM.create();
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)this.getEntityNumber(), (String)selectProperty, (QFilter[])new QFilter[]{qFilter}, (String)"id");){
                groupKeys.add("id");
                groupKeys.add("billno");
                DataSet groupDataSet = dataSet.groupBy(groupKeys.toArray(new String[0])).finish();
                dynamicObjects.addAll((Collection<DynamicObject>)orm.toPlainDynamicObjectCollection(groupDataSet));
                if (groupDataSet == null) return dynamicObjects;
                groupDataSet.close();
                return dynamicObjects;
            }
        } else {
            dynamicObjects.addAll((Collection<DynamicObject>)QueryServiceHelper.query((String)this.getEntityNumber(), (String)selectProperty, (QFilter[])new QFilter[]{qFilter}, (String)"id"));
        }
        return dynamicObjects;
    }

    protected final List<DynamicObject> loadDynamicObjects(Long[] pkIds) {
        return Arrays.asList(BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntityNumber())));
    }

    @Override
    public final ScMultiParamArgs assembleCallJointParam(List<DynamicObject> dynamicObjects) {
        return this.verifyEnable(dynamicObjects) != false ? this.assembleJointParam(dynamicObjects) : null;
    }

    protected abstract ScMultiParamArgs assembleJointParam(List<DynamicObject> var1);

    protected final MultiDataHandleResult getScDataHandleResult() {
        return this.scDataHandleResult;
    }

    protected final ScDataMultiJointChannelInfo getScDataChannelInfo() {
        return this.scDataMultiJointChannelInfo;
    }

    public final MultiCustomParam getMultiCustomParam() {
        return this.multiCustomParam;
    }

    public final String getEntityNumber() {
        return this.entityNumber;
    }

    public final String getSceneEntityNumber() {
        return this.sceneEntityNumber;
    }

    public final String getValueProperty() {
        return this.valueProperty;
    }

    public final Set<String> getValueOptions() {
        return this.valueOptions;
    }

    protected final void setValueProperty(String valueProperty) {
        this.valueProperty = valueProperty;
    }

    protected final void addValueOption(String valueOption) {
        this.valueOptions.add(valueOption);
    }
}

