/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiDataChannelHelper;
import kd.scm.common.helper.multisystemjoint.business.MultiSystemJointStrategyMatchHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.exception.MultiSystemJointError;
import kd.scm.common.helper.scdatahandle.IScDataHandleService;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.channel.ScChannelHandleService;
import kd.scm.common.helper.scdatahandle.channel.ScDataHandleChannelServiceTypes;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;

public class JointDataHandleService
implements IScDataHandleService {
    protected static Log log = LogFactory.getLog(JointDataHandleService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScDataHandleResult excuteDataHandle(String dataHandleKey, DynamicObject[] dataEntities) {
        ScDataHandleResult scDataHandleResult = new ScDataHandleResult();
        try {
            String entityNumber = null;
            ArrayList<Long> pkIds = new ArrayList<Long>(dataEntities.length);
            for (DynamicObject bill : dataEntities) {
                if (entityNumber == null) {
                    entityNumber = bill.getDynamicObjectType().getName();
                }
                pkIds.add(bill.getLong("id"));
            }
            LinkedHashMap<Long, ScDataMultiJointChannelInfo> scDataChannelInfoMap = new LinkedHashMap<Long, ScDataMultiJointChannelInfo>(this.getMultiChannelInfo(entityNumber, pkIds));
            LinkedHashMap<String, ArrayList<Long>> channelGroupBillMap = new LinkedHashMap<String, ArrayList<Long>>(1024);
            LinkedHashMap channelIdDataMap = new LinkedHashMap(16);
            for (Map.Entry entry : scDataChannelInfoMap.entrySet()) {
                String channelId = ((ScDataMultiJointChannelInfo)entry.getValue()).getChannelId();
                Long billId = (Long)entry.getKey();
                channelIdDataMap.putIfAbsent(channelId, entry.getValue());
                ArrayList<Long> groupBillIds = (ArrayList<Long>)channelGroupBillMap.get(channelId);
                if (groupBillIds == null) {
                    groupBillIds = new ArrayList<Long>(1024);
                    groupBillIds.add(billId);
                } else {
                    groupBillIds.add(billId);
                }
                channelGroupBillMap.put(channelId, groupBillIds);
            }
            DynamicObject[] groupData = null;
            for (Map.Entry entry : channelGroupBillMap.entrySet()) {
                List groupBillIds = (List)entry.getValue();
                groupData = new DynamicObject[groupBillIds.size()];
                int groupIndex = 0;
                for (DynamicObject bill : dataEntities) {
                    if (!groupBillIds.contains(bill.getLong("id"))) continue;
                    groupData[groupIndex] = bill;
                    ++groupIndex;
                }
                scDataHandleResult = this.executeChannelService((ScDataMultiJointChannelInfo)channelIdDataMap.get(entry.getKey()), dataHandleKey, groupData);
            }
        }
        catch (RuntimeException exception) {
            scDataHandleResult.setMessage(String.valueOf(exception.getMessage()));
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)exception);
        }
        catch (MultiSystemJointError e) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)e);
        }
        finally {
            scDataHandleResult.setFinishedTime(TimeServiceHelper.now());
        }
        return scDataHandleResult;
    }

    protected Map<Long, ScDataMultiJointChannelInfo> getMultiChannelInfo(String entityNumber, List<Long> pkIds) throws MultiSystemJointError {
        LinkedHashMap<Long, ScDataMultiJointChannelInfo> jointChannelInfoLinkedHashMap = new LinkedHashMap<Long, ScDataMultiJointChannelInfo>();
        if (MultiSystemJointStrategyMatchHelper.isContainJointDataChannelFiled(entityNumber)) {
            ORM orm = ORM.create();
            DynamicObjectCollection dataChannels = null;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ScMultiDataHandleServiceHelper.class.getName(), (String)entityNumber, (String)"id,materialentry.jointdatachannelid jointdatachannelid", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds).and(QFilter.isNotNull((String)"materialentry.jointdatachannelid"))}, (String)"id");){
                DataSet jointChannelIdDataSet = dataSet.copy();
                dataChannels = orm.toPlainDynamicObjectCollection(jointChannelIdDataSet.groupBy(new String[]{"jointdatachannelid", "id"}).finish());
                jointChannelIdDataSet.close();
            }
            Map<Long, String> billJointDataMap = MultiSystemJointStrategyMatchHelper.getDefaultStrategy(dataChannels);
            jointChannelInfoLinkedHashMap.putAll(MultiDataChannelHelper.getMultiChannelInfoJointChannelData(entityNumber, billJointDataMap));
        }
        List<Long> notMatchBillIds = null;
        notMatchBillIds = jointChannelInfoLinkedHashMap.isEmpty() ? pkIds : pkIds.stream().filter(row -> !jointChannelInfoLinkedHashMap.containsKey(row)).collect(Collectors.toList());
        jointChannelInfoLinkedHashMap.putAll(MultiDataChannelHelper.calStrategyConfigJointChannel(entityNumber, notMatchBillIds));
        return jointChannelInfoLinkedHashMap;
    }

    protected final ScDataHandleResult executeChannelService(ScDataMultiJointChannelInfo scDataChannelInfo, String dataHandleKey, DynamicObject[] dataEntities) {
        ScDataHandleResult scDataHandleResult = new ScDataHandleResult();
        try {
            ScChannelHandleService scChannelHandleService = this.initializeService(scDataChannelInfo, dataHandleKey, dataEntities);
            scDataHandleResult = scChannelHandleService.excute(dataEntities);
        }
        catch (Exception exception) {
            StringBuilder message = new StringBuilder();
            message.append(exception.getClass().getName());
            message.append(exception.getMessage());
            scDataHandleResult.setMessage(String.valueOf(message));
            throw new KDException(new ErrorCode("\u534f\u540c\u5904\u7406\u6570\u636e\u670d\u52a1\u5904\u7406\u5931\u8d25", message.toString()), new Object[]{exception});
        }
        finally {
            scDataHandleResult.setFinishedTime(TimeServiceHelper.now());
        }
        return scDataHandleResult;
    }

    @Deprecated
    protected ScDataMultiJointChannelInfo getChannelNumber(DynamicObject[] dynamicObjects) throws MultiSystemJointError {
        return MultiDataChannelHelper.getSingleStableChannelInfo();
    }

    protected ScChannelHandleService initializeService(ScDataMultiJointChannelInfo scDataChannelInfo, String dataChannelKey, DynamicObject[] dataEntities) {
        ScChannelHandleService scChannelHandleService = (ScChannelHandleService)ScDataHandleChannelServiceTypes.createEntityOperate(scDataChannelInfo);
        scChannelHandleService.initialize(scDataChannelInfo, dataChannelKey, dataEntities);
        return scChannelHandleService;
    }
}

