/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scm.common.helper.scdatahandle.args.ScStoreDataHandleMessageInfo;
import kd.scm.common.helper.scdatahandle.task.FailTaskWorker;

public final class ScDataHandleTaskHelper {
    private static final Log log;
    private static final FailTaskWorker queue;
    private static final ThreadPool failWorkerThreadPool;
    private static final int MIN_BATCH_SIZE;

    public static Map<String, Object> executeTask(ScStoreDataHandleMessageInfo scStoreDataHandleMessageInfo) {
        queue.submitThread(scStoreDataHandleMessageInfo);
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> batchExecuteTask(final Set<ScStoreDataHandleMessageInfo> scStoreDataHandleMessageInfos) {
        if (scStoreDataHandleMessageInfos != null && !scStoreDataHandleMessageInfos.isEmpty()) {
            if (scStoreDataHandleMessageInfos.size() > MIN_BATCH_SIZE) {
                failWorkerThreadPool.execute(new Runnable(){

                    @Override
                    public void run() {
                        Iterator storeDataHandleMessageInfoIterator = scStoreDataHandleMessageInfos.iterator();
                        while (storeDataHandleMessageInfoIterator.hasNext()) {
                            ScDataHandleTaskHelper.singleExecuteTask((ScStoreDataHandleMessageInfo)storeDataHandleMessageInfoIterator.next());
                        }
                    }
                });
            } else {
                Iterator<ScStoreDataHandleMessageInfo> storeDataHandleMessageInfoIterator = scStoreDataHandleMessageInfos.iterator();
                while (storeDataHandleMessageInfoIterator.hasNext()) {
                    ScDataHandleTaskHelper.singleExecuteTask(storeDataHandleMessageInfoIterator.next());
                }
            }
        }
        return new HashMap<String, Object>();
    }

    private static Map<String, Object> singleExecuteTask(ScStoreDataHandleMessageInfo scStoreDataHandleMessageInfo) {
        queue.submit(scStoreDataHandleMessageInfo, RequestContext.get());
        return new HashMap<String, Object>();
    }

    public static Map<String, Object> queryHandleTaskInfo() {
        return new HashMap<String, Object>();
    }

    static {
        int minBatchSize;
        int count;
        log = LogFactory.getLog(ScDataHandleTaskHelper.class);
        failWorkerThreadPool = ThreadPools.newCachedThreadPool((String)"SCM_SC_FAIL_WORKER", (int)3, (int)9);
        try {
            count = Integer.parseInt(System.getProperty("SCM_SC_TASK_THREADS"));
            if (count <= 0) {
                count = 16;
            }
        }
        catch (Exception var2) {
            count = 16;
        }
        try {
            minBatchSize = Integer.parseInt(System.getProperty("SCM_SC_MIN_BATCH_SIZE"));
            if (minBatchSize <= 0) {
                minBatchSize = 10;
            }
        }
        catch (Exception var2) {
            minBatchSize = 10;
        }
        queue = new FailTaskWorker(Math.max(5, count));
        MIN_BATCH_SIZE = Math.max(10, minBatchSize);
    }
}

