/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.channel;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.ScHandleParamProxy;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractDataHandlePlugin;
import kd.scm.common.helper.scdatahandle.handleplugin.HandleServiceListener;
import kd.scm.common.helper.scdatahandle.handleplugin.IDataHandlePlugin;

public class HandleServicePlugInProxy {
    protected static Log logger = LogFactory.getLog(HandleServicePlugInProxy.class);
    private Map<String, Map<String, Object>> pluginsMetas = null;
    protected Map<String, IDataHandlePlugin> plugIns = new LinkedHashMap<String, IDataHandlePlugin>();
    protected Map<String, HandleServiceListener> servicePlugIns = new LinkedHashMap<String, HandleServiceListener>();
    protected Map<String, AbstractDataHandlePlugin> extPlugIns = new LinkedHashMap<String, AbstractDataHandlePlugin>();

    public HandleServicePlugInProxy(Map<String, Map<String, Object>> pluginsMetas) {
        this.pluginsMetas = pluginsMetas;
        for (Map.Entry<String, Map<String, Object>> entry : this.pluginsMetas.entrySet()) {
            String entryKey = entry.getKey();
            Map<String, Object> pluginType = entry.getValue();
            String className = (String)pluginType.get("handleclass");
            String isv = (String)pluginType.get("isv");
            if (isv == null || "none".equals(className)) continue;
            if (isv.equals("kingdee")) {
                this.plugIns.putIfAbsent(entryKey, (IDataHandlePlugin)TypesContainer.createInstance((String)className));
                continue;
            }
            if (isv.trim().isEmpty() || isv.equals("kingdee")) continue;
            this.extPlugIns.putIfAbsent(entryKey, (AbstractDataHandlePlugin)TypesContainer.createInstance((String)className));
        }
    }

    public void registerPlugIn(String serviceId, IDataHandlePlugin plugIn) {
        this.plugIns.putIfAbsent(serviceId, plugIn);
    }

    public String getPluginInfo() {
        HashMap<String, String> pluginInfo = new HashMap<String, String>(this.plugIns.size());
        for (Map.Entry<String, IDataHandlePlugin> entry : this.plugIns.entrySet()) {
            pluginInfo.putIfAbsent(entry.getKey(), entry.getValue().getClass().getName());
        }
        return ((Object)pluginInfo).toString();
    }

    public void fireContext(String scDataConfigId, String handleConfig, Map<String, Object> scDataConfig, ScHandleParamProxy scHandleParamProxy) {
        for (Map.Entry<String, IDataHandlePlugin> entry : this.plugIns.entrySet()) {
            IDataHandlePlugin dataHandlePlugin = entry.getValue();
            dataHandlePlugin.setContext(scDataConfigId, scDataConfig, scHandleParamProxy);
            dataHandlePlugin.initializeHandleConfig(handleConfig);
        }
    }

    public void fireInitializeOperationResult(ScDataHandleResult scDataHandleResult) {
        for (AbstractDataHandlePlugin abstractDataHandlePlugin : this.plugIns.values()) {
            abstractDataHandlePlugin.initializeOperationResult(scDataHandleResult);
        }
    }

    public void fireHandleData(AssembleHandleArgs assembleHandleArgs) {
        for (AbstractDataHandlePlugin abstractDataHandlePlugin : this.plugIns.values()) {
            abstractDataHandlePlugin.handleData(assembleHandleArgs);
        }
    }

    public void fireAssembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        for (AbstractDataHandlePlugin abstractDataHandlePlugin : this.plugIns.values()) {
            abstractDataHandlePlugin.assembleCosmicHandleArgs(assembleHandleArgs);
        }
    }

    public void fireAssembleEASHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        for (AbstractDataHandlePlugin abstractDataHandlePlugin : this.plugIns.values()) {
            abstractDataHandlePlugin.assembleEASHandleArgs(assembleHandleArgs);
        }
    }

    public void fireAssembleXKHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        for (AbstractDataHandlePlugin abstractDataHandlePlugin : this.plugIns.values()) {
            abstractDataHandlePlugin.assembleXKHandleArgs(assembleHandleArgs);
        }
    }

    public void fireEasCallBack(ScDataHandleResult scDataHandleResult) {
        for (AbstractDataHandlePlugin abstractDataHandlePlugin : this.plugIns.values()) {
            abstractDataHandlePlugin.easCallBack(scDataHandleResult);
        }
    }

    public void fireXkCallBack(ScDataHandleResult scDataHandleResult) {
        for (AbstractDataHandlePlugin abstractDataHandlePlugin : this.plugIns.values()) {
            abstractDataHandlePlugin.xkCallBack(scDataHandleResult);
        }
    }

    public void fireCosmicCallBack(ScDataHandleResult scDataHandleResult) {
        for (AbstractDataHandlePlugin abstractDataHandlePlugin : this.plugIns.values()) {
            abstractDataHandlePlugin.cosmicCallBack(scDataHandleResult);
        }
    }
}

