/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.channel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.jointchannel.IScChannelHandleService;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.ScDataHandleTaskHelper;
import kd.scm.common.helper.scdatahandle.ScHandleContext;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.MajorDataParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleConfig;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleException;
import kd.scm.common.helper.scdatahandle.args.ScHandleParamProxy;
import kd.scm.common.helper.scdatahandle.args.ScStoreDataHandleMessageInfo;
import kd.scm.common.helper.scdatahandle.channel.HandleServiceConfigProxy;
import kd.scm.common.helper.scdatahandle.channel.HandleServicePlugInProxy;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleLogInfo;
import kd.scm.common.helper.scdatahandle.log.IScDataHandleLog;
import kd.scm.common.helper.scdatahandle.log.ScDataHandleLog;
import kd.scm.common.helper.scdatahandle.scmeta.ScDataHandleMetaCache;
import kd.scm.common.helper.scdatahandle.storedata.AbstractPushDataHandler;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.ExceptionUtil;

public abstract class ScChannelHandleService
implements IScChannelHandleService {
    protected static Log log = LogFactory.getLog(ScChannelHandleService.class);
    protected Map<String, Object> scHandleMeta;
    private HandleServicePlugInProxy plugInProxy;
    private HandleServiceConfigProxy handleServiceConfigProxy;
    private ScHandleParamProxy scHandleParamProxy;
    protected ScDataMultiJointChannelInfo multiJointChannelInfo;
    protected String handleKey;
    protected String scDataConfigId;
    protected ScHandleContext scHandleContext;
    protected DynamicObject[] dataEntities;
    protected ScDataHandleResult scDataHandleResult;
    protected AbstractPushDataHandler abstractPushDataHandler;
    protected IScDataHandleLog iScDataHandleLog;
    protected String failStrategy = "ignore";

    public void initialize(ScDataMultiJointChannelInfo scDataChannelInfo, String handleKey, DynamicObject[] dataEntities) {
        this.multiJointChannelInfo = scDataChannelInfo;
        this.dataEntities = dataEntities;
        this.handleKey = handleKey;
        this.scDataHandleResult = this.createHandleResult();
        this.iScDataHandleLog = new ScDataHandleLog();
        try {
            this.initScDataConfigId();
            this.scHandleMeta = ScDataHandleMetaCache.getHandleMetaInfo(handleKey, this.getScDataConfigId());
            this.plugInProxy = new HandleServicePlugInProxy((Map)this.scHandleMeta.get("plugins"));
            this.handleServiceConfigProxy = new HandleServiceConfigProxy(new HashMap<String, Map<String, Object>>());
            this.handleServiceConfigProxy.createScDataService((Map)this.scHandleMeta.get("scserviceconfig"), this.getScDataConfigId());
            this.failStrategy = String.valueOf(this.getScHandleMeta().getOrDefault("failstrategy", "ignore"));
            MajorDataParamArgs majorDataHandleArgs = new MajorDataParamArgs();
            majorDataHandleArgs.setDynamicObjects(this.getDataEntities());
            majorDataHandleArgs.setDataServiceId((String)this.getScHandleMeta().get("scdatahandle"));
            majorDataHandleArgs.setEntity((String)this.getScHandleMeta().get("entitykey"));
            majorDataHandleArgs.setIscDataLinkNumber(this.getMultiJointChannelInfo().getIscLinkNumber());
            this.scHandleParamProxy = new ScHandleParamProxy(majorDataHandleArgs);
            this.plugInProxy.fireContext(this.getScDataConfigId(), (String)this.scHandleMeta.get("handleconfig"), (Map)this.scHandleMeta.get("scdataconfig"), this.getScHandleParamProxy());
            this.handleServiceConfigProxy.fireContext(this.getScDataConfigId(), (String)this.scHandleMeta.get("handleconfig"), (Map)this.scHandleMeta.get("scdataconfig"), this.getScHandleParamProxy());
        }
        catch (ScDataHandleException scException) {
            log.error(ExceptionUtil.getStackTrace((Throwable)scException));
            this.handleSelfException(scException);
            throw new KDException(new ErrorCode("SC_DATA_ERROR_CODE_001", "\u521d\u59cb\u5316\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u4e0d\u53ef\u633d\u56de\u7684\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u652f\u6301\u4eba\u5458\u4fee\u590d"), new Object[]{scException});
        }
        catch (Throwable throwable) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)throwable);
            throw new KDException(new ErrorCode("SC_DATA_ERROR_CODE_001", "\u521d\u59cb\u5316\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u4e0d\u53ef\u633d\u56de\u7684\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u652f\u6301\u4eba\u5458\u4fee\u590d" + throwable.getMessage()), new Object[]{throwable});
        }
        finally {
            log.info("\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u521d\u59cb\u5316\u7ed3\u675f");
        }
    }

    public Map<String, Object> getScHandleMeta() {
        return this.scHandleMeta;
    }

    public void setScHandleMeta(Map<String, Object> scHandleMeta) {
        this.scHandleMeta = scHandleMeta;
    }

    public ScDataMultiJointChannelInfo getMultiJointChannelInfo() {
        return this.multiJointChannelInfo;
    }

    public String getHandleKey() {
        return this.handleKey;
    }

    public void setHandleKey(String handleKey) {
        this.handleKey = handleKey;
    }

    public void setScHandleContext(ScHandleContext scHandleContext) {
        this.scHandleContext = scHandleContext;
    }

    public void setDataEntities(DynamicObject[] dataEntities) {
        this.dataEntities = dataEntities;
    }

    public HandleServicePlugInProxy getPlugInProxy() {
        return this.plugInProxy;
    }

    public ScHandleParamProxy getScHandleParamProxy() {
        return this.scHandleParamProxy;
    }

    public ScHandleContext getScHandleContext() {
        return this.scHandleContext;
    }

    public DynamicObject[] getDataEntities() {
        return this.dataEntities;
    }

    public ScDataHandleResult getScDataHandleResult() {
        return this.scDataHandleResult;
    }

    public HandleServiceConfigProxy getHandleServiceConfigProxy() {
        return this.handleServiceConfigProxy;
    }

    public AbstractPushDataHandler getAbstractPushDataHandler() {
        return this.abstractPushDataHandler;
    }

    public void initScDataConfigId() {
        DynamicObject single = BusinessDataServiceHelper.loadSingleFromCache((String)"pbd_scdataconfig", (QFilter[])new QFilter[]{new QFilter("scdatachannel", "=", (Object)this.getMultiJointChannelInfo().getChannelId())});
        if (single != null) {
            this.scDataConfigId = single.getString("id");
            String storeeclass = single.getString("storeeclass");
            if (storeeclass != null && !storeeclass.trim().isEmpty()) {
                try {
                    this.abstractPushDataHandler = (AbstractPushDataHandler)TypesContainer.createInstance((String)storeeclass);
                }
                catch (Exception e) {
                    log.error(ExceptionUtil.getStackTrace((Throwable)e));
                }
            }
        }
    }

    public String getScDataConfigId() {
        return this.scDataConfigId;
    }

    private ScDataHandleResult createHandleResult() {
        ScDataHandleResult scDataHandleResult = new ScDataHandleResult();
        scDataHandleResult.setStartTime(TimeServiceHelper.now());
        return scDataHandleResult;
    }

    private IScDataHandleLog getiScDataHandleLog() {
        this.iScDataHandleLog = new ScDataHandleLog();
        return this.iScDataHandleLog;
    }

    public final ScDataHandleResult excute(DynamicObject[] dataEntities) throws Exception {
        this.dataEntities = dataEntities;
        this.plugInProxy.fireInitializeOperationResult(this.getScDataHandleResult());
        this.getHandleServiceConfigProxy().fireInitializeOperationResult(this.getScDataHandleResult());
        try {
            this.doExcute();
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getStackTrace((Throwable)e));
            this.handleSelfException(e);
        }
        finally {
            log.info("\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u5904\u7406\u7ed3\u675f");
        }
        return this.getScDataHandleResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExcute() {
        this.executeHandleData();
        AssembleHandleArgs assembleHandleArgs = new AssembleHandleArgs(this.getDataEntities());
        this.prepareAssembleHandleArgs(assembleHandleArgs);
        LinkedHashMap<String, ScDataHandleArgs> scDataHandleArgsMap = this.scHandleParamProxy.getScDataHandleArgsLinkedHashMap();
        if (scDataHandleArgsMap.isEmpty()) {
            this.handleEmptyArgs();
        }
        for (Map.Entry entry : scDataHandleArgsMap.entrySet()) {
            try {
                ScDataHandleArgs scDataHandleArgs = (ScDataHandleArgs)entry.getValue();
                scDataHandleArgs.setIscDataLinkNumber(this.getMultiJointChannelInfo().getIscLinkNumber());
                this.abstractPushDataHandler.exec(this.getScDataHandleResult(), scDataHandleArgs);
                this.assembleScDataSuccessLog((ScDataHandleArgs)entry.getValue());
                this.afterCallBack(this.getScDataHandleResult());
            }
            catch (ScDataHandleException e) {
                log.warn(e.getMessage(), (Throwable)e);
                this.handleException((ScDataHandleArgs)entry.getValue(), e);
                break;
            }
            catch (KDException e) {
                this.getScDataHandleResult().setFinishedTime(TimeServiceHelper.now());
                log.warn(e.getMessage(), (Throwable)e);
                this.handleSelfException(e);
                break;
            }
            catch (Throwable throwable) {
                this.getScDataHandleResult().setFinishedTime(TimeServiceHelper.now());
                log.warn(throwable);
                this.handleSelfException(throwable);
                break;
            }
            finally {
                log.warn("\u534f\u540c\u6570\u636e\u5904\u7406\u670d\u52a1\u5904\u7406\u7ed3\u675f");
            }
        }
    }

    protected void handleEmptyArgs() {
        ScDataHandleLogInfo scDataHandleLogInfo = this.assembleDefaultLogInfo();
        scDataHandleLogInfo.setLogType("successlog");
        scDataHandleLogInfo.setState("success");
        Map<String, Object> scHandleMeta = this.getScHandleMeta();
        String entityKey = (String)scHandleMeta.get("entitykey");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        scDataHandleLogInfo.setLogAppId(dataEntityType.getAppId());
        ScDataHandleConfig scDataHandleConfig = this.assembleScDataHandleConfig(dataEntityType);
        String configJson = SerializationUtils.toJsonString((Object)scDataHandleConfig);
        scDataHandleLogInfo.setConfig(configJson);
        scDataHandleLogInfo.setConfigTag(configJson);
        scDataHandleLogInfo.setEntityDesc(scDataHandleConfig.getEntityDesc());
        scDataHandleLogInfo.setOperateDesc(scDataHandleConfig.getOperateDesc());
        scDataHandleLogInfo.setParams("empty ParamArgs");
        scDataHandleLogInfo.setParamsTag("empty ParamArgs");
        String message = this.getScDataHandleResult().getMessage();
        if (message != null && !message.isEmpty()) {
            scDataHandleLogInfo.setResult(message);
            scDataHandleLogInfo.setResultTag(message);
        } else {
            scDataHandleLogInfo.setResult("success");
            scDataHandleLogInfo.setResultTag("success");
        }
        this.getiScDataHandleLog().info(scDataHandleLogInfo);
    }

    protected final ScDataHandleLogInfo assembleDefaultLogInfo() {
        ScDataHandleLogInfo scDataHandleLogInfo = new ScDataHandleLogInfo();
        scDataHandleLogInfo.setId(DBServiceHelper.genStringId());
        scDataHandleLogInfo.setLogDim("scdataframe");
        scDataHandleLogInfo.setTraceId(RequestContext.get().getTraceId());
        scDataHandleLogInfo.setUserName(RequestContext.get().getUserName());
        scDataHandleLogInfo.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
        scDataHandleLogInfo.setLogAppId("pbd");
        return scDataHandleLogInfo;
    }

    protected void handleSelfException(Throwable throwable) {
        ScDataHandleLogInfo scDataHandleLogInfo = this.assembleDefaultLogInfo();
        Map<String, Object> scHandleMeta = this.getScHandleMeta();
        if (scHandleMeta != null) {
            String entityKey = (String)scHandleMeta.get("entitykey");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
            scDataHandleLogInfo.setLogAppId(dataEntityType.getAppId());
            ScDataHandleConfig scDataHandleConfig = this.assembleScDataHandleConfig(dataEntityType);
            scDataHandleLogInfo.setConfig("scDataHandleConfig");
            scDataHandleLogInfo.setConfigTag(SerializationUtils.toJsonString((Object)scDataHandleConfig));
            scDataHandleLogInfo.setEntityDesc(scDataHandleConfig.getEntityDesc());
            scDataHandleLogInfo.setOperateDesc(scDataHandleConfig.getOperateDesc());
        } else {
            scDataHandleLogInfo.setLogAppId("pbd");
            scDataHandleLogInfo.setConfig("scDataHandleConfig");
            scDataHandleLogInfo.setEntityDesc("\u4e0d\u53ef\u9884\u671f\u7684\u9519\u8bef");
            scDataHandleLogInfo.setOperateDesc("\u4e0d\u53ef\u9884\u671f\u7684\u9519\u8bef");
        }
        scDataHandleLogInfo.setParams("scDataHandleArgs");
        scDataHandleLogInfo.setLogType("successlog");
        scDataHandleLogInfo.setState("success");
        scDataHandleLogInfo.setResult(throwable.getMessage() != null ? throwable.getMessage() : "failed");
        scDataHandleLogInfo.setResultTag(ExceptionUtil.getStackTrace((Throwable)throwable));
        this.getiScDataHandleLog().info(scDataHandleLogInfo);
        this.getScDataHandleResult().setScDataFailId(scDataHandleLogInfo.getId());
        this.getScDataHandleResult().setFinishedTime(TimeServiceHelper.now());
    }

    protected void handleException(ScDataHandleArgs scDataHandleArgs, ScDataHandleException sc) {
        ScDataHandleLogInfo scDataHandleLogInfo = this.assembleDefaultLogInfo();
        Map<String, Object> scHandleMeta = this.getScHandleMeta();
        String entityKey = (String)scHandleMeta.get("entitykey");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        scDataHandleLogInfo.setLogAppId(dataEntityType.getAppId());
        ScDataHandleConfig scDataHandleConfig = this.assembleScDataHandleConfig(dataEntityType);
        scDataHandleLogInfo.setRetry(Integer.valueOf(Integer.parseInt("0")));
        this.assembleScDataLog(scDataHandleArgs, scDataHandleLogInfo, scDataHandleConfig);
        scDataHandleLogInfo.setLogType("faillog");
        scDataHandleLogInfo.setState("fail");
        scDataHandleLogInfo.setResult(sc.getMessage());
        scDataHandleLogInfo.setResultTag(ExceptionUtil.getStackTrace((Throwable)sc));
        this.getiScDataHandleLog().info(scDataHandleLogInfo);
        this.getScDataHandleResult().setScDataFailId(scDataHandleLogInfo.getId());
        this.getScDataHandleResult().setFinishedTime(TimeServiceHelper.now());
        ScStoreDataHandleMessageInfo scStoreDataHandleMessageInfo = new ScStoreDataHandleMessageInfo(scDataHandleLogInfo.getId());
        scStoreDataHandleMessageInfo.setScDataHandleArgs(scDataHandleArgs);
        scStoreDataHandleMessageInfo.setScDataHandleConfig(scDataHandleConfig);
        if ("retry".equals(this.failStrategy)) {
            ScDataHandleTaskHelper.executeTask(scStoreDataHandleMessageInfo);
        }
    }

    protected void assembleScDataSuccessLog(ScDataHandleArgs majorDataHandleArgs) {
        ScDataHandleLogInfo scDataHandleLogInfo = this.assembleDefaultLogInfo();
        Map<String, Object> scHandleMeta = this.getScHandleMeta();
        String entityKey = (String)scHandleMeta.get("entitykey");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        scDataHandleLogInfo.setLogAppId(dataEntityType.getAppId());
        ScDataHandleConfig scDataHandleConfig = this.assembleScDataHandleConfig(dataEntityType);
        this.assembleScDataLog(majorDataHandleArgs, scDataHandleLogInfo, scDataHandleConfig);
        scDataHandleLogInfo.setLogType("successlog");
        scDataHandleLogInfo.setState("success");
        String message = this.getScDataHandleResult().getMessage();
        if (message != null && !message.isEmpty()) {
            scDataHandleLogInfo.setResult(message);
            scDataHandleLogInfo.setResultTag(message);
        } else {
            scDataHandleLogInfo.setResult("success");
            scDataHandleLogInfo.setResultTag("success");
        }
        this.getiScDataHandleLog().info(scDataHandleLogInfo);
        this.getScDataHandleResult().setScDataLogId(scDataHandleLogInfo.getId());
        this.getScDataHandleResult().setFinishedTime(TimeServiceHelper.now());
    }

    protected void assembleScDataLog(ScDataHandleArgs scDataHandleArgs, ScDataHandleLogInfo scDataHandleLogInfo, ScDataHandleConfig scDataHandleConfig) {
        scDataHandleLogInfo.setScDataHandle((String)this.getScHandleMeta().get("scdatahandle"));
        String configJson = SerializationUtils.toJsonString((Object)scDataHandleConfig);
        scDataHandleLogInfo.setConfig(configJson);
        scDataHandleLogInfo.setConfigTag(configJson);
        scDataHandleLogInfo.setEntityDesc(scDataHandleConfig.getEntityDesc());
        scDataHandleLogInfo.setOperateDesc(scDataHandleConfig.getOperateDesc());
        scDataHandleArgs.setDynamicObjects(null);
        LinkedHashMap<String, ScDataHandleArgs> scDataHandleArgsLinkedHashMap = this.getScHandleParamProxy().getScDataHandleArgsLinkedHashMap();
        for (Map.Entry entry : scDataHandleArgsLinkedHashMap.entrySet()) {
            ((ScDataHandleArgs)entry.getValue()).setDynamicObjects(null);
        }
        String paramJson = SerializationUtils.toJsonString((Object)scDataHandleArgs);
        scDataHandleLogInfo.setParams(paramJson);
        scDataHandleLogInfo.setParamsTag(paramJson);
    }

    protected ScDataHandleConfig assembleScDataHandleConfig(MainEntityType dataEntityType) {
        ScDataHandleConfig scDataHandleConfig = new ScDataHandleConfig();
        scDataHandleConfig.setChannelInfo(this.getClass().getName());
        scDataHandleConfig.setScHandleDataInfo(this.abstractPushDataHandler.getClass().getName());
        scDataHandleConfig.setScPluginInfo(this.getPlugInProxy().getPluginInfo());
        String entityName = dataEntityType.getDisplayName().getLocaleValue() + "(" + dataEntityType.getName() + ")";
        scDataHandleConfig.setEntityDesc(entityName);
        scDataHandleConfig.setOperateDesc((String)this.getScHandleMeta().get("name"));
        LinkedHashMap<String, ScDataHandleArgs> scDataHandleArgsLinkedHashMap = this.getScHandleParamProxy().getScDataHandleArgsLinkedHashMap();
        ArrayList dataMaps = new ArrayList(1024);
        ScDataHandleArgs majorDataParamArgs = this.getScHandleParamProxy().getMajorDataParamArgs();
        DynamicObject[] dynamicObjects = majorDataParamArgs.getDynamicObjects();
        if (dynamicObjects != null) {
            for (DynamicObject bill : dynamicObjects) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put(majorDataParamArgs.getDataServiceId(), bill.getDynamicObjectType().getName());
                dataMap.put("id", bill.getString("id"));
                dataMap.put("billno", bill.getString("billno"));
                dataMaps.add(dataMap);
            }
        }
        for (Map.Entry entry : scDataHandleArgsLinkedHashMap.entrySet()) {
            DynamicObject[] refBills = ((ScDataHandleArgs)entry.getValue()).getDynamicObjects();
            if (refBills == null) continue;
            for (DynamicObject refBill : refBills) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put(((ScDataHandleArgs)entry.getValue()).getDataServiceId(), refBill.getDynamicObjectType().getName());
                dataMap.put("id", refBill.getString("id"));
                dataMap.put("billno", refBill.getString("billno"));
                dataMaps.add(dataMap);
            }
        }
        scDataHandleConfig.setDataJson(((Object)dataMaps).toString());
        return scDataHandleConfig;
    }

    protected abstract void executeHandleData();

    protected void prepareAssembleHandleArgs(AssembleHandleArgs assembleHandleArgs) {
    }

    protected void afterCallBack(ScDataHandleResult scDataHandleResult) {
    }
}

