/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.scmeta;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.scdatahandle.util.CacheKeyUtil;

public class ScDataHandleMetaCache {
    public static Map<String, Object> getHandleMetaInfo(String handleKey, String scDataConfigId) {
        Map<String, Object> map = ScDataHandleMetaCache.getHandleCacheKey(handleKey, scDataConfigId);
        return map;
    }

    public static void putCache(String handleKey, Map<String, Object> paramMap) {
        String makeCacheKey = CacheKeyUtil.makeCacheKey(handleKey);
        ScDataHandleMetaCache.getAppCache().put(makeCacheKey, paramMap);
    }

    public static void removeCache(String handleKey) {
        String makeCacheKey = CacheKeyUtil.makeCacheKey(handleKey);
        ScDataHandleMetaCache.getAppCache().remove(makeCacheKey);
    }

    private static Map<String, Object> getHandleCacheKey(String handleKey, String scDataConfigId) {
        String makeCacheKey = CacheKeyUtil.makeCacheKey(handleKey);
        Map<String, Object> cacheData = (Map<String, Object>)ScDataHandleMetaCache.getAppCache().get(makeCacheKey, Map.class);
        if (cacheData == null) {
            cacheData = ScDataHandleMetaCache.getDbScHandleMeta(handleKey, scDataConfigId);
            ScDataHandleMetaCache.putCache(handleKey, cacheData);
        }
        return cacheData;
    }

    private static Map<String, Object> getDbScHandleMeta(String handleKey, String scDataConfigId) {
        LinkedHashMap<String, Object> scHandleMeta = new LinkedHashMap<String, Object>(12);
        LinkedHashMap plugins = new LinkedHashMap(12);
        LinkedHashMap<String, String> scDataConfigMaps = new LinkedHashMap<String, String>(12);
        LinkedHashMap<String, String> scServiceConfigMaps = new LinkedHashMap<String, String>(3);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.scm.common.helper.scdatahandle.scmeta.ScHandleMetaAppCache", (String)"pbd_scdatahandle", (String)"id,number,name,entity,operate,isv,handleclass,failstrategy,handleconfig,refentity.scdataservice scdataservice,refentity.scdataservice.isv serviceisv,refentity.scserviceconfig scserviceconfig,configentity.scdataconfig scdataconfig,configentity.scdataconfigtext scdataconfigtext", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)handleKey)}, (String)"id,refentity.seq");){
            while (dataSet.hasNext()) {
                String scdataconfig;
                Row row = dataSet.next();
                scHandleMeta.putIfAbsent("scdatahandle", row.getString("id"));
                scHandleMeta.putIfAbsent("number", row.getString("number"));
                scHandleMeta.putIfAbsent("name", row.getString("name"));
                scHandleMeta.putIfAbsent("handleconfig", row.getString("handleconfig"));
                HashMap<String, String> pluginMap = new HashMap<String, String>(1);
                pluginMap.put("handleclass", row.getString("handleclass"));
                pluginMap.put("isv", row.getString("isv"));
                scHandleMeta.putIfAbsent("failstrategy", row.getString("failstrategy"));
                scHandleMeta.putIfAbsent("entitykey", row.getString("entity"));
                scHandleMeta.putIfAbsent("operatekey", row.getString("operate"));
                String scdataservice = row.getString("scdataservice");
                if (scdataservice != null) {
                    scServiceConfigMaps.putIfAbsent(scdataservice, row.getString("scserviceconfig"));
                }
                if ((scdataconfig = row.getString("scdataconfig")) != null) {
                    scDataConfigMaps.putIfAbsent(scdataconfig, row.getString("scdataconfigtext"));
                }
                plugins.putIfAbsent(row.getString("id"), pluginMap);
            }
            scHandleMeta.putIfAbsent("plugins", plugins);
            scHandleMeta.putIfAbsent("scserviceconfig", scServiceConfigMaps);
            scHandleMeta.putIfAbsent("scdataconfig", scDataConfigMaps);
        }
        return scHandleMeta;
    }

    private static IAppCache getAppCache() {
        return AppCache.get((String)"schandlemetaappcache");
    }
}

