/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.task;

import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.scm.common.helper.scdatahandle.args.ScStoreDataHandleMessageInfo;
import kd.scm.common.helper.scdatahandle.util.CacheKeyUtil;
import kd.scm.common.util.ExceptionUtil;

public final class FailTaskWorker {
    private static final Log log;
    private int running_count = 0;
    private final int MAX_THREADS;
    private final ThreadPool workerThreadPool;
    private static final int MAX_POOL_SIZE;
    private static final String RUNNING_THREAD_COUNT_CACHE_KEY;

    private static IAppCache getAppCache() {
        return AppCache.get((String)"scdatarunningthreadcount");
    }

    public FailTaskWorker(int maxThreadCount) {
        this.MAX_THREADS = maxThreadCount;
        this.workerThreadPool = ThreadPools.newCachedThreadPool((String)"SCM_SC_TASK_WORKER", (int)0, (int)MAX_POOL_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void submitThread(final ScStoreDataHandleMessageInfo scStoreDataHandleMessageInfo) {
        block19: {
            final String scDataHandleFailId = scStoreDataHandleMessageInfo.getScDataHandleFailId();
            try (final DLock lock = DLock.create((String)scDataHandleFailId);){
                HashSet<String> runningThreadFailIds;
                HashSet chacheSet = (HashSet)FailTaskWorker.getAppCache().get(RUNNING_THREAD_COUNT_CACHE_KEY, HashSet.class);
                if (chacheSet == null) {
                    chacheSet = new HashSet(MAX_POOL_SIZE);
                }
                if ((runningThreadFailIds = new HashSet<String>(chacheSet)).size() >= MAX_POOL_SIZE) break block19;
                runningThreadFailIds.add(scDataHandleFailId);
                FailTaskWorker.getAppCache().put(RUNNING_THREAD_COUNT_CACHE_KEY, runningThreadFailIds);
                try {
                    if (lock.tryLock(2600000L)) {
                        this.workerThreadPool.execute(new Runnable(){

                            @Override
                            public void run() {
                                int waitTime = 1;
                                int cycleTimes = 1;
                                QFilter filter = new QFilter("id", "=", (Object)scDataHandleFailId);
                                while (true) {
                                    DynamicObject scdatafail;
                                    if (cycleTimes == 1) {
                                        waitTime = 100;
                                    }
                                    if (cycleTimes == 2) {
                                        waitTime = 300;
                                    }
                                    if (cycleTimes == 3) {
                                        waitTime = 700;
                                    }
                                    if (cycleTimes == 4) {
                                        waitTime = 1500;
                                    }
                                    try {
                                        Thread.sleep(waitTime * 1000);
                                    }
                                    catch (InterruptedException e) {
                                        log.error((Throwable)e);
                                    }
                                    if ((scdatafail = QueryServiceHelper.queryOne((String)"pbd_scdatahandlefail", (String)"state,retry", (QFilter[])new QFilter[]{filter})) == null) continue;
                                    String state = scdatafail.getString("state");
                                    Integer retry = scdatafail.getInt("retry");
                                    if (state.equals("success")) {
                                        runningThreadFailIds.remove(scDataHandleFailId);
                                        FailTaskWorker.getAppCache().put(RUNNING_THREAD_COUNT_CACHE_KEY, (Object)runningThreadFailIds);
                                        lock.unlock();
                                        break;
                                    }
                                    if (cycleTimes > 4 || !state.equals("fail")) break;
                                    FailTaskWorker.this.submit(scStoreDataHandleMessageInfo, RequestContext.get());
                                    ++cycleTimes;
                                }
                            }
                        }, RequestContext.get());
                    }
                }
                catch (Exception e) {
                    log.warn("Exception" + ExceptionUtil.getStackTrace((Throwable)e));
                }
                finally {
                    log.info("\u4ec5\u7528\u4f5c\u8bb0\u5f55\u670d\u52a1\u5904\u7406\u5b8c\u6bd5");
                }
            }
        }
    }

    public synchronized void submit(ScStoreDataHandleMessageInfo scStoreDataHandleMessageInfo, RequestContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is null.");
        }
        this.startWorkThread(scStoreDataHandleMessageInfo);
    }

    private void startWorkThread(ScStoreDataHandleMessageInfo scStoreDataHandleMessageInfo) {
        log.info("running_count" + this.running_count);
        log.info("MAX_THREADS" + this.MAX_THREADS);
        if (this.running_count < this.MAX_THREADS) {
            ++this.running_count;
            this.innerExecute(scStoreDataHandleMessageInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerExecute(ScStoreDataHandleMessageInfo scStoreDataHandleMessageInfo) {
        MessagePublisher pub = MQFactory.get().createSimplePublisher("scm", "scdatahandle_queue");
        try {
            if (MutexHelper.require((String)"pbd_scdatahandlefail", (Object)scStoreDataHandleMessageInfo.getScDataHandleFailId(), (String)"modify", (StringBuilder)new StringBuilder())) {
                log.info("mq\u6267\u884c\u83b7\u5f97\u4e86\u9501\uff0c\u5c06\u6267\u884c\u534f\u540c\u5f02\u6784\u7cfb\u7edf\u6570\u636e\u5904\u7406\u4efb\u52a1");
                pub.publish((Object)scStoreDataHandleMessageInfo);
            } else {
                log.warn("\u6ca1\u6709\u83b7\u5f97\u6267\u884c\u5931\u8d25\u6570\u636e\u7684\u94a5\u5319");
            }
        }
        catch (Exception e) {
            log.warn(ExceptionUtil.getStackTrace((Throwable)e));
            log.warn("\u8bb0\u5f55\u5f02\u5e38\u4fe1\u606f\uff0c\u5e76\u4e14\u4fdd\u5b58\u5f02\u5e38\u7684\u4e0a\u4e0b\u6587\uff0c\u652f\u6301\u4e0b\u4e00\u6b21\u91cd\u65b0\u8c03\u7528");
        }
        finally {
            if (pub != null) {
                pub.close();
            }
            --this.running_count;
        }
    }

    static {
        int count;
        log = LogFactory.getLog(FailTaskWorker.class);
        RUNNING_THREAD_COUNT_CACHE_KEY = CacheKeyUtil.makeCacheKey("scdatarunningthreadcount");
        try {
            count = Integer.parseInt(System.getProperty("SCM_SC_TASK_THREADS"));
            if (count <= 0) {
                count = 16;
            }
        }
        catch (Exception var2) {
            count = 16;
        }
        MAX_POOL_SIZE = Math.max(5, count) * 2;
        FailTaskWorker.getAppCache().put(RUNNING_THREAD_COUNT_CACHE_KEY, new HashSet(MAX_POOL_SIZE));
    }
}

