/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.plugin;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.property.ComboProp;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.plugin.AbstractQuoFormPlugin;
import kd.scm.common.util.SouBidHallUtil;

public abstract class AbstractBidHall
extends AbstractQuoFormPlugin
implements CountDownListener {
    private IAppCache appCache = AppCache.get((String)"scm");

    public final IAppCache getAppCache() {
        return this.appCache;
    }

    public void initialize() {
        CountDown autoRefresh;
        super.initialize();
        CountDown countdown = (CountDown)this.getControl("countdownap");
        if (countdown != null) {
            countdown.addCountDownListener((CountDownListener)this);
        }
        if ((autoRefresh = (CountDown)this.getControl("autorefresh_cd")) != null) {
            autoRefresh.addCountDownListener((CountDownListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject quoBidBill = this.getSouBidBill();
        this.bindData(quoBidBill);
        this.getPageCache().put("hasCache", "true");
    }

    protected abstract void bindData(DynamicObject var1);

    public void onCountDownEnd(CountDownEvent evt) {
        CountDown countDown = (CountDown)evt.getSource();
        if ("countdownap".equals(countDown.getKey())) {
            DynamicObject quoBidBill = this.getSouBidBill();
            quoBidBill.set("bidstatus", (Object)BidStatusEnum.EVALUATING);
            this.setRestOfTime(quoBidBill);
        } else if ("autorefresh_cd".equals(countDown.getKey())) {
            this.refresh(null, false);
            countDown.setDuration(this.getRefreshTime());
        }
    }

    protected abstract void refresh(DynamicObject var1, boolean var2);

    protected void setRestOfTime(DynamicObject quoBidBill) {
        Label secondsLable;
        Label minutesLable;
        IFormView view = this.getView();
        String bidStatus = quoBidBill.getString("bidstatus");
        CountDown countdown = (CountDown)this.getControl("countdownap");
        CountDown autoRefresh = (CountDown)this.getControl("autorefresh_cd");
        long restOfTime = SouBidHallUtil.getRestOfTime(quoBidBill);
        long days = restOfTime / 86400000L;
        long hours = (restOfTime - days * 86400000L) / 3600000L;
        long minutes = (restOfTime - days * 86400000L - hours * 3600000L) / 60000L;
        long second = restOfTime / 1000L - days * 24L * 60L * 60L - hours * 60L * 60L - minutes * 60L;
        Label hoursLable = (Label)view.getControl("hours");
        if (hoursLable != null) {
            hoursLable.setText(String.valueOf(hours));
        }
        if ((minutesLable = (Label)view.getControl("minutes")) != null) {
            minutesLable.setText(String.valueOf(minutes));
        }
        if ((secondsLable = (Label)view.getControl("seconds")) != null) {
            secondsLable.setText(String.valueOf(second));
        }
        if (countdown != null) {
            countdown.setDuration((int)(restOfTime / 1000L));
            if (restOfTime == 0L) {
                countdown.pause();
            }
        }
        if (countdown != null && bidStatus.equals(BidStatusEnum.PAUSED.getVal())) {
            countdown.pause();
        }
        if (autoRefresh != null) {
            autoRefresh.setDuration(this.getRefreshTime());
        }
        this.changeBtnEnable(quoBidBill, this);
    }

    protected void changeBtnEnable(DynamicObject quoBidBill, AbstractBidHall plugin) {
    }

    protected abstract int getRefreshTime();

    protected abstract DynamicObject getSouBidBill();

    protected void pauseCountDown(CountDown countDown) {
        if (countDown != null) {
            countDown.pause();
        }
    }

    protected void pauseAll() {
        CountDown countdown = (CountDown)this.getControl("countdownap");
        CountDown autoRefresh = (CountDown)this.getControl("autorefresh_cd");
        if (countdown != null) {
            countdown.setDuration(0);
            countdown.pause();
        }
        if (autoRefresh != null) {
            autoRefresh.setDuration(0);
            autoRefresh.pause();
        }
    }

    protected DynamicObject needFresh(boolean force) {
        String newBidStatus;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object pkid = param.get("bidBillId");
        String key = String.valueOf(pkid);
        String s1 = this.getPageCache().get(key);
        String s2 = (String)this.getAppCache().get(key, String.class);
        if ((StringUtils.isNotBlank((CharSequence)s1) && StringUtils.isBlank((CharSequence)s2) || StringUtils.isNotBlank((CharSequence)s1) && StringUtils.isNotBlank((CharSequence)s2) && StringUtils.equals((CharSequence)s1, (CharSequence)s2)) && !force) {
            String newBidStatus2;
            String curBidStatus;
            DynamicObject quoBidBill = this.getSouBidBill();
            if (Objects.nonNull(quoBidBill) && !StringUtils.equals((CharSequence)(curBidStatus = this.getPageCache().get("bidstatus")), (CharSequence)(newBidStatus2 = quoBidBill.getString("bidstatus")))) {
                this.getPageCache().put("bidstatus", newBidStatus2);
                return quoBidBill;
            }
            return null;
        }
        this.getPageCache().put(key, s2);
        DynamicObject quoBidBill = this.getSouBidBill();
        if (quoBidBill == null) {
            return quoBidBill;
        }
        String curBidStatus = this.getPageCache().get("bidstatus");
        if (!StringUtils.equals((CharSequence)curBidStatus, (CharSequence)(newBidStatus = quoBidBill.getString("bidstatus")))) {
            this.getPageCache().put("bidstatus", newBidStatus);
            return quoBidBill;
        }
        String bidStatus = quoBidBill.getString("bidstatus");
        if ((bidStatus.equals(BidStatusEnum.BIDDING.getVal()) || bidStatus.equals(BidStatusEnum.PAUSED.getVal()) || bidStatus.equals(BidStatusEnum.END.getVal()) || bidStatus.equals(BidStatusEnum.EVALUATING.getVal())) && null != quoBidBill) {
            this.setRestOfTime(quoBidBill);
        }
        return quoBidBill;
    }

    protected void setBidRuleInfo(DynamicObject souBidBill) {
        DynamicProperty quotationtrend1 = souBidBill.getDynamicObjectType().getProperty("quotationtrend");
        if (quotationtrend1 instanceof ComboProp) {
            String trend = souBidBill.getString("quotationtrend");
            Label quotationtrend = (Label)this.getView().getControl("quotationtrend");
            String itemByName = ((ComboProp)quotationtrend1).getItemByName(trend);
            if (quotationtrend != null) {
                quotationtrend.setText(itemByName);
            }
        }
    }
}

