/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BidStatusEnum;

public class SouBidHallUtil {
    private static Log log = LogFactory.getLog((String)"SouBidHallUtil");

    public static long getRestOfTime(DynamicObject quoBidBill) {
        Date pauseTime = quoBidBill.getDate("pausetime");
        Date pauseRestartDate = quoBidBill.getDate("pausestarttime");
        Date openDate = quoBidBill.getDate("opendate");
        int bidTime = quoBidBill.getInt("bidtime");
        Date currTime = TimeServiceHelper.now();
        String bidStatus = quoBidBill.getString("bidstatus");
        long restOfTime = quoBidBill.getLong("bidrestoftime");
        if (bidStatus.equals(BidStatusEnum.BIDDING.getVal())) {
            if (null == pauseTime) {
                restOfTime = (long)(bidTime * 60000) - (currTime.getTime() - openDate.getTime());
                log.info("bidTime * (1000 * 60) - (currTime.getTime() - openDate.getTime())=" + bidTime * 60000 + "|" + currTime + "|" + openDate);
            } else {
                log.info("restOfTime = restOfTime - (currTime.getTime() - pauseRestartDate.getTime())=" + (restOfTime -= currTime.getTime() - pauseRestartDate.getTime()) + "|" + currTime + "|" + pauseRestartDate);
            }
        }
        if (!bidStatus.equals(BidStatusEnum.BIDDING.getVal()) && !bidStatus.equals(BidStatusEnum.PAUSED.getVal())) {
            restOfTime = 0L;
        }
        log.info("restOfTime:" + restOfTime);
        return restOfTime < 0L ? 0L : restOfTime;
    }

    public static void sortByQuoteDate(DynamicObjectCollection quoteCols, final int i) {
        Collections.sort(quoteCols, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                if (o1.getDate("quotedate") == null) {
                    return -1 * i;
                }
                if (o2.getDate("quotedate") == null) {
                    return 1 * i;
                }
                return i * o1.getDate("quotedate").compareTo(o2.getDate("quotedate"));
            }
        });
    }
}

