/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.algox;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrderCheckQtyMapFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Map<String, Integer> idxs;
    private String entityKey;

    public OrderCheckQtyMapFunc(RowMeta rowMeta, String entityKey) {
        this.rowMeta = rowMeta;
        this.entityKey = entityKey;
        this.buildIndexs();
    }

    public void reduce(Iterable<RowX> it, Collector collector) {
        int batchSize = 100;
        ArrayList<RowX> rows = new ArrayList<RowX>(batchSize);
        for (RowX row : it) {
            rows.add(row.copy());
            if (rows.size() < batchSize) continue;
            this.handleRows(rows, collector);
            rows.clear();
        }
        if (!rows.isEmpty()) {
            this.handleRows(rows, collector);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void handleRows(List<RowX> rows, Collector collector) {
        Long materialId;
        String pobillno;
        HashSet<String> billnoSet = new HashSet<String>(rows.size());
        HashSet<Long> matIdSet = new HashSet<Long>(rows.size());
        for (RowX row : rows) {
            billnoSet.add(row.getString(this.idxs.get("billno").intValue()));
            matIdSet.add(row.getLong(this.idxs.get("material").intValue()));
        }
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        String selectFields = null;
        if ("pur_check".equals(this.entityKey)) {
            qFilter.and("materialentry.pobillno", "in", billnoSet);
            qFilter.and("materialentry.material", "in", matIdSet);
            selectFields = "materialentry.pobillno pobillno,materialentry.material material,materialentry.qty qty,materialentry.taxamount taxamount";
        } else {
            qFilter.and("entryentity1.pobillno1", "in", billnoSet);
            qFilter.and("entryentity1.material1", "in", matIdSet);
            selectFields = "entryentity1.pobillno1 pobillno,entryentity1.material1 material,entryentity1.qty1 qty,entryentity1.taxamount1 taxamount";
        }
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)this.entityKey, (String)selectFields, (QFilter[])qFilter.toArray());
        HashMap<String, ArrayList<DynamicObject>> checkMap = new HashMap<String, ArrayList<DynamicObject>>(dynList.size());
        for (DynamicObject dyn : dynList) {
            pobillno = dyn.getString("pobillno");
            materialId = dyn.getLong("material");
            String checkKey = pobillno + "_" + materialId;
            ArrayList<DynamicObject> checkList = (ArrayList<DynamicObject>)checkMap.get(checkKey);
            if (checkList == null) {
                checkList = new ArrayList<DynamicObject>(1);
                checkMap.put(checkKey, checkList);
            }
            checkList.add(dyn);
        }
        for (RowX row : rows) {
            pobillno = row.getString(this.idxs.get("billno").intValue());
            materialId = row.getLong(this.idxs.get("material").intValue());
            List checkList = (List)checkMap.get(pobillno + "_" + materialId);
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            if (checkList != null && !checkList.isEmpty()) {
                for (DynamicObject check : checkList) {
                    qty = qty.add(check.getBigDecimal("qty"));
                    amount = amount.add(check.getBigDecimal("taxamount"));
                }
            }
            row.set(this.idxs.get("payableqty").intValue(), (Object)qty);
            row.set(this.idxs.get("payableamt").intValue(), (Object)amount);
            collector.collect(row);
        }
    }

    private void buildIndexs() {
        Field[] fields = this.rowMeta.getFields();
        ArrayList<String> cols = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            cols.add(field.getName());
        }
        this.idxs = this.buildIndexs(this.rowMeta, cols);
    }

    private Map<String, Integer> buildIndexs(RowMeta rowMeta, Collection<String> cols) {
        HashMap<String, Integer> indexs = new HashMap<String, Integer>(cols.size());
        for (String col : cols) {
            indexs.put(col, rowMeta.getFieldIndex(col));
        }
        return indexs;
    }
}

