/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.algox;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;

public class SupplierDeliverQtyMapFunc
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Map<String, Integer> idxs;

    public SupplierDeliverQtyMapFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.buildIndexs();
    }

    public void reduce(Iterable<RowX> it, Collector collector) {
        int batchSize = 1000;
        HashMap<String, BigDecimal> poentryidMap = new HashMap<String, BigDecimal>(batchSize);
        HashMap<Long, Long> matUnitIdMap = new HashMap<Long, Long>(100);
        ArrayList<RowX> rows = new ArrayList<RowX>(batchSize);
        for (RowX row : it) {
            rows.add(row.copy());
            if (rows.size() < batchSize) continue;
            this.handleRows(rows, collector, matUnitIdMap, poentryidMap);
            rows.clear();
        }
        if (!rows.isEmpty()) {
            this.handleRows(rows, collector, matUnitIdMap, poentryidMap);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    private void handleRows(List<RowX> rows, Collector collector, Map<Long, Long> matUnitIdMap, Map<String, BigDecimal> poentryidMap) {
        for (RowX row : rows) {
            String poentryid;
            BigDecimal orderqty;
            Long matId = row.getLong(this.idxs.get("material").intValue());
            if (matId != null && matId != 0L) {
                Long unitId = matUnitIdMap.get(matId);
                if (unitId == null) {
                    String selectFields = "id,masterid,purchaseunit";
                    QFilter qFilter = new QFilter("masterid", "=", (Object)matId);
                    DynamicObject materialPurchaseInfo = QueryServiceHelper.queryOne((String)"bd_materialpurchaseinfo", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
                    if (null != materialPurchaseInfo) {
                        unitId = materialPurchaseInfo.getLong("purchaseunit");
                    }
                    matUnitIdMap.put(matId, unitId);
                }
                if (unitId != null) {
                    row.set(this.idxs.get("unit").intValue(), (Object)unitId);
                }
            }
            if ((orderqty = poentryidMap.get(poentryid = row.getString(this.idxs.get("poentryid").intValue()))) == null) {
                orderqty = row.getBigDecimal(this.idxs.get("orderqty").intValue());
                poentryidMap.put(poentryid, orderqty);
            } else {
                row.set(this.idxs.get("orderqty").intValue(), (Object)BigDecimal.ZERO);
            }
            BigDecimal basicqty = row.getBigDecimal(this.idxs.get("basicqty").intValue());
            basicqty = basicqty == null ? BigDecimal.ZERO : basicqty;
            Date billdate = row.getDate(this.idxs.get("billdate").intValue());
            billdate = billdate == null ? null : DateUtil.string2date((String)DateUtil.date2str((Date)billdate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            Date entrydelidate = row.getDate(this.idxs.get("entrydelidate").intValue());
            Date date = entrydelidate = entrydelidate == null ? null : DateUtil.string2date((String)DateUtil.date2str((Date)entrydelidate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
            if (billdate == null || billdate.after(entrydelidate)) {
                row.set(this.idxs.get("delayqty").intValue(), (Object)basicqty);
            } else {
                row.set(this.idxs.get("ontimeqty").intValue(), (Object)basicqty);
            }
            collector.collect(row);
        }
    }

    private void buildIndexs() {
        Field[] fields = this.rowMeta.getFields();
        ArrayList<String> cols = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            cols.add(field.getName());
        }
        this.idxs = this.buildIndexs(this.rowMeta, cols);
    }

    private Map<String, Integer> buildIndexs(RowMeta rowMeta, Collection<String> cols) {
        HashMap<String, Integer> indexs = new HashMap<String, Integer>(cols.size());
        for (String col : cols) {
            indexs.put(col, rowMeta.getFieldIndex(col));
        }
        return indexs;
    }
}

