/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.checkmapping;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.checkmapping.PurCheckMapping;
import kd.scm.common.checkmapping.PurCheckMappingFieldProp;
import kd.scm.common.checkmapping.PurCheckMappingUtils;
import kd.scm.common.checkmapping.PurHandCheckSupportDefaultImpl;
import kd.scm.common.checkmapping.ScpHandCheckSupportDefaultImpl;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.LineTypeUtil;
import kd.scm.common.util.MaterialUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.PurTypeUtil;
import kd.scm.common.util.check.HandCheckUtil;
import kd.scm.sccore.business.CheckAvailableBasicQtyHelper;
import kd.sdk.scm.common.extpoint.IPurInstockCheckMappingService;
import kd.sdk.scm.pur.extpoint.IPurHandCheckSupport;
import kd.sdk.scm.scp.extpoint.IScpHandCheckSupport;

public final class PurCheckServiceImpl {
    private final Log log = LogFactory.getLog(PurCheckServiceImpl.class);
    private Set<String> extendFields;
    private Map<String, Set<String>> extendFieldsMap;
    private Map<String, Set<String>> extendGroups;
    private Set<String> removeGroups;
    private Boolean isPur;

    public PurCheckServiceImpl(Set<String> extendFields, Map<String, Set<String>> extendFieldsMap, Map<String, Set<String>> extendGroups, Set<String> removeGroups, Boolean isPur) {
        this.extendFields = extendFields;
        this.extendFieldsMap = extendFieldsMap;
        this.extendGroups = extendGroups;
        this.removeGroups = removeGroups;
        this.isPur = isPur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getData(Map<String, Map<String, Object>> filterMap, Map<String, Object> customParams, String jointChannelData) {
        List<String> plugins = PurCheckMappingUtils.findPurCheckMappingPlugin();
        DynamicObject jointCacheData = null;
        String jointSystemTypeParam = this.getJoinChannelType(jointChannelData, jointCacheData);
        DataSet dataSet = null;
        for (String plugin : plugins) {
            DataSet detailDataSet = null;
            try {
                IPurInstockCheckMappingService pluginService;
                HashMap<String, Map<String, Object>> filterParamsMap = new HashMap<String, Map<String, Object>>();
                filterParamsMap.putAll(filterMap);
                Object newInstance = TypesContainer.createInstance((String)plugin);
                if (!(newInstance instanceof IPurInstockCheckMappingService) || (detailDataSet = this.getData(pluginService = (IPurInstockCheckMappingService)newInstance, filterParamsMap, customParams, jointSystemTypeParam)) == null) continue;
                if (dataSet == null) {
                    dataSet = detailDataSet.copy();
                    continue;
                }
                dataSet = dataSet.union(detailDataSet);
            }
            catch (Exception e) {
                throw new KDException(new ErrorCode("exception", e.getMessage()), "", (Throwable)e);
            }
            finally {
                if (detailDataSet == null) continue;
                detailDataSet.close();
            }
        }
        if (dataSet == null) {
            return null;
        }
        DataSet detailDataSet = null;
        DataSet groupByDataSet = null;
        try {
            String[] groupby = this.getGrroupByFields(this.extendGroups, this.removeGroups, jointSystemTypeParam);
            HashMap<String, DynamicObjectCollection> objectMap = new HashMap<String, DynamicObjectCollection>();
            ORM orm = ORM.create();
            List<String> decimalField = this.getDecimalFields();
            dataSet.orderBy(new String[]{"billdate desc", "billno desc"});
            Integer maxCheckRow = HandCheckUtil.getMaxCheckRow("scp_check", "maxcheckdata");
            dataSet.top(maxCheckRow.intValue());
            detailDataSet = dataSet.copy();
            DynamicObjectCollection detailList = orm.toPlainDynamicObjectCollection(detailDataSet);
            Set<String> deductBill = null;
            Map lineTypeByNumber = null;
            if ("self".equals(jointSystemTypeParam)) {
                deductBill = PurCheckMappingUtils.getDeductBill();
                lineTypeByNumber = LineTypeUtil.getControlcriterionLineType();
            }
            CheckAvailableBasicQtyHelper.assembleDetailBusinessDirect((Collection<DynamicObject>)detailList);
            for (DynamicObject detail : detailList) {
                if ("self".equals(jointSystemTypeParam)) {
                    String srcbilltype = detail.getString("srcbilltype");
                    if (deductBill != null && deductBill.contains(srcbilltype)) {
                        String controlcriterion = detail.getString("controlcriterion");
                        if (lineTypeByNumber != null) {
                            detail.set("linetype", lineTypeByNumber.get(controlcriterion));
                        }
                    }
                }
                detail.set("groupkey", (Object)this.getGroupKey(detail, groupby));
                PurCheckMappingUtils.assembleDetailUnmatchtaxamount(detail, "unmatchtaxamount", "");
            }
            DataEntityPropertyCollection properties = detailList.getDynamicObjectType().getProperties();
            objectMap.put("detail", detailList);
            groupByDataSet = dataSet.copy();
            GroupbyDataSet groupBy = groupByDataSet.groupBy(groupby);
            for (IDataEntityProperty pro : properties) {
                String name = pro.getName();
                if (!decimalField.contains(name)) continue;
                groupBy.sum(name);
            }
            DataSet finishDataSet = groupBy.finish();
            if (finishDataSet.isEmpty()) {
                IDataEntityProperty pro;
                pro = null;
                return pro;
            }
            DynamicObjectCollection sumList = orm.toPlainDynamicObjectCollection(finishDataSet);
            for (DynamicObject sumCol : sumList) {
                String purSumGroupKey = this.getGroupKey(sumCol, groupby);
                sumCol.set("groupkey", (Object)purSumGroupKey);
            }
            objectMap.put("sum", sumList);
            if (null != finishDataSet) {
                finishDataSet.close();
            }
            HashMap<String, DynamicObjectCollection> hashMap = objectMap;
            return hashMap;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            if (detailDataSet != null) {
                detailDataSet.close();
            }
        }
    }

    private DataSet getData(IPurInstockCheckMappingService pluginService, Map<String, Map<String, Object>> filterMap, Map<String, Object> customParams, String jointSystemTypeParam) {
        String entityKey = pluginService.getEntityKey();
        this.log.info("###IPurInstockCheckMappingService start getData,entitykey={}", (Object)entityKey);
        PurCheckMapping findBillColMap = PurCheckMappingUtils.findBillColMap(entityKey);
        String conditionEntryKey = pluginService.getConditionEntryKey(this.isPur);
        Map<String, Map<String, Object>> buildCondition = this.buildCondition(pluginService, filterMap, customParams, conditionEntryKey, jointSystemTypeParam);
        String queryString = this.getSelectFieldString(pluginService, filterMap, entityKey, findBillColMap, jointSystemTypeParam);
        String orderBys = pluginService.getOrderBys();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"IPurInstockCheckMappingService", (String)entityKey, (String)queryString, (QFilter[])ORMUtil.map2QFilter(buildCondition), (String)orderBys);
        this.log.info("###IPurInstockCheckMappingService end getData,entitykey={}", (Object)entityKey);
        return dataSet;
    }

    /*
     * WARNING - void declaration
     */
    private String getSelectFieldString(IPurInstockCheckMappingService pluginService, Map<String, Map<String, Object>> filterMap, String entityKey, PurCheckMapping findBillColMap, String jointSystemTypeParam) {
        Map<String, String> tarColMap = findBillColMap.getTarColMap();
        HashMap tarColMapReSuffix = new HashMap(8);
        List<String> excludeKey = this.getExcludeKeys();
        List<PurCheckMappingFieldProp> targetFieldPropFixeds = PurCheckMappingUtils.getPurCheckMappingFieldProps(excludeKey, false, true);
        HashSet<Object> targetFields = new HashSet<Object>(8);
        for (PurCheckMappingFieldProp targetField : targetFieldPropFixeds) {
            Object targetobjcol = targetField.getTargetobjcol();
            if (((String)targetobjcol).endsWith("3")) {
                targetobjcol = ((String)targetobjcol).substring(0, ((String)targetobjcol).length() - 1);
            }
            targetFields.add(targetobjcol);
        }
        StringBuilder selectFieldSb = new StringBuilder();
        List<String> extTargetFields = this.getExtFields();
        for (Map.Entry entry : tarColMap.entrySet()) {
            void var15_18;
            String string = (String)entry.getKey();
            if (string.endsWith("3")) {
                String string2 = string.substring(0, string.length() - 1);
            }
            tarColMapReSuffix.put(var15_18, entry.getValue());
        }
        List<String> groupbyFields = this.getHandCheckGroupFields(this.extendGroups, this.removeGroups, jointSystemTypeParam);
        for (String string : groupbyFields) {
            if (targetFields.contains(string)) continue;
            selectFieldSb.append("null ").append(string).append(",");
        }
        for (String string : targetFields) {
            String targetValue = (String)tarColMapReSuffix.get(string);
            if (extTargetFields.contains(string)) continue;
            if (targetValue == null) {
                selectFieldSb.append("null").append(" ").append(string).append(",");
                continue;
            }
            selectFieldSb.append(targetValue).append(" ").append(string).append(",");
        }
        selectFieldSb.append("'").append(entityKey).append("' as srcbilltype").append(",'");
        Map<String, Object> map = filterMap.get("billdate");
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            stringBuilder.append(DateUtil.date2str((Date)((Date)entry.getValue()), (String)"yyyy-MM-dd")).append(':');
        }
        selectFieldSb.append((CharSequence)stringBuilder).append("' as checkperiod").append(",");
        selectFieldSb.append("' '").append(" ").append("groupkey").append(",");
        selectFieldSb.append("' '").append(" ").append("groupkey3");
        selectFieldSb.append(",curr.amtprecision amtprecision,curr.priceprecision priceprecision");
        this.setExtendFields(entityKey, selectFieldSb);
        String queryString = pluginService.getSelectFieldString(selectFieldSb);
        return queryString;
    }

    private List<String> getExcludeKeys() {
        ArrayList<String> excludeKeys = new ArrayList<String>(8);
        excludeKeys.add("checkperiod");
        excludeKeys.add("dateto");
        excludeKeys.add("dateform");
        excludeKeys.add("srcbilltype3");
        excludeKeys.add("groupkey");
        excludeKeys.add("groupkey3");
        excludeKeys.add("checkstatus");
        excludeKeys.add("diffqty");
        excludeKeys.add("cfmqty");
        excludeKeys.add("outqty");
        excludeKeys.add("outtaxamount");
        excludeKeys.add("diffamt");
        excludeKeys.add("cfmamt");
        excludeKeys.add("operationcolumnap");
        excludeKeys.add("loccurr");
        return excludeKeys;
    }

    private void setExtendFields(String entityKey, StringBuilder sb) {
        if (this.extendFields != null && !this.extendFields.isEmpty()) {
            MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)entityKey);
            if (this.extendFieldsMap != null && this.extendFieldsMap.containsKey(entityKey)) {
                Set<String> allowFields = this.extendFieldsMap.get(entityKey);
                this.extendFields.forEach(arg_0 -> this.lambda$setExtendFields$0(allowFields, sb, (DynamicObjectType)objectType, arg_0));
            } else {
                this.extendFields.forEach(arg_0 -> this.lambda$setExtendFields$1(sb, (DynamicObjectType)objectType, arg_0));
            }
        }
    }

    private Map<String, Map<String, Object>> buildCondition(IPurInstockCheckMappingService pluginService, Map<String, Map<String, Object>> filterMap, Map<String, Object> customParams, String entityKey, String jointSystemTypeParam) {
        String showmatchedKey;
        String checkTypes;
        String orgKey;
        String materielGroup;
        String materialKey;
        String sumCheckTaxAmountKey;
        String sumCheckQtyKey;
        String writeoffflagKey;
        String settleorgKey = pluginService.getSettleorgKey();
        String supplierKey = pluginService.getSupplierKey();
        String supplierscope = (String)customParams.get("supplier");
        if (null != supplierscope && !supplierscope.isEmpty()) {
            HashMap<String, Object[]> supplierMap = new HashMap<String, Object[]>(1);
            supplierMap.put("in", Arrays.stream(supplierscope.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray());
            filterMap.put(supplierKey, supplierMap);
        } else if (!this.isPur.booleanValue()) {
            List supplierList = BizPartnerUtil.getSupplierByUserOfBizPartner();
            HashMap<String, List> supplierMap = new HashMap<String, List>(1);
            supplierMap.put("in", supplierList);
            filterMap.put(supplierKey, supplierMap);
        }
        String settleorgscope = (String)customParams.get("settleorg");
        if (null != settleorgscope && !settleorgscope.isEmpty()) {
            HashMap<String, Object[]> settleOrgScopeMap = new HashMap<String, Object[]>(1);
            settleOrgScopeMap.put("in", Arrays.stream(settleorgscope.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray());
            filterMap.put(settleorgKey, settleOrgScopeMap);
        } else {
            List permissionOrgs = OrgUtil.getHasSettlePermissionOrgs((String)entityKey);
            HashMap<String, List> orgsMap = new HashMap<String, List>(1);
            orgsMap.put("in", permissionOrgs);
            filterMap.put(settleorgKey, orgsMap);
        }
        String ischeckorinvoiceKey = pluginService.getIsCheckorInvoiceKey();
        if (StringUtils.isNotBlank((String)ischeckorinvoiceKey)) {
            HashMap<String, Boolean> isCheckInvoiceMap = new HashMap<String, Boolean>(1);
            isCheckInvoiceMap.put("=", Boolean.FALSE);
            filterMap.put(ischeckorinvoiceKey, isCheckInvoiceMap);
        }
        if (StringUtils.isNotBlank((String)(writeoffflagKey = pluginService.getWriteOffFlagKey()))) {
            HashMap<String, String> isNotWriteOffMap = new HashMap<String, String>(1);
            isNotWriteOffMap.put("!=", "1");
            filterMap.put(writeoffflagKey, isNotWriteOffMap);
        }
        if (StringUtils.isNotBlank((String)(sumCheckQtyKey = pluginService.getSumCheckQtyKey()))) {
            HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(1);
            qtyMap.put("<=", BigDecimal.ZERO);
            filterMap.put(sumCheckQtyKey, qtyMap);
        }
        if (StringUtils.isNotBlank((String)(sumCheckTaxAmountKey = pluginService.getSumCheckTaxAmountKey()))) {
            HashMap<String, BigDecimal> taxamountMap = new HashMap<String, BigDecimal>(1);
            taxamountMap.put("<=", BigDecimal.ZERO);
            filterMap.put(sumCheckTaxAmountKey, taxamountMap);
        }
        if (StringUtils.isNotBlank((String)(materialKey = pluginService.getMaterialKey())) && null != (materielGroup = (String)customParams.get("materialgroup")) && !materielGroup.isEmpty()) {
            HashMap<String, List> materialMap = new HashMap<String, List>(1);
            materialMap.put("in", MaterialUtil.getMaterialByGroup((Object[])Arrays.stream(materielGroup.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray()));
            filterMap.put(materialKey, materialMap);
        }
        if (StringUtils.isNotBlank((String)(orgKey = pluginService.getOrgKey()))) {
            String rcvOrgscope = (String)customParams.get("rcvorg");
            if (null != rcvOrgscope && !rcvOrgscope.isEmpty()) {
                HashMap<String, Object[]> rcvOrgScopeMap = new HashMap<String, Object[]>(1);
                rcvOrgScopeMap.put("in", Arrays.stream(rcvOrgscope.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()).toArray());
                filterMap.put(orgKey, rcvOrgScopeMap);
            } else {
                List permissionOrgs = OrgUtil.getUserHasPermissionOrgs((String)entityKey);
                HashMap<String, List> orgsMap = new HashMap<String, List>(1);
                orgsMap.put("in", permissionOrgs);
                filterMap.put(orgKey, orgsMap);
            }
        }
        filterMap.putAll(pluginService.wrapCustomFilterMap(customParams, entityKey));
        HashMap<String, String> statusMap = new HashMap<String, String>(1);
        statusMap.put("=", BillStatusEnum.AUDIT.getVal());
        filterMap.put("billstatus", statusMap);
        filterMap.putAll(pluginService.wrapVmiFilterMap());
        String isCenterSettleKey = pluginService.isCenterSettleKey();
        if (StringUtils.isNotBlank((String)isCenterSettleKey)) {
            HashMap<String, String> isCenterSettleMap = new HashMap<String, String>(1);
            isCenterSettleMap.put("!=", "1");
            filterMap.put("iscentersettle", isCenterSettleMap);
        }
        if (StringUtils.isNotBlank((String)(checkTypes = pluginService.getCheckTypes()))) {
            HashMap<String, Object[]> checkTypeMap = new HashMap<String, Object[]>(1);
            Object[] checkTypeIds = this.getLineTypeOrPurTypeIds(checkTypes, jointSystemTypeParam);
            checkTypeMap.put("in", checkTypeIds);
            filterMap.put(pluginService.getLineTypeOrPurType(jointSystemTypeParam), checkTypeMap);
        }
        if (StringUtils.isNotBlank((String)(showmatchedKey = pluginService.showmatchedKey()))) {
            Object showMatchedString = customParams.get("showmatched");
            boolean showmatched = Boolean.FALSE;
            if (showMatchedString != null) {
                showmatched = Boolean.parseBoolean(showMatchedString.toString());
            }
            if (!showmatched) {
                HashMap<String, Integer> currFilter = new HashMap<String, Integer>(1);
                currFilter.put("!=", 0);
                filterMap.put(showmatchedKey, currFilter);
            }
        }
        this.wrapExtendConditions(filterMap, customParams, entityKey);
        this.log.info("###IPurInstockCheckMappingService filterMap:" + SerializationUtils.toJsonString(filterMap));
        return filterMap;
    }

    private void wrapExtendConditions(Map<String, Map<String, Object>> filterMap, Map<String, Object> customParams, String entityKey) {
        MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)entityKey);
        BillEntityType billEntityType = (BillEntityType)objectType;
        if (this.isPur.booleanValue()) {
            PurHandCheckSupportDefaultImpl defaultSupport = new PurHandCheckSupportDefaultImpl();
            PluginProxy pluginProxy = PluginProxy.create((Object)defaultSupport, IPurHandCheckSupport.class, (String)"SCM_PUR_HANDCHECK_SUPPORT", null);
            List handCheckPlugins = pluginProxy.getPlugins();
            if (handCheckPlugins != null && !handCheckPlugins.isEmpty()) {
                handCheckPlugins.forEach(arg_0 -> this.lambda$wrapExtendConditions$6(customParams, entityKey, (DynamicObjectType)objectType, billEntityType, filterMap, arg_0));
            }
        } else {
            ScpHandCheckSupportDefaultImpl defaultSupport = new ScpHandCheckSupportDefaultImpl();
            PluginProxy pluginProxy = PluginProxy.create((Object)defaultSupport, IScpHandCheckSupport.class, (String)"SCM_SCP_HANDCHECK_SUPPORT", null);
            List handCheckPlugins = pluginProxy.getPlugins();
            if (handCheckPlugins != null && !handCheckPlugins.isEmpty()) {
                handCheckPlugins.forEach(arg_0 -> this.lambda$wrapExtendConditions$7(customParams, entityKey, (DynamicObjectType)objectType, billEntityType, filterMap, arg_0));
            }
        }
    }

    private Map<String, Map<String, Object>> getExistFieldConditions(DynamicObjectType objectType, BillEntityType billEntityType, Map<String, Map<String, Object>> tempParams) {
        if (CollectionUtils.isEmpty(tempParams)) {
            return null;
        }
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>(8);
        for (Map.Entry<String, Map<String, Object>> entrySet : tempParams.entrySet()) {
            String newField = entrySet.getKey().trim();
            String[] split = newField.split("\\.");
            if (split == null) continue;
            String fieldPrefixKey = null;
            String entryPrefixKey = null;
            if (split.length == 1) {
                fieldPrefixKey = split[0];
            } else if (split.length >= 2) {
                fieldPrefixKey = split[0];
                entryPrefixKey = split[1];
            }
            if (StringUtils.isNotEmpty((String)fieldPrefixKey)) {
                Map entityTypeMap = billEntityType.getAllEntities();
                EntityType entityType = (EntityType)entityTypeMap.get(fieldPrefixKey);
                if (entityType == null || entityType.getProperty(entryPrefixKey) == null) continue;
                params.put(entrySet.getKey(), entrySet.getValue());
                continue;
            }
            if (objectType.getProperty(fieldPrefixKey) == null) continue;
            params.put(entrySet.getKey(), entrySet.getValue());
        }
        return params;
    }

    private Object[] getLineTypeOrPurTypeIds(String checkType, String jointsystemtype) {
        Object[] purTypes = null;
        List purTypeIdList = null;
        if ("self".equals(jointsystemtype)) {
            boolean isStorage = false;
            if ("2".equals(checkType)) {
                isStorage = true;
            }
            purTypeIdList = LineTypeUtil.getLineTypeByStorage((Boolean)isStorage);
        } else {
            purTypeIdList = PurTypeUtil.getPurTypeByCheckType((String)checkType);
        }
        if (purTypeIdList != null && purTypeIdList.size() > 0) {
            purTypes = purTypeIdList.toArray(new Object[0]);
        }
        return purTypes;
    }

    private String checkField(String field, DynamicObjectType objectType) {
        BillEntityType billEntityType;
        Map entityTypeMap;
        EntityType entityType;
        String newField = field.trim();
        int headDivideIndex = newField.indexOf(".");
        int aliasDivideIndex = newField.indexOf(" ");
        String fieldPrefixKey = null;
        String fieldSuffixKey = null;
        if (headDivideIndex > 0) {
            fieldPrefixKey = newField.substring(0, headDivideIndex).toLowerCase();
            if (aliasDivideIndex > 0) {
                fieldSuffixKey = newField.substring(headDivideIndex + 1, aliasDivideIndex).toLowerCase();
            }
        } else if (aliasDivideIndex > 0) {
            fieldPrefixKey = newField.substring(0, aliasDivideIndex).toLowerCase();
        }
        if (StringUtils.isNotEmpty(fieldPrefixKey) && (StringUtils.isNotEmpty(fieldSuffixKey) ? (entityType = (EntityType)(entityTypeMap = (billEntityType = (BillEntityType)objectType).getAllEntities()).get(fieldPrefixKey)) != null && entityType.getProperty(fieldSuffixKey) != null : objectType.getProperty(fieldPrefixKey) != null)) {
            return field;
        }
        if (aliasDivideIndex > 0) {
            return " null " + newField.substring(newField.lastIndexOf(" ") + 1);
        }
        return headDivideIndex > 0 ? " null " + newField.substring(headDivideIndex + 1) : " null " + field;
    }

    private List<String> getExtFields() {
        ArrayList<String> txtTargetFields = new ArrayList<String>(8);
        for (String field : this.extendFields) {
            String targetField;
            String newField = field.trim();
            int headDivideIndex = newField.indexOf(".");
            int aliasDivideIndex = newField.indexOf(" ");
            if (aliasDivideIndex > 0) {
                targetField = newField.substring(newField.lastIndexOf(" ") + 1);
                txtTargetFields.add(targetField);
                continue;
            }
            targetField = headDivideIndex > 0 ? newField.substring(headDivideIndex + 1) : field;
            txtTargetFields.add(targetField);
        }
        return txtTargetFields;
    }

    private String getJoinChannelType(String jointChannelData, DynamicObject jointCacheData) {
        String jointSystemTypeParam = "";
        if (jointChannelData != null) {
            jointCacheData = SystemJointChannelHelper.getJointChannelData((String)jointChannelData);
        }
        if (jointCacheData != null) {
            jointSystemTypeParam = jointCacheData.getString("jointchanneltype.jointsystemtype");
        }
        return jointSystemTypeParam;
    }

    private List<String> getDecimalFields() {
        FormMetadata formmeta = PurCheckMappingUtils.getFormMetaData("pur_handcheck");
        List<String> decimalField = PurCheckMappingUtils.getProQtyOrPriceEntitykey(formmeta);
        return decimalField;
    }

    private String getGroupKey(DynamicObject obj, String[] groupBys) {
        StringBuilder sb = new StringBuilder();
        for (String group : groupBys) {
            if (obj.get(group) instanceof DynamicObject) {
                sb.append(((DynamicObject)obj.get(group)).getPkValue()).append('-');
                continue;
            }
            sb.append(obj.get(group)).append('-');
        }
        return sb.toString();
    }

    private List<String> getHandCheckGroupFields(Map<String, Set<String>> extendFieldGroups, Set<String> removeGroups, String jointSystemTypeParam) {
        List<String> checkGroupsList = PurCheckMappingUtils.getGroupByKeys();
        if (!CollectionUtils.isEmpty(extendFieldGroups)) {
            for (Map.Entry entry : extendFieldGroups.entrySet()) {
                String entityKey = (String)entry.getKey();
                Set allowFields = (Set)entry.getValue();
                MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)entityKey);
                for (String field : allowFields) {
                    String checkFieldGroup = this.checkFieldGroup(field, (DynamicObjectType)objectType);
                    if (!StringUtils.isNotBlank((String)checkFieldGroup)) continue;
                    checkGroupsList.add(checkFieldGroup);
                }
            }
        }
        if (!CollectionUtils.isEmpty(removeGroups)) {
            for (String string : removeGroups) {
                if (!checkGroupsList.contains(string)) continue;
                checkGroupsList.remove(string);
            }
        }
        return checkGroupsList;
    }

    private String[] getGrroupByFields(Map<String, Set<String>> extendFieldGroups, Set<String> removeGroups, String jointSystemTypeParam) {
        List<String> checkGroupsList = this.getHandCheckGroupFields(extendFieldGroups, removeGroups, jointSystemTypeParam);
        checkGroupsList.add("groupkey");
        checkGroupsList.add("checkperiod");
        String[] groupby = this.getGroupBy(checkGroupsList, jointSystemTypeParam);
        return groupby;
    }

    private String checkFieldGroup(String field, DynamicObjectType objectType) {
        BillEntityType billEntityType;
        Map entityTypeMap;
        EntityType entityType;
        String newField = field.trim();
        String[] splitAlias = newField.split(" ");
        String fieldPrefixKey = null;
        String fieldSuffixKey = null;
        String alaisField = null;
        if (splitAlias.length > 1) {
            String fieldStr = splitAlias[0];
            alaisField = splitAlias[1];
            String[] splitField = fieldStr.split("\\.");
            if (splitField.length > 1) {
                fieldPrefixKey = splitField[0];
                fieldSuffixKey = splitField[1];
            } else {
                fieldPrefixKey = splitField[0];
            }
        } else {
            String[] splitField = newField.split("\\.");
            if (splitField.length > 1) {
                fieldPrefixKey = splitField[0];
                fieldSuffixKey = splitField[1];
            } else {
                fieldPrefixKey = splitField[0];
            }
            alaisField = field;
        }
        if (StringUtils.isNotEmpty((String)fieldPrefixKey) && (StringUtils.isNotEmpty((String)fieldSuffixKey) ? (entityType = (EntityType)(entityTypeMap = (billEntityType = (BillEntityType)objectType).getAllEntities()).get(fieldPrefixKey)) != null && entityType.getProperty(fieldSuffixKey) != null : objectType.getProperty(fieldPrefixKey) != null)) {
            return alaisField;
        }
        return null;
    }

    private String[] getGroupBy(List<String> groupby, String jointSystemTypeParam) {
        if ("self".equals(jointSystemTypeParam)) {
            groupby.add("controlcriterion");
        }
        return groupby.toArray(new String[0]);
    }

    private /* synthetic */ void lambda$wrapExtendConditions$7(Map customParams, String entityKey, DynamicObjectType objectType, BillEntityType billEntityType, Map filterMap, IScpHandCheckSupport t) {
        Map tempParams = t.getFilterMap(customParams, entityKey);
        Map<String, Map<String, Object>> existFieldConditionsParams = this.getExistFieldConditions(objectType, billEntityType, tempParams);
        if (existFieldConditionsParams != null && !existFieldConditionsParams.isEmpty()) {
            filterMap.putAll(existFieldConditionsParams);
        }
    }

    private /* synthetic */ void lambda$wrapExtendConditions$6(Map customParams, String entityKey, DynamicObjectType objectType, BillEntityType billEntityType, Map filterMap, IPurHandCheckSupport t) {
        Map tempParams = t.getFilterMap(customParams, entityKey);
        Map<String, Map<String, Object>> existFieldConditionsParams = this.getExistFieldConditions(objectType, billEntityType, tempParams);
        if (existFieldConditionsParams != null && !existFieldConditionsParams.isEmpty()) {
            filterMap.putAll(existFieldConditionsParams);
        }
    }

    private /* synthetic */ void lambda$setExtendFields$1(StringBuilder sb, DynamicObjectType objectType, String t) {
        sb.append(",").append(this.checkField(t, objectType));
    }

    private /* synthetic */ void lambda$setExtendFields$0(Set allowFields, StringBuilder sb, DynamicObjectType objectType, String t) {
        if (allowFields.contains(t)) {
            sb.append(",").append(this.checkField(t, objectType));
        }
    }
}

