/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.args.OperationArgs;
import kd.scm.common.eip.helper.BillOpration;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.SaloutUtil;
import kd.scm.common.util.WriteBackUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PurInstockDeleteOperation
extends BillOpration {
    private static Log log = LogFactory.getLog(PurInstockDeleteOperation.class);

    protected String getOperationKey() {
        return "delete";
    }

    protected String getEntityKey() {
        return "pur_instock";
    }

    protected String getSelectFields() {
        String selectFileds = super.getSelectFields();
        StringBuilder selectSb = new StringBuilder();
        selectSb.append(selectFileds).append(',').append("materialentry").append('.').append("id").append(',').append("materialentry").append('.').append("qty").append(',').append("materialentry").append('.').append("entrystatus").append(',').append("materialentry").append('.').append("poentryid").append(',').append("materialentry").append('.').append("pobillid").append(',').append("businessdirect").append(',').append("replenishtype");
        return selectSb.toString();
    }

    protected void beforeDelete(OperationArgs opArgs) {
        super.beforeDelete(opArgs);
        DynamicObject[] dys = opArgs.getDynamicObjects();
        ArrayList<DynamicObject> normalDys = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> returnDys = new ArrayList<DynamicObject>(8);
        for (DynamicObject dy : dys) {
            String businessdirect = dy.getString("businessdirect");
            if ("return".equals(businessdirect)) {
                returnDys.add(dy);
                continue;
            }
            normalDys.add(dy);
        }
        if (!CollectionUtils.isEmpty(normalDys)) {
            this.writeBackSrcBill(opArgs);
            this.deleteCheckRelation(opArgs);
        }
        if (!CollectionUtils.isEmpty(returnDys)) {
            ArrayList<String> proList = new ArrayList<String>();
            proList.add("suminstockretqty");
            proList.add("suminstockretbaseqty");
            DynamicObject[] purReturnObjs = opArgs.getDynamicObjects();
            Map<String, String> billNo_TypeMap = this.getBillNoTypeMap();
            ArrayList<DynamicObject> returnObjList = new ArrayList<DynamicObject>();
            for (DynamicObject purReturnObj : purReturnObjs) {
                String billNo = purReturnObj.getString("billno");
                String type = billNo_TypeMap.get(billNo);
                if (null == type || type.trim().equals("1")) continue;
                returnObjList.add(purReturnObj);
            }
            if (!CollectionUtils.isEmpty(returnObjList)) {
                OrderUtil.writeBackOrderReturnInfo(returnObjList, proList, "materialentry", "delete");
            }
        }
    }

    private Map<String, String> getBillNoTypeMap() {
        HashMap<String, String> billNoTypeMap = new HashMap<String, String>();
        JSONArray list = JSONArray.fromObject(this.param.get("data"));
        list.forEach(object -> {
            JSONObject entity = JSONObject.fromObject((Object)object);
            Object type = entity.get("type");
            Object billNo = entity.get("billno");
            if (null != billNo && null != type) {
                billNoTypeMap.put(billNo.toString(), type.toString());
            }
        });
        return billNoTypeMap;
    }

    private void writeBackSrcBill(OperationArgs opArgs) {
        JSONArray list = JSONArray.fromObject(this.param.get("data"));
        ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
        ArrayList<Object> poEntryIdList = new ArrayList<Object>();
        HashMap<String, BigDecimal> srcEntryId_qtyMap = new HashMap<String, BigDecimal>();
        ArrayList<String> inOrRevList = new ArrayList<String>();
        list.forEach(object -> {
            Object type;
            JSONObject entity = JSONObject.fromObject((Object)object);
            Object billNoObject = entity.get("billno");
            if (null != billNoObject) {
                inOrRevList.add(billNoObject.toString());
            }
            if (null != (type = entity.get("type")) && !type.toString().equals("1")) {
                JSONArray entryList = JSONArray.fromObject(entity.get("entryentity"));
                for (Object entry : entryList) {
                    String srcEntryIdStr;
                    JSONObject entryMap = JSONObject.fromObject(entry);
                    Object srcEntryId = entryMap.get("saloutentryid");
                    Object poEntryId = entryMap.get("poentryid");
                    BigDecimal qty = CommonUtil.getBigDecimalPro(entryMap.get("qty"));
                    if (null != poEntryId) {
                        poEntryIdList.add(poEntryId);
                    }
                    if (null == srcEntryId || (srcEntryIdStr = String.valueOf(srcEntryId)).isEmpty()) continue;
                    if (null != srcEntryId_qtyMap.get(srcEntryIdStr)) {
                        BigDecimal bigDecimal = ((BigDecimal)srcEntryId_qtyMap.get(srcEntryIdStr)).add(qty);
                        srcEntryId_qtyMap.put(srcEntryIdStr, bigDecimal);
                    } else {
                        srcEntryId_qtyMap.put(srcEntryIdStr, qty);
                    }
                    srcEntryIdList.add(Long.valueOf(srcEntryIdStr));
                }
            }
        });
        if (srcEntryIdList.size() > 0) {
            log.info("###PurInstockDeleteOperation writeback srcEntryIdList:" + CommonUtil.objs2str((Object[])srcEntryIdList.toArray(new Object[0])));
            HashMap<String, List<String>> proListMap = new HashMap<String, List<String>>(1);
            ArrayList<String> proList = new ArrayList<String>();
            proList.add("suminstockqty");
            proListMap.put("materialentry", proList);
            WriteBackUtil.writeBackBill("scp_saloutstock", proListMap, srcEntryIdList, srcEntryId_qtyMap, "delete");
            proList.clear();
            proList.add("suminstockqty");
            proListMap.put("materialentry", proList);
            WriteBackUtil.skipUnAuditWriteBackBill("scp_saloutstock", proListMap, srcEntryIdList, srcEntryId_qtyMap, "scp_order");
        } else if (poEntryIdList.size() > 0) {
            log.info("###PurInstockDeleteOperation writeback poEntryIdList:" + CommonUtil.objs2str((Object[])poEntryIdList.toArray(new Object[0])));
            this.writeBackOrderByInstock((List<Object>)list, poEntryIdList);
        }
        HashMap<String, ArrayList<Object>> entryIdMap = new HashMap<String, ArrayList<Object>>();
        entryIdMap.put("entryid", poEntryIdList);
        opArgs.addParam(entryIdMap);
        WriteBackUtil.partRejWriteBack(poEntryIdList, poEntryIdList, null, inOrRevList, "delete");
    }

    private void writeBackOrderByInstock(List<Object> list, List<Object> poEntryIdList) {
        ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
        HashMap<String, BigDecimal> srcEntryId_qtyMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> srcPoEntryId_qtyMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection srcBillObjects = OrderUtil.querySrcBillInfo(poEntryIdList);
        list.forEach(object -> {
            JSONObject entity = JSONObject.fromObject((Object)object);
            Object type = entity.get("type");
            if (null != type && !type.toString().equals("1")) {
                JSONArray entryList = JSONArray.fromObject(entity.get("entryentity"));
                for (Object entry : entryList) {
                    String srcEntryIdStr;
                    JSONObject entryMap = JSONObject.fromObject(entry);
                    Object srcPoEntryId = entryMap.get("poentryid");
                    log.info("srcPoEntryId" + srcPoEntryId);
                    BigDecimal qty = CommonUtil.getBigDecimalPro(entryMap.get("qty"));
                    if (null == srcPoEntryId || (srcEntryIdStr = String.valueOf(srcPoEntryId)).isEmpty() && srcEntryIdStr.trim().length() == 0) continue;
                    if (srcPoEntryId_qtyMap.get(srcEntryIdStr) != null) {
                        BigDecimal bigDecimal = ((BigDecimal)srcPoEntryId_qtyMap.get(srcEntryIdStr)).add(qty);
                        srcPoEntryId_qtyMap.put(srcEntryIdStr, bigDecimal);
                    } else {
                        srcPoEntryId_qtyMap.put(srcEntryIdStr, qty);
                    }
                    DynamicObject poBillEntry = OrderUtil.getSrcBillEntry(srcBillObjects, srcPoEntryId);
                    String poEntryId = null;
                    if (poBillEntry == null) continue;
                    log.info("poBillEntry" + poBillEntry);
                    poEntryId = poBillEntry.getString("entryId");
                    if (null != srcEntryId_qtyMap.get(poEntryId)) {
                        srcEntryId_qtyMap.put(poEntryId, ((BigDecimal)srcEntryId_qtyMap.get(poEntryId)).add(qty));
                    } else {
                        srcEntryId_qtyMap.put(poEntryId, qty);
                    }
                    srcEntryIdList.add(Long.valueOf(poEntryId));
                }
            }
        });
        if (!srcEntryIdList.isEmpty()) {
            HashMap<String, List<String>> proListMap = new HashMap<String, List<String>>(1);
            ArrayList<String> proList = new ArrayList<String>();
            proList.add("suminstockqty");
            proListMap.put("materialentry", proList);
            log.info("srcEntryIdList" + srcEntryIdList);
            WriteBackUtil.writeBackBillForPurOrder("pur_order", proListMap, srcEntryIdList, srcEntryId_qtyMap, "delete");
        }
        srcPoEntryId_qtyMap.put("poentryid", BigDecimal.ZERO);
        SaloutUtil.updateReciptQtyOrInstockQty(poEntryIdList, srcPoEntryId_qtyMap, "suminstockqty", "delete");
    }

    protected void delete(OperationArgs opArgs) {
        super.delete(opArgs);
        DynamicObject[] purOderObjs = this.getPurOrderInfo(opArgs);
        HashMap<String, Object> billMap = new HashMap<String, Object>(purOderObjs.length);
        billMap.put("purOderObjs.length", purOderObjs != null ? purOderObjs.length : 0);
        for (DynamicObject purOrder : purOderObjs) {
            String logStatus = purOrder.getString("logStatus");
            String billId = ((DynamicObject)purOrder.getDynamicObjectCollection("materialentry").get(0)).getString("pobillid");
            billMap.put(billId, logStatus);
        }
        opArgs.getReturnData().put("pur_order", billMap);
    }

    private DynamicObject[] getPurOrderInfo(OperationArgs opArgs) {
        String selectFields = "logstatus,materialentry.pobillid";
        HashMap paramMap = new HashMap(1);
        HashMap poBillIdMap = new HashMap(1);
        poBillIdMap.put("in", opArgs.getParam().get("entryid"));
        paramMap.put("materialentry.poentryid", poBillIdMap);
        return ORMUtil.load((String)"pur_order", (String)selectFields, paramMap);
    }

    private void deleteCheckRelation(OperationArgs opArgs) {
        DynamicObject[] purReturnObjs;
        ArrayList entryIdList = new ArrayList();
        for (DynamicObject purReturnObj : purReturnObjs = opArgs.getDynamicObjects()) {
            DynamicObjectCollection entrys = purReturnObj.getDynamicObjectCollection("materialentry");
            entrys.forEach(entry -> entryIdList.add(entry.getPkValue().toString()));
        }
        log.info("###purInstockDelete deleteCheckRelation:" + CommonUtil.objs2str((Object[])entryIdList.toArray()));
        QFilter filter = new QFilter("srcentryid", "in", entryIdList);
        DeleteServiceHelper.delete((String)"pur_checkrelation", (QFilter[])new QFilter[]{filter});
    }

    protected DynamicObject[] getExecuteData() {
        DynamicObject[] objs = ORMUtil.load((String)this.getEntityKey(), (String)this.getSelectFields(), (Map)this.buildCondition(), (String)this.getOrderby());
        this.throwException(objs);
        return objs;
    }
}

