/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.eip.args.OperationArgs;
import kd.scm.common.eip.helper.BillOpration;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.CommonUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class PurInvoiceSaveOperation
extends BillOpration {
    private static Log log = LogFactory.getLog(PurInvoiceSaveOperation.class);
    private static final String PAYABLENO = "payableno";
    private static final String PAYABLEAMT = "payableamt";
    private static final String CFMNOTE = "cfmnote";
    private Map<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> apBillNoDataMap = new HashMap<String, Map<String, Object>>();
    private Set<String> orderIdSet = new HashSet<String>();
    private Set<Long> invoiceIdSet = new HashSet<Long>();
    private Map<String, String> num_invoiceId = new HashMap<String, String>();

    protected String getOperationKey() {
        return "save";
    }

    protected String getEntityKey() {
        return "pur_invoice";
    }

    protected String getSelectFields() {
        return "id,billno,org,payableno,payableamt,cfmnote,ispay,entryentity1.poentryid1,entryentity1.id,entryentity1.entrypaybillno,entryentity1.isentrypay,entryentity1.entrypaytype";
    }

    protected Map<String, Map<String, Object>> buildCondition() {
        this.initDataMap();
        HashMap<String, Map<String, Object>> conditionMap = new HashMap<String, Map<String, Object>>(1);
        if (this.invoiceIdSet.size() > 0) {
            HashMap idMap = new HashMap(1);
            idMap.put("in", this.dataMap.keySet().stream().map(Long::parseLong).collect(Collectors.toList()));
            conditionMap.put("id", idMap);
        } else if (this.apBillNoDataMap.size() > 0) {
            HashMap<String, Set<String>> billNoMap = new HashMap<String, Set<String>>(1);
            billNoMap.put("in", this.apBillNoDataMap.keySet());
            conditionMap.put("entryentity1.entrypaybillno", billNoMap);
        } else {
            HashMap<String, Set<String>> idMap = new HashMap<String, Set<String>>(1);
            idMap.put("in", this.orderIdSet);
            conditionMap.put("entryentity1.poentryid1", idMap);
        }
        log.info("PurInvoiceSaveOperation#buildCondition#invoiceIdSet" + this.invoiceIdSet);
        log.info("PurInvoiceSaveOperation#buildCondition#apBillNoDataMap" + this.apBillNoDataMap.keySet());
        log.info("PurInvoiceSaveOperation#buildCondition#conditionMap" + conditionMap);
        return conditionMap;
    }

    private void initDataMap() {
        JSONArray list = JSONArray.fromObject(this.param.get("data"));
        list.forEach(object -> {
            JSONObject entity = JSONObject.fromObject((Object)object);
            Object invoiceBillId = entity.get("invoiceBillId");
            if (!String.valueOf(invoiceBillId).isEmpty() && !JSONNull.getInstance().equals(invoiceBillId)) {
                this.invoiceIdSet.add(Long.parseLong(String.valueOf(invoiceBillId)));
                this.dataMap.put(String.valueOf(invoiceBillId), (Map<String, Object>)entity);
            }
            if (null != entity.get("entryentity1")) {
                JSONArray entryList = JSONArray.fromObject(entity.get("entryentity1"));
                for (Object entry : entryList) {
                    JSONObject entryMap = JSONObject.fromObject(entry);
                    Object poEntryId = entryMap.get("poentryid1");
                    if (null == poEntryId) continue;
                    this.orderIdSet.add(String.valueOf(poEntryId));
                }
            }
            Object number = entity.get("number");
            if (!JSONNull.getInstance().equals(number) && !String.valueOf(number).isEmpty()) {
                this.apBillNoDataMap.put(String.valueOf(number), (Map<String, Object>)entity);
            }
        });
    }

    protected void save(OperationArgs opArgs) {
        super.save(opArgs);
        this.writeBackInvoicePayInfo(opArgs.getDynamicObjects());
        Map retData = opArgs.getReturnData();
        retData.put("code", "200");
        retData.put("data", this.num_invoiceId);
        opArgs.setReturnData(retData);
    }

    private void writeBackInvoicePayInfo(DynamicObject[] objs) {
        boolean retry;
        int attempt = 0;
        if (this.invoiceIdSet.isEmpty()) {
            log.info("EAS\u5173\u8054\u751f\u6210\u5e94\u4ed8 start");
            this.writeBackByEAS();
            log.info("EAS\u5173\u8054\u751f\u6210\u5e94\u4ed8 end");
        }
        do {
            if (objs.length == 0) {
                return;
            }
            retry = false;
            ArrayList<Long> errorIds = new ArrayList<Long>();
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            if (attempt > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    log.info("\u4f11\u772005\u79d2error\uff1a" + e.getMessage());
                }
            }
            ++attempt;
            if (!this.hasDataToProcess()) continue;
            log.info("PurInvoiceSaveOperation#writeBackInvoicePayInfo#invoiceIdSet: " + this.invoiceIdSet);
            log.info("PurInvoiceSaveOperation#writeBackInvoicePayInfo#apBillNoDataMap: " + this.apBillNoDataMap.keySet());
            log.info("PurInvoiceSaveOperation#writeBackInvoicePayInfo#orderIdSet: " + this.orderIdSet);
            this.processEntries(objs, errorIds, successObjs);
            if (!successObjs.isEmpty()) {
                SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])successObjs.toArray(new DynamicObject[0]));
            }
            if (errorIds.isEmpty()) continue;
            log.info("All entrypaybillno are empty. Retrying to fetch updated objs...");
            objs = this.fetchObjsFromDatabase(errorIds);
            retry = objs.length != 0;
        } while (retry && attempt < 3);
        if (retry) {
            log.warn("Exceeded maximum retry attempts for writeBackInvoicePayInfo.");
        }
    }

    private boolean hasDataToProcess() {
        return this.invoiceIdSet.size() > 0 || this.orderIdSet.size() > 0 || this.apBillNoDataMap.size() > 0;
    }

    private void processEntries(DynamicObject[] objs, List<Long> errorIds, List<DynamicObject> successObjs) {
        for (DynamicObject obj : objs) {
            Map<String, Object> data = this.dataMap.get(String.valueOf(obj.getPkValue()));
            if (data == null) {
                DynamicObjectCollection entryCol = obj.getDynamicObjectCollection("entryentity1");
                boolean allEntriesEmpty = true;
                for (DynamicObject entry : entryCol) {
                    String entryPayBillNo = entry.getString("entrypaybillno");
                    if (!StringUtils.isNotBlank((CharSequence)entryPayBillNo)) continue;
                    allEntriesEmpty = false;
                    data = this.apBillNoDataMap.get(entryPayBillNo);
                    if (data == null) continue;
                    this.handleApBillNo(obj, data);
                    successObjs.add(obj);
                }
                if (!allEntriesEmpty) continue;
                errorIds.add(obj.getLong("id"));
                continue;
            }
            this.handleApBillNo(obj, data);
            successObjs.add(obj);
        }
    }

    private DynamicObject[] fetchObjsFromDatabase(List<Long> errorIds) {
        log.info("Fetching updated objs from database...");
        try {
            return BusinessDataServiceHelper.load((String)this.getEntityKey(), (String)this.getSelectFields(), (QFilter[])new QFilter[]{new QFilter("id", "in", errorIds)});
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u67e5\u8be2\u5931\u8d25: " + e.getMessage());
            return new DynamicObject[0];
        }
    }

    private void handleApBillNo(DynamicObject invoiceBill, Map<String, Object> data) {
        if ("delete".equals(data.get("type"))) {
            Object epayableno = data.get("number");
            Object amount = data.get("amount");
            BigDecimal epayableamt = new BigDecimal(amount == null ? "0" : amount.toString());
            String payableno = invoiceBill.get(PAYABLENO).toString();
            BigDecimal payableamt = invoiceBill.getBigDecimal(PAYABLEAMT);
            String[] billno = payableno.split(",");
            ArrayList<String> nolist = new ArrayList<String>();
            for (int j = 1; j < billno.length; ++j) {
                if (!billno[j].contains("[")) continue;
                nolist.add(billno[j].replace("[", "").replace("]", ""));
            }
            nolist.remove(epayableno);
            invoiceBill.set("ispay", (Object)"2");
            invoiceBill.set(PAYABLENO, (Object)String.join((CharSequence)",", nolist));
            invoiceBill.set(PAYABLEAMT, (Object)payableamt.subtract(epayableamt));
            DynamicObjectCollection entryCol = invoiceBill.getDynamicObjectCollection("entryentity1");
            for (DynamicObject entry : entryCol) {
                if (!epayableno.equals(entry.getString("entrypaybillno"))) continue;
                entry.set("entrypaybillno", null);
                entry.set("isentrypay", (Object)"2");
                entry.set("entrypaytype", (Object)"");
            }
        } else {
            invoiceBill.set(PAYABLENO, data.get(PAYABLENO));
            invoiceBill.set(PAYABLEAMT, (Object)CommonUtil.getBigDecimalPro((Object)data.get(PAYABLEAMT)));
            invoiceBill.set(CFMNOTE, (Object)"");
        }
    }

    protected void writeBackByEAS() {
        JSONArray list = JSONArray.fromObject(this.param.get("data"));
        HashMap invoiceNum_srcIdMap = new HashMap();
        HashMap invoiceNum_amountMap = new HashMap();
        HashMap invoiceNum_typeMap = new HashMap(1024);
        ArrayList<String> srcEntryIdList = new ArrayList<String>();
        list.forEach(object -> {
            JSONObject entity = JSONObject.fromObject((Object)object);
            String invoiceNum = String.valueOf(entity.get("number"));
            Object amount = entity.get("amount");
            Object srctype = entity.get("srctype");
            if (null != entity.get("entryentity1")) {
                JSONArray entryList = JSONArray.fromObject(entity.get("entryentity1"));
                ArrayList<String> entryIDList = new ArrayList<String>();
                for (Object entry : entryList) {
                    JSONObject entryMap = JSONObject.fromObject(entry);
                    Object poEntryId = entryMap.get("srcentryid1");
                    if (null == poEntryId) continue;
                    srcEntryIdList.add(String.valueOf(poEntryId));
                    entryIDList.add(String.valueOf(poEntryId));
                }
                invoiceNum_srcIdMap.put(invoiceNum, entryIDList);
                invoiceNum_amountMap.put(invoiceNum, new BigDecimal(amount == null ? "0" : amount.toString()));
                invoiceNum_typeMap.put(invoiceNum, srctype);
            }
        });
        HashMap<String, String> entryId_srcEntryMap = new HashMap<String, String>();
        ArrayList<DynamicObject> allDynList = new ArrayList<DynamicObject>();
        log.info("\u5e94\u4ed8---\u6536\u8d27\u5904\u7406");
        this.writeBackByReceipt(srcEntryIdList, entryId_srcEntryMap, allDynList);
        log.info("\u5e94\u4ed8---\u5165\u5e93\u5904\u7406");
        this.writeBackByInstock(srcEntryIdList, entryId_srcEntryMap, allDynList);
        HashSet availableInvoiceEntryIds = new HashSet(entryId_srcEntryMap.size());
        DynamicObject entry = null;
        DynamicObjectCollection entryCol = null;
        for (Map.Entry entryId : entryId_srcEntryMap.entrySet()) {
            for (Map.Entry invoiceNum : invoiceNum_srcIdMap.entrySet()) {
                List srcEntryList = (List)invoiceNum.getValue();
                if (!srcEntryList.contains(entryId.getValue())) continue;
                entryId_srcEntryMap.put((String)entryId.getKey(), (String)invoiceNum.getKey());
                availableInvoiceEntryIds.add(entryId.getKey());
            }
        }
        log.info("PurInvoiceSaveOperation#writeBackByEAS#availableInvoiceEntryIds" + availableInvoiceEntryIds);
        log.info("PurInvoiceSaveOperation#writeBackByEAS#entryId_srcEntryMapbefore" + entryId_srcEntryMap);
        if (!availableInvoiceEntryIds.isEmpty()) {
            entryId_srcEntryMap.entrySet().removeIf(mapEntry -> !availableInvoiceEntryIds.contains(mapEntry.getKey()));
        }
        log.info("PurInvoiceSaveOperation#writeBackByEAS#entryId_srcEntryMapafter" + entryId_srcEntryMap);
        String srcInvoiceNum = null;
        boolean issuccess = false;
        boolean enableWriteOffFlag = QueryServiceHelper.exists((String)"pur_updateparamconfig", (QFilter[])new QFilter[]{new QFilter("paramkey", "=", (Object)"writeoffkey").and(new QFilter("paramvalue", "=", (Object)"Y"))});
        for (DynamicObject dyn : allDynList) {
            entryCol = dyn.getDynamicObjectCollection("entryentity1");
            BigDecimal payableamt = dyn.getBigDecimal(PAYABLEAMT);
            issuccess = false;
            for (int i = 0; i < entryCol.size(); ++i) {
                entry = (DynamicObject)entryCol.get(i);
                srcInvoiceNum = (String)entryId_srcEntryMap.get(entry.getString("id"));
                if (null == srcInvoiceNum) continue;
                Object srctype = invoiceNum_typeMap.get(srcInvoiceNum);
                if (enableWriteOffFlag && ApiConfigUtil.hasEASConfig()) {
                    entry.set("entrypaybillno", entryId_srcEntryMap.get(entry.getString("id")));
                } else if (null != srctype && srctype.equals("1")) {
                    entry.set("entrypaybillno", entryId_srcEntryMap.get(entry.getString("id")));
                }
                entry.set("isentrypay", (Object)"1");
                entry.set("entrypaytype", (Object)"1");
                if (null == invoiceNum_amountMap.get(srcInvoiceNum)) continue;
                BigDecimal amount = (BigDecimal)invoiceNum_amountMap.remove(srcInvoiceNum);
                dyn.set(PAYABLEAMT, (Object)payableamt.add(amount));
                issuccess = true;
                this.num_invoiceId.put(srcInvoiceNum, dyn.getString("id"));
            }
            if (!issuccess) continue;
            dyn.set("cfmstatus", (Object)"B");
        }
        if (allDynList.size() > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])allDynList.toArray(new DynamicObject[0]));
        }
    }

    protected void writeBackByInstock(List<String> srcEntryIdList, Map<String, String> entryId_srcEntryMap, List<DynamicObject> allDynList) {
        int i;
        String selectors = "id,billno,org,payableno,payableamt,cfmstatus,cfmnote,ispay,entryentity1.id,entryentity1.entrypaybillno,entryentity1.entrypaytype,entryentity1.isentrypay,entryentity1.srcentryid1";
        HashSet<String> srctype = new HashSet<String>();
        QFilter prodfilter = new QFilter("materialentry.srcentryid", "in", srcEntryIdList);
        DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)"pur_instock", (String)"id,number,materialentry.srcentryid,materialentry.id", (QFilter[])new QFilter[]{prodfilter});
        DynamicObject entry = null;
        DynamicObjectCollection entryCol = null;
        HashSet<String> srcBillEntryIds = new HashSet<String>();
        HashMap<String, String> receipt_srcId = new HashMap<String, String>();
        for (DynamicObject dyna : prodArray) {
            entryCol = dyna.getDynamicObjectCollection("materialentry");
            for (i = 0; i < entryCol.size(); ++i) {
                entry = (DynamicObject)entryCol.get(i);
                srcBillEntryIds.add(entry.getString("id"));
                receipt_srcId.put(entry.getString("id"), entry.getString("srcentryid"));
            }
        }
        prodfilter = new QFilter("materialentry.srcentryid", "in", srcEntryIdList);
        for (DynamicObject dyna : prodArray = BusinessDataServiceHelper.load((String)"pur_return", (String)"id,number,materialentry.srcentryid,materialentry.id", (QFilter[])new QFilter[]{prodfilter})) {
            entryCol = dyna.getDynamicObjectCollection("materialentry");
            for (i = 0; i < entryCol.size(); ++i) {
                entry = (DynamicObject)entryCol.get(i);
                srcBillEntryIds.add(entry.getString("id"));
                receipt_srcId.put(entry.getString("id"), entry.getString("srcentryid"));
            }
        }
        srctype.clear();
        srctype.add("pur_instock");
        srctype.add("scp_instock");
        srctype.add("pur_return");
        srctype.add("scp_return");
        prodfilter = new QFilter("entryentity1.srcentryid1", "in", srcBillEntryIds);
        prodfilter = prodfilter.and(new QFilter("entryentity1.srcbilltype1", "in", srctype));
        for (DynamicObject dyn : prodArray = BusinessDataServiceHelper.load((String)"pur_invoice", (String)selectors, (QFilter[])new QFilter[]{prodfilter})) {
            entryCol = dyn.getDynamicObjectCollection("entryentity1");
            for (i = 0; i < entryCol.size(); ++i) {
                entry = (DynamicObject)entryCol.get(i);
                if (!srcBillEntryIds.contains(entry.getString("srcentryid1"))) continue;
                entryId_srcEntryMap.put(entry.getString("id"), (String)receipt_srcId.get(entry.getString("srcentryid1")));
            }
            allDynList.add(dyn);
        }
    }

    protected void writeBackByReceipt(List<String> srcEntryIdList, Map<String, String> entryId_srcEntryMap, List<DynamicObject> allDynList) {
        DynamicObject[] prodArray;
        DynamicObject entry = null;
        DynamicObjectCollection entryCol = null;
        String selectors = "id,billno,org,payableno,payableamt,cfmnote,ispay,cfmstatus,entryentity1.id,entryentity1.poentryid1,entryentity1.entrypaybillno,entryentity1.isentrypay";
        QFilter prodfilter = new QFilter("entryentity1.poentryid1", "in", srcEntryIdList);
        HashSet<String> srctype = new HashSet<String>();
        srctype.add("pur_receipt");
        srctype.add("scp_receipt");
        prodfilter = prodfilter.and(new QFilter("entryentity1.srcbilltype1", "in", srctype));
        for (DynamicObject dyn : prodArray = BusinessDataServiceHelper.load((String)"pur_invoice", (String)selectors, (QFilter[])new QFilter[]{prodfilter})) {
            entryCol = dyn.getDynamicObjectCollection("entryentity1");
            for (int i = 0; i < entryCol.size(); ++i) {
                entry = (DynamicObject)entryCol.get(i);
                if (!srcEntryIdList.contains(entry.getString("poentryid1"))) continue;
                entryId_srcEntryMap.put(entry.getString("id"), entry.getString("poentryid1"));
            }
            allDynList.add(dyn);
        }
    }
}

