/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.eip.helper.BillCoreHelper;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.enums.PurOrderSrcTypeEnum;
import kd.scm.common.isc.util.ISCUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderParamUtil;
import kd.scm.common.util.MessageSendUtil;
import kd.scm.common.util.OrderUtil;
import org.apache.commons.collections.CollectionUtils;

public class PurOrderHelper
extends BillCoreHelper {
    private static Log log = LogFactory.getLog(PurOrderHelper.class);
    private static String ENTITY_KEY = "pur_order";

    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    protected String getSelectfields(Set<String> keySet) {
        StringBuilder strBuffer = new StringBuilder();
        strBuffer.append(super.getSelectfields(keySet));
        strBuffer.append(',').append("logstatus").append(",cfmstatus,cfm,cfmdate,sumoutstockqty,sumreceiptqty,suminstockqty,vmistockqty,payableqty").append(",entryentity.goods,person,reqperson,reqorg,jdorderid");
        return strBuffer.toString();
    }

    protected DynamicObject setHeadDefaultProperties(DynamicObject obj) {
        obj = super.setHeadDefaultProperties(obj);
        obj.set("cfmstatus", (Object)"A");
        obj.set("issyn", (Object)"1");
        return obj;
    }

    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.beforeAddEntity(dynamicObjects, headDataMap, entryDataMap);
        ArrayList<DynamicObject> dynAlertList = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String srcType = dynamicObject.getString("srctype");
            if (null == srcType) {
                srcType = "3";
            }
            if ("7".equals(dynamicObject.getString("billstatus"))) {
                dynamicObject.set("billstatus", (Object)BillStatusEnum.CLOSED.getVal());
            }
            if ("4".equals(dynamicObject.getString("billstatus")) || BillStatusEnum.AUDIT.getVal().equals(dynamicObject.getString("billstatus"))) {
                dynamicObject.set("billstatus", (Object)BillStatusEnum.AUDIT.getVal());
                if (!srcType.equals("1") && !srcType.equals("2")) {
                    dynAlertList.add(dynamicObject);
                }
            }
            if (BillStatusEnum.CLOSED.getVal().equals(dynamicObject.getString("billstatus"))) {
                dynAlertList.add(dynamicObject);
            }
            log.info("###purOrderHelper srcType:" + dynamicObject.getString("srctype"));
            if ("2".equals(dynamicObject.getString("srctype"))) {
                log.info("###\u5df2\u7ecf\u8fdb\u6765\u4e86purOrderHelper srcType:" + dynamicObject.getString("srctype"));
                dynamicObject.set("logstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
            }
            if (dynamicObject.getInt("billversion") > 0) {
                dynamicObject.set("cfmstatus", (Object)ConfirmStatusEnum.CONFIRM.getVal());
                if (null == dynamicObject.get("logstatus") || "".equals(dynamicObject.getString("logstatus"))) {
                    dynamicObject.set("logstatus", (Object)LogisticsStatusEnum.CONFIRM.getVal());
                }
                dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
                dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("cfm", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("cfmdate", (Object)TimeServiceHelper.now());
            }
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("materialentry");
            String billno = dynamicObject.getString(this.getBillNumber());
            BigDecimal sumTax = BigDecimal.ZERO;
            for (DynamicObject entry : entryCol) {
                entry.set("pobillno", (Object)billno);
                sumTax = sumTax.add(entry.getBigDecimal("tax"));
                if ("7".equals(entry.getString("entrystatus"))) {
                    entry.set("entrystatus", (Object)BillEntryStatusEnum.CLOSED.getVal());
                }
                if ("4".equals(entry.getString("entrystatus"))) {
                    entry.set("entrystatus", (Object)BillEntryStatusEnum.COMMON.getVal());
                }
                if (!"2".equals(dynamicObject.getString("srctype"))) continue;
                entry.set("rowlogstatus", (Object)LogisticsStatusEnum.ALLOUTSTOCK.getVal());
            }
            if (dynamicObject.getPkValue() != null && (Long)dynamicObject.getPkValue() != 0L) continue;
            dynamicObject.set("sumtax", (Object)sumTax);
            if (!this.minDeliInfo(entryCol).containsKey("delidate")) continue;
            dynamicObject.set("delidate", this.minDeliInfo(entryCol).get("delidate"));
            dynamicObject.set("deliaddress", this.minDeliInfo(entryCol).get("deliaddress"));
        }
        if (MalOrderParamUtil.getDefaultMalVersion() || StringUtils.equalsIgnoreCase((CharSequence)MalOrderParamUtil.getBizFlowParam(), (CharSequence)"3")) {
            this.updateByMalOrder(dynamicObjects);
        }
        if (dynAlertList.size() > 0) {
            OrderUtil.updateOrderCfmStatus(dynAlertList.toArray(new DynamicObject[0]), false);
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (null == dynamicObject.get("logstatus") || StringUtils.isEmpty((CharSequence)dynamicObject.getString("logstatus"))) continue;
            dynamicObject.set("cfmstatus", (Object)ConfirmStatusEnum.CONFIRM.getVal());
        }
    }

    protected void updateByMalOrder(List<DynamicObject> dynamicObjects) {
        log.info("###start updateByMalOrder");
        HashSet<String> ids = new HashSet<String>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryDyo : entryCol) {
                if (!StringUtils.isNotBlank((CharSequence)entryDyo.getString("srcentryid"))) continue;
                ids.add(entryDyo.getString("srcentryid"));
            }
        }
        if (ids.size() == 0) {
            return;
        }
        DynamicObjectCollection cols = this.getMalDynamicObjectBynumber(ids);
        if (CollectionUtils.isEmpty((Collection)cols) || cols.size() == 0) {
            return;
        }
        Map entryId_orderMap = DynamicObjectUtil.colsToMap((DynamicObjectCollection)cols, (String)"entryentity.id");
        boolean isrequest = StringUtils.equalsIgnoreCase((CharSequence)MalOrderParamUtil.getBizFlowParam(), (CharSequence)"3");
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!isrequest && !MalOrderParamUtil.getDefaultMalVersion()) {
                dynamicObject.set("billstatus", (Object)BillStatusEnum.SUBMIT.getVal());
            }
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("materialentry");
            DynamicObject srcEntry = null;
            for (DynamicObject entry : entryCol) {
                srcEntry = (DynamicObject)entryId_orderMap.get(entry.get("srcentryid"));
                if (null == srcEntry) continue;
                entry.set("goods", srcEntry.get("entryentity.goods"));
                entry.set("srcbillid", srcEntry.get("id"));
            }
            if (null == srcEntry) continue;
            dynamicObject.set("person", srcEntry.get("person"));
            dynamicObject.set("reqperson", srcEntry.get("reqperson"));
            dynamicObject.set("reqorg", srcEntry.get("deporg"));
            dynamicObject.set("jdorderid", srcEntry.get("jdorderid"));
        }
    }

    private Map<String, Object> minDeliInfo(DynamicObjectCollection dynamicObjectCollection) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (resultMap.size() > 0 && dynamicObject.getDate("entrydelidate") != null) {
                    if (!((Date)resultMap.get("delidate")).after(dynamicObject.getDate("entrydelidate"))) continue;
                    resultMap.put("delidate", dynamicObject.getDate("entrydelidate"));
                    resultMap.put("deliaddress", dynamicObject.getString("deliaddr"));
                    continue;
                }
                if (resultMap.size() > 0 || dynamicObject.getDate("entrydelidate") == null) continue;
                resultMap.put("delidate", dynamicObject.getDate("entrydelidate"));
                resultMap.put("deliaddress", dynamicObject.getString("deliaddr"));
            }
        }
        return resultMap;
    }

    @Deprecated
    protected void updateBySrcOrder(List<DynamicObject> dynamicObjects) {
    }

    protected void afterAddEntityTransaction(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> headDataMap, Map<String, Map<String, Object>> entryDataMap) {
        super.afterAddEntityTransaction(dynamicObjects, headDataMap, entryDataMap);
        String generateEirpBill = MalOrderParamUtil.getGenerateErpBill();
        String bizFlowParam = MalOrderParamUtil.getBizFlowParam();
        HashMap<String, String> extraMap = new HashMap<String, String>();
        extraMap.put("tplScene", "purorderconfirm");
        extraMap.put("configUrlForm", "scp_order_mob");
        extraMap.put("orgScopeType", "purorgscope");
        ArrayList<DynamicObject> orderLsit = new ArrayList<DynamicObject>();
        boolean isisc = ISCUtil.isISC();
        for (DynamicObject dynamicObject : dynamicObjects) {
            boolean flag;
            String srcType = dynamicObject.getString("srctype");
            String billStatus = dynamicObject.getString("billstatus");
            if ("2".equals(srcType) || "1".equals(srcType)) {
                orderLsit.add(dynamicObject);
            }
            boolean bl = flag = StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)generateEirpBill) && StringUtils.equalsIgnoreCase((CharSequence)"2", (CharSequence)bizFlowParam) && (StringUtils.equals((CharSequence)PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_JD.getVal(), (CharSequence)srcType) || StringUtils.equals((CharSequence)PurOrderSrcTypeEnum.PUR_ORDER_SRC_TYPE_SELF.getVal(), (CharSequence)srcType));
            if (isisc && (MalOrderParamUtil.getDefaultMalVersion() || StringUtils.equalsIgnoreCase((CharSequence)MalOrderParamUtil.getBizFlowParam(), (CharSequence)"3"))) {
                flag = false;
            }
            if (flag) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)this.getEntityKey(), (Object[])new Object[]{dynamicObject.getPkValue()}, (OperateOption)option);
                if (!auditResult.isSuccess()) {
                    log.info("@@@kd.scm.common.eip.helper.PurOrderHelper.afterAddEntity\u5ba1\u6838\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                }
            }
            if (!BillStatusEnum.AUDIT.getVal().equals(billStatus)) continue;
            MessageSendUtil.send((DynamicObject)dynamicObject, extraMap);
        }
        if (orderLsit.size() > 0) {
            OrderUtil.updateMalOrderByOrder(orderLsit.toArray(new DynamicObject[0]));
        }
        this.setReturnLogStatus(dynamicObjects);
    }

    private void setReturnLogStatus(List<DynamicObject> dynamicObjects) {
        HashMap<String, String> logStatusMap = new HashMap<String, String>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String billNo = dynamicObject.getString(this.getBillNumber());
            String logStatus = dynamicObject.getString("logstatus");
            logStatusMap.putIfAbsent(billNo, logStatus);
        }
        this.getReturnVal().put("logstatus", logStatusMap);
    }

    protected String getEntrySelectfields(Set<String> keySet, String str) {
        StringBuilder selectFieldsSb = new StringBuilder();
        selectFieldsSb.append(super.getEntrySelectfields(keySet, str)).append(',').append("pobillno").append(',').append("srcbillid").append(',').append("entrystatus");
        return selectFieldsSb.toString();
    }

    public DynamicObjectCollection getDynamicObjectByID(Set<Long> ids) {
        StringBuilder selectFieldsSb = new StringBuilder();
        selectFieldsSb.append("id,createtime,creator");
        selectFieldsSb.append(',').append(this.getEntryKey()).append('.').append("id").append(' ').append("entryid");
        selectFieldsSb.append(',').append(this.getEntryKey()).append('.').append("material").append(' ').append("material");
        selectFieldsSb.append(',').append(this.getEntryKey()).append('.').append("srcentryid").append(' ').append("srcentryid");
        selectFieldsSb.append(',').append(this.getEntryKey()).append('.').append("srcbillid").append(' ').append("srcbillid");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pur_order", (String)selectFieldsSb.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, (String)"id");
        DynamicObjectCollection cols = ORM.create().toPlainDynamicObjectCollection(dataSet);
        return cols;
    }

    protected boolean isNotUpdated(DynamicObject obj, Map<String, Object> dataMap) {
        return false;
    }

    public DynamicObjectCollection getMalDynamicObjectBynumber(Set<String> ids) {
        String selectFields = "id,reqperson,entryentity.goods,deporg,person,entryentity.id,jdorderid";
        HashSet malOrderEntryIds = new HashSet(ids.size() * 2);
        ids.forEach(id -> malOrderEntryIds.add(Long.valueOf(id)));
        QFilter filter = new QFilter("entryentity.id", "in", malOrderEntryIds);
        return QueryServiceHelper.query((String)"mal_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }
}

