/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.args.OperationArgs;
import kd.scm.common.eip.helper.BillOpration;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.SaloutUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PurReturnDeleteOperation
extends BillOpration {
    private static Log log = LogFactory.getLog(PurReturnDeleteOperation.class);

    protected String getOperationKey() {
        return "delete";
    }

    protected String getEntityKey() {
        return "scp_return";
    }

    protected String getSelectFields() {
        String selectFileds = super.getSelectFields();
        StringBuilder selectSb = new StringBuilder();
        selectSb.append(selectFileds).append(',').append("materialentry").append('.').append("id").append(',').append("materialentry").append('.').append("entrystatus").append(',').append("materialentry").append('.').append("qty").append(',').append("materialentry").append('.').append("poentryid").append(',').append("replenishtype").append(',').append("materialentry").append('.').append("pobillid");
        return selectSb.toString();
    }

    protected void beforeDelete(OperationArgs opArgs) {
        super.beforeDelete(opArgs);
        ArrayList entryIdstrList = new ArrayList();
        ArrayList entryIdList = new ArrayList();
        DynamicObject[] purReturnObjs = opArgs.getDynamicObjects();
        Map<String, String> billNo_TypeMap = this.getBillNoTypeMap();
        ArrayList<DynamicObject> returnObjList = new ArrayList<DynamicObject>();
        for (DynamicObject purReturnObj : purReturnObjs) {
            String billNo = purReturnObj.getString("billno");
            String type = billNo_TypeMap.get(billNo);
            if (null != type && !type.trim().equals("1")) {
                returnObjList.add(purReturnObj);
            }
            DynamicObjectCollection entrys = purReturnObj.getDynamicObjectCollection("materialentry");
            entrys.forEach(entry -> {
                entryIdList.add((Long)entry.getPkValue());
                entryIdstrList.add(entry.getPkValue().toString());
            });
        }
        ArrayList<Object> targetIdList = new ArrayList<Object>(1024);
        List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)this.getEntityKey(), (String)"materialentry", (Long[])entryIdList.toArray(new Long[0]));
        bfRowList.forEach(bfRow -> targetIdList.add(bfRow.getId().getBillId()));
        if (targetIdList.size() > 0) {
            SaloutUtil.writeOrderSumoutstockqty(targetIdList);
            this.deletSaleReturnBill(targetIdList);
        }
        ArrayList<String> proList = new ArrayList<String>();
        proList.add("suminstockretqty");
        OrderUtil.writeBackOrderReturnInfo(returnObjList, proList, "materialentry", "delete");
        log.info("###purReturnDelete deleteCheckRelation:" + CommonUtil.objs2str((Object[])entryIdstrList.toArray()));
        QFilter filter = new QFilter("srcentryid", "in", entryIdstrList);
        DeleteServiceHelper.delete((String)"pur_checkrelation", (QFilter[])new QFilter[]{filter});
    }

    private void deletSaleReturnBill(List<Object> saleReturnbillidList) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult unAuditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"scp_salreturn", (Object[])saleReturnbillidList.toArray(), (OperateOption)option);
        if (unAuditResult.isSuccess()) {
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"scp_salreturn", (Object[])saleReturnbillidList.toArray(), (OperateOption)option);
            if (!deleteResult.isSuccess()) {
                StringBuilder message = this.buildErrorMessage(deleteResult);
                log.error("@@\u5220\u9664\u76ee\u6807\u5355\u9500\u552e\u9000\u8d27\u5931\u8d25\uff1a" + message);
                SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)new KDBizException(message.toString()));
            }
        } else {
            StringBuilder message = this.buildErrorMessage(unAuditResult);
            log.error("\u53cd\u5ba1\u6838\u9500\u552e\u9000\u8d27\u5355\u5931\u8d25\uff1a" + message);
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)new KDBizException(message.toString()));
        }
    }

    protected void delete(OperationArgs opArgs) {
        super.delete(opArgs);
        DynamicObject[] purOderObjs = this.getPurOrderInfo(opArgs);
        HashMap<String, Object> billMap = new HashMap<String, Object>(purOderObjs.length);
        billMap.put("purOderObjs.length", purOderObjs != null ? purOderObjs.length : 0);
        for (DynamicObject purOrder : purOderObjs) {
            String logStatus = purOrder.getString("logStatus");
            String billId = ((DynamicObject)purOrder.getDynamicObjectCollection("materialentry").get(0)).getString("pobillid");
            billMap.put(billId, logStatus);
        }
        opArgs.getReturnData().put("pur_order", billMap);
    }

    private DynamicObject[] getPurOrderInfo(OperationArgs opArgs) {
        String selectFields = "logstatus,materialentry.pobillid";
        HashMap paramMap = new HashMap(1);
        HashMap poBillIdMap = new HashMap(1);
        poBillIdMap.put("in", opArgs.getParam().get("entryid"));
        paramMap.put("materialentry.poentryid", poBillIdMap);
        return ORMUtil.load((String)"pur_order", (String)selectFields, paramMap);
    }

    private Map<String, String> getBillNoTypeMap() {
        HashMap<String, String> billNoTypeMap = new HashMap<String, String>();
        JSONArray list = JSONArray.fromObject(this.param.get("data"));
        list.forEach(object -> {
            JSONObject entity = JSONObject.fromObject((Object)object);
            Object type = entity.get("type");
            Object billNo = entity.get("billno");
            if (null != billNo && null != type) {
                billNoTypeMap.put(billNo.toString(), type.toString());
            }
        });
        return billNoTypeMap;
    }

    protected DynamicObject[] getExecuteData() {
        DynamicObject[] objs = ORMUtil.load((String)this.getEntityKey(), (String)this.getSelectFields(), (Map)this.buildCondition(), (String)this.getOrderby());
        this.throwException(objs);
        return objs;
    }
}

