/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.eip.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.eip.helper.CoreHelper;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class PurchasePersonHelper
extends CoreHelper {
    private static String ENTITY_KEY = "pur_bizperson";

    protected String getEntityKey() {
        return ENTITY_KEY;
    }

    protected DynamicObject setDefaultProperties(DynamicObject obj) {
        obj = super.setDefaultProperties(obj);
        obj.set("createorg", (Object)RequestContext.get().getOrgId());
        obj.set("ctrlstrategy", (Object)"5");
        return obj;
    }

    protected void beforeAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.beforeAddEntity(dynamicObjects, dataMap);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String userNumber;
            String number = dynamicObject.getString("number").toLowerCase();
            Map<String, Object> personMap = dataMap.get(number);
            DynamicObject user = null;
            if (personMap != null && (userNumber = (String)personMap.get("number")) != null && !userNumber.isEmpty()) {
                QFilter filter = new QFilter("number", "=", (Object)userNumber);
                user = QueryServiceHelper.queryOne((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter[]{filter});
            }
            if (user == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u91c7\u8d2d\u5458\u5173\u8054\u4eba\u5458\u4e0d\u5b58\u5728\uff0c\u5355\u636e\u540c\u6b65\u5931\u8d25\u3002", (String)"PurchasePersonHelper_0", (String)"scm-common", (Object[])new Object[0]));
            }
            dynamicObject.set("user", (Object)user.getLong("id"));
            if (StringUtils.isEmpty((Object)dynamicObject.getString("group"))) continue;
            ApiUtil.syncPurchasePersonGroup((String)("'" + dynamicObject.getString("group") + "'"));
        }
    }

    protected void afterAddEntity(List<DynamicObject> dynamicObjects, Map<String, Map<String, Object>> dataMap) {
        super.afterAddEntity(dynamicObjects, dataMap);
        HashSet<String> groupSet = new HashSet<String>(dynamicObjects.size());
        HashSet<String> userIdSet = new HashSet<String>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            groupSet.add(dynamicObject.getString("group"));
            userIdSet.add(dynamicObject.getString("user"));
        }
        QFilter userfilter = new QFilter("id", "in", userIdSet);
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)(DynamicObjectUtil.getSelectfields((String)"bos_user", (boolean)false) + "," + DynamicObjectUtil.getEntrySelectfields(null, (String)"bos_user", (String)"entryentity", (boolean)false)), (QFilter[])new QFilter[]{userfilter});
        HashMap<String, DynamicObject> userIdMap = new HashMap<String, DynamicObject>(users.length);
        for (int i = 0; i < users.length; ++i) {
            DynamicObject user = users[i];
            userIdMap.put(user.getString("id"), user);
        }
        QFilter filter = new QFilter("id", "in", groupSet);
        DynamicObject[] groups = BusinessDataServiceHelper.load((String)"bd_operatorgroup", (String)(DynamicObjectUtil.getSelectfields((String)"bd_operatorgroup", (boolean)false) + "," + DynamicObjectUtil.getEntrySelectfields(null, (String)"bd_operatorgroup", (String)"entryentity", (boolean)false)), (QFilter[])new QFilter[]{filter});
        HashMap group_personMap = new HashMap(groups.length);
        HashMap<String, DynamicObject> groupMap = new HashMap<String, DynamicObject>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            DynamicObjectCollection groupCol = groups[i].getDynamicObjectCollection("entryentity");
            HashSet<String> phoneSet = new HashSet<String>(groupCol.size());
            for (int j = 0; j < groupCol.size(); ++j) {
                DynamicObject operator = ((DynamicObject)groupCol.get(j)).getDynamicObject("operator");
                String phone = operator.getString("phone");
                phoneSet.add(phone);
            }
            group_personMap.put(groups[i].getString("id"), phoneSet);
            groupMap.put(groups[i].getString("id"), groups[i]);
        }
        HashSet<DynamicObject> bdGroupSet = new HashSet<DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String userId = dynamicObject.getString("user");
            String phone = dynamicObject.getString("phone");
            String groupId = dynamicObject.getString("group");
            if (StringUtils.isEmpty((Object)userId) || "0".equals(userId) || null == group_personMap.get(groupId)) continue;
            Set userPhoneSet = (Set)group_personMap.get(groupId);
            if (null == groupMap.get(groupId)) continue;
            DynamicObject group = (DynamicObject)groupMap.get(groupId);
            DynamicObjectCollection entrys = group.getDynamicObjectCollection("entryentity");
            if (userPhoneSet.contains(phone)) {
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entryUser = ((DynamicObject)entrys.get(i)).getDynamicObject("operator");
                    if (!phone.equals(entryUser.getString("phone"))) continue;
                    ((DynamicObject)entrys.get(i)).set("operator", userIdMap.get(userId));
                }
                group.set("entryentity", (Object)entrys);
                bdGroupSet.add(group);
                continue;
            }
            if (null == userIdMap.get(userId)) continue;
            DynamicObject entry = ORMUtil.newDynamicObject((DynamicObjectType)entrys.getDynamicObjectType());
            entry.set("seq", (Object)(entrys.size() + 1));
            entry.set("operator", userIdMap.get(userId));
            entrys.add((Object)entry);
            group.set("entryentity", (Object)entrys);
            bdGroupSet.add(group);
        }
        if (bdGroupSet.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])bdGroupSet.toArray(new DynamicObject[0]));
        }
    }
}

