/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.kuaidi100.impl.kuaidiQueryHelper;
import kd.scm.common.kuaidi100.util.KuaidiUtil;
import kd.scm.common.util.BillAssistUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.GenericLogisticsInfoQueryUtil;

public abstract class GenericLogisticsInfoQueryPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(GenericLogisticsInfoQueryPlugin.class);
    protected static final String ENTRY_ENTITY = "entryentity";
    protected static final String LOG_ENTRY_ENTITY = "logentryentity";
    protected static final String IS_CLICK_QUERY = "isclickquery";
    protected static final GenericLogisticsInfoQueryUtil InfoQueryUtil = new GenericLogisticsInfoQueryUtil();

    public abstract String[] getEntityKeys();

    protected void allotDynamicData(List<DynamicObject> dynamicObjectList) {
        QFilter kudifilter = new QFilter("database_type.number", "in", (Object)"TMS_KD100");
        Map kuaidiMap = BusinessDataServiceHelper.loadFromCache((String)"isc_database_link", (QFilter[])new QFilter[]{kudifilter});
        if (!KuaidiUtil.IsExistAccount()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9700\u8981\u914d\u7f6e\u5feb\u9012100\u8d26\u53f7\u624d\u80fd\u67e5\u8be2\u7269\u6d41\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"GenericLogisticsInfoQueryPlugin_1", (String)"scm-common", (Object[])new Object[0]));
        } else {
            this.clearData();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            List propertiesEntity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(ENTRY_ENTITY).getDynamicObjectType());
            model.batchCreateNewEntryRow(ENTRY_ENTITY, DynamicFormUtil.batchBindData(dynamicObjectList, (List)propertiesEntity, (String)""));
            grid.selectRows(0);
            DynamicObject dynamicObject = dynamicObjectList.get(0);
            HashMap<String, Object> queryLogMap = new HashMap<String, Object>();
            queryLogMap.put("com", dynamicObject.getString("logsuppliernumber"));
            queryLogMap.put("num", dynamicObject.get("logbillno"));
            this.allotLogDynamicData(this.queryLogData(queryLogMap));
        }
    }

    public List<Map<String, Object>> queryLogData(Map<String, Object> queryLogMap) {
        kuaidiQueryHelper httpRequestService = new kuaidiQueryHelper();
        Map resultMap = new HashMap();
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        try {
            if (!KuaidiUtil.IsExistAccount()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u9700\u8981\u914d\u7f6e\u5feb\u9012100\u8d26\u53f7\u624d\u80fd\u67e5\u8be2\u7269\u6d41\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"GenericLogisticsInfoQueryPlugin_1", (String)"scm-common", (Object[])new Object[0]));
                return mapList;
            }
            resultMap = httpRequestService.executeApi(queryLogMap);
            if ("false".equals(String.valueOf(resultMap.get("result")))) {
                KuaidiUtil.setVerify(resultMap, (IFormView)this.getView());
                return mapList;
            }
            List dataList = (List)resultMap.get("data");
            if (dataList != null) {
                mapList.addAll(dataList);
            }
        }
        catch (Exception e) {
            log.info(ExceptionUtil.getStackTrace((Throwable)e));
        }
        return mapList;
    }

    protected void beforeAllotDynamicData() {
    }

    protected void afterAllotDynamicData() {
    }

    public void allotLogDynamicData(List<Map<String, Object>> mapList) {
        log.info(((Object)((Object)this)).getClass().getName() + mapList.size() + mapList);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.deleteEntryData(LOG_ENTRY_ENTITY);
        int rowCount = 0;
        for (Map<String, Object> object : mapList) {
            if (object instanceof Map) {
                for (Map.Entry<String, Object> entry : object.entrySet()) {
                    switch (entry.getKey()) {
                        case "time": {
                            vs.set(entry.getKey(), entry.getValue(), rowCount);
                            break;
                        }
                        case "ftime": {
                            vs.set(entry.getKey(), entry.getValue(), rowCount);
                            break;
                        }
                        case "context": {
                            vs.set(entry.getKey(), entry.getValue(), rowCount);
                            break;
                        }
                    }
                }
            } else if (object instanceof String) {
                vs.set("context", object, rowCount);
            } else {
                vs.set("context", (Object)ResManager.loadKDString((String)"\u9519\u8bef", (String)"GenericLogisticsInfoQueryPlugin_0", (String)"scm-common", (Object[])new Object[0]), rowCount);
            }
            ++rowCount;
        }
        model.batchCreateNewEntryRow(LOG_ENTRY_ENTITY, vs);
        log.info(((Object)((Object)this)).getClass().getName() + vs.getCount() + vs.getFields());
    }

    protected final Map<String, Map<String, Object>> assembleFilterValue(String showKey) {
        IDataModel model = this.getModel();
        HashMap<String, Map<String, Object>> filterMap = new HashMap<String, Map<String, Object>>();
        DataEntityPropertyCollection properties = model.getDataEntity().getDataEntityType().getProperties();
        HashMap<String, Date> deliMap = new HashMap<String, Date>();
        HashMap<String, Date> logDateMap = new HashMap<String, Date>();
        block30: for (IDataEntityProperty iDataEntityProperty : properties) {
            String nameKey = iDataEntityProperty.getName();
            Object value = this.getModel().getValue(nameKey);
            switch (nameKey) {
                case "fdeli_enddate": {
                    if (value == null) break;
                    deliMap.put("<=", DateUtil.formatEndDate((Date)((Date)value)));
                    if (deliMap.size() <= 0) break;
                    filterMap.put("logentryentity.logdelidate", deliMap);
                    break;
                }
                case "fdeli_startdate": {
                    if (value == null) break;
                    deliMap.put(">=", DateUtil.formatStartDate((Date)((Date)value)));
                    if (deliMap.size() <= 0) break;
                    filterMap.put("logentryentity.logdelidate", deliMap);
                    break;
                }
                case "fmaterial": {
                    if (!(value instanceof DynamicObjectCollection) || ((DynamicObjectCollection)value).size() <= 0) break;
                    HashMap<String, ArrayList<Long>> materialMap = new HashMap<String, ArrayList<Long>>(1);
                    materialMap.put("in", this.getMultipleIds((DynamicObjectCollection)value));
                    filterMap.put("materialentry.material", materialMap);
                    break;
                }
                case "fsupplier": {
                    HashMap<String, ArrayList> supplierMap;
                    if (value instanceof DynamicObjectCollection && ((DynamicObjectCollection)value).size() > 0) {
                        supplierMap = new HashMap(1);
                        supplierMap.put("in", this.getMultipleIds((DynamicObjectCollection)value));
                        filterMap.put("supplier", supplierMap);
                        break;
                    }
                    if (!this.isFromSupplier()) break;
                    supplierMap = new HashMap<String, ArrayList>(1);
                    supplierMap.put("in", BizPartnerUtil.getSupplierByBizPartner());
                    filterMap.put("supplier", supplierMap);
                    break;
                }
                case "flogsupplier": {
                    if (!(value instanceof DynamicObjectCollection) || ((DynamicObjectCollection)value).size() <= 0) break;
                    HashMap<String, ArrayList<Long>> logSupplierMap = new HashMap<String, ArrayList<Long>>(1);
                    logSupplierMap.put("in", this.getMultipleIds((DynamicObjectCollection)value));
                    filterMap.put("logentryentity.logsupplier", logSupplierMap);
                    break;
                }
                case "fpobillno": {
                    if (value == null || value.toString().trim().isEmpty()) break;
                    HashMap<String, Object> poBillMap = new HashMap<String, Object>();
                    StringBuilder stringBufferBillNo = new StringBuilder();
                    poBillMap.put("match", stringBufferBillNo.append(value).toString());
                    Map<String, Map<String, Object>> map = BillAssistUtil.assembleBillNO(showKey, poBillMap);
                    if (map.size() <= 0) continue block30;
                    filterMap.putAll(map);
                    break;
                }
                case "finvoiceno": {
                    if (value == null || value.toString().trim().isEmpty()) break;
                    HashMap<String, Object> poBillMap = new HashMap();
                    StringBuilder stringBufferBillNo = new StringBuilder();
                    poBillMap.put("match", stringBufferBillNo.append(value).toString());
                    filterMap.put("invoiceno", poBillMap);
                    break;
                }
                case "fbillno": {
                    if (value == null || value.toString().trim().isEmpty()) break;
                    HashMap<String, Object> poBillMap = new HashMap();
                    poBillMap.put("match", value);
                    Map<String, Map<String, Object>> map = BillAssistUtil.assembleBillNO(showKey, poBillMap);
                    if (map.size() <= 0) continue block30;
                    filterMap.putAll(map);
                    break;
                }
                case "flogbillno": {
                    HashMap<String, String> logBillMap = new HashMap<String, String>();
                    if (value == null || value.toString().trim().isEmpty()) break;
                    StringBuilder stringBufferLogBillNo = new StringBuilder("%");
                    logBillMap.put("like", stringBufferLogBillNo.append(value).append('%').toString());
                    filterMap.put("logentryentity.logbillno", logBillMap);
                    break;
                }
                case "frcvorg": {
                    if (!(value instanceof DynamicObjectCollection) || ((DynamicObjectCollection)value).size() <= 0) break;
                    HashMap<String, Object> invOrgMap = new HashMap<String, Object>();
                    invOrgMap.put("in", this.getMultipleIds((DynamicObjectCollection)value));
                    if (BillAssistUtil.assembleRCVORGFitBill(showKey, invOrgMap).size() <= 0) continue block30;
                    filterMap.putAll(BillAssistUtil.assembleRCVORGFitBill(showKey, invOrgMap));
                    break;
                }
                case "forg": {
                    if (!(value instanceof DynamicObjectCollection) || ((DynamicObjectCollection)value).size() <= 0) break;
                    HashMap<String, ArrayList<Long>> OrgMap = new HashMap<String, ArrayList<Long>>();
                    OrgMap.put("in", this.getMultipleIds((DynamicObjectCollection)value));
                    filterMap.put("org", OrgMap);
                    break;
                }
                case "flog_enddate": {
                    if (value == null) break;
                    logDateMap.put("<=", DateUtil.formatEndDate((Date)((Date)value)));
                    if (logDateMap.size() <= 0) break;
                    filterMap.put("logentryentity.logdate", logDateMap);
                    break;
                }
                case "flog_startdate": {
                    if (value == null) break;
                    logDateMap.put(">=", DateUtil.formatStartDate((Date)((Date)value)));
                    if (logDateMap.size() <= 0) break;
                    filterMap.put("logentryentity.logdate", logDateMap);
                }
            }
        }
        return filterMap;
    }

    private ArrayList<Long> getMultipleIds(DynamicObjectCollection dynamicObjects) {
        ArrayList<Long> pks = new ArrayList<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            pks.add(dynamicObject.getLong("fbasedataid_id"));
        }
        return pks;
    }

    protected boolean isFromSupplier() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object isFromSupplier = param.get("isFromSupplier");
        return Boolean.TRUE.equals(isFromSupplier);
    }

    public void clearData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
    }
}

