/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.helper.scdatahandle.handleservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.EASParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.XkParamArgs;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractServiceDataHandlePlugin;
import kd.scm.common.util.OrderUtil;

public final class ScOrderLogisticsStatusService
extends AbstractServiceDataHandlePlugin {
    private String entityType = "scp_order";

    public DynamicObject[] assembleRefHandleArgs() {
        DynamicObject[] dynamicObjects = this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects();
        HashSet<String> linkProValues = new HashSet<String>(1024);
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entryRow : materialentry) {
                String poentryid = entryRow.getString("poentryid");
                if (poentryid == null || poentryid.isEmpty() || "0".equalsIgnoreCase(poentryid)) continue;
                linkProValues.add(poentryid);
            }
        }
        if (!linkProValues.isEmpty()) {
            return BusinessDataServiceHelper.load((String)this.getScDataServiceInfo().getEntityKey(), (String)this.getScDataServiceInfo().getValueProperty(), (QFilter[])new QFilter[]{new QFilter(this.getScDataServiceInfo().getLinkProperty(), "in", linkProValues)});
        }
        return new DynamicObject[0];
    }

    public void assembleXKHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        XkParamArgs scDataHandleArgs = (XkParamArgs)this.getScDataHandleArgs();
        DynamicObject[] orderBills = assembleHandleArgs.getDynamicObjects();
        HashMap<String, String> logStatusMap = new HashMap<String, String>(OrderUtil.getPKValueStr(orderBills));
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, HashMap<String, String>> dataMap = new HashMap<String, HashMap<String, String>>();
        dataMap.put("billid", logStatusMap);
        param.put("billtype", this.entityType);
        param.put("action", scDataHandleArgs.getAction());
        param.put("data", dataMap);
        XkParamArgs xkParamArgs = new XkParamArgs();
        xkParamArgs.setFacade(scDataHandleArgs.getFacade());
        xkParamArgs.setMethod(scDataHandleArgs.getMethod());
        xkParamArgs.setParamMap(param);
        xkParamArgs.setDataServiceId(this.getScDataServiceInfo().getServiceId());
        xkParamArgs.setDynamicObjects(orderBills);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)xkParamArgs);
    }

    public void assembleEASHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] orderBills = assembleHandleArgs.getDynamicObjects();
        EASParamArgs scDataHandleArgs = (EASParamArgs)this.getScDataHandleArgs();
        HashMap<String, String> logStatusMap = new HashMap<String, String>(OrderUtil.getPKValueStr(orderBills));
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, HashMap<String, String>> dataMap = new HashMap<String, HashMap<String, String>>();
        dataMap.put("billid", logStatusMap);
        param.put("billtype", this.entityType);
        param.put("action", scDataHandleArgs.getAction());
        param.put("data", dataMap);
        EASParamArgs easParamArgs = new EASParamArgs();
        easParamArgs.setFacade(scDataHandleArgs.getFacade());
        easParamArgs.setMethod(scDataHandleArgs.getMethod());
        easParamArgs.setApi("");
        easParamArgs.setParamMap(param);
        easParamArgs.setDataServiceId(this.getScDataServiceInfo().getServiceId());
        easParamArgs.setDynamicObjects(orderBills);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)easParamArgs);
    }

    public void assembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        Set handleValuesSet = this.getScDataServiceInfo().getHandleValuesSet();
        handleValuesSet.add("");
        DynamicObject[] orderBills = assembleHandleArgs.getDynamicObjects();
        HashMap<String, HashSet<Long>> statusMap = new HashMap<String, HashSet<Long>>(3);
        if (orderBills != null) {
            String handleProperty = this.getScDataServiceInfo().getHandleProperty();
            for (DynamicObject bill : orderBills) {
                String logStatus = bill.getString(handleProperty);
                if (!handleValuesSet.contains(logStatus)) continue;
                DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
                for (DynamicObject row : materialentry) {
                    String poId = row.getString("pobillid");
                    if (poId == null) continue;
                    HashSet<Long> logisticsIds = (HashSet<Long>)statusMap.get(logStatus);
                    if (logisticsIds == null) {
                        logisticsIds = new HashSet<Long>(16);
                    }
                    logisticsIds.add(Long.parseLong(poId));
                    statusMap.put(logStatus, logisticsIds);
                }
            }
        }
        CosmicParamArgs scDataHandleArgs = (CosmicParamArgs)this.getScDataHandleArgs();
        for (Map.Entry key : statusMap.entrySet()) {
            HashMap<String, Object> confirmMap = new HashMap<String, Object>(2);
            confirmMap.put("status", key.getKey());
            confirmMap.put("ids", new ArrayList((Collection)key.getValue()));
            CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
            cosmicParamArgs.setDataServiceId(this.getScDataServiceInfo().getServiceId());
            cosmicParamArgs.setCloudId(scDataHandleArgs.getCloudId());
            cosmicParamArgs.setAppId(scDataHandleArgs.getAppId());
            cosmicParamArgs.setServiceName(scDataHandleArgs.getServiceName());
            cosmicParamArgs.setMethodName(scDataHandleArgs.getMethodName());
            cosmicParamArgs.setParamMap(confirmMap);
            cosmicParamArgs.setDynamicObjects(orderBills);
            this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs, (String)key.getKey());
        }
    }

    private Map<String, String> getPKValueStr(DynamicObject[] objs) {
        HashMap<String, String> pobillidMap = new HashMap<String, String>();
        for (DynamicObject dynamicObject : objs) {
            DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("materialentry");
            if (dynamicObjects.size() <= 0) continue;
            pobillidMap.put(((DynamicObject)dynamicObjects.get(0)).get("pobillid").toString(), dynamicObject.get("logstatus").toString());
        }
        return pobillidMap;
    }
}

