/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.invcloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Html;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.invcloud.KingdeeInvoiceCloudConfig;
import kd.scm.common.invcloud.bean.aws.IframeParam;
import kd.scm.common.invcloud.bean.aws.ImportInvoiceIframeUrlReqParam;
import kd.scm.common.invcloud.bean.aws.InvoiceCloudCfg;
import kd.scm.common.invcloud.bean.aws.ShowInvoiceUrlReqParam;
import kd.scm.common.util.AwsMD5Util;

public class AwsInvoiceCloudPagePlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(AwsInvoiceCloudPagePlugin.class);
    private static final String IFRAME_WEB_SOCKET = "iframewebsocket";
    protected final String STATE = "state";

    public void beforeBindData(EventObject e) {
        try {
            String actionType = this.getParam("actionType");
            if ("selectInvoice".equals(actionType)) {
                this.selectInvoice();
            } else if ("viewInvoice".equals(actionType)) {
                this.viewInvoice();
            } else if ("viewInvoiceList".equals(actionType)) {
                this.viewInvoiceList();
            }
        }
        catch (Exception var4) {
            log.error("\u52a0\u8f7d\u53d1\u7968\u4e91\u9875\u9762\u4e4b\u524d\u51fa\u73b0\u5f02\u5e38", (Throwable)var4);
            HashMap<String, String> m = new HashMap<String, String>(8);
            m.put("state", "1");
            m.put("msg", ResManager.loadKDString((String)"\u52a0\u8f7d\u53d1\u7968\u4e91\u9875\u9762\u4e4b\u524d\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AwsInvoiceCloudPagePlugin_0", (String)"scm-sccore-common", (Object[])new Object[0]));
            this.getView().returnDataToParent(m);
            this.getPageCache().put("state", "1");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String state = this.getPageCache().get("state");
        String actionType = this.getParam("actionType");
        log.info("state: " + StringUtils.defaultString((String)state) + "; actionType: " + StringUtils.defaultString((String)actionType));
        if (StringUtils.equals((CharSequence)actionType, (CharSequence)"selectInvoice") && StringUtils.isBlank((CharSequence)state)) {
            boolean realyClose = Boolean.parseBoolean(StringUtils.defaultString((String)this.getPageCache().get("closeImportInvoiceCloudPage"), (String)"false"));
            if (!realyClose) {
                try {
                    String msg = this.getShowMessageBeforeCloseImportInvoicePage();
                    if (StringUtils.isNotBlank((CharSequence)msg)) {
                        this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("closeImportInvoiceCloudPage"));
                        e.setCancel(true);
                    }
                }
                catch (Exception e2) {
                    log.info(e2.getMessage());
                    this.getView().showErrorNotification(e2.getMessage());
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)state)) {
            this.getPageCache().remove(state);
        }
    }

    public String getShowMessageBeforeCloseImportInvoicePage() {
        return ResManager.loadKDString((String)"\u5173\u95ed\u7a97\u53e3\u540e\uff0c\u518d\u6253\u5f00\u9700\u91cd\u65b0\u626b\u63cf\uff0c\u662f\u5426\u5173\u95ed\uff1f", (String)"AwsInvoiceCloudPagePlugin_1", (String)"scm-sccore-common", (Object[])new Object[0]);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)"closeImportInvoiceCloudPage")) {
            String resultValue = messageBoxClosedEvent.getResultValue();
            if (StringUtils.equals((CharSequence)resultValue, (CharSequence)"Yes")) {
                this.getPageCache().put("closeImportInvoiceCloudPage", "true");
                this.getView().close();
            }
        } else {
            this.getPageCache().put("closeImportInvoiceCloudPage", "false");
        }
    }

    private void viewInvoice() {
        String showInvoiceParamStr = this.getParam("showInvoiceUrlReqParam");
        ShowInvoiceUrlReqParam request = new ShowInvoiceUrlReqParam();
        if (StringUtils.isNotBlank((CharSequence)showInvoiceParamStr)) {
            request = (ShowInvoiceUrlReqParam)JSON.parseObject((String)showInvoiceParamStr, ShowInvoiceUrlReqParam.class);
        }
        try {
            IframeParam iframeParam = this.getShowInvoiceIframeParam(request, this.getView());
            this.showURL(iframeParam.getUrl());
        }
        catch (Exception var5) {
            log.error((Throwable)var5);
            this.getView().showErrorNotification(var5.getMessage());
            return;
        }
    }

    private void viewInvoiceList() {
        String showInvoiceParamStr = this.getParam("showInvoiceUrlReqParam");
        ShowInvoiceUrlReqParam request = new ShowInvoiceUrlReqParam();
        if (StringUtils.isNotBlank((CharSequence)showInvoiceParamStr)) {
            request = (ShowInvoiceUrlReqParam)JSON.parseObject((String)showInvoiceParamStr, ShowInvoiceUrlReqParam.class);
        }
        try {
            IframeParam iframeParam = this.getShowInvoiceIframeListParam(request, this.getView());
            this.showURL(iframeParam.getUrl());
        }
        catch (Exception var5) {
            log.error((Throwable)var5);
            this.getView().showErrorNotification(var5.getMessage());
            return;
        }
    }

    public IframeParam getShowInvoiceIframeListParam(ShowInvoiceUrlReqParam request, IFormView formView) {
        String url = KingdeeInvoiceCloudConfig.getInvoiceListURL_PC();
        String userKey = request.getUserKey();
        log.info("\u67e5\u770b\u53d1\u7968\u5217\u8868url:" + url);
        IframeParam iframeParam = new IframeParam();
        HashMap<String, String> showInvoiceParam = new HashMap<String, String>(8);
        showInvoiceParam.put("userKey", userKey);
        String iframeUrl = url + "?" + this.transferMapToUrlParam(showInvoiceParam);
        iframeParam.setUrl(iframeUrl);
        Map<String, Object> temp = showInvoiceParam.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        iframeParam.setContent(temp);
        return iframeParam;
    }

    public IframeParam getShowInvoiceIframeParam(ShowInvoiceUrlReqParam request, IFormView formView) {
        String url = KingdeeInvoiceCloudConfig.getInvoiceViewURL_PC();
        String userKey = request.getUserKey();
        String serialNo = request.getSerialNo();
        log.info("\u67e5\u770b\u53d1\u7968\u5217\u8868url:" + url);
        IframeParam iframeParam = new IframeParam();
        HashMap<String, String> showInvoiceParam = new HashMap<String, String>(8);
        showInvoiceParam.put("serialNo", serialNo);
        showInvoiceParam.put("userKey", userKey);
        String iframeUrl = url + "?" + this.transferMapToUrlParam(showInvoiceParam);
        iframeParam.setUrl(iframeUrl);
        Map<String, Object> temp = showInvoiceParam.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
        iframeParam.setContent(temp);
        return iframeParam;
    }

    private void selectInvoice() {
        ImportInvoiceIframeUrlReqParam request = new ImportInvoiceIframeUrlReqParam();
        String requestJson = "";
        requestJson = this.getParam("importInvoiceIframeUrlReqParam");
        if (StringUtils.isNotBlank((CharSequence)requestJson)) {
            request = (ImportInvoiceIframeUrlReqParam)JSON.parseObject((String)requestJson, ImportInvoiceIframeUrlReqParam.class);
        }
        try {
            IframeParam iframeParam = this.getImportInvoiceIframeParam(request, this.getView());
            IFrame socketIFrame = (IFrame)this.getControl(IFRAME_WEB_SOCKET);
            socketIFrame.setSrc(iframeParam.getSocketUrl());
            this.showURL(iframeParam.getUrl());
        }
        catch (Exception var6) {
            log.error((Throwable)var6);
            this.getView().showErrorNotification(var6.getMessage());
            return;
        }
    }

    private void showURL(String url) {
        log.info("\u5c55\u793aURL: " + url);
        Html htmlap = (Html)this.getControl("htmlap");
        String htmlContent = "<iframe id='invoicepageframe' style='width:100%;border:0px;' src='" + url + "' ></iframe>";
        htmlap.setConent(htmlContent);
    }

    public IframeParam getImportInvoiceIframeParam(ImportInvoiceIframeUrlReqParam request, IFormView formView) {
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(request.getInvoiceCompanyId());
        String timestamp = request.getTimestamp();
        HashMap<String, String> showInvoiceParam = new HashMap<String, String>(8);
        showInvoiceParam.put("gridParam", request.getGridParam());
        showInvoiceParam.put("optMode", request.getOptMode());
        showInvoiceParam.put("userKey", request.getUserKey());
        showInvoiceParam.put("sourceType", request.getSourceType());
        showInvoiceParam.put("linkKey", request.getLinkKey());
        String url = KingdeeInvoiceCloudConfig.getInvoiceSelectURL_PC();
        String iframeUrl = url + "?" + this.transferMapToUrlParam(showInvoiceParam);
        log.info("\u9009\u62e9\u53d1\u7968\u7684url: " + url);
        Map<String, String> params = this.getInvoicePCPageSocketParams(config, timestamp, request.getLinkKey(), formView.getPageId());
        params.put("actionType", "selectInvoice");
        String socketUrl = this.getCtxPath() + "/ws.html?" + this.transferMapToUrlParam(params);
        log.info("\u9009\u62e9\u53d1\u7968\u7684socketurl: " + socketUrl);
        IframeParam iframeParam = new IframeParam();
        iframeParam.setUrl(iframeUrl);
        iframeParam.setSocketUrl(socketUrl);
        Map<String, Object> temp = showInvoiceParam.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue()));
        iframeParam.setContent(temp);
        return iframeParam;
    }

    private Map<String, String> getInvoicePCPageSocketParams(InvoiceCloudCfg config, String timestamp, String linkKey, String pageId) {
        RequestContext requestContext = RequestContext.get();
        String userId = requestContext.getUserId();
        String taxRegNum = config.getTaxRegnum();
        String client_id = config.getClientId();
        String client_secret = config.getClientSecret();
        HashMap<String, String> urlParams = new HashMap<String, String>(8);
        urlParams.put("timestamp", String.valueOf(timestamp));
        urlParams.put("client_id", client_id);
        urlParams.put("tin", taxRegNum);
        String rawSign = client_id + client_secret + timestamp;
        urlParams.put("sign", AwsMD5Util.md5crypt(rawSign));
        urlParams.put("eid", userId);
        urlParams.put("pageid", pageId);
        urlParams.put("clientType", "pc");
        urlParams.put("linkKey", linkKey);
        urlParams.put("env", KingdeeInvoiceCloudConfig.isProduct() ? "prod" : "test");
        return urlParams;
    }

    private String getCtxPath() {
        return RequestContext.get().getClientFullContextPath() + "invoicecloud";
    }

    private String transferMapToUrlParam(Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            String urlParam = map.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
            return urlParam;
        }
        return "";
    }

    public void customEvent(CustomEventArgs e) {
        String msg = e.getEventArgs();
        log.info("\u3010\u53d1\u7968\u4e91\u3011aws\u63a5\u6536\u524d\u7aef\u7684\u8c03\u7528" + msg);
        this.handleInvoiceData(msg);
    }

    protected void handleInvoiceData(String msg) {
        EditInvoiceReturnDataVO returnDataVO = (EditInvoiceReturnDataVO)JSON.parseObject((String)msg, EditInvoiceReturnDataVO.class);
        if (!returnDataVO.getSuccess().booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AwsInvoiceCloudPagePlugin_0", (String)"scm-sccore-common", (Object[])new Object[0]));
        } else {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("state", "0");
            String serialNo = returnDataVO.getSerialNo();
            log.info("\u53d1\u7968\u4e91\u8fd4\u56de\u53d1\u7968\u5e8f\u5217\u53f7: " + serialNo);
            if (StringUtils.isEmpty((CharSequence)serialNo) && returnDataVO.getOption() != null) {
                serialNo = returnDataVO.getOption().getJSONObject("data").getString("invoiceSerialNos");
                log.info("\u53d1\u7968\u4e91\u8fd4\u56de\u53d1\u7968\u5e8f\u5217\u53f7 option :" + serialNo);
            }
            returnMap.put("serialNos", serialNo);
            this.getView().returnDataToParent(returnMap);
            this.getPageCache().put("state", "0");
            this.getView().close();
        }
    }

    protected String getParam(String key) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object object = customParams.get(key);
        return object != null ? object.toString() : "";
    }

    protected static class EditInvoiceReturnDataVO {
        private Boolean success;
        private JSONObject option;
        private String serialNo;

        protected EditInvoiceReturnDataVO() {
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public String getSerialNo() {
            return this.serialNo;
        }

        public void setSerialNo(String serialNo) {
            this.serialNo = serialNo;
        }

        public void setOption(JSONObject option) {
            this.option = option;
        }

        public JSONObject getOption() {
            return this.option;
        }
    }
}

