/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.isc.util.ISCUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.caldynamic.CalDynamicFactory;
import kd.scm.common.util.caldynamic.ICalDynamic;

public class AutoPushSalOutUtil {
    private static Log log = LogFactory.getLog(AutoPushSalOutUtil.class);
    private static String[] BASEDATA_PROS = new String[]{"entrysettleorg", "warehouse", "entryrcvorg", "entrypurorg", "entryreqorg"};

    public static void autoPushToSalOut(Object[] orderPks) {
        DynamicObject[] orderObjs = AutoPushSalOutUtil.getOrderObjs(orderPks);
        AutoPushSalOutUtil.autoPushToSalOut(orderObjs);
    }

    public static void autoPushToSalOut(DynamicObject[] orderObjs) {
        if (orderObjs != null && orderObjs.length > 0) {
            AutoPushSalOutUtil.updateOrdersConfirmed(orderObjs);
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber("scp_order");
            pushArgs.setTargetEntityNumber("scp_saloutstock");
            pushArgs.setBuildConvReport(true);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"scp_saloutstock");
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                }
            };
            ArrayList<DynamicObject> pushedDataList = new ArrayList<DynamicObject>();
            for (int i = 0; i < orderObjs.length; ++i) {
                String srcType;
                if (null == orderObjs[i] || !StringUtil.isEmpty((CharSequence)(srcType = orderObjs[i].getString("srctype"))) && srcType.equals("2")) continue;
                ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
                DynamicObjectCollection cols = orderObjs[i].getDynamicObjectCollection("materialentry");
                for (DynamicObject col : cols) {
                    if (col.getBigDecimal("suminstockqty").compareTo(BigDecimal.ZERO) <= 0 && col.getBigDecimal("sumreceiptqty").compareTo(BigDecimal.ZERO) <= 0 || col.getBigDecimal("sumoutstockqty").compareTo(BigDecimal.ZERO) != 0) continue;
                    ListSelectedRow row = new ListSelectedRow();
                    row.setPrimaryKeyValue(orderObjs[i].getPkValue());
                    row.setEntryEntityKey("materialentry");
                    row.setEntryPrimaryKeyValue(col.getPkValue());
                    selectedRowList.add(row);
                }
                pushArgs.setSelectedRows(selectedRowList);
                ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
                if (result.isSuccess()) {
                    List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                    pushedDataList.addAll(targetData);
                    result.release(refDataProvider, mainType);
                    continue;
                }
                log.info("@@@\u534f\u540c\u8ba2\u5355\u4e0b\u63a8\u9500\u552e\u53d1\u8d27\u5355\u5f02\u5e38\uff1a" + result.getMessage());
            }
            log.info("@@@\u4e0b\u63a8\u7684\u9500\u552e\u53d1\u8d27\u5355\u6570\u636e\u5305\u5927\u5c0fpushedDataList\uff1a" + pushedDataList.size());
            AutoPushSalOutUtil.updateDeliDate(pushedDataList);
            AutoPushSalOutUtil.updateSaloutQtyOrBdPro(orderObjs, pushedDataList);
            OperationResult opResult = SaveServiceHelper.saveOperate((String)"scp_saloutstock", (DynamicObject[])pushedDataList.toArray(new DynamicObject[0]), null);
            HashSet errorPkIds = new HashSet();
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            option.setVariableValue("ishasright", String.valueOf(true));
            if (opResult.getSuccessPkIds().size() > 0) {
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"scp_saloutstock", (Object[])opResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
                if (submitResult.getSuccessPkIds().size() > 0) {
                    log.info("@@@@\u9500\u552e\u53d1\u8d27\u5355\u5ba1\u6838\u6210\u529f!");
                } else {
                    log.info("@@@\u9500\u552e\u53d1\u8d27\u5355\u63d0\u4ea4\u5f02\u5e38\uff1a" + ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
                }
                List errorInfoList = submitResult.getAllErrorInfo();
                StringBuilder errorMsg = new StringBuilder(ResManager.loadKDString((String)"@@@\u63d0\u4ea4\u5f02\u5e38\u4fe1\u606f\uff1a", (String)"AutoPushSalOutUtil_0", (String)"scm-common", (Object[])new Object[0]));
                for (OperateErrorInfo operateErrorInfo : errorInfoList) {
                    errorMsg.append(operateErrorInfo.getMessage()).append(';');
                }
                errorPkIds.addAll(submitResult.getValidateResult().getErrorPkIds());
                log.info("@@@\u5220\u9664\u63d0\u4ea4\u4e2d\u65ad\u7684\u6570\u636e\uff1a" + errorPkIds.size());
                log.info(errorMsg.toString());
                if (errorPkIds.size() > 0) {
                    DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)pushedDataList.get(0)).getDataEntityType(), (Object[])errorPkIds.toArray(new Object[0]));
                }
            } else {
                log.info("@@@\u9500\u552e\u53d1\u8d27\u5355\u4fdd\u5b58\u5f02\u5e38\uff1a" + opResult.getMessage());
            }
        }
    }

    public static void autoPushToSalOut() {
        DynamicObject[] orderObjs = AutoPushSalOutUtil.getOrderObjs(null);
        AutoPushSalOutUtil.autoPushToSalOut(orderObjs);
    }

    public static DynamicObject[] getOrderObjs(Object[] orderPks) {
        log.info("@@@getOrderObjs \u83b7\u53d6\u7b26\u5408\u6761\u4ef6\u7684\u534f\u540c\u8ba2\u5355\u3002\u3002\u3002\u3002");
        String selectFields = "id,billno,cfmstatus,logstatus,materialentry.id,materialentry.pobillid,materialentry.poentryid,materialentry.qty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.sumoutstockqty";
        QFilter filter = new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.UNCONFIRM.getVal()).and(new QFilter("materialentry.sumreceiptqty", ">", (Object)0).or(new QFilter("materialentry.suminstockqty", ">", (Object)0))).or(new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.CONFIRM.getVal()).and(new QFilter("materialentry.sumreceiptqty", ">", (Object)0).or(new QFilter("materialentry.suminstockqty", ">", (Object)0))).and(new QFilter("materialentry.sumoutstockqty", "<=", (Object)0)));
        if (null != orderPks) {
            filter.and("id", "in", (Object)orderPks);
        }
        DynamicObject[] orderObjs = BusinessDataServiceHelper.load((String)"scp_order", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return orderObjs;
    }

    public static DynamicObject[] getOrderObjs() {
        return AutoPushSalOutUtil.getOrderObjs(null);
    }

    public static void updateOrdersConfirmed(DynamicObject[] orderObjs) {
        log.info("@@@updateOrdersConfirmed \u66f4\u65b0\u534f\u540c\u8ba2\u5355\u786e\u8ba4\u72b6\u6001\u3002\u3002\u3002\u3002");
        if (null == orderObjs) {
            return;
        }
        String cfmstatus = ConfirmStatusEnum.CONFIRM.getVal();
        if (ApiConfigUtil.hasEASConfig() && ISCUtil.isISC()) {
            cfmstatus = ConfirmStatusEnum.AUTOCONFIRM.getVal();
        }
        ArrayList<DynamicObject> needUpdateOrders = new ArrayList<DynamicObject>();
        for (DynamicObject order : orderObjs) {
            if (!ConfirmStatusEnum.UNCONFIRM.getVal().equals(order.getString("cfmstatus"))) continue;
            order.set("cfmstatus", (Object)cfmstatus);
            needUpdateOrders.add(order);
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])needUpdateOrders.toArray(new DynamicObject[0]));
    }

    public static void updateDeliDate(List<DynamicObject> salOutstockObjs) {
        log.info("@@@updateDeliDate \u66f4\u65b0\u9500\u552e\u53d1\u8d27\u5355\u53d1\u8d27\u65e5\u671f\u3002\u3002\u3002\u3002");
        for (DynamicObject salOutstockObj : salOutstockObjs) {
            Date curDate;
            Calendar calendar = Calendar.getInstance();
            Date deliDate = salOutstockObj.getDate("delidate");
            if (deliDate.compareTo(curDate = new Date()) > 0) continue;
            calendar.setTime(curDate);
            calendar.add(11, 1);
            salOutstockObj.set("delidate", (Object)calendar.getTime());
        }
    }

    public static void updateSaloutQtyOrBdPro(DynamicObject[] orderObjs, List<DynamicObject> saloutObjList) {
        HashMap<String, Object> entryMap = new HashMap<String, Object>();
        log.info("@@@updateSaloutQty \u66f4\u65b0\u53d1\u8d27\u6570\u91cf\u3002\u3002\u3002\u3002");
        for (DynamicObject orderObj : orderObjs) {
            DynamicObjectCollection cols = orderObj.getDynamicObjectCollection("materialentry");
            for (Object col : cols) {
                String srcPoEntryId = col.getString("poentryid");
                if (null == srcPoEntryId) continue;
                entryMap.put(srcPoEntryId, col);
            }
        }
        ICalDynamic iCalDynamic = new CalDynamicFactory().createCal();
        for (DynamicObject salOutObj : saloutObjList) {
            DynamicObjectCollection cols = salOutObj.getDynamicObjectCollection("materialentry");
            for (DynamicObject col : cols) {
                String srcPoEntryId = col.getString("poentryid");
                DynamicObject orderEntry = (DynamicObject)entryMap.get(srcPoEntryId);
                if (null != orderEntry) {
                    BigDecimal sumReceiptQty = orderEntry.getBigDecimal("sumreceiptqty");
                    BigDecimal sumInstockQty = orderEntry.getBigDecimal("suminstockqty");
                    if (sumInstockQty.compareTo(BigDecimal.ZERO) > 0) {
                        col.set("qty", (Object)sumInstockQty);
                    } else if (sumReceiptQty.compareTo(BigDecimal.ZERO) > 0) {
                        col.set("qty", (Object)sumReceiptQty);
                    }
                }
                for (int i = 0; i < BASEDATA_PROS.length; ++i) {
                    Object bdObj = col.get(BASEDATA_PROS[i]);
                    if (null == bdObj || !(bdObj instanceof DynamicObject)) continue;
                    col.set(BASEDATA_PROS[i], col.getDynamicObject(BASEDATA_PROS[i]).getPkValue());
                }
            }
            DynamicObjectCollection dynentrys = salOutObj.getDynamicObjectCollection("materialentry");
            if (dynentrys == null || dynentrys.isEmpty()) continue;
            for (int i = 0; i < dynentrys.size(); ++i) {
                iCalDynamic.proChanged(salOutObj, "materialentry", "qty", i);
            }
        }
        entryMap.clear();
    }
}

