/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.CheckStatusEnum;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CheckUtils;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.check.PurCheckWriteBackDto;

public final class BatchCheckUtil {
    private static final String QTY = "qty";
    private static final String TAXAMOUNT = "taxamount";
    private static final String SRCBILLTYPE = "srcbilltype";
    private static final String SRCBILLID = "srcbillid";
    private static final String SRCENTRYID = "srcentryid";
    private static Log log = LogFactory.getLog(BatchCheckUtil.class);
    private static DynamicObject entry;
    private static final String CHECKSUM_ENTRY_KEY = "sumentryentity";
    private static boolean isPur;

    public static void writeBackSrcBill(String entityKey, List<Long> billIdList, List<Long> entryIdList, Map<Long, BigDecimal> confirmQtyMap, Map<Long, BigDecimal> confirmAmtMap, String operation, List<Long> negativeList) {
        BatchCheckUtil.writeBackSrcBill(entityKey, billIdList, entryIdList, confirmQtyMap, confirmAmtMap, operation, false, negativeList);
    }

    public static void writeBackSrcBill(String entityKey, List<Long> billIdList, List<Long> entryIdList, Map<Long, BigDecimal> confirmQtyMap, Map<Long, BigDecimal> confirmAmtMap, String operation) {
        BatchCheckUtil.writeBackSrcBill(entityKey, billIdList, entryIdList, confirmQtyMap, confirmAmtMap, operation, false, null);
    }

    public static void writeBackSrcBill(String entityKey, List<Long> billIdList, List<Long> entryIdList, Map<Long, BigDecimal> confirmQtyMap, Map<Long, BigDecimal> confirmAmtMap, String operation, boolean isConvert) {
        BatchCheckUtil.writeBackSrcBill(entityKey, billIdList, entryIdList, confirmQtyMap, confirmAmtMap, operation, isConvert, null);
    }

    public static void writeBackSrcBill(Map<String, BigDecimal> param, String entryType, String operate) {
        HashSet<Long> newEntrySetID = new HashSet<Long>(param.size());
        for (String entryID : param.keySet()) {
            newEntrySetID.add(Long.valueOf(entryID));
        }
        QFilter prodfilter = new QFilter("materialentry.id", "in", newEntrySetID);
        DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)entryType, (String)"id,billno,materialentry.id,materialentry.sumcheckamt", (QFilter[])new QFilter[]{prodfilter});
        DynamicObjectCollection entryCol = null;
        for (DynamicObject dyn : prodArray) {
            entryCol = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                BigDecimal diffAmt = param.get(entry.getString("id"));
                if (null == diffAmt || diffAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal sumcheckamt = entry.getBigDecimal("sumcheckamt");
                if ("audit".equals(operate)) {
                    entry.set("sumcheckamt", (Object)sumcheckamt.add(diffAmt).abs());
                    continue;
                }
                entry.set("sumcheckamt", (Object)sumcheckamt.subtract(diffAmt).abs());
            }
        }
        if (prodArray.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodArray);
        }
    }

    public static void writeBackSrcOrderBill(Map<String, BigDecimal> param, String operate) {
        QFilter prodfilter = new QFilter("materialentry.poentryid", "in", param.keySet());
        DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,billno,materialentry.id,materialentry.payableamt,materialentry.poentryid", (QFilter[])new QFilter[]{prodfilter});
        DynamicObjectCollection entryCol = null;
        for (DynamicObject dyn : prodArray) {
            entryCol = dyn.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entryCol) {
                BigDecimal diffAmt = param.get(entry.getString("poentryid"));
                if (null == diffAmt || diffAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal sumcheckamt = entry.getBigDecimal("payableamt");
                if ("audit".equals(operate)) {
                    entry.set("payableamt", (Object)sumcheckamt.add(diffAmt).abs());
                    continue;
                }
                entry.set("payableamt", (Object)sumcheckamt.subtract(diffAmt).abs());
            }
        }
        if (prodArray.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodArray);
        }
    }

    public static void writeBackPurOrder(DynamicObject[] checkObjs, String entryKey, String suffix, String operator) {
        HashMap<String, PurCheckWriteBackDto> map = new HashMap<String, PurCheckWriteBackDto>(8);
        for (DynamicObject checkObj : checkObjs) {
            DynamicObjectCollection entrys = checkObj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entrys) {
                String srcBillType = entry.getString(SRCBILLTYPE + suffix);
                if (!CheckUtils.isPurInstock((String)srcBillType) && !CheckUtils.isPurReciept((String)srcBillType)) continue;
                String poEntryId = entry.getString("poentryid" + suffix);
                PurCheckWriteBackDto dto = (PurCheckWriteBackDto)map.get(poEntryId);
                if (dto == null) {
                    dto = new PurCheckWriteBackDto();
                }
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get(QTY + suffix));
                BigDecimal confirmQty = dto.getConfirmQty();
                if (confirmQty == null) {
                    dto.setConfirmQty(qty);
                } else {
                    BigDecimal add = qty.add(confirmQty);
                    dto.setConfirmQty(add);
                }
                BigDecimal taxAmount = CommonUtil.getBigDecimalPro((Object)entry.get(TAXAMOUNT + suffix));
                BigDecimal confirmAmt = dto.getConfirmAmt();
                if (confirmAmt == null) {
                    dto.setConfirmAmt(taxAmount);
                } else {
                    BigDecimal add = confirmAmt.add(taxAmount);
                    dto.setConfirmAmt(add);
                }
                map.put(poEntryId, dto);
            }
        }
        BatchCheckUtil.writeBackPurOrder(map, operator);
    }

    private static void writeBackPurOrder(Map<String, PurCheckWriteBackDto> map, String operator) {
        DynamicObject[] orderList;
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        QFilter prodfilter = new QFilter("materialentry.poentryid", "in", map.keySet());
        for (DynamicObject poBill : orderList = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,billno,materialentry.id,materialentry.poentryid,materialentry.qty,materialentry.taxamount,materialentry.payableqty,materialentry.payableamt", (QFilter[])new QFilter[]{prodfilter})) {
            DynamicObjectCollection entrys = poBill.getDynamicObjectCollection("materialentry");
            for (DynamicObject poBillEntry : entrys) {
                PurCheckWriteBackDto purCheckWriteBackDto = map.get(poBillEntry.getString("poentryid"));
                if (purCheckWriteBackDto == null) continue;
                BigDecimal checkQty = CommonUtil.getBigDecimalPro((Object)purCheckWriteBackDto.getConfirmQty());
                BigDecimal checkTaxAmt = CommonUtil.getBigDecimalPro((Object)purCheckWriteBackDto.getConfirmAmt());
                BigDecimal sumPayableQty = CommonUtil.getBigDecimalPro((Object)poBillEntry.get("payableqty"));
                BigDecimal sumPayableAmt = CommonUtil.getBigDecimalPro((Object)poBillEntry.get("payableamt"));
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)poBillEntry.get(QTY));
                BigDecimal taxamount = CommonUtil.getBigDecimalPro((Object)poBillEntry.get(TAXAMOUNT));
                if ("audit".equals(operator)) {
                    sumPayableQty = sumPayableQty.add(checkQty);
                    sumPayableAmt = sumPayableAmt.add(checkTaxAmt);
                    if (sumPayableQty.abs().compareTo(qty.abs()) > 0) {
                        sumPayableQty = qty;
                    }
                    if (sumPayableAmt.abs().compareTo(taxamount.abs()) > 0) {
                        sumPayableAmt = taxamount;
                    }
                } else if ("delete".equals(operator)) {
                    sumPayableQty = sumPayableQty.subtract(checkQty);
                    sumPayableAmt = sumPayableAmt.subtract(checkTaxAmt);
                }
                poBillEntry.set("payableqty", (Object)sumPayableQty);
                poBillEntry.set("payableamt", (Object)sumPayableAmt);
            }
        }
        if (orderList.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orderList);
        }
    }

    public static void writeBackSrcBill(DynamicObject[] checkObjs, String entryKey, String suffix, String operator, boolean isConvert) {
        HashMap map = new HashMap(8);
        for (DynamicObject checkObj : checkObjs) {
            DynamicObjectCollection entrys = checkObj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entrys) {
                String srcBillIdStr = entry.getString(SRCBILLID + suffix);
                String srcEntryIdStr = entry.getString(SRCENTRYID + suffix);
                String srcBillType = entry.getString(SRCBILLTYPE + suffix);
                HashMap billIdMap = (HashMap)map.get(srcBillType);
                if (billIdMap == null) {
                    billIdMap = new HashMap(8);
                }
                if (srcBillIdStr == null || srcBillIdStr.trim().isEmpty()) continue;
                Long srcBillId = Long.valueOf(srcBillIdStr);
                HashMap<Long, PurCheckWriteBackDto> confirmQtyMap = (HashMap<Long, PurCheckWriteBackDto>)billIdMap.get(srcBillId);
                if (confirmQtyMap == null) {
                    confirmQtyMap = new HashMap<Long, PurCheckWriteBackDto>(8);
                }
                if (srcEntryIdStr == null || srcEntryIdStr.trim().isEmpty()) continue;
                Long srcEntryId = Long.valueOf(srcEntryIdStr);
                PurCheckWriteBackDto dto = (PurCheckWriteBackDto)confirmQtyMap.get(srcEntryId);
                if (dto == null) {
                    dto = new PurCheckWriteBackDto();
                }
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get(QTY + suffix)).abs();
                if (CommonUtil.getBigDecimalPro((Object)entry.get(QTY + suffix)).compareTo(BigDecimal.ZERO) < 0) {
                    dto.setIsNegative(true);
                } else {
                    dto.setIsNegative(false);
                }
                BigDecimal confirmQty = dto.getConfirmQty();
                if (confirmQty == null) {
                    dto.setConfirmQty(qty);
                } else {
                    BigDecimal add = qty.add(confirmQty);
                    dto.setConfirmQty(add);
                }
                BigDecimal taxAmount = CommonUtil.getBigDecimalPro((Object)entry.get(TAXAMOUNT + suffix)).abs();
                BigDecimal confirmAmt = dto.getConfirmAmt();
                if (confirmAmt == null) {
                    dto.setConfirmAmt(taxAmount);
                } else {
                    BigDecimal add = confirmAmt.add(taxAmount);
                    dto.setConfirmAmt(add);
                }
                confirmQtyMap.put(srcEntryId, dto);
                billIdMap.put(srcBillId, confirmQtyMap);
                map.put(srcBillType, billIdMap);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            String srcBillType = (String)entry.getKey();
            Map billIdMaps = (Map)entry.getValue();
            BatchCheckUtil.writeBackSrcBill(srcBillType, billIdMaps, operator, isConvert);
        }
    }

    public static void writeBackSrcBill(String entityKey, Map<Long, Map<Long, PurCheckWriteBackDto>> billIdMaps, String operation, boolean isConvert) {
        DynamicObject[] col;
        ArrayList<String> noSrcCheckKeyList = new ArrayList<String>(4);
        noSrcCheckKeyList.add("pur_instock");
        noSrcCheckKeyList.add("pur_return");
        noSrcCheckKeyList.add("pur_receipt");
        noSrcCheckKeyList.add("pur_receipt_return");
        noSrcCheckKeyList.add("scp_instock");
        noSrcCheckKeyList.add("scp_return");
        noSrcCheckKeyList.add("scp_receipt");
        noSrcCheckKeyList.add("scp_receipt_return");
        if (!noSrcCheckKeyList.contains(entityKey)) {
            return;
        }
        String selectFields = "id,billno,billstatus,materialentry.id, materialentry.pobillno,materialentry.poentryid,materialentry.sumcheckqty,materialentry.qty,materialentry.sumcheckamt,materialentry.taxamount,materialentry.entrystatus,materialentry.ischeckorinvoice";
        HashMap params = new HashMap();
        if (!billIdMaps.isEmpty()) {
            HashMap<String, Set<Long>> billIdParam = new HashMap<String, Set<Long>>(1);
            billIdParam.put("in", billIdMaps.keySet());
            params.put("id", billIdParam);
        }
        for (DynamicObject bill : col = ORMUtil.load((String)entityKey, (String)selectFields, params)) {
            Long billId = (Long)bill.getPkValue();
            Map<Long, PurCheckWriteBackDto> entryIdMap = billIdMaps.get(billId);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                Long entryId = (Long)entry.getPkValue();
                PurCheckWriteBackDto purCheckWriteBackDto = entryIdMap.get(entryId);
                if (purCheckWriteBackDto == null) continue;
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get(QTY));
                BigDecimal taxamount = CommonUtil.getBigDecimalPro((Object)entry.get(TAXAMOUNT));
                BigDecimal checkQty = CommonUtil.getBigDecimalPro((Object)purCheckWriteBackDto.getConfirmQty());
                BigDecimal checkTaxAmt = CommonUtil.getBigDecimalPro((Object)purCheckWriteBackDto.getConfirmAmt());
                BigDecimal sumCheckQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumcheckqty"));
                BigDecimal sumCheckTaxAmt = CommonUtil.getBigDecimalPro((Object)entry.get("sumcheckamt"));
                if ("audit".equals(operation)) {
                    sumCheckQty = sumCheckQty.add(checkQty);
                    sumCheckTaxAmt = sumCheckTaxAmt.add(checkTaxAmt);
                    if (sumCheckQty.abs().compareTo(qty.abs()) > 0) {
                        sumCheckQty = qty;
                    }
                    if (sumCheckTaxAmt.abs().compareTo(taxamount.abs()) > 0) {
                        sumCheckTaxAmt = taxamount;
                    }
                } else if ("delete".equals(operation)) {
                    sumCheckQty = sumCheckQty.subtract(checkQty);
                    sumCheckTaxAmt = sumCheckTaxAmt.subtract(checkTaxAmt);
                }
                if (isConvert) {
                    sumCheckQty = checkQty;
                    sumCheckTaxAmt = checkTaxAmt;
                }
                if (checkQty.compareTo(BigDecimal.ZERO) > 0) {
                    entry.set("sumcheckqty", (Object)sumCheckQty);
                    if (null == sumCheckQty || BigDecimal.ZERO.compareTo(sumCheckQty) == 0) {
                        entry.set("ischeckorinvoice", (Object)Boolean.FALSE);
                    } else {
                        entry.set("ischeckorinvoice", (Object)Boolean.TRUE);
                    }
                }
                if (checkTaxAmt.compareTo(BigDecimal.ZERO) > 0) {
                    entry.set("sumcheckamt", (Object)sumCheckTaxAmt);
                    continue;
                }
                if (!noSrcCheckKeyList.contains(entityKey)) continue;
                if ("audit".equals(operation)) {
                    if (checkQty.abs().compareTo(qty.abs()) > 0) {
                        checkQty = qty;
                    }
                    if (checkTaxAmt.abs().compareTo(taxamount.abs()) > 0) {
                        checkTaxAmt = taxamount;
                    }
                    entry.set("sumcheckamt", (Object)checkTaxAmt);
                    entry.set("sumcheckqty", (Object)checkQty);
                    entry.set("ischeckorinvoice", (Object)Boolean.TRUE);
                    continue;
                }
                if (!"delete".equals(operation)) continue;
                entry.set("sumcheckamt", (Object)BigDecimal.ZERO);
                entry.set("sumcheckqty", (Object)BigDecimal.ZERO);
                entry.set("ischeckorinvoice", (Object)Boolean.FALSE);
            }
        }
        if (col.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])col);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBackSrcBill(String entityKey, List<Long> billIdList, List<Long> entryIdList, Map<Long, BigDecimal> confirmQtyMap, Map<Long, BigDecimal> confirmAmtMap, String operation, boolean isConvert, List<Long> negativeList) {
        String selectFields = "id,billno,billstatus,materialentry.id, materialentry.pobillno,materialentry.poentryid,materialentry.sumcheckqty,materialentry.qty,materialentry.sumcheckamt,materialentry.taxamount,materialentry.entrystatus,materialentry.ischeckorinvoice";
        HashMap params = new HashMap();
        ArrayList<String> noSrcCheckKeyList = new ArrayList<String>(4);
        noSrcCheckKeyList.add("pur_instock");
        noSrcCheckKeyList.add("pur_return");
        noSrcCheckKeyList.add("pur_receipt");
        noSrcCheckKeyList.add("pur_receipt_return");
        noSrcCheckKeyList.add("scp_instock");
        noSrcCheckKeyList.add("scp_return");
        noSrcCheckKeyList.add("scp_receipt");
        noSrcCheckKeyList.add("scp_receipt_return");
        if (!noSrcCheckKeyList.contains(entityKey)) {
            return;
        }
        if (!billIdList.isEmpty()) {
            HashMap<String, List<Long>> billIdParam = new HashMap<String, List<Long>>(1);
            billIdParam.put("in", billIdList);
            params.put("id", billIdParam);
        }
        DynamicObject[] col = ORMUtil.load((String)entityKey, (String)selectFields, params);
        ArrayList<String> poBillIdList = new ArrayList<String>(1024);
        for (DynamicObject dynamicObject : col) {
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                if (!StringUtil.isNotEmpty((CharSequence)entry.getString("pobillno")) || poBillIdList.contains(entry.getString("pobillno"))) continue;
                poBillIdList.add(entry.getString("pobillno"));
            }
        }
        QFilter prodfilter = new QFilter("billno", "in", poBillIdList);
        DynamicObject[] orderList = BusinessDataServiceHelper.load((String)"pur_order", (String)"id,billno,materialentry.id,materialentry.poentryid,materialentry.payableqty,materialentry.payableamt", (QFilter[])new QFilter[]{prodfilter});
        HashMap<String, DynamicObject> poBillMap = new HashMap<String, DynamicObject>(1024);
        for (DynamicObject poBill : orderList) {
            DynamicObjectCollection entrys = poBill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                poBillMap.put(entry.getString("poentryid"), entry);
            }
        }
        for (DynamicObject bill : col) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                Long entryId = (Long)entry.getPkValue();
                if (!entryIdList.contains(entryId)) continue;
                BigDecimal qty = CommonUtil.getBigDecimalPro((Object)entry.get(QTY));
                BigDecimal taxamount = CommonUtil.getBigDecimalPro((Object)entry.get(TAXAMOUNT));
                BigDecimal bigDecimal = CommonUtil.getBigDecimalPro((Object)confirmQtyMap.get(entryId));
                BigDecimal checkTaxAmt = CommonUtil.getBigDecimalPro((Object)confirmAmtMap.get(entryId));
                BigDecimal sumCheckQty = CommonUtil.getBigDecimalPro((Object)entry.get("sumcheckqty"));
                BigDecimal sumCheckTaxAmt = CommonUtil.getBigDecimalPro((Object)entry.get("sumcheckamt"));
                DynamicObject poBillEntry = (DynamicObject)poBillMap.get(entry.getString("poentryid"));
                if (poBillEntry != null) {
                    BigDecimal sumPayableQty = CommonUtil.getBigDecimalPro((Object)poBillEntry.get("payableqty"));
                    BigDecimal sumPayableAmt = CommonUtil.getBigDecimalPro((Object)poBillEntry.get("payableamt"));
                    if ("audit".equals(operation)) {
                        sumCheckQty = sumCheckQty.add(bigDecimal);
                        sumCheckTaxAmt = sumCheckTaxAmt.add(checkTaxAmt);
                        if (null != negativeList && negativeList.contains(bill.getLong("id"))) {
                            sumPayableQty = sumPayableQty.subtract(bigDecimal);
                            sumPayableAmt = sumPayableAmt.subtract(checkTaxAmt);
                        } else {
                            sumPayableQty = sumPayableQty.add(bigDecimal);
                            sumPayableAmt = sumPayableAmt.add(checkTaxAmt);
                        }
                        if (sumCheckQty.abs().compareTo(qty.abs()) > 0) {
                            sumCheckQty = qty;
                        }
                        if (sumCheckTaxAmt.abs().compareTo(taxamount.abs()) > 0) {
                            sumCheckTaxAmt = taxamount;
                        }
                        if (sumPayableQty.abs().compareTo(qty.abs()) > 0) {
                            sumPayableQty = qty;
                        }
                        if (sumPayableAmt.abs().compareTo(taxamount.abs()) > 0) {
                            sumPayableAmt = taxamount;
                        }
                    } else if ("delete".equals(operation)) {
                        sumCheckQty = sumCheckQty.subtract(bigDecimal);
                        sumCheckTaxAmt = sumCheckTaxAmt.subtract(checkTaxAmt);
                        if (null != negativeList && negativeList.contains(bill.getLong("id"))) {
                            sumPayableQty = sumPayableQty.add(bigDecimal);
                            sumPayableAmt = sumPayableAmt.add(checkTaxAmt);
                        } else {
                            sumPayableQty = sumPayableQty.subtract(bigDecimal);
                            sumPayableAmt = sumPayableAmt.subtract(checkTaxAmt);
                        }
                    }
                    if (isConvert) {
                        sumCheckQty = bigDecimal;
                        sumCheckTaxAmt = checkTaxAmt;
                        sumPayableQty = bigDecimal;
                        sumPayableAmt = checkTaxAmt;
                    }
                    if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                        entry.set("sumcheckqty", (Object)sumCheckQty);
                        if (!isConvert) {
                            poBillEntry.set("payableqty", (Object)sumPayableQty);
                        }
                        if (null == sumCheckQty || BigDecimal.ZERO.compareTo(sumCheckQty) == 0) {
                            entry.set("ischeckorinvoice", (Object)Boolean.FALSE);
                        } else {
                            entry.set("ischeckorinvoice", (Object)Boolean.TRUE);
                        }
                    }
                    if (checkTaxAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    entry.set("sumcheckamt", (Object)sumCheckTaxAmt);
                    if (isConvert) continue;
                    poBillEntry.set("payableamt", (Object)sumPayableAmt);
                    continue;
                }
                if (!noSrcCheckKeyList.contains(entityKey)) continue;
                if ("audit".equals(operation)) {
                    void var16_23;
                    if (bigDecimal.abs().compareTo(qty.abs()) > 0) {
                        BigDecimal bigDecimal2 = qty;
                    }
                    if (checkTaxAmt.abs().compareTo(taxamount.abs()) > 0) {
                        checkTaxAmt = taxamount;
                    }
                    entry.set("sumcheckamt", (Object)checkTaxAmt);
                    entry.set("sumcheckqty", (Object)var16_23);
                    entry.set("ischeckorinvoice", (Object)Boolean.TRUE);
                    continue;
                }
                if (!"delete".equals(operation)) continue;
                entry.set("sumcheckamt", (Object)BigDecimal.ZERO);
                entry.set("sumcheckqty", (Object)BigDecimal.ZERO);
                entry.set("ischeckorinvoice", (Object)Boolean.FALSE);
            }
        }
        if (col.length > 0) {
            Object[] objs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])col);
            log.info("save success:" + Arrays.toString(objs));
            if (orderList.length > 0) {
                Object[] poObjs = SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])orderList);
                log.info("save poBillOrder success:" + Arrays.toString(poObjs));
            }
        }
    }

    public static void updateBillStatus(DynamicObject[] col) {
        boolean isClosed = true;
        for (DynamicObject bill : col) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                String entryStatus = entry.get("entrystatus").toString();
                if (entryStatus.equals(BillEntryStatusEnum.CLOSED.getVal())) continue;
                isClosed = false;
            }
            if (!isClosed) continue;
            bill.set("billstatus", (Object)BillStatusEnum.CLOSED.getVal());
        }
    }

    public static void fillMatchData(IDataModel model, DynamicObject checkScheme, String entryKey, String suffix, boolean isPurApp) {
        isPur = isPurApp;
        HashMap<String, BigDecimal> qtyData = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> taxAmtData = new HashMap<String, BigDecimal>();
        DynamicObjectCollection detailCol = model.getEntryEntity(entryKey);
        String qtyKey = null;
        String taxAmountKey = null;
        if (!isPurApp) {
            qtyKey = "inqty";
            taxAmountKey = "intaxamount";
        } else {
            qtyKey = "outqty";
            taxAmountKey = "outtaxamount";
        }
        for (DynamicObject detail : detailCol) {
            String groupkey = detail.get("groupkey" + suffix).toString();
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)detail.get(qtyKey + suffix));
            BigDecimal taxamt = CommonUtil.getBigDecimalPro((Object)detail.get(taxAmountKey + suffix));
            if (qtyData.get(groupkey) != null) {
                qtyData.put(groupkey, ((BigDecimal)qtyData.get(groupkey)).add(qty));
            } else {
                qtyData.put(groupkey, qty);
            }
            if (taxAmtData.get(groupkey) != null) {
                taxAmtData.put(groupkey, ((BigDecimal)taxAmtData.get(groupkey)).add(taxamt));
                continue;
            }
            taxAmtData.put(groupkey, taxamt);
        }
        String nodiffType = checkScheme.getString("nodifftype");
        BatchCheckUtil.fillMatchRowData(model, qtyData, taxAmtData, CHECKSUM_ENTRY_KEY, "", qtyKey, taxAmountKey, nodiffType, isPurApp);
    }

    @Deprecated
    public static void fillMatchData(IDataModel model, String entryKey, String suffix, boolean isPurApp) {
        isPur = isPurApp;
        HashMap<String, BigDecimal> qtyData = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> taxAmtData = new HashMap<String, BigDecimal>();
        DynamicObjectCollection detailCol = model.getEntryEntity(entryKey);
        log.info("###batchCheck \u6784\u9020\u53d1\u8d27\u6c47\u603b\u6570\u636e\uff0c\u6570\u636e\u5927\u5c0f\uff1a" + detailCol.size());
        String qtyKey = null;
        String taxAmountKey = null;
        if (!isPurApp) {
            qtyKey = "inqty";
            taxAmountKey = "intaxamount";
        } else {
            qtyKey = "outqty";
            taxAmountKey = "outtaxamount";
        }
        for (DynamicObject detail : detailCol) {
            String groupkey = detail.get("groupkey" + suffix).toString();
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)detail.get(qtyKey + suffix));
            BigDecimal taxamt = CommonUtil.getBigDecimalPro((Object)detail.get(taxAmountKey + suffix));
            if (qtyData.get(groupkey) != null) {
                qtyData.put(groupkey, ((BigDecimal)qtyData.get(groupkey)).add(qty));
            } else {
                qtyData.put(groupkey, qty);
            }
            if (taxAmtData.get(groupkey) != null) {
                taxAmtData.put(groupkey, ((BigDecimal)taxAmtData.get(groupkey)).add(taxamt));
                continue;
            }
            taxAmtData.put(groupkey, taxamt);
        }
        log.info("###batchCheck \u6784\u9020\u53d1\u8d27\u6c47\u603b\u6570\u636e\uff0c\u6c47\u603b\u6570\u636e\uff1a" + taxAmtData);
        BatchCheckUtil.fillMatchRowData(model, qtyData, taxAmtData, CHECKSUM_ENTRY_KEY, "", qtyKey, taxAmountKey, "1", isPurApp);
    }

    @Deprecated
    public static void fillMatchRowData(IDataModel model, Map<String, BigDecimal> qtyData, Map<String, BigDecimal> taxAmtData, String entryKey, String index, String qtyKey, String taxAmountKey, String nodiffType) {
        BatchCheckUtil.fillMatchRowData(model, qtyData, taxAmtData, entryKey, index, qtyKey, taxAmountKey, nodiffType, isPur);
    }

    public static void fillMatchRowData(IDataModel model, Map<String, BigDecimal> qtyData, Map<String, BigDecimal> taxAmtData, String entryKey, String index, String qtyKey, String taxAmountKey, String nodiffType, boolean isPurApp) {
        DynamicObjectCollection rowCol = model.getEntryEntity(entryKey);
        BigDecimal diffQty = BigDecimal.ZERO;
        BigDecimal diffTaxAmt = BigDecimal.ZERO;
        for (int curEntryindex = 0; curEntryindex < rowCol.size(); ++curEntryindex) {
            DynamicObject currRow = model.getEntryRowEntity(entryKey, curEntryindex);
            String groupkey = index.isEmpty() ? currRow.get("groupkey").toString() : currRow.get("materialgroupkey" + index).toString();
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)currRow.get(QTY + index));
            if (qty.compareTo(new BigDecimal(9999999999999L)) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u7269\u6599\u603b\u6570\u91cf\u5df2\u8d85\u8fc713\u4f4d\uff0c\u8bf7\u7f29\u5c0f\u8fc7\u6ee4\u8303\u56f4\u91cd\u65b0\u5bf9\u8d26\u3002", (String)"BatchCheckUtil_0", (String)"scm-common", (Object[])new Object[0]));
            }
            BigDecimal amt = CommonUtil.getBigDecimalPro((Object)currRow.get(TAXAMOUNT + index));
            if (amt.compareTo(new BigDecimal(9999999999999L)) > 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u603b\u91d1\u989d\u5df2\u8d85\u8fc713\u4f4d\uff0c\u8bf7\u7f29\u5c0f\u8fc7\u6ee4\u8303\u56f4\u91cd\u65b0\u5bf9\u8d26\u3002", (String)"BatchCheckUtil_1", (String)"scm-common", (Object[])new Object[0]));
            }
            BigDecimal matchQty = qtyData.get(groupkey);
            if (matchQty != null) {
                if (isPurApp) {
                    diffQty = matchQty.subtract(qty);
                    model.setValue("cfmqty" + index, (Object)qty, curEntryindex);
                } else {
                    diffQty = qty.subtract(matchQty);
                    model.setValue("cfmqty" + index, (Object)matchQty, curEntryindex);
                }
                model.setValue(qtyKey + index, (Object)matchQty, curEntryindex);
            }
            BigDecimal matchTaxAmt = taxAmtData.get(groupkey);
            log.info("###batchCheck \u5339\u914d\u7684\u6c47\u603b\u91d1\u989d\uff1a" + matchTaxAmt + ",\u5206\u7ec4groupKey\uff1a" + groupkey + ";\u884c\u6570\uff1a" + curEntryindex);
            if (matchTaxAmt != null) {
                if (isPurApp) {
                    diffTaxAmt = matchTaxAmt.subtract(amt);
                    model.setValue("cfmamt" + index, (Object)amt, curEntryindex);
                } else {
                    diffTaxAmt = amt.subtract(matchTaxAmt);
                    model.setValue("cfmamt" + index, (Object)matchTaxAmt, curEntryindex);
                }
                model.setValue(taxAmountKey + index, (Object)matchTaxAmt, curEntryindex);
            }
            if (matchQty == null && matchTaxAmt == null) {
                log.info("###batchCheck \u672a\u5339\u914d\u5230\u6570\u636e\uff0cmatchQty\uff0cmatchTaxAmt\u4e3a\u7a7a");
                continue;
            }
            boolean isNodiff = false;
            if (nodiffType.equals("1")) {
                if (diffQty.compareTo(BigDecimal.ZERO) == 0 && diffTaxAmt.compareTo(BigDecimal.ZERO) == 0) {
                    isNodiff = true;
                }
            } else if (nodiffType.equals("2")) {
                if (diffTaxAmt.compareTo(BigDecimal.ZERO) == 0) {
                    isNodiff = true;
                }
            } else if (nodiffType.equals("3") && diffQty.compareTo(BigDecimal.ZERO) == 0) {
                isNodiff = true;
            }
            log.info("###batchCheck isNodiff:" + isNodiff);
            if (isNodiff) {
                model.setValue("checkstatus" + index, (Object)CheckStatusEnum.NODIFFERENCE.getVal(), curEntryindex);
                continue;
            }
            model.setValue("checkstatus" + index, (Object)CheckStatusEnum.DIFFERENCE.getVal(), curEntryindex);
            model.setValue("diffqty" + index, (Object)diffQty, curEntryindex);
            model.setValue("diffamt" + index, (Object)diffTaxAmt, curEntryindex);
        }
    }

    @Deprecated
    public static void buildeMatchData(IDataModel model, DynamicObjectCollection firstDetail, DynamicObjectCollection secondDetail, String firstIndex, String secondIndex, DynamicObject checkScheme) {
    }

    @Deprecated
    public static void buildeMatchData(IDataModel model, DynamicObjectCollection firstDetail, DynamicObjectCollection secondDetail, String firstIndex, String secondIndex) {
        BatchCheckUtil.buildeMatchData(model, firstDetail, secondDetail, firstIndex, secondIndex, null);
    }

    static {
        isPur = false;
    }

    private static class MatchInfo {
        private String billno;
        private String billid;
        private String billentryid;
        private boolean isMatch = false;
        private BigDecimal matchedQty = BigDecimal.ZERO;
        private BigDecimal matchedTaxamount = BigDecimal.ZERO;
        private BigDecimal totalQty = BigDecimal.ZERO;
        private BigDecimal totalTaxamount = BigDecimal.ZERO;
        private String groupKey;
        private List<MatchInfo> matchDetail = new ArrayList<MatchInfo>();

        private MatchInfo() {
        }

        public String getBillno() {
            return this.billno;
        }

        public MatchInfo setBillno(String billno) {
            this.billno = billno;
            return this;
        }

        public String getBillid() {
            return this.billid;
        }

        public MatchInfo setBillid(String billid) {
            this.billid = billid;
            return this;
        }

        public String getBillentryid() {
            return this.billentryid;
        }

        public MatchInfo setBillentryid(String billentryid) {
            this.billentryid = billentryid;
            return this;
        }

        public MatchInfo setMatch(boolean isMatch) {
            this.isMatch = isMatch;
            return this;
        }

        public boolean isMatch() {
            return this.isMatch;
        }

        public BigDecimal getMatchedQty() {
            return this.matchedQty;
        }

        public MatchInfo setMatchedQty(BigDecimal matchedQty) {
            this.matchedQty = matchedQty;
            return this;
        }

        public BigDecimal getMatchedTaxamount() {
            return this.matchedTaxamount;
        }

        public MatchInfo setMatchedTaxamount(BigDecimal matchedTaxamount) {
            this.matchedTaxamount = matchedTaxamount;
            return this;
        }

        public BigDecimal getTotalQty() {
            return this.totalQty;
        }

        public MatchInfo setTotalQty(BigDecimal totalQty) {
            this.totalQty = totalQty;
            return this;
        }

        public BigDecimal getTotalTaxamount() {
            return this.totalTaxamount;
        }

        public MatchInfo setTotalTaxamount(BigDecimal totalTaxamount) {
            this.totalTaxamount = totalTaxamount;
            return this;
        }

        public String getGroupKey() {
            return this.groupKey;
        }

        public MatchInfo setGroupKey(String groupKey) {
            this.groupKey = groupKey;
            return this;
        }

        public MatchInfo setMatchDetail(MatchInfo detail) {
            this.matchDetail.add(detail);
            return this;
        }

        public String getMatchDetailBillno() {
            StringBuilder sb = new StringBuilder();
            HashSet<String> billNoSet = new HashSet<String>();
            for (MatchInfo detail : this.matchDetail) {
                if (billNoSet.contains(detail.getBillno())) continue;
                if (sb.length() > 0) {
                    sb.append(',').append(detail.getBillno());
                    billNoSet.add(detail.getBillno());
                    continue;
                }
                sb.append(detail.getBillno());
            }
            return sb.toString();
        }

        public String getMatchDetailBillId() {
            StringBuilder sb = new StringBuilder();
            for (MatchInfo detail : this.matchDetail) {
                if (sb.length() > 0) {
                    sb.append(',').append(detail.getBillid());
                    continue;
                }
                sb.append(detail.getBillno());
            }
            return sb.toString();
        }

        public String getMatchDetailBillEntryId() {
            StringBuilder sb = new StringBuilder();
            for (MatchInfo detail : this.matchDetail) {
                if (sb.length() > 0) {
                    sb.append(',').append(detail.getBillentryid());
                    continue;
                }
                sb.append(detail.getBillno());
            }
            return sb.toString();
        }

        public BigDecimal getMatchDetailMatchQty() {
            BigDecimal qty = BigDecimal.ZERO;
            for (MatchInfo detail : this.matchDetail) {
                qty = qty.add(detail.getMatchedQty());
            }
            return qty;
        }

        public BigDecimal getMatchDetailMatchAmount() {
            BigDecimal amount = BigDecimal.ZERO;
            for (MatchInfo detail : this.matchDetail) {
                amount = amount.add(detail.getMatchedTaxamount());
            }
            return amount;
        }
    }
}

