/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.helper.multisystemjoint.constant.MServiceParamType;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.store.SRMStoreDataTraceHelper;

public final class PurModuleReceiptHelper {
    private static Log log = LogFactory.getLog(PurModuleReceiptHelper.class);
    public static final String OPERATOR_AUDIT = "audit";
    public static final String OPERATOR_UNAUDIT = "unaudit";

    public static void setwarehousebysupplierid(List<DynamicObject> dys) {
        HashMap param = new HashMap(1);
        MultiDataHandleResult executeManualSceneHandle = ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"manualgetwarehousebysupplierid", dys, param);
        String message = executeManualSceneHandle.getMessage();
        if (!StringUtils.isEmpty((Object)message)) {
            try {
                Map map = (Map)SerializationUtils.fromJsonString((String)message, Map.class);
                if (map != null && !map.isEmpty()) {
                    HashMap<String, DynamicObject> supplierwarehouses = new HashMap<String, DynamicObject>(8);
                    HashMap<String, DynamicObject> supplierlocations = new HashMap<String, DynamicObject>(8);
                    PurModuleReceiptHelper.getWarehouseId(map, supplierwarehouses, supplierlocations);
                    for (DynamicObject dataEntity : dys) {
                        Long supplierId = PurModuleReceiptHelper.getSupplierId(dataEntity);
                        Long orgId = PurModuleReceiptHelper.getOrgId(dataEntity);
                        String key = String.valueOf(supplierId) + "-" + String.valueOf(orgId);
                        DynamicObjectCollection materialentrys = dataEntity.getDynamicObjectCollection("materialentry");
                        for (DynamicObject dy : materialentrys) {
                            DynamicObject recwarehouse = (DynamicObject)supplierwarehouses.get(key);
                            DynamicObject reclocation = (DynamicObject)supplierlocations.get(key);
                            if (recwarehouse != null) {
                                dy.set("recwarehouse", (Object)recwarehouse);
                            }
                            if (reclocation == null) continue;
                            dy.set("reclocation", (Object)reclocation);
                        }
                    }
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
        }
    }

    private static void getWarehouseId(Map<String, String> map, Map<String, DynamicObject> supplierwarehouses, Map<String, DynamicObject> supplierlocations) {
        ArrayList<Long> warehouseIds = new ArrayList<Long>(8);
        ArrayList<Long> locationIds = new ArrayList<Long>(8);
        HashMap<String, Long> supplierWarehouse = new HashMap<String, Long>(8);
        HashMap<String, Long> supplierLocation = new HashMap<String, Long>(8);
        for (Map.Entry<String, String> entrySet : map.entrySet()) {
            String[] split;
            if (entrySet == null) continue;
            String supplierIdOrgId = entrySet.getKey();
            String warehouseStr = entrySet.getValue();
            if (StringUtils.isEmpty((Object)warehouseStr) || (split = warehouseStr.split("-")) == null || split.length != 2) continue;
            String warehouseIdStr = split[0];
            String locationIdStr = split[1];
            if (!"0".equals(locationIdStr)) {
                locationIds.add(Long.parseLong(locationIdStr));
                supplierLocation.put(supplierIdOrgId, Long.parseLong(locationIdStr));
            }
            warehouseIds.add(Long.parseLong(warehouseIdStr));
            supplierWarehouse.put(supplierIdOrgId, Long.parseLong(warehouseIdStr));
        }
        PurModuleReceiptHelper.loadAndPopulateData("bd_warehouse", warehouseIds, supplierWarehouse, supplierwarehouses);
        PurModuleReceiptHelper.loadAndPopulateData("bd_location", locationIds, supplierLocation, supplierlocations);
    }

    private static void loadAndPopulateData(String billKey, List<Long> ids, Map<String, Long> supplierWarehouse, Map<String, DynamicObject> resultMap) {
        if (!CollectionUtils.isEmpty(ids)) {
            Map data = BusinessDataServiceHelper.loadFromCache((Object[])ids.toArray(), (String)billKey);
            supplierWarehouse.forEach((supplierId, warehouseId) -> {
                DynamicObject dynamicObject = (DynamicObject)data.get(warehouseId);
                if (dynamicObject != null) {
                    resultMap.put((String)supplierId, dynamicObject);
                }
            });
        }
    }

    public static Long getOrgId(DynamicObject dataEntity) {
        Object org = dataEntity.get("org");
        Long orgId = 0L;
        if (org instanceof DynamicObject) {
            orgId = ((DynamicObject)org).getLong("id");
        } else if (org instanceof Long) {
            orgId = (Long)org;
        }
        return orgId;
    }

    public static Long getSupplierId(DynamicObject dataEntity) {
        Object supplier = dataEntity.get("supplier");
        Long supplierId = 0L;
        if (supplier instanceof DynamicObject) {
            supplierId = ((DynamicObject)supplier).getLong("id");
        } else if (supplier instanceof Long) {
            supplierId = (Long)supplier;
        }
        return supplierId;
    }

    public static void writeBackModuleDeliverySubQty(String operator, DynamicObject[] objs) {
        HashMap<String, Map<String, BigDecimal>> outstockqty = new HashMap<String, Map<String, BigDecimal>>(8);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection dys = obj.getDynamicObjectCollection("materialentry");
            for (DynamicObject dy : dys) {
                String mainbillentryid = dy.getString("mainbillentryid");
                HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(8);
                BigDecimal receiptqty = dy.getBigDecimal("qty");
                BigDecimal receiptbasicqty = dy.getBigDecimal("basicqty");
                map.put("outstockqty", receiptqty);
                map.put("outstockbaseqty", receiptbasicqty);
                outstockqty.put(mainbillentryid, map);
            }
        }
        if (!CollectionUtils.isEmpty(outstockqty)) {
            PurModuleReceiptHelper.updateWriteBacksubqty(operator, "", outstockqty);
        }
    }

    public static void writeBackModulereceiptSubQty(String operator, DynamicObject[] objs) {
        HashMap<String, Map<String, BigDecimal>> receiptqtyMap = new HashMap<String, Map<String, BigDecimal>>(8);
        HashMap<String, Map<String, BigDecimal>> returnqtyMap = new HashMap<String, Map<String, BigDecimal>>(8);
        for (DynamicObject obj : objs) {
            String receipttype = obj.getString("receipttype");
            DynamicObjectCollection dys = obj.getDynamicObjectCollection("materialentry");
            for (DynamicObject dy : dys) {
                String mainbillentryid = dy.getString("mainbillentryid");
                HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(8);
                BigDecimal receiptqty = dy.getBigDecimal("receiptqty");
                BigDecimal receiptbasicqty = dy.getBigDecimal("receiptbasicqty");
                map.put("receiptqty", receiptqty);
                map.put("receiptbasicqty", receiptbasicqty);
                if ("0".equals(receipttype)) {
                    receiptqtyMap.put(mainbillentryid, map);
                    continue;
                }
                returnqtyMap.put(mainbillentryid, map);
            }
        }
        if (!CollectionUtils.isEmpty(receiptqtyMap)) {
            PurModuleReceiptHelper.updateWriteBacksubqty(operator, "0", receiptqtyMap);
        }
        if (!CollectionUtils.isEmpty(returnqtyMap)) {
            PurModuleReceiptHelper.updateWriteBacksubqty(operator, "1", returnqtyMap);
        }
    }

    public static void updateWriteBacksubqty(String operator, String receipttype, Map<String, Map<String, BigDecimal>> receiptqtyMap) {
        DynamicObject[] loads;
        if (CollectionUtils.isEmpty(receiptqtyMap)) {
            return;
        }
        Set<String> keySet = receiptqtyMap.keySet();
        QFilter qf = new QFilter("materialentry.subsrcbillentryid", "in", keySet);
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"pur_modulelist", (String)"id,materialentry.id,materialentry.subsrcbillentryid,materialentry.outstocksubqty,materialentry.outstocksubbaseqty,materialentry.receiptsubqty,materialentry.receiptsubbaseqty,materialentry.returnsubqty,materialentry.returnsubbaseqty", (QFilter[])new QFilter[]{qf})) {
            DynamicObjectCollection dys = load.getDynamicObjectCollection("materialentry");
            for (DynamicObject dy : dys) {
                String subsrcbillentryid = dy.getString("subsrcbillentryid");
                Map<String, BigDecimal> map = receiptqtyMap.get(subsrcbillentryid);
                if (CollectionUtils.isEmpty(map)) continue;
                if ("0".equals(receipttype)) {
                    PurModuleReceiptHelper.writebackReceiptQty(operator, dy, map);
                } else if ("1".equals(receipttype) || "3".equals(receipttype)) {
                    PurModuleReceiptHelper.writebackReturnSubQty(operator, dy, map);
                }
                PurModuleReceiptHelper.writebackoutstockqty(operator, dy, map);
            }
        }
        if (loads.length > 0) {
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])loads);
        }
    }

    private static void writebackReceiptQty(String operator, DynamicObject dy, Map<String, BigDecimal> map) {
        BigDecimal receiptqty = map.get("receiptqty");
        BigDecimal receiptbasicqty = map.get("receiptbasicqty");
        BigDecimal receiptsubqty = dy.getBigDecimal("receiptsubqty");
        BigDecimal receiptsubbaseqty = dy.getBigDecimal("receiptsubbaseqty");
        if (receiptqty != null) {
            receiptsubqty = OPERATOR_AUDIT.equals(operator) ? receiptsubqty.add(receiptqty) : receiptsubqty.subtract(receiptqty);
            dy.set("receiptsubqty", (Object)receiptsubqty);
        }
        if (receiptbasicqty != null) {
            receiptsubbaseqty = OPERATOR_AUDIT.equals(operator) ? receiptsubbaseqty.add(receiptbasicqty) : receiptsubbaseqty.subtract(receiptbasicqty);
            dy.set("receiptsubbaseqty", (Object)receiptsubbaseqty);
        }
    }

    private static void writebackReturnSubQty(String operator, DynamicObject dy, Map<String, BigDecimal> map) {
        BigDecimal receiptqty = map.get("receiptqty");
        BigDecimal receiptbasicqty = map.get("receiptbasicqty");
        BigDecimal returnsubqty = dy.getBigDecimal("returnsubqty");
        BigDecimal returnsubbaseqty = dy.getBigDecimal("returnsubbaseqty");
        if (receiptqty != null) {
            returnsubqty = OPERATOR_AUDIT.equals(operator) ? returnsubqty.add(receiptqty) : returnsubqty.subtract(receiptqty);
            dy.set("returnsubqty", (Object)returnsubqty);
        }
        if (receiptbasicqty != null) {
            returnsubbaseqty = OPERATOR_AUDIT.equals(operator) ? returnsubbaseqty.add(receiptbasicqty) : returnsubbaseqty.subtract(receiptbasicqty);
            dy.set("returnsubbaseqty", (Object)returnsubbaseqty);
        }
    }

    private static void writebackoutstockqty(String operator, DynamicObject dy, Map<String, BigDecimal> map) {
        BigDecimal outstockqty = map.get("outstockqty");
        BigDecimal outstockbaseqty = map.get("outstockbaseqty");
        BigDecimal outstocksubqty = dy.getBigDecimal("outstocksubqty");
        BigDecimal outstocksubbaseqty = dy.getBigDecimal("outstocksubbaseqty");
        if (outstockqty != null) {
            outstocksubqty = OPERATOR_AUDIT.equals(operator) ? outstocksubqty.add(outstockqty) : outstocksubqty.subtract(outstockqty);
            dy.set("outstocksubqty", (Object)outstocksubqty);
        }
        if (outstockbaseqty != null) {
            outstocksubbaseqty = OPERATOR_AUDIT.equals(operator) ? outstocksubbaseqty.add(outstockbaseqty) : outstocksubbaseqty.subtract(outstockbaseqty);
            dy.set("outstocksubbaseqty", (Object)outstocksubbaseqty);
        }
    }

    public static void moduleReceiptUnConfirmCallback(MultiDataHandleResult scDataHandleResult) {
        String resultMessage = scDataHandleResult.getMessage();
        if (resultMessage == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u4e0b\u6e38\u5355\u636e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PurModuleReceiptHelper_0", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        HashMap messageMap = new HashMap();
        Map messageResultMap = (Map)SerializationUtils.fromJsonString((String)resultMessage.toString(), Map.class);
        messageMap.putAll(messageResultMap);
        if (CollectionUtils.isEmpty(messageMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u4e0b\u6e38\u5355\u636e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PurModuleReceiptHelper_0", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        Object isSuccess = messageMap.get("isSuccess");
        if (isSuccess == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u4e0b\u6e38\u5355\u636e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PurModuleReceiptHelper_0", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        Boolean successResult = (Boolean)isSuccess;
        if (!successResult.booleanValue()) {
            Object errorMap = messageMap.get("message");
            if (errorMap instanceof Map) {
                Map errorMsg = (Map)errorMap;
                StringJoiner joiner = new StringJoiner(",");
                for (Object errormsg : errorMsg.values()) {
                    if (errormsg == null) continue;
                    joiner.add(String.valueOf(errormsg.toString()));
                }
                if (joiner.length() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u4e0b\u6e38\u5355\u636e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PurModuleReceiptHelper_0", (String)"scm-sccore-common", (Object[])new Object[0]));
                }
                throw new KDBizException(joiner.toString());
            }
            if (errorMap != null && !StringUtils.isEmpty((Object)errorMap.toString())) {
                throw new KDBizException(errorMap.toString());
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u4e0b\u6e38\u5355\u636e\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PurModuleReceiptHelper_0", (String)"scm-sccore-common", (Object[])new Object[0]));
        }
        try {
            if (isSuccess != null && ((Boolean)isSuccess).booleanValue()) {
                ScMultiParamArgs multiParamArgs = scDataHandleResult.getReqParams();
                ScMultiCosmicStdParamArgs multiCosmicStdParamArgs = (ScMultiCosmicStdParamArgs)multiParamArgs;
                Map paramMap = multiCosmicStdParamArgs.getParamMap();
                if (CollectionUtils.isEmpty((Map)paramMap)) {
                    return;
                }
                Object moduleReceiptIdsObj = paramMap.get("moduleReceiptIds");
                if (moduleReceiptIdsObj == null) {
                    return;
                }
                String selectProperties = "id,materialentry.id,materialentry.downstreambilltype,materialentry.downstreambillno,materialentry.downstreambillid,materialentry.downstreambillentryid";
                Set moduleReceiptIdSet = (Set)moduleReceiptIdsObj;
                QFilter qf = new QFilter("id", "in", (Object)moduleReceiptIdSet);
                DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pur_modulereceipt", (String)selectProperties, (QFilter[])new QFilter[]{qf});
                if (loads != null && loads.length > 0) {
                    for (DynamicObject dy : loads) {
                        DynamicObjectCollection materialentrys = dy.getDynamicObjectCollection("materialentry");
                        for (DynamicObject materialentry : materialentrys) {
                            materialentry.set("downstreambilltype", (Object)" ");
                            materialentry.set("downstreambillno", (Object)" ");
                            materialentry.set("downstreambillid", (Object)" ");
                            materialentry.set("downstreambillentryid", (Object)" ");
                        }
                    }
                    SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])loads);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static ScMultiCosmicStdParamArgs assembleUnConfirmDeleteDownStreamParam(List<DynamicObject> dynamicObjects) {
        HashSet<Long> idSet = new HashSet<Long>();
        String downstreambilltype = "";
        HashSet<Long> moduleReceiptIdSet = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String downstreambillid = dynamicObject.getString("downstreambillid");
            if (!StringUtils.isEmpty((Object)downstreambillid)) {
                idSet.add(Long.parseLong(downstreambillid));
                moduleReceiptIdSet.add(dynamicObject.getLong("id"));
            }
            downstreambilltype = dynamicObject.getString("downstreambilltype");
        }
        if (CollectionUtils.isEmpty(idSet) || StringUtils.isEmpty((Object)downstreambilltype)) {
            return null;
        }
        ScMultiCosmicStdParamArgs scMultiParamArgs = new ScMultiCosmicStdParamArgs();
        scMultiParamArgs.setCloudId("scmc");
        scMultiParamArgs.setAppId("im");
        scMultiParamArgs.setServiceName("InvDeleteByScmCancelService");
        scMultiParamArgs.setMethodName("deleteScmDownInvBill");
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        ArrayList ids = new ArrayList(idSet);
        map.put("ids", ids);
        map.put("entityName", downstreambilltype);
        map.put("moduleReceiptIds", moduleReceiptIdSet);
        scMultiParamArgs.setParamMap(map);
        scMultiParamArgs.setParamType(MServiceParamType.GATHERMAP);
        return scMultiParamArgs;
    }
}

