/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.helper.transfer.SDKTransferHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ExchrateUtil;
import kd.scm.common.util.LineTypeUtil;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.ParamConfigUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SaloutUtil;
import kd.scm.common.util.WriteBackUtil;
import kd.scm.common.util.check.CheckWriteDataEntity;

public class ScmcUtil {
    private static Log log = LogFactory.getLog(ScmcUtil.class);
    private static final String PM_PURORDER = "pm_purorderbill";
    private static final String IM_PURINBILL = "im_purinbill";
    private static final String IM_PURRECEIVEBILL = "im_purreceivebill";
    private static final String PM_PURACCEPTBILL = "pm_puracceptbill";
    private static final String AP_FINAPBILL = "ap_finapbill";
    private static final String PM_PURORDER_ENTRY = "billentry";
    private static final String IM_PURINBILL_ENTRY = "billentry";
    private static final String ENTRYENTITY = "materialentry";
    private static final String POBILLID = "pobillid";
    private static final String IDS = "ids";
    private static final String CFMSTATUS = "cfmstatus";
    private static final String LOGSTATUS = "logstatus";

    public static List<ConvertRuleElement> getRuleList(String srcEntity, String targetEntity) {
        return ConvertMetaServiceHelper.loadRules((String)srcEntity, (String)targetEntity);
    }

    public static Boolean checkReceiptVersion() {
        Boolean checkVertionUpdate = Boolean.FALSE;
        try {
            checkVertionUpdate = (Boolean)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"PoToReceiveBotpService", (String)"checkVerUpdate", (Object[])new Object[0]);
        }
        catch (Throwable throwable) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)throwable);
        }
        return checkVertionUpdate;
    }

    public static String checkSplitStrategy() {
        String createuserstrategy = null;
        try {
            createuserstrategy = String.valueOf(ParamUtil.getBillParam((String)"pur_saloutstock", (String)"splitstrategy"));
        }
        catch (Exception exception) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)exception);
        }
        return createuserstrategy == null ? "splitrow" : createuserstrategy;
    }

    public static void putSplitStrategyMap(Map<String, Object> billInfoMap) {
        String createuserstrategy = null;
        try {
            createuserstrategy = String.valueOf(ParamUtil.getBillParam((String)"pur_saloutstock", (String)"splitstrategy"));
        }
        catch (Exception exception) {
            SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)exception);
        }
        if (createuserstrategy != null && !createuserstrategy.trim().isEmpty()) {
            billInfoMap.put("splitstrategy", createuserstrategy);
        }
    }

    @Deprecated
    public static Map<String, Object> toImPurInBill(String source, String target, String ruleId, List<DynamicObject> dataList) {
        return ScmcUtil.toImPurInBill(source, target, ruleId, dataList, new HashMap<String, String>());
    }

    @Deprecated
    public static Map<String, Object> toImPurInBill(String source, String target, String ruleId, List<DynamicObject> dataList, Map<String, String> transferPropertyMap) {
        return ScmcUtil.toImPurInBill(source, target, ruleId, dataList, transferPropertyMap, new HashMap<String, String>());
    }

    public static Map<String, Object> toImPurInBill(String source, String target, String ruleId, List<DynamicObject> dataList, Map<String, String> transferPropertyMap, Map<String, String> batchExtEntryPro) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        String splitStrategy = ScmcUtil.checkSplitStrategy();
        if (ScmcUtil.checkReceiptVersion().booleanValue() && "splitrow".equals(splitStrategy)) {
            LinkedHashMap<String, List<Map<String, String>>> receipt = new LinkedHashMap<String, List<Map<String, String>>>(56);
            LinkedHashMap<Long, Collection<Long>> pushOrderData = new LinkedHashMap<Long, Collection<Long>>(20);
            for (DynamicObject dynamicObject : dataList) {
                HashMap<String, String> salOutInfo;
                String poentryid = dynamicObject.getString("poentryid1");
                String pobillid = dynamicObject.getString("pobillid1");
                if (poentryid.isEmpty() || pobillid.isEmpty()) continue;
                List<Map<String, String>> salOutInfoS = receipt.get(poentryid);
                if (salOutInfoS != null) {
                    salOutInfo = new HashMap<String, String>(16);
                    salOutInfo.putAll(ScmcUtil.doAddQty(poentryid, dynamicObject));
                    salOutInfo.putAll(ScmcUtil.doAddSelfParam(poentryid, dynamicObject));
                    if (!CollectionUtils.isEmpty(batchExtEntryPro)) {
                        salOutInfo.putAll(ScmcUtil.doAddExpMap(poentryid, dynamicObject, batchExtEntryPro));
                    } else {
                        salOutInfo.putAll(ScmcUtil.doAddExpMap(poentryid, dynamicObject, transferPropertyMap));
                    }
                    salOutInfoS.add(salOutInfo);
                } else {
                    salOutInfoS = new ArrayList<Map<String, String>>();
                    salOutInfo = new HashMap(16);
                    salOutInfo.putAll(ScmcUtil.doAddQty(poentryid, dynamicObject));
                    salOutInfo.putAll(ScmcUtil.doAddSelfParam(poentryid, dynamicObject));
                    if (!CollectionUtils.isEmpty(batchExtEntryPro)) {
                        salOutInfo.putAll(ScmcUtil.doAddExpMap(poentryid, dynamicObject, batchExtEntryPro));
                    } else {
                        salOutInfo.putAll(ScmcUtil.doAddExpMap(poentryid, dynamicObject, transferPropertyMap));
                    }
                    salOutInfoS.add(salOutInfo);
                    receipt.put(poentryid, salOutInfoS);
                }
                HashSet<Long> orderEntry = (HashSet<Long>)pushOrderData.get(Long.parseLong(pobillid));
                if (orderEntry != null) {
                    orderEntry.add(Long.parseLong(poentryid));
                    continue;
                }
                orderEntry = new HashSet<Long>(16);
                orderEntry.add(Long.parseLong(poentryid));
                pushOrderData.put(Long.parseLong(pobillid), orderEntry);
            }
            ConvertRuleElement convertRuleElement = ConvertMetaServiceHelper.loadRule((String)ruleId);
            returnMap.putAll(ScmcUtil.pushStockBill(convertRuleElement, pushOrderData, receipt));
        } else {
            List<DynamicObject> unDoData = dataList;
            while (unDoData.size() > 0 && !Boolean.FALSE.equals(returnMap.get("succed"))) {
                unDoData = ScmcUtil.pushImBill(source, target, ruleId, unDoData, returnMap, new HashMap<String, String>(1));
            }
        }
        if (Boolean.TRUE.equals(returnMap.get("succed"))) {
            ScmcUtil.afterPush(returnMap, (List)returnMap.get("targetData"), transferPropertyMap, dataList);
        }
        return returnMap;
    }

    private static List<DynamicObject> pushImBill(String source, String target, String ruleId, List<DynamicObject> dataList, Map<String, Object> returnMap, Map<String, String> batchExtEntryPro) {
        returnMap.put("succed", Boolean.FALSE);
        returnMap.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u6d88\u606f", (String)"ScmcUtil_12", (String)"scm-common", (Object[])new Object[0]));
        ArrayList<DynamicObject> unDoData = new ArrayList<DynamicObject>();
        ArrayList<String> poEntryIdList = new ArrayList<String>();
        HashMap<String, DynamicObject> plusData = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : dataList) {
            String poentryid = dynamicObject.getString("poentryid1");
            if (poentryid.isEmpty()) continue;
            if (plusData.get(poentryid) != null) {
                unDoData.add(dynamicObject);
                continue;
            }
            poEntryIdList.add(poentryid);
            plusData.put(poentryid, dynamicObject);
        }
        if (!poEntryIdList.isEmpty()) {
            returnMap = ScmcUtil.dopush(source, ruleId, returnMap, poEntryIdList, target, plusData, batchExtEntryPro);
        } else {
            returnMap.put("succed", Boolean.FALSE);
            returnMap.put("message", ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u6ee1\u8db3\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u662f\u5426\u5408\u6cd5\uff01", (String)"ScmcUtil_14", (String)"scm-common", (Object[])new Object[0]));
        }
        return unDoData;
    }

    public static List<Long> getLongList(Object poEntryIdList) {
        return CommonUtil.getLongList((Object)poEntryIdList);
    }

    private static Map<String, Object> dopush(String source, String ruleId, Map<String, Object> returnMap, List<String> poEntryIdList, String target, Map<String, DynamicObject> plusData, Map<String, String> batchExtEntryPro) {
        ConvertRuleElement convertRuleElement = ConvertMetaServiceHelper.loadRule((String)ruleId);
        LinkedHashMap<Long, Collection<Long>> pushOrderData = new LinkedHashMap<Long, Collection<Long>>(20);
        LinkedHashMap<String, String> salOutInfoMap = new LinkedHashMap<String, String>(50);
        HashSet<Long> poEntryIdSet = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pur_order", (String)"materialentry.poentryid poentryid,materialentry.pobillid pobillid", (QFilter[])new QFilter[]{new QFilter("materialentry.poentryid", "in", poEntryIdList)}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String poBillId = row.getString(POBILLID);
                String poEntryId = row.getString("poentryid");
                if (poBillId.isEmpty() || poEntryId.isEmpty()) continue;
                poEntryIdSet = (HashSet<Long>)pushOrderData.get(Long.parseLong(poBillId));
                if (poEntryIdSet == null) {
                    poEntryIdSet = new HashSet<Long>();
                    poEntryIdSet.add(Long.parseLong(poEntryId));
                    pushOrderData.put(Long.parseLong(poBillId), poEntryIdSet);
                    continue;
                }
                poEntryIdSet.add(Long.parseLong(poEntryId));
                pushOrderData.put(Long.parseLong(poBillId), poEntryIdSet);
            }
        }
        if (!pushOrderData.isEmpty()) {
            ScmcUtil.setQtyMap(plusData, salOutInfoMap);
            ScmcUtil.addSelfParam(plusData, salOutInfoMap);
            ScmcUtil.setExtMap(plusData, salOutInfoMap, batchExtEntryPro);
            List pkIds = (List)returnMap.get("data");
            List targetData = (List)returnMap.get("targetData");
            Map<String, Object> tempMap = ScmcUtil.pushStockBill(convertRuleElement, pushOrderData, salOutInfoMap);
            returnMap.putAll(tempMap);
            if (pkIds != null) {
                pkIds.addAll((List)tempMap.get("data"));
                returnMap.put("data", pkIds);
            }
            if (targetData != null) {
                targetData.addAll((List)tempMap.get("targetData"));
                returnMap.put("targetData", targetData);
            }
        } else {
            returnMap.put("succed", Boolean.FALSE);
            returnMap.put("message", ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u6ee1\u8db3\u751f\u6210\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u662f\u5426\u5408\u6cd5\uff01", (String)"ScmcUtil_14", (String)"scm-common", (Object[])new Object[0]));
        }
        return returnMap;
    }

    public static Map<String, Object> pushStockBill(ConvertRuleElement element, Map<Long, Collection<Long>> pushOrderData, Map<String, String> salOutInfoMap) {
        String srcEntity = element.getSourceEntityNumber();
        String tarEntity = element.getTargetEntityNumber();
        PushArgs pushArgs = new PushArgs();
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber(tarEntity);
        pushArgs.setBuildConvReport(true);
        if (element.getId() != null) {
            pushArgs.setRuleId(element.getId());
        }
        for (Map.Entry<Long, Collection<Long>> entry : pushOrderData.entrySet()) {
            Long entryKey = entry.getKey();
            for (Long next : entry.getValue()) {
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue((Object)entryKey);
                listSelectedRow.setEntryEntityKey("billentry");
                listSelectedRow.setEntryPrimaryKeyValue((Object)next);
                selectedRowList.add(listSelectedRow);
            }
        }
        pushArgs.setSelectedRows(selectedRowList);
        pushArgs.addCustomParam("splitstrategy", "splitbill");
        for (Map.Entry<Object, Object> entry : salOutInfoMap.entrySet()) {
            pushArgs.addCustomParam((String)entry.getKey(), (String)entry.getValue());
        }
        return ScmcUtil.doPushStockBill(pushArgs);
    }

    public static Map<String, Object> pushStockBill(ConvertRuleElement element, Map<Long, Collection<Long>> pushOrderData, LinkedHashMap<String, List<Map<String, String>>> receiptInfo) {
        String srcEntity = element.getSourceEntityNumber();
        String tarEntity = element.getTargetEntityNumber();
        PushArgs pushArgs = new PushArgs();
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber(tarEntity);
        pushArgs.setBuildConvReport(true);
        pushArgs.setRuleId(element.getId());
        for (Map.Entry<Long, Collection<Long>> entry : pushOrderData.entrySet()) {
            Long entryKey = entry.getKey();
            for (Long next : entry.getValue()) {
                ListSelectedRow listSelectedRow = new ListSelectedRow();
                listSelectedRow.setPrimaryKeyValue((Object)entryKey);
                listSelectedRow.setEntryEntityKey("billentry");
                listSelectedRow.setEntryPrimaryKeyValue((Object)next);
                selectedRowList.add(listSelectedRow);
            }
        }
        pushArgs.setSelectedRows(selectedRowList);
        pushArgs.addCustomParam("splitstrategy", "splitrow");
        for (Map.Entry<Object, Collection<Object>> entry : receiptInfo.entrySet()) {
            pushArgs.addCustomParam((String)entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
        }
        return ScmcUtil.doPushStockBill(pushArgs);
    }

    private static Map<String, Object> doPushStockBill(PushArgs pushArgs) {
        HashMap<String, Object> returnMap;
        block5: {
            returnMap = new HashMap<String, Object>(2);
            returnMap.put("succed", Boolean.FALSE);
            returnMap.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u6d88\u606f", (String)"ScmcUtil_12", (String)"scm-common", (Object[])new Object[0]));
            pushArgs.setBuildConvReport(true);
            pushArgs.addCustomParam("botp_outformula", String.valueOf(Boolean.TRUE));
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
                IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                        BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
                    }
                };
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                result.release(refDataProvider, mainType);
                ArrayList pkIds = new ArrayList(targetData.size());
                try {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                    OperationResult operationResult = SaveServiceHelper.saveOperate((String)pushArgs.getTargetEntityNumber(), (DynamicObject[])targetData.toArray(new DynamicObject[0]), (OperateOption)operateOption);
                    if (operationResult == null) break block5;
                    if (operationResult.isSuccess() && operationResult.getSuccessPkIds().size() > 0) {
                        pkIds.addAll(operationResult.getSuccessPkIds());
                        returnMap.put("data", pkIds);
                        returnMap.put("targetData", targetData);
                        returnMap.put("message", "ok");
                        returnMap.put("succed", Boolean.TRUE);
                        break block5;
                    }
                    returnMap.put("succed", Boolean.FALSE);
                    StringBuilder messageError = new StringBuilder();
                    messageError.append(operationResult.getMessage()).append("\n\t");
                    operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append("\n\t"));
                    returnMap.put("message", messageError.toString());
                }
                catch (Throwable throwable) {
                    log.error(throwable);
                    returnMap.put("succed", Boolean.FALSE);
                    returnMap.put("message", ExceptionUtil.getStackTrace((Throwable)throwable));
                }
            } else {
                returnMap.put("succed", Boolean.FALSE);
                StringBuilder message = new StringBuilder();
                message.append(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u4e0b\u63a8\u5355\u636e\u5f02\u5e38\u3002", (String)"ScmcUtil_13", (String)"scm-common", (Object[])new Object[0])).append("\t\n");
                message.append(result.getMessage());
                result.getBillReports().forEach(row -> message.append(row.getFailMessage()));
                returnMap.put("message", message.toString());
                log.info("@@@\u91c7\u8d2d\u8ba2\u5355\u4e0b\u63a8\u5e93\u5b58\u91c7\u8d2d\u5165\u5e93\u5355\u5f02\u5e38\uff1a" + result.getMessage());
            }
        }
        return returnMap;
    }

    private static void setQtyMap(Map<String, DynamicObject> plusData, Map<String, String> salOutInfoMap) {
        for (Map.Entry<String, DynamicObject> entry : plusData.entrySet()) {
            if (StringUtils.isEmpty((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
            salOutInfoMap.putAll(ScmcUtil.doAddQty(entry.getKey(), entry.getValue()));
        }
    }

    private static Map<String, String> doAddQty(String key, DynamicObject dataRow) {
        LinkedHashMap<String, String> salOutInfoMap = new LinkedHashMap<String, String>();
        BigDecimal receiveqty = dataRow.getBigDecimal("receiveqty1");
        if (receiveqty.compareTo(BigDecimal.ZERO) > 0) {
            DynamicObject unit = dataRow.getDynamicObject("unit1");
            DynamicObject basicunit = dataRow.getDynamicObject("basicunit1");
            DynamicObject material = dataRow.getDynamicObject("material1");
            BigDecimal receiveBasicQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)receiveqty, (DynamicObject)basicunit);
            salOutInfoMap.put("qty_" + key, receiveqty.toPlainString());
            salOutInfoMap.put("basicqty_" + key, receiveBasicQty.toPlainString());
        }
        return salOutInfoMap;
    }

    private static void setExtMap(Map<String, DynamicObject> plusData, Map<String, String> salOutInfoMap, Map<String, String> batchExtEntryPro) {
        for (Map.Entry<String, DynamicObject> entry : plusData.entrySet()) {
            if (StringUtils.isEmpty((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
            salOutInfoMap.putAll(ScmcUtil.doAddExpMap(entry.getKey(), entry.getValue(), batchExtEntryPro));
        }
    }

    private static Map<String, String> doAddExpMap(String key, DynamicObject dataRow, Map<String, String> batchExtEntryPro) {
        LinkedHashMap<String, String> salOutInfoMap = new LinkedHashMap<String, String>();
        Map autoExtStockBill = SDKTransferHelper.executeTransfer((DynamicObject)dataRow, batchExtEntryPro, (boolean)false);
        if (!autoExtStockBill.isEmpty()) {
            for (Map.Entry proDataEntry : autoExtStockBill.entrySet()) {
                salOutInfoMap.put((String)proDataEntry.getKey() + "_" + key, (String)proDataEntry.getValue());
            }
        }
        return salOutInfoMap;
    }

    protected static void addSelfParam(Map<String, DynamicObject> plusData, Map<String, String> salOutInfoMap) {
        for (Map.Entry<String, DynamicObject> entry : plusData.entrySet()) {
            if (StringUtils.isEmpty((CharSequence)entry.getKey()) || entry.getValue() == null) continue;
            salOutInfoMap.putAll(ScmcUtil.doAddSelfParam(entry.getKey(), entry.getValue()));
        }
    }

    private static Map<String, String> doAddSelfParam(String key, DynamicObject dataRow) {
        LinkedHashMap<String, String> salOutInfoMap = new LinkedHashMap<String, String>();
        String saloutNo = dataRow.getString("billno1");
        String saloutId = dataRow.getString("billid1");
        String saloutEntryId = dataRow.getString("entryid1");
        String suplot1 = dataRow.getString("suplot1");
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:MM:ss");
        Date proddate1 = dataRow.getDate("proddate1");
        Date duedate1 = dataRow.getDate("duedate1");
        if (StringUtil.isNotEmpty((CharSequence)saloutNo)) {
            salOutInfoMap.put("saloutNo_" + key, saloutNo);
        }
        if (StringUtil.isNotEmpty((CharSequence)saloutId)) {
            salOutInfoMap.put("saloutId_" + key, saloutId);
        }
        if (StringUtil.isNotEmpty((CharSequence)saloutEntryId)) {
            salOutInfoMap.put("saloutEntryId_" + key, saloutEntryId);
        }
        if (StringUtil.isNotEmpty((CharSequence)suplot1)) {
            salOutInfoMap.put("suplot_" + key, suplot1);
        }
        if (null != proddate1 && StringUtil.isNotEmpty((CharSequence)sf.format(proddate1))) {
            salOutInfoMap.put("proddate_" + key, sf.format(proddate1));
        }
        if (null != duedate1 && StringUtil.isNotEmpty((CharSequence)sf.format(duedate1))) {
            salOutInfoMap.put("duedate_" + key, sf.format(duedate1));
        }
        return salOutInfoMap;
    }

    @Deprecated
    private static void afterPush(Map<String, Object> returnMap, List<DynamicObject> targetDataAll, Map<String, String> transferPropertyMap, List<DynamicObject> dataList) {
        if (!CollectionUtils.isEmpty(transferPropertyMap)) {
            ScmcUtil.setImTargetData(targetDataAll, dataList, transferPropertyMap);
            SaveServiceHelper.save((DynamicObject[])targetDataAll.toArray(new DynamicObject[0]));
        }
    }

    @Deprecated
    private static void setImTargetData(List<DynamicObject> targetDataAll, List<DynamicObject> dataList, Map<String, String> transferPropertyMap) {
        HashMap<String, DynamicObject> saleDataMap = new HashMap<String, DynamicObject>(dataList.size());
        for (DynamicObject dynamicObject : dataList) {
            saleDataMap.put(dynamicObject.getString("entryid1"), dynamicObject);
        }
        DynamicObjectCollection entrys = null;
        String saleentryid = null;
        DynamicObject saleorderinfo = null;
        Object value = null;
        for (DynamicObject targetData : targetDataAll) {
            entrys = targetData.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                saleentryid = entry.getString("srcsysbillentryid");
                saleorderinfo = (DynamicObject)saleDataMap.get(saleentryid);
                if (saleorderinfo == null) continue;
                for (Map.Entry<String, String> row : transferPropertyMap.entrySet()) {
                    String key = row.getKey();
                    value = saleorderinfo.get(key);
                    String property = row.getValue();
                    if (value instanceof DynamicObject) {
                        value = ((DynamicObject)value).getPkValue();
                    }
                    if (property.contains("billentry.")) {
                        entry.set(property.replace("billentry.", ""), value);
                        continue;
                    }
                    targetData.set(property, value);
                }
            }
        }
    }

    public static Object toPmPurOrder(List<DynamicObject> dataList) {
        if (ApiConfigUtil.hasEASConfig()) {
            log.info("\u542f\u7528\u4e86EAS api\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e0b\u63a8\u82cd\u7a79\u4f9b\u5e94\u94fe\u91c7\u8d2d\u8ba2\u5355");
            return null;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pur_order");
        pushArgs.setTargetEntityNumber(PM_PURORDER);
        pushArgs.setBuildConvReport(true);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)PM_PURORDER);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        ArrayList<DynamicObject> pushedDataList = new ArrayList<DynamicObject>();
        ArrayList<Long> entryIdList = new ArrayList<Long>();
        for (int i = 0; i < dataList.size(); ++i) {
            DynamicObjectCollection cols = dataList.get(i).getDynamicObjectCollection(ENTRYENTITY);
            ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(cols.getRowCount());
            for (DynamicObject col : cols) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(dataList.get(i).getPkValue());
                row.setEntryEntityKey(ENTRYENTITY);
                row.setEntryPrimaryKeyValue((Object)Long.valueOf(col.getPkValue().toString()));
                entryIdList.add(Long.valueOf(col.getPkValue().toString()));
                selectedRowList.add(row);
            }
            pushArgs.setSelectedRows(selectedRowList);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (result.isSuccess()) {
                List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
                pushedDataList.addAll(targetData);
                result.release(refDataProvider, mainType);
                continue;
            }
            log.info("@@@\u534f\u540c\u8ba2\u5355\u4e0b\u63a8\u4f9b\u5e94\u94fe\u91c7\u8d2d\u8ba2\u5355\u5f02\u5e38\uff1a" + result.getMessage());
        }
        ScmcUtil.dealPmPurOrderInfo(pushedDataList);
        ScmcUtil.dealConvertResult(pushedDataList, PM_PURORDER);
        ScmcUtil.dealWriteBackInfo(dataList, entryIdList, PM_PURORDER, "billentry");
        return null;
    }

    public static void dealPmPurOrderInfo(List<DynamicObject> pushedPurOrderList) {
        DynamicObject billType = ScmcUtil.getBdByNumber("bos_billtype", "pm_PurOrderBill_STD_BT_S");
        DynamicObject bizType = ScmcUtil.getBdByNumber("bd_biztype", "110");
        DynamicObject exratetable = ScmcUtil.getBdByNumber("bd_exratetable", "HLB01");
        for (int i = 0; i < pushedPurOrderList.size(); ++i) {
            String supplierId;
            if (null != billType && pushedPurOrderList.get(i).get("billtype") == null) {
                pushedPurOrderList.get(i).set("billtype", (Object)billType);
            }
            if (StringUtils.isNotBlank((CharSequence)(supplierId = pushedPurOrderList.get(i).getString("providersupplier_id"))) && supplierId.equals("486095512240421888")) {
                pushedPurOrderList.get(i).set(CFMSTATUS, (Object)"B");
                pushedPurOrderList.get(i).set(LOGSTATUS, (Object)"C");
            }
            if (null != bizType && pushedPurOrderList.get(i).get("biztype") == null) {
                pushedPurOrderList.get(i).set("biztype", (Object)bizType);
            }
            if (null == exratetable || pushedPurOrderList.get(i).get("exratetable") != null) continue;
            pushedPurOrderList.get(i).set("exratetable", (Object)exratetable);
        }
    }

    public static String toApFinapbill(List<DynamicObject> dataList, Map<String, String> extParamMap) {
        ArrayList<String> purinbillEntryIdList = new ArrayList<String>(1024);
        ArrayList<String> purinReturnbillEntryIdList = new ArrayList<String>(1024);
        ArrayList<String> reciveEntryIdList = new ArrayList<String>(1024);
        ArrayList<String> receiveacceptbillEntryIdList = new ArrayList<String>(1024);
        ArrayList<String> imInbillEntryIdList = new ArrayList<String>(1024);
        ArrayList<String> imReciveEntryIdList = new ArrayList<String>(1024);
        ArrayList<String> acceptbillEntryIdList = new ArrayList<String>(1024);
        HashMap<String, Long> checkInOrRevMap = new HashMap<String, Long>(1024);
        HashMap<String, Long> checkImInOrRevMap = new HashMap<String, Long>(1024);
        HashMap<Long, DynamicObject> invoiceMap = new HashMap<Long, DynamicObject>(1024);
        for (int i = 0; i < dataList.size(); ++i) {
            DynamicObject dy = dataList.get(i);
            if (null == dy) continue;
            DynamicObjectCollection cols = dy.getDynamicObjectCollection("entryentity1");
            DynamicProperty linetype1 = cols.getDynamicObjectType().getProperty("linetype1");
            for (DynamicObject col : cols) {
                if ("1".equals(col.get("isentrypay"))) continue;
                Long pkId = dy.getLong("id");
                checkInOrRevMap.put(col.getString("srcentryid1"), pkId);
                invoiceMap.put(pkId, dy);
                String srcBillType = col.getString("srcbilltype1");
                String srcEntryid = col.getString("srcentryid1");
                if ("pur_instock".equals(srcBillType) || "scp_instock".equals(srcBillType)) {
                    purinbillEntryIdList.add(srcEntryid);
                    continue;
                }
                if ("pur_return".equals(srcBillType) || "scp_return".equals(srcBillType)) {
                    purinReturnbillEntryIdList.add(srcEntryid);
                    continue;
                }
                if (!"pur_receipt".equals(srcBillType) && !"scp_receipt".equals(srcBillType)) continue;
                if (linetype1 != null) {
                    DynamicObject value = (DynamicObject)linetype1.getValue((Object)col);
                    if (value != null && value.getBoolean("acceptance")) {
                        receiveacceptbillEntryIdList.add(srcEntryid);
                        continue;
                    }
                    reciveEntryIdList.add(srcEntryid);
                    continue;
                }
                reciveEntryIdList.add(srcEntryid);
            }
        }
        DynamicObjectCollection purInbills = QueryServiceHelper.query((String)"pur_instock", (String)" materialentry.id entryId, materialentry.srcentryid srcEntryId", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", ScmcUtil.getLongList(purinbillEntryIdList))});
        DynamicObjectCollection purInReturnbills = QueryServiceHelper.query((String)"pur_return", (String)" materialentry.id entryId, materialentry.srcentryid srcEntryId", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", ScmcUtil.getLongList(purinReturnbillEntryIdList))});
        DynamicObjectCollection purRevBills = QueryServiceHelper.query((String)"pur_receipt", (String)"materialentry.id entryId, materialentry.srcentryid srcEntryId,materialentry.linetype.acceptance acceptance", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", ScmcUtil.getLongList(reciveEntryIdList)).or(new QFilter("materialentry.id", "in", ScmcUtil.getLongList(receiveacceptbillEntryIdList)))});
        if (purInbills.isEmpty() && purRevBills.isEmpty() && purInReturnbills.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u7b26\u5408\u751f\u6210\u5e94\u4ed8\u7684\u6761\u4ef6\uff0c\u672a\u627e\u5230\u5165\u5e93\u6216\u6536\u8d27\u6e90\u5355\u3002", (String)"ScmcUtil_16", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
        for (DynamicObject temp : purInbills) {
            if (StringUtil.isBlank((CharSequence)temp.getString("srcEntryId"))) continue;
            imInbillEntryIdList.add(temp.getString("srcEntryId"));
            checkImInOrRevMap.put(temp.getString("srcEntryId"), (Long)checkInOrRevMap.get(temp.getString("entryId")));
        }
        for (DynamicObject temp : purInReturnbills) {
            if (StringUtil.isBlank((CharSequence)temp.getString("srcEntryId"))) continue;
            imInbillEntryIdList.add(temp.getString("srcEntryId"));
            checkImInOrRevMap.put(temp.getString("srcEntryId"), (Long)checkInOrRevMap.get(temp.getString("entryId")));
        }
        for (DynamicObject temp : purRevBills) {
            if (StringUtil.isBlank((CharSequence)temp.getString("srcEntryId"))) continue;
            if (temp.getBoolean("acceptance")) {
                acceptbillEntryIdList.add(temp.getString("srcEntryId"));
            } else {
                imReciveEntryIdList.add(temp.getString("srcEntryId"));
            }
            checkImInOrRevMap.put(temp.getString("srcEntryId"), (Long)checkInOrRevMap.get(temp.getString("entryId")));
        }
        StringBuilder messsage = new StringBuilder();
        if (imInbillEntryIdList.size() > 0) {
            messsage.append(ScmcUtil.pushBillAndWriteBack(invoiceMap, checkImInOrRevMap, imInbillEntryIdList, IM_PURINBILL, AP_FINAPBILL, "pur_instock", extParamMap));
        }
        if (imReciveEntryIdList.size() > 0) {
            messsage.append("  ").append(ScmcUtil.pushBillAndWriteBack(invoiceMap, checkImInOrRevMap, imReciveEntryIdList, IM_PURRECEIVEBILL, AP_FINAPBILL, "pur_receipt", extParamMap));
        }
        if (acceptbillEntryIdList.size() > 0) {
            messsage.append("  ").append(ScmcUtil.pushBillAndWriteBack(invoiceMap, checkImInOrRevMap, acceptbillEntryIdList, PM_PURACCEPTBILL, AP_FINAPBILL, "pur_receipt", extParamMap));
        }
        if (purinbillEntryIdList.isEmpty() && reciveEntryIdList.isEmpty() && imInbillEntryIdList.isEmpty() && acceptbillEntryIdList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e0d\u7b26\u5408\u751f\u6210\u5e94\u4ed8\u7684\u6761\u4ef6\u3002", (String)"ScmcUtil_17", (String)"scm-pur-formplugin", (Object[])new Object[0]));
        }
        return messsage.toString();
    }

    public static String toApFinapbill(List<DynamicObject> dataList) {
        return ScmcUtil.toApFinapbill(dataList, null);
    }

    private static String pushBillAndWriteBack(Map<Long, DynamicObject> invoiceMap, Map<String, Long> checkOrderMap, List<String> entryIdList, String srcEntity, String targetEntity, String srcbilltype, Map<String, String> extparamMap) {
        ConvertOperationResult result;
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)srcEntity, (String)"id, billentry.id entryId", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", ScmcUtil.getLongList(entryIdList))});
        HashMap<String, String> srcBillidMap = new HashMap<String, String>();
        if (IM_PURINBILL.equals(srcEntity)) {
            Object obj2;
            DynamicObjectCollection purInbills = QueryServiceHelper.query((String)"pur_instock", (String)" id, materialentry.srcbillid srcbillid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcEntryId", "in", entryIdList)});
            for (Object obj2 : purInbills) {
                srcBillidMap.put(obj2.getString("srcbillid"), obj2.getString("id"));
            }
            Iterator purInReturnbills = QueryServiceHelper.query((String)"pur_return", (String)"id, materialentry.srcbillid srcbillid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", entryIdList)});
            obj2 = purInReturnbills.iterator();
            while (obj2.hasNext()) {
                Iterator obj3 = (DynamicObject)obj2.next();
                srcBillidMap.put(obj3.getString("srcbillid"), obj3.getString("id"));
            }
        } else if (IM_PURRECEIVEBILL.equals(srcEntity) || PM_PURACCEPTBILL.equals(srcEntity)) {
            DynamicObjectCollection purRevBills = QueryServiceHelper.query((String)"pur_receipt", (String)"id, materialentry.srcbillid srcbillid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", entryIdList)});
            for (Object obj2 : purRevBills) {
                srcBillidMap.put(obj2.getString("srcbillid"), obj2.getString("id"));
            }
        }
        if (dyos.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u90e8\u5206\u6240\u9009\u5355\u636e\u6ca1\u6709\u627e\u5230\u6e90\u5355\u3002", (String)"ScmcUtil_18", (String)"scm-common", (Object[])new Object[0]));
        }
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>();
        ArrayList<Long> srcEntryIdList = new ArrayList<Long>();
        HashMap<String, Long> purInvoiceOrderMap = new HashMap<String, Long>();
        for (DynamicObject dyo : dyos) {
            Long sBillId = dyo.getLong("id");
            Long sEntryId = dyo.getLong("entryId");
            ListSelectedRow row = new ListSelectedRow();
            row.setEntryEntityKey("billentry");
            row.setPrimaryKeyValue((Object)sBillId);
            row.setEntryPrimaryKeyValue((Object)sEntryId);
            selectedRowList.add(row);
            srcEntryIdList.add(sEntryId);
            purInvoiceOrderMap.put(sEntryId.toString(), checkOrderMap.get(sEntryId.toString()));
        }
        log.info("###\u4f9b\u5e94\u94fe\u91c7\u8d2d\u5165\u5e93\u5355\u5206\u5f55id\u96c6\u5408\uff1a" + srcEntryIdList);
        ArrayList pushedDataList = new ArrayList();
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRowList);
        if (null != extparamMap) {
            pushArgs.getCustomParams().putAll(extparamMap);
        }
        if (!(result = ConvertServiceHelper.push((PushArgs)pushArgs)).isSuccess()) {
            log.error("push finance error : " + result.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355\u5f02\u5e38\uff1a", (String)"ScmcUtil_15", (String)"scm-common", (Object[])new Object[0]) + result.getMessage());
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dType);
            }
        };
        List targetData = result.loadTargetDataObjects(refDataProvider, mainType);
        pushedDataList.addAll(targetData);
        result.release(refDataProvider, mainType);
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult opResult = SaveServiceHelper.saveOperate((String)targetEntity, (DynamicObject[])pushedDataList.toArray(new DynamicObject[0]), (OperateOption)option);
        if (!opResult.isSuccess()) {
            StringBuilder messageError = new StringBuilder();
            messageError.append(opResult.getMessage());
            messageError.append(ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo()));
            throw new KDBizException(new ErrorCode("operation error", ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u63d0\u4ea4\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScmcUtil_19", (String)"scm-common", (Object[])new Object[0]) + messageError), new Object[0]);
        }
        String inbillMsg = ScmcUtil.savePurInvoiceOrder(opResult.getSuccessPkIds(), targetEntity, purInvoiceOrderMap, srcBillidMap, invoiceMap);
        return inbillMsg;
    }

    private static String savePurInvoiceOrder(List<Object> targetPks, String targetEntity, Map<String, Long> checkOrderMap, Map<String, String> srcBillidMap, Map<Long, DynamicObject> invoiceMap) {
        String coreBillId = "";
        String srcbillid = "";
        String srcbillEntryid = "";
        String srcpurbillid = "";
        String billno = null;
        HashSet<String> billnoSet = new HashSet<String>(targetPks.size());
        DynamicObject checkbill = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)targetEntity, (String)"id,billno,sourcebillid, detailentry.corebillid corebillid,detailentry.e_sourcebillid e_sourcebillid, detailentry.e_sourcebillentryid e_sourcebillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", ScmcUtil.getLongList(targetPks))}, (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                billno = row.getString("billno");
                log.info(billno);
                srcbillid = row.getString("e_sourcebillid");
                if (StringUtils.isEmpty((CharSequence)srcbillid)) {
                    srcbillid = row.getString("sourcebillid");
                }
                srcbillEntryid = row.getString("e_sourcebillentryid");
                log.info(srcbillEntryid);
                Long invoiceId = checkOrderMap.get(srcbillEntryid);
                if (null == invoiceId || (checkbill = invoiceMap.get(invoiceId)) == null) continue;
                log.info(checkbill.getString("id") + checkbill.getString("billno"));
                srcpurbillid = srcBillidMap.get(srcbillid);
                DynamicObjectCollection cols = checkbill.getDynamicObjectCollection("entryentity1");
                DynamicObjectType dynamicObjectType = cols.getDynamicObjectType();
                for (DynamicObject entry : cols) {
                    if (!dynamicObjectType.getProperty("srcbillid1").getValue((Object)entry).equals(srcpurbillid)) continue;
                    dynamicObjectType.getProperty("isentrypay").setValue((Object)entry, (Object)"1");
                    dynamicObjectType.getProperty("entrypaybillno").setValue((Object)entry, (Object)billno);
                    dynamicObjectType.getProperty("entrypaytype").setValue((Object)entry, (Object)"1");
                }
                billnoSet.add(billno);
            }
        }
        log.info(((Object)billnoSet).toString());
        Collection<DynamicObject> cols = invoiceMap.values();
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])cols.toArray(new DynamicObject[0]));
        return ((Object)billnoSet).toString();
    }

    public static List<BFRow> getSourceBotpRelations(String sourceEntityKey, String sourceEntryKey, List<Long> entryIds) {
        List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)sourceEntityKey, (String)sourceEntryKey, (Long[])entryIds.toArray(new Long[0]));
        return bfRowList;
    }

    public static List<BFRow> getTargetBotpRelations(String targetEntityKey, String targetEntryKey, List<Long> entryIds) {
        List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)targetEntityKey, (String)targetEntryKey, (Long[])entryIds.toArray(new Long[0]));
        return bfRowList;
    }

    public static String dealConvertResult(List<DynamicObject> pushedDataList, String entityKey, boolean isAudit) {
        if (pushedDataList.isEmpty()) {
            return ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u63a8\u6570\u636e\u96c6\u5408", (String)"ScmcUtil_3", (String)"scm-common", (Object[])new Object[0]);
        }
        String billName = null;
        switch (entityKey) {
            case "im_purinbill": {
                billName = ResManager.loadKDString((String)"\u91c7\u8d2d\u5165\u5e93\u5355", (String)"ScmcUtil_4", (String)"scm-common", (Object[])new Object[0]);
                break;
            }
            case "pm_purorderbill": {
                billName = ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"ScmcUtil_5", (String)"scm-common", (Object[])new Object[0]);
                break;
            }
            case "ap_finapbill": {
                billName = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"ScmcUtil_6", (String)"scm-common", (Object[])new Object[0]);
                break;
            }
            default: {
                billName = entityKey;
            }
        }
        StringBuilder msgSb = new StringBuilder();
        HashSet errorPkIds = new HashSet();
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult opResult = SaveServiceHelper.saveOperate((String)entityKey, (DynamicObject[])pushedDataList.toArray(new DynamicObject[0]), (OperateOption)option);
        if (opResult.getSuccessPkIds().size() > 0) {
            msgSb.append(billName);
            if (!isAudit) {
                msgSb.append(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\uff01", (String)"ScmcUtil_7", (String)"scm-common", (Object[])new Object[0]));
                return msgSb.toString();
            }
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)entityKey, (Object[])opResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
            if (submitResult.getSuccessPkIds().size() > 0) {
                OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)entityKey, (Object[])submitResult.getSuccessPkIds().toArray(new Object[0]), (OperateOption)option);
                if (auditResult.isSuccess()) {
                    msgSb.append(ResManager.loadKDString((String)"\u751f\u6210\u6210\u529f\uff01", (String)"ScmcUtil_7", (String)"scm-common", (Object[])new Object[0]));
                } else {
                    msgSb.append(MessageFormat.format(ResManager.loadKDString((String)"\u5ba1\u6838\u5f02\u5e38\uff1a{0}", (String)"ScmcUtil_8", (String)"scm-common", (Object[])new Object[0]), ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo())));
                }
            } else {
                msgSb.append(MessageFormat.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5f02\u5e38\uff1a{0}", (String)"ScmcUtil_9", (String)"scm-common", (Object[])new Object[0]), ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo())));
            }
            log.info(msgSb.toString());
            List errorInfoList = submitResult.getAllErrorInfo();
            StringBuilder errorMsg = new StringBuilder(ResManager.loadKDString((String)"@@@\u63d0\u4ea4\u5f02\u5e38\u4fe1\u606f\uff1a", (String)"ScmcUtil_20", (String)"scm-common", (Object[])new Object[0]));
            for (OperateErrorInfo operateErrorInfo : errorInfoList) {
                errorMsg.append(operateErrorInfo.getMessage()).append(";\n");
            }
            errorPkIds.addAll(submitResult.getValidateResult().getErrorPkIds());
            log.info(errorMsg.toString());
            if (errorPkIds.size() > 0) {
                DeleteServiceHelper.delete((IDataEntityType)pushedDataList.get(0).getDataEntityType(), (Object[])errorPkIds.toArray(new Object[0]));
            }
        } else {
            msgSb.append(MessageFormat.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f02\u5e38\uff1a{0}\u3002", (String)"ScmcUtil_10", (String)"scm-common", (Object[])new Object[0]), ExceptionUtil.getErrorInfoDetails((List)opResult.getAllErrorOrValidateInfo())));
            log.info(msgSb.toString());
        }
        return msgSb.toString();
    }

    public static String dealConvertResult(List<DynamicObject> pushedDataList, String entityKey) {
        return ScmcUtil.dealConvertResult(pushedDataList, entityKey, true);
    }

    public static DynamicObject getBdByNumber(String bdKey, String number) {
        QFilter qFilter2 = new QFilter("number", "=", (Object)number);
        DynamicObject billType = BusinessDataServiceHelper.loadSingleFromCache((String)bdKey, (String)"number,name", (QFilter[])new QFilter[]{qFilter2});
        return billType;
    }

    public static void dealWriteBackInfo(List<DynamicObject> dataList, List<Long> entryIdList, String targetKey, String targetEntryKey) {
        List bfRowList = BFTrackerServiceHelper.loadTargetRowIds((String)"pur_order", (String)ENTRYENTITY, (Long[])entryIdList.toArray(new Long[0]));
        if (bfRowList.isEmpty()) {
            return;
        }
        HashMap<String, BFRow> entryID_BFRowMap = new HashMap<String, BFRow>(bfRowList.size());
        for (BFRow bfRow : bfRowList) {
            BFRowId bfRowId = bfRow.getSId();
            entryID_BFRowMap.put(bfRowId.getEntryId().toString(), bfRow);
        }
        for (int i = 0; i < dataList.size(); ++i) {
            DynamicObjectCollection cols = dataList.get(i).getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject col : cols) {
                BFRow bfRow = (BFRow)entryID_BFRowMap.get(col.getPkValue().toString());
                if (null == bfRow) continue;
                BFRowId bfRowId = bfRow.getId();
                col.set(POBILLID, (Object)bfRowId.getBillId());
                col.set("poentryid", (Object)bfRowId.getEntryId());
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dataList.toArray(new DynamicObject[0]));
    }

    public static void updateScmcStatus(DynamicObject[] objs, String entryKey) {
        log.info("@@@\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355start");
        DynamicObject[] orders = ScmcUtil.getOrders(objs, entryKey);
        HashMap<Long, String> logstatusMap = new HashMap<Long, String>(orders.length);
        HashSet<String> pmApplyPkIds = new HashSet<String>(orders.length);
        for (int i = 0; i < orders.length; ++i) {
            DynamicObject order = orders[i];
            DynamicObject orderEntry = (DynamicObject)order.getDynamicObjectCollection(ENTRYENTITY).get(0);
            logstatusMap.put(Long.valueOf(orderEntry.getString(POBILLID)), order.getString(LOGSTATUS));
            log.info("\u4f9b\u5e94\u94fe\u8ba2\u5355ID" + orderEntry.getString(POBILLID));
            log.info("\u4f9b\u5e94\u94fe\u8ba2\u5355ID\u786e\u8ba4\u72b6\u6001" + order.getString(CFMSTATUS));
            log.info("\u4f9b\u5e94\u94fe\u8ba2\u5355ID\u7269\u6d41\u72b6\u6001" + order.getString(LOGSTATUS));
            pmApplyPkIds.add(orderEntry.getString(POBILLID));
        }
        log.info("@@@\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355end");
        log.info("@@@\u66f4\u65b0\u4f9b\u5e94\u94fe\u91c7\u8d2d\u8ba2\u5355start");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(3);
        ArrayList<Long> pkList = new ArrayList<Long>(pmApplyPkIds.size());
        for (String pk : pmApplyPkIds) {
            pkList.add(Long.valueOf(pk));
        }
        paramMap.put(IDS, pkList);
        if (pkList.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                paramMap.put(CFMSTATUS, "D");
                paramMap.put(LOGSTATUS, logstatusMap.get(pkList.get(0)));
                DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PmSupColService", (String)"upOrderStatus", (Object[])new Object[]{paramMap});
            }
            catch (Exception e) {
                log.error("@@@\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u5931\u8d25-->" + ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
        log.info("@@@\u66f4\u65b0\u4f9b\u5e94\u94fe\u91c7\u8d2d\u8ba2\u5355end");
    }

    public static DynamicObject[] getOrders(DynamicObject[] objs, String entryKey) {
        HashSet<String> poBillIdSet = new HashSet<String>();
        for (DynamicObject dynamicObject : objs) {
            DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection(entryKey);
            if (dynamicObjects.size() == 0) continue;
            for (DynamicObject dynamicObjectinner : dynamicObjects) {
                String poBillId = dynamicObjectinner.getString(POBILLID);
                if (null == poBillId || poBillId.isEmpty() || "0".equalsIgnoreCase(poBillId)) continue;
                poBillIdSet.add(poBillId);
            }
        }
        HashMap filterMap = new HashMap(2);
        HashMap<String, HashSet<String>> idMap = new HashMap<String, HashSet<String>>(1);
        idMap.put("in", poBillIdSet);
        filterMap.put("materialentry.pobillid", idMap);
        return ORMUtil.load((String)"scp_order", (String)"billno,cfmstatus,logstatus,materialentry.pobillid,materialentry.entrystatus,materialentry.poentryid", filterMap);
    }

    public static DynamicObject[] getScmcOrders(Set<String> srcIdSet) {
        HashMap filterMap = new HashMap(2);
        HashMap<String, List<Long>> idMap = new HashMap<String, List<Long>>(1);
        idMap.put("in", ScmcUtil.getLongList(srcIdSet));
        filterMap.put("id", idMap);
        return ORMUtil.load((String)PM_PURORDER, (String)"billno,confirmstatus,logisticsstatus,id", filterMap);
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        return ExchrateUtil.getCurrencyAndExRateTable((Long)orgId);
    }

    public static Map getCurrencyDefaultValue(Long orgId) {
        return ScmcUtil.getCurrencyAndExRateTable(orgId);
    }

    public static boolean writeBackData(DynamicObject[] objs, String operateKey) {
        String entityKey = objs[0].getDataEntityType().getName();
        if ("pur_instock".equals(entityKey)) {
            String imEntityKeyStr = IM_PURINBILL;
            DynamicObject bussinessType = objs[0].getDynamicObject("businesstype");
            if (BussinessTypeUtils.checkOmBussinessType(bussinessType)) {
                imEntityKeyStr = "im_mdc_omcmplinbill";
            }
            String writePro = "suminstockbaseqty";
            String writeSrcPro = "basicqty";
            return ScmcUtil.writeBackData(objs, operateKey, entityKey, imEntityKeyStr, writePro, writeSrcPro);
        }
        if ("pur_receipt".equals(entityKey)) {
            String imEntityKeyStr;
            ArrayList<DynamicObject> amountAcceptanceWriteBackDy = new ArrayList<DynamicObject>(8);
            ArrayList<DynamicObject> qtyAcceptanceWriteBackDy = new ArrayList<DynamicObject>(8);
            ArrayList<DynamicObject> qtyWriteBackDy = new ArrayList<DynamicObject>(8);
            for (DynamicObject obj : objs) {
                DynamicObjectCollection cols = obj.getDynamicObjectCollection(ENTRYENTITY);
                Iterator iterator = cols.iterator();
                if (!iterator.hasNext()) continue;
                DynamicObject entry = (DynamicObject)iterator.next();
                boolean isLineTypeacceptance = LineTypeUtil.isLineTypeacceptance((DynamicObject)entry);
                if (isLineTypeacceptance) {
                    boolean amountLineTypeControlCriterion = LineTypeUtil.isAmountLineTypeControlCriterion((DynamicObject)entry);
                    if (amountLineTypeControlCriterion) {
                        amountAcceptanceWriteBackDy.add(obj);
                        continue;
                    }
                    qtyAcceptanceWriteBackDy.add(obj);
                    continue;
                }
                qtyWriteBackDy.add(obj);
            }
            if (!CollectionUtils.isEmpty(amountAcceptanceWriteBackDy)) {
                imEntityKeyStr = PM_PURACCEPTBILL;
                String writePro = "sumaccepttaxamount";
                String writeSrcPro = "taxamount";
                ScmcUtil.writeBackData(amountAcceptanceWriteBackDy.toArray(new DynamicObject[0]), operateKey, entityKey, imEntityKeyStr, writePro, writeSrcPro);
            }
            if (!CollectionUtils.isEmpty(qtyAcceptanceWriteBackDy)) {
                imEntityKeyStr = PM_PURACCEPTBILL;
                String writePro = "sumreceiptbaseqty";
                String writeSrcPro = "basicqty";
                ScmcUtil.writeBackData(objs, operateKey, entityKey, imEntityKeyStr, writePro, writeSrcPro);
            }
            if (!CollectionUtils.isEmpty(qtyWriteBackDy)) {
                imEntityKeyStr = IM_PURRECEIVEBILL;
                String writePro = "sumreceiptbaseqty";
                String writeSrcPro = "basicqty";
                ScmcUtil.writeBackData(objs, operateKey, entityKey, imEntityKeyStr, writePro, writeSrcPro);
            }
            return true;
        }
        if ("pur_receipt_return".equals(entityKey) && "delete".equals(operateKey)) {
            return true;
        }
        throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301{0}\u53cd\u5199\uff01", (String)"ScmcUtil_11", (String)"scm-common", (Object[])new Object[0]), entityKey));
    }

    public static boolean writeBackData(DynamicObject[] objs, String operateKey, String entityKey, String imEntityKeyStr, String writePro, String writeSrcPro) {
        log.info("###startwriteBackData:" + Arrays.toString(objs));
        ArrayList<Object> poEntryIdList = new ArrayList<Object>();
        HashMap<String, BigDecimal> srcEntryId_qtyMap = new HashMap<String, BigDecimal>();
        ArrayList<Long> srcEntryIdList = new ArrayList<Long>(16);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection cols = obj.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject entry : cols) {
                Object poEntryId = entry.get("poentryid");
                if (null == poEntryId) continue;
                poEntryIdList.add(poEntryId);
            }
        }
        HashMap<String, DynamicObject[]> orderEntryMap = new HashMap<String, DynamicObject[]>();
        if (poEntryIdList.size() > 0) {
            DynamicObjectCollection srcBillObjects = OrderUtil.querySrcBillInfo(poEntryIdList);
            for (DynamicObject[] dynamicObject : srcBillObjects) {
                orderEntryMap.put(dynamicObject.getString("poentryid"), dynamicObject);
            }
        }
        CheckWriteDataEntity writeData = new CheckWriteDataEntity();
        ScmcUtil.setSaloutWriteBack(objs, imEntityKeyStr, writeData, writeSrcPro);
        HashMap<String, String> writePropertyDimMap = new HashMap<String, String>(16);
        if ("pur_instock".equals(entityKey)) {
            writePropertyDimMap.put("qty", "suminstockqty");
            writePropertyDimMap.put("basicqty", "suminstockbaseqty");
        } else if ("pur_receipt".equals(entityKey)) {
            writePropertyDimMap.put("qty", "sumreceiptqty");
            writePropertyDimMap.put("basicqty", "sumreceiptbaseqty");
        }
        writeData.putWritePropertyMap("pur_saloutstock", writePropertyDimMap);
        writeData.putWritePropertyMap("pur_order", writePropertyDimMap);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection cols = obj.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject entry : cols) {
                String srcEntryIdStr;
                Object srcPoEntryId = entry.get("poentryid");
                if (null == srcPoEntryId || (srcEntryIdStr = String.valueOf(srcPoEntryId)).isEmpty()) continue;
                BigDecimal provalue = CommonUtil.getBigDecimalPro((Object)entry.get(writeSrcPro));
                writeData.setWriteData(srcEntryIdStr, entry.getPkValue().toString(), provalue);
                writeData.setEntryIdBillIdMap(entry.getPkValue().toString(), obj.getPkValue().toString());
                writeData.setSrcEntityKey(entityKey);
                writeData.setTarEntityKey("pur_saloutstock");
                DynamicObject poBillEntry = (DynamicObject)orderEntryMap.get(srcEntryIdStr);
                String poEntryId = null;
                if (poBillEntry == null) continue;
                poEntryId = poBillEntry.getString("entryId");
                if (null != srcEntryId_qtyMap.get(poEntryId)) {
                    srcEntryId_qtyMap.put(poEntryId, ((BigDecimal)srcEntryId_qtyMap.get(poEntryId)).add(provalue));
                } else {
                    srcEntryId_qtyMap.put(poEntryId, provalue);
                }
                srcEntryIdList.add(Long.valueOf(poEntryId));
            }
        }
        log.info("###srcEntryIdList:" + CommonUtil.collection2str(poEntryIdList) + ";saloutWriteBackMap=" + writeData.getSaloutWriteBackMap());
        if (srcEntryIdList.size() > 0) {
            HashMap<String, List<String>> proListMap = new HashMap<String, List<String>>(1);
            ArrayList<String> proList = new ArrayList<String>();
            proList.add(writePro);
            proListMap.put(ENTRYENTITY, proList);
            WriteBackUtil.writeBackBillForPurOrder("pur_order", proListMap, srcEntryIdList, srcEntryId_qtyMap, operateKey);
            log.info("###\u66f4\u65b0\u7269\u6d41\u72b6\u6001");
            Boolean scconsistencyservice = ParamConfigUtil.getCacheBooleanParamConfig((String)"scconsistencyservice");
            if (ApiConfigUtil.hasCQScmConfig() && !scconsistencyservice.booleanValue()) {
                ScmcUtil.updateScmcStatus(objs, ENTRYENTITY);
            }
        }
        if ("basicqty".equals(writeSrcPro)) {
            log.info("###\u66f4\u65b0\u5173\u8054\u6536\u8d27\u6570\u91cf");
            SaloutUtil.updateReciptQtyOrInstockQtyEx(writeData, writePro, operateKey);
        }
        if ("taxamount".equals(writeSrcPro)) {
            SaloutUtil.updateReceiptTaxAmount(writeData, writePro, operateKey);
        }
        return true;
    }

    private static void setSaloutWriteBack(DynamicObject[] objs, String imEntityKeyStr, CheckWriteDataEntity writeData, String writeSrcPro) {
        ArrayList<Long> imInOrRevIdList = new ArrayList<Long>(1024);
        for (DynamicObject obj : objs) {
            DynamicObjectCollection cols = obj.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject entry : cols) {
                Object inOrRevId = entry.get("srcbillid");
                if (StringUtils.isEmpty((CharSequence)inOrRevId.toString().trim()) || "".equals(inOrRevId.toString().trim())) continue;
                imInOrRevIdList.add(Long.parseLong(inOrRevId.toString()));
            }
        }
        StringBuilder sb = new StringBuilder("billentry.id entryid");
        if (PM_PURACCEPTBILL.equals(imEntityKeyStr)) {
            sb.append(",billentry.srcbillentity srcbillentity, billentry.soubillnumber srcsysbillno,billentry.srcbillentryid srcbillentryid,billentry.soubillid srcsysbillid,billentry.soubillentryid srcsysbillentryid");
        } else if ("im_mdc_omcmplinbill".equals(imEntityKeyStr)) {
            sb.append(",billentry.srcbillentity srcbillentity, billentry.saleoutstockbillno as srcsysbillno,billentry.srcbillentryid srcbillentryid,billentry.saleoutstockid srcsysbillid,billentry.saleoutstockentryid srcsysbillentryid");
        } else {
            sb.append(",billentry.srcbillentity srcbillentity, billentry.srcsysbillno srcsysbillno,billentry.srcbillentryid srcbillentryid,billentry.srcsysbillid srcsysbillid,billentry.srcsysbillentryid srcsysbillentryid");
        }
        String selectFields = sb.toString();
        DynamicObjectCollection imData = QueryServiceHelper.query((String)imEntityKeyStr, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", imInOrRevIdList)});
        HashMap<String, String> imInOrRevMap = new HashMap<String, String>(1024);
        HashMap<String, String> imInstockMap = new HashMap<String, String>();
        HashMap<String, Set<Long>> entityMap = new HashMap<String, Set<Long>>(16);
        log.info("1.\u5165\u5e93\u5355\u4e0a\u67e5\u5355\u636e" + imEntityKeyStr + "\u67e5\u8be2\u6570\u91cf:" + imData.size());
        imData.forEach(o -> {
            String srcbillentity = o.getString("srcbillentity");
            String srcsysbillentryid = o.getString("srcsysbillentryid");
            writeData.setSaloutBillInfoList(o.getString("srcsysbillno"), o.getString("srcsysbillid"), srcsysbillentryid);
            String srcbillentryid = o.getString("srcbillentryid");
            String entryid = o.getString("entryid");
            if (StringUtils.isEmpty((CharSequence)srcsysbillentryid)) {
                imInstockMap.put(srcbillentryid, entryid);
            } else {
                imInOrRevMap.put(entryid, srcsysbillentryid);
            }
            entityMap.computeIfAbsent(srcbillentity, k -> new HashSet(16)).add(o.getLong("srcbillentryid"));
        });
        log.info("2.\u4e0a\u6e38\u5355\u636e\u4fe1\u606fentityMap=" + entityMap);
        if ("im_mdc_omcmplinbill".equals(imEntityKeyStr)) {
            ScmcUtil.setSalOutBillInfoList(writeData, selectFields, imInOrRevMap, imInstockMap, entityMap, "im_mdc_omcmplinbill", "pm_om_purorderbill", IM_PURRECEIVEBILL);
        } else {
            ScmcUtil.setSalOutBillInfoList(writeData, selectFields, imInOrRevMap, imInstockMap, entityMap, IM_PURINBILL, PM_PURORDER, IM_PURRECEIVEBILL);
        }
        for (DynamicObject obj : objs) {
            DynamicObjectCollection cols = obj.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject entry : cols) {
                BigDecimal provalue = CommonUtil.getBigDecimalPro((Object)entry.get(writeSrcPro));
                writeData.setSaloutWriteBackMapOne(imInOrRevMap.get(entry.getString("srcentryid")), provalue);
            }
        }
    }

    private static void setSalOutBillInfoList(CheckWriteDataEntity writeData, String selectFields, HashMap<String, String> imInOrRevMap, Map<String, String> imInstockMap, Map<String, Set<Long>> entityMap, String srcEntityKey, String srcOrderEntityKey, String receivebillEntityKey) {
        HashSet entryIdList = new HashSet(16);
        HashMap imInstock1Map = new HashMap();
        if (!entityMap.isEmpty()) {
            if (entityMap.containsKey(srcEntityKey)) {
                DynamicObjectCollection imData2 = QueryServiceHelper.query((String)srcEntityKey, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", entityMap.get(srcEntityKey))});
                log.info("2.1\u5165\u5e93\u5355\u4e0a\u67e5\u5355\u636eim_purinbill\u67e5\u8be2\u6570\u91cf:" + imData2.size());
                imData2.forEach(o -> {
                    String srcbillentity = o.getString("srcbillentity");
                    if (srcOrderEntityKey.equals(srcbillentity)) {
                        String srcsysbillentryid = o.getString("srcsysbillentryid");
                        String entryid = o.getString("entryid");
                        if (StringUtils.isNotEmpty((CharSequence)srcsysbillentryid)) {
                            if (imInstockMap.containsKey(entryid)) {
                                imInOrRevMap.put((String)imInstockMap.get(entryid), srcsysbillentryid);
                            } else {
                                imInOrRevMap.put(entryid, srcsysbillentryid);
                            }
                            writeData.setSaloutBillInfoList(o.getString("srcsysbillno"), o.getString("srcsysbillid"), srcsysbillentryid);
                        }
                    } else if (receivebillEntityKey.equals(srcbillentity)) {
                        String srcsysbillentryid = o.getString("srcsysbillentryid");
                        writeData.setSaloutBillInfoList(o.getString("srcsysbillno"), o.getString("srcsysbillid"), srcsysbillentryid);
                        String srcbillentryid = o.getString("srcbillentryid");
                        String entryid = o.getString("entryid");
                        if (StringUtils.isEmpty((CharSequence)srcsysbillentryid)) {
                            imInstock1Map.put(srcbillentryid, entryid);
                        } else {
                            imInOrRevMap.put(entryid, srcsysbillentryid);
                        }
                        entryIdList.add(o.getLong("srcbillentryid"));
                    }
                });
            }
            if (entityMap.containsKey(receivebillEntityKey)) {
                entryIdList.addAll(entityMap.get(receivebillEntityKey));
            }
        }
        log.info("3.\u4e0a\u6e38\u5355\u636e\u4fe1\u606fentryIdList=" + entryIdList + ";imInstock1Map=" + imInstock1Map + ";imInstockMap=" + imInstockMap + ";imInOrRevMap=" + imInOrRevMap);
        if (!entryIdList.isEmpty()) {
            String selectField = "billentry.id entryid,billentry.srcbillentity srcbillentity, billentry.srcsysbillno srcsysbillno,billentry.srcbillentryid srcbillentryid,billentry.srcsysbillid srcsysbillid,billentry.srcsysbillentryid srcsysbillentryid";
            DynamicObjectCollection im3Data = QueryServiceHelper.query((String)receivebillEntityKey, (String)selectField, (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", entryIdList)});
            log.info("3.1 \u5165\u5e93\u5355\u4e0a\u67e5\u5355\u636eim_purreceivebill\u67e5\u8be2\u6570\u91cf:" + im3Data.size());
            im3Data.forEach(dyn -> {
                String srcsysbillentryid = dyn.getString("srcsysbillentryid");
                String entryid = dyn.getString("entryid");
                if (StringUtils.isNotEmpty((CharSequence)srcsysbillentryid)) {
                    if (imInstock1Map.containsKey(entryid) && imInstockMap.containsKey(imInstock1Map.get(entryid))) {
                        imInOrRevMap.put((String)imInstockMap.get(imInstock1Map.get(entryid)), srcsysbillentryid);
                    }
                    if (imInstockMap.containsKey(entryid)) {
                        imInOrRevMap.put((String)imInstockMap.get(entryid), srcsysbillentryid);
                    } else {
                        imInOrRevMap.put(entryid, srcsysbillentryid);
                    }
                    writeData.setSaloutBillInfoList(dyn.getString("srcsysbillno"), dyn.getString("srcsysbillid"), srcsysbillentryid);
                }
            });
        }
    }
}

