/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.check;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scm.common.util.ApiConfigUtil;
import kd.scm.common.util.BatchCheckUtil;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.common.util.CheckUtils;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.MD5Util;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.common.util.check.OrderCheckUtil;

public class HandCheckUtil {
    private static Log log = LogFactory.getLog(HandCheckUtil.class);
    private static final int MAX_PUR_ENTRY_ROW = 10000;
    private static final String ALL_PUR_ENTRY_KEY = "scm_pur_allmaterialentry";
    private static final String GROUPKEY = "groupkey";
    private static final String MATERIAL_GROUPKEY = "materialgroupkey";
    private static final String CHECKSUM_ENTRY_KEY = "sumentryentity";
    private static String[] VIRTUAL_SELECTS = new String[]{"entryid", "srcinsentryid"};
    private static String[] ACT_SELECTS = new String[]{"billno", "srcentryid", "rcvorg"};

    public static Integer getMaxCheckRow(String formId, String params) {
        Integer maxCheckRow = 10000;
        try {
            Object maxCheckRowObj = ParamUtil.getBillParam((String)formId, (String)params);
            if (Objects.nonNull(maxCheckRowObj)) {
                maxCheckRow = (Integer)maxCheckRowObj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxCheckRow;
    }

    public static void put2Map(String groupKey, Map<String, List<Map<String, Object>>> map, Map<String, Object> mapdetail) {
        List<Map<String, Object>> list2 = map.get(groupKey);
        if (CollectionUtils.isEmpty(list2)) {
            list2 = new ArrayList<Map<String, Object>>(8);
        }
        list2.add(mapdetail);
        map.put(groupKey, list2);
    }

    public static List<Map<String, Object>> getAllDetailCache(IPageCache pageCache) {
        ArrayList<Map<String, Object>> lists = new ArrayList<Map<String, Object>>(8);
        List<String> groupKeyCache = HandCheckUtil.getGroupKeyCache(pageCache);
        for (String groupKey : groupKeyCache) {
            if (StringUtils.isEmpty((CharSequence)groupKey)) continue;
            List<Map<String, Object>> detailCache = HandCheckUtil.getDetailCache(pageCache, groupKey);
            lists.addAll(detailCache);
        }
        return lists;
    }

    public static void putCache(IPageCache pageCache, Map<String, List<Map<String, Object>>> map) {
        for (Map.Entry<String, List<Map<String, Object>>> entry : map.entrySet()) {
            String key = entry.getKey();
            List<Map<String, Object>> value = entry.getValue();
            String md5Key = MD5Util.encode((String)key);
            pageCache.putBigObject(ALL_PUR_ENTRY_KEY + md5Key, JacksonJsonUtil.toJSON(value));
        }
        Set<String> keySet = map.keySet();
        pageCache.put(ALL_PUR_ENTRY_KEY, JacksonJsonUtil.toJSON(keySet));
    }

    public static List<String> getGroupKeyCache(IPageCache pageCache) {
        String bigObject = pageCache.get(ALL_PUR_ENTRY_KEY);
        if (StringUtils.isEmpty((CharSequence)bigObject)) {
            return new ArrayList<String>(8);
        }
        List fromJSONList = JacksonJsonUtil.fromJSONList((String)bigObject, String.class);
        return fromJSONList;
    }

    public static List<Map<String, Object>> getDetailCache(IPageCache pageCache, String groupKey) {
        String md5Key = MD5Util.encode((String)groupKey);
        String bigObject = pageCache.getBigObject(ALL_PUR_ENTRY_KEY + md5Key);
        if (StringUtils.isEmpty((CharSequence)bigObject)) {
            return new ArrayList<Map<String, Object>>(8);
        }
        List fromJSONList = JacksonJsonUtil.fromJSONList((String)bigObject, Map.class);
        return fromJSONList;
    }

    public static void buildMatchData(AbstractFormDataModel model, IPageCache pageCache, List<DynamicObject> purDetailList, DynamicObjectCollection relationDatas, String entryKey, String[] groupKeys, String suffix) {
        if (purDetailList == null || purDetailList.size() == 0) {
            return;
        }
        String showMatchedString = pageCache.get("showmatched");
        boolean showmatched = Boolean.FALSE;
        if (showMatchedString != null && !showMatchedString.isEmpty()) {
            showmatched = Boolean.parseBoolean(showMatchedString);
        }
        String groupKey = null;
        String materialGroupKey = null;
        String[] materialGroupKeys = HandCheckUtil.getMaterialGroups();
        Map keyMap = DynamicObjectUtil.getDynamicObjectKeyMap((DynamicObject)purDetailList.get(0));
        Map<String, String> propertiesMap = HandCheckUtil.getPurEntryKeyProperties(model, entryKey);
        OrderCheckUtil.GroupDataInfo groupData = null;
        if (relationDatas != null) {
            groupData = new OrderCheckUtil.GroupDataInfo(relationDatas, "srcentryid");
        }
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>(8);
        for (DynamicObject detail : purDetailList) {
            if (null == detail) continue;
            BigDecimal unMatchQty = detail.getBigDecimal("unmatchqty");
            if (!showmatched && unMatchQty.compareTo(BigDecimal.ZERO) == 0) continue;
            HashMap<String, Object> mapdetail = new HashMap<String, Object>(8);
            for (String key : keyMap.keySet()) {
                if (null == propertiesMap.get(key + suffix)) continue;
                mapdetail.put(key + suffix, detail.get(key));
            }
            groupKey = detail.getString(GROUPKEY);
            mapdetail.put(MATERIAL_GROUPKEY + suffix, materialGroupKey);
            materialGroupKey = HandCheckUtil.getGroupKey(detail, materialGroupKeys);
            String srcEntryId = "";
            BigDecimal qty = new BigDecimal(0);
            if (detail != null) {
                srcEntryId = detail.getString("entryid");
                qty = detail.getBigDecimal("qty");
            }
            BigDecimal matchQty = BigDecimal.ZERO;
            if (groupData != null) {
                matchQty = groupData.getQty("srcentryid", srcEntryId, "qty");
            }
            if (qty.compareTo(BigDecimal.ZERO) < 0) {
                matchQty = matchQty.multiply(new BigDecimal("-1"));
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getString("materialname"))) {
                mapdetail.put("materialname" + suffix, detail.getString("materialname"));
            } else {
                mapdetail.put("materialname" + suffix, detail.getString("materialnameold"));
            }
            mapdetail.put("outqty" + suffix, matchQty);
            mapdetail.put("cfmqty" + suffix, matchQty);
            mapdetail.put("diffqty" + suffix, matchQty.subtract(qty));
            String matchDetail = "";
            if (groupData != null) {
                matchDetail = groupData.getBillNoAndQty(srcEntryId, "billno", "salQty");
            }
            if (matchDetail != null && matchDetail.length() > 255) {
                matchDetail = matchDetail.substring(0, 255);
            }
            mapdetail.put("matchdetail" + suffix, matchDetail);
            String sendBillNo = "";
            if (groupData != null) {
                sendBillNo = groupData.getBillNo(srcEntryId, "billno");
            }
            if (sendBillNo != null && sendBillNo.length() > 255) {
                sendBillNo = sendBillNo.substring(0, 255);
            }
            mapdetail.put("outbillno" + suffix, sendBillNo);
            if (matchQty.compareTo(qty) == 0) {
                mapdetail.put("checkstatus" + suffix, "1");
            } else {
                mapdetail.put("checkstatus" + suffix, "2");
            }
            HandCheckUtil.recalTaxAmountToMap(mapdetail, detail, qty, matchQty, suffix);
            HandCheckUtil.put2Map(groupKey, map, mapdetail);
        }
        HandCheckUtil.putCache(pageCache, map);
    }

    public static void buildUnMatchData(AbstractFormDataModel model, IPageCache pageCache, List<DynamicObject> purDetailList, String entryKey, String[] groupKeys, String suffix) {
        if (purDetailList == null || purDetailList.size() == 0) {
            return;
        }
        String showMatchedString = pageCache.get("showmatched");
        boolean showmatched = Boolean.FALSE;
        if (showMatchedString != null && !showMatchedString.isEmpty()) {
            showmatched = Boolean.parseBoolean(showMatchedString);
        }
        String groupKey = null;
        String materialGroupKey = null;
        String[] materialGroupKeys = HandCheckUtil.getMaterialGroups();
        Map keyMap = DynamicObjectUtil.getDynamicObjectKeyMap((DynamicObject)purDetailList.get(0));
        Map<String, String> propertiesMap = HandCheckUtil.getPurEntryKeyProperties(model, entryKey);
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>(8);
        for (DynamicObject detail : purDetailList) {
            if (null == detail) continue;
            BigDecimal unMatchQty = detail.getBigDecimal("unmatchqty");
            if (!showmatched && unMatchQty.compareTo(BigDecimal.ZERO) == 0) continue;
            HashMap<String, Object> mapdetail = new HashMap<String, Object>(8);
            for (String key : keyMap.keySet()) {
                if (null == propertiesMap.get(key + suffix)) continue;
                mapdetail.put(key + suffix, detail.get(key));
            }
            if (StringUtils.isNotBlank((CharSequence)detail.getString("materialname"))) {
                mapdetail.put("materialname" + suffix, detail.getString("materialname"));
            } else {
                mapdetail.put("materialname" + suffix, detail.getString("materialnameold"));
            }
            groupKey = detail.getString(GROUPKEY);
            mapdetail.put(MATERIAL_GROUPKEY + suffix, materialGroupKey);
            materialGroupKey = HandCheckUtil.getGroupKey(detail, materialGroupKeys);
            BigDecimal qty = new BigDecimal(0);
            if (detail != null) {
                qty = detail.getBigDecimal("qty");
            }
            HandCheckUtil.recalTaxAmountToMap(mapdetail, detail, qty, qty, suffix);
            mapdetail.put("cfmqty" + suffix, qty);
            mapdetail.put("checkstatus" + suffix, "1");
            HandCheckUtil.put2Map(groupKey, map, mapdetail);
        }
        HandCheckUtil.putCache(pageCache, map);
    }

    public static void fillMatchData(IDataModel model, List<Map<String, Object>> detailCache, String suffix, boolean isPurApp) {
        HashMap<String, BigDecimal> qtyData = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> taxAmtData = new HashMap<String, BigDecimal>();
        String qtyKey = null;
        String taxAmountKey = null;
        if (!isPurApp) {
            qtyKey = "inqty";
            taxAmountKey = "intaxamount";
        } else {
            qtyKey = "outqty";
            taxAmountKey = "outtaxamount";
        }
        log.info("###batchCheck \u6784\u9020\u53d1\u8d27\u6c47\u603b\u6570\u636e\uff0c\u6570\u636e\u5927\u5c0f\uff1a" + detailCache.size());
        for (Map<String, Object> detail : detailCache) {
            String groupKey;
            Object groupKeyObj = detail.get(GROUPKEY + suffix);
            if (groupKeyObj == null || StringUtils.isEmpty((CharSequence)(groupKey = (String)groupKeyObj))) continue;
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)detail.get(qtyKey + suffix));
            BigDecimal taxamt = CommonUtil.getBigDecimalPro((Object)detail.get(taxAmountKey + suffix));
            BigDecimal qtyDataBd = (BigDecimal)qtyData.get(groupKey);
            if (qtyDataBd != null) {
                qtyData.put(groupKey, qtyDataBd.add(qty));
            } else {
                qtyData.put(groupKey, qty);
            }
            BigDecimal taxAmtDataBd = (BigDecimal)taxAmtData.get(groupKey);
            if (taxAmtDataBd != null) {
                taxAmtData.put(groupKey, taxAmtDataBd.add(taxamt));
                continue;
            }
            taxAmtData.put(groupKey, taxamt);
        }
        log.info("###batchCheck \u6784\u9020\u53d1\u8d27\u6c47\u603b\u6570\u636e\uff0c\u6c47\u603b\u6570\u636e\uff1a" + taxAmtData);
        BatchCheckUtil.fillMatchRowData(model, qtyData, taxAmtData, CHECKSUM_ENTRY_KEY, "", qtyKey, taxAmountKey, "1", isPurApp);
    }

    private static String[] getMaterialGroups() {
        return new String[]{"srcentryid"};
    }

    public static String getGroupKey(DynamicObject obj, String[] groupBys) {
        if (null == obj) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String group : groupBys) {
            if (obj.get(group) instanceof DynamicObject) {
                sb.append(((DynamicObject)obj.get(group)).getPkValue()).append('-');
                continue;
            }
            sb.append(obj.get(group)).append('-');
        }
        return sb.toString();
    }

    private static void recalTaxAmountToMap(Map<String, Object> mapdetail, DynamicObject detail, BigDecimal qty, BigDecimal matchQty, String suffix) {
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal diffAmount = BigDecimal.ZERO;
        taxAmount = detail.getBigDecimal("taxamount");
        if (qty.compareTo(matchQty) != 0) {
            int amtPrecision = 6;
            int pricePrecision = 6;
            if (detail.getInt("amtprecision") > 0) {
                amtPrecision = detail.getInt("amtprecision");
            }
            if (detail.getInt("priceprecision") > 0) {
                pricePrecision = detail.getInt("priceprecision");
            }
            BigDecimal taxPrice = detail.getBigDecimal("taxprice");
            taxPrice = taxPrice.setScale(pricePrecision, RoundingMode.HALF_UP);
            BigDecimal dcRate = detail.getBigDecimal("dctrate");
            BigDecimal matchAmount = CalculateUtils.calTaxAmountByDiscountPercent((BigDecimal)matchQty, (BigDecimal)taxPrice, (BigDecimal)dcRate, (int)amtPrecision);
            diffAmount = matchAmount.subtract(taxAmount);
            taxAmount = matchAmount;
        }
        mapdetail.put("outtaxamount" + suffix, taxAmount);
        mapdetail.put("cfmamt" + suffix, taxAmount);
        mapdetail.put("diffamt" + suffix, diffAmount);
    }

    private static Map<String, String> getPurEntryKeyProperties(AbstractFormDataModel model, String entryKey) {
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntryEntity(entryKey).getDynamicObjectType());
        HashMap<String, String> propertiesMap = new HashMap<String, String>((int)((double)propertiesentity.size() / 0.75));
        for (String property : propertiesentity) {
            propertiesMap.put(property, property);
        }
        return propertiesMap;
    }

    public static void buildVirtualData(List<Map<String, Object>> allDetails, String entityKey, String suffix) {
        if (CollectionUtils.isEmpty(allDetails)) {
            return;
        }
        ArrayList<String> poEntryIdList = new ArrayList<String>();
        for (Map<String, Object> detail : allDetails) {
            Object poentryId;
            String srcBillType = String.valueOf(detail.get("srcbilltype" + suffix));
            if (!entityKey.equals(srcBillType) || (poentryId = detail.get("poentryid" + suffix)) == null) continue;
            poEntryIdList.add((String)poentryId);
        }
        Map<String, DynamicObject> entryId_dataMap = HandCheckUtil.getEntryIdDataMap(entityKey, poEntryIdList);
        if (entryId_dataMap == null || entryId_dataMap.size() == 0) {
            return;
        }
        for (Map<String, Object> detail : allDetails) {
            Object rcvOrg;
            String entryId;
            DynamicObject data;
            String srcBillType = String.valueOf(detail.get("srcbilltype" + suffix));
            if (!entityKey.equals(srcBillType) || null == (data = entryId_dataMap.get(entryId = String.valueOf(detail.get("entryid" + suffix)))) || null == (rcvOrg = data.get("rcvorg")) || rcvOrg.toString().equals("0")) continue;
            detail.put("invorg" + suffix, rcvOrg);
            detail.put("actbillno" + suffix, data.get("billno"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, DynamicObject> getEntryIdDataMap(String entityKey, List<String> poEntryIdList) {
        HashMap<String, DynamicObject> entryId_dataMap = new HashMap<String, DynamicObject>();
        DynamicObjectCollection dataCols = null;
        DataSet unionData = null;
        DataSet srcinsentryidDataSet = null;
        DataSet srcentryidDataSet = null;
        try {
            StringBuilder selectFields = new StringBuilder();
            selectFields.append("billno,org rcvorg,materialentry.id entryid,materialentry.srcentryid srcentryid").append(",materialentry.srcinsentryid srcinsentryid");
            QFilter filter = new QFilter("materialentry.poentryid", "in", poEntryIdList);
            filter.and(QFilter.of((String)"materialentry.srcinsentryid is not null", (Object[])new Object[0])).and(QFilter.of((String)"materialentry.srcinsentryid!=''", (Object[])new Object[0])).and(QFilter.of((String)"materialentry.srcinsentryid!=' '", (Object[])new Object[0]));
            srcinsentryidDataSet = QueryServiceHelper.queryDataSet((String)"srcinsentryidBuildVirtualData", (String)entityKey, (String)selectFields.toString(), (QFilter[])new QFilter[]{filter}, null);
            QFilter srcentryidFilter = new QFilter("materialentry.poentryid", "in", poEntryIdList);
            srcentryidFilter.and(QFilter.of((String)"materialentry.srcentryid is not null", (Object[])new Object[0])).and(QFilter.of((String)"materialentry.srcentryid!=''", (Object[])new Object[0])).and(QFilter.of((String)"materialentry.srcentryid!=' '", (Object[])new Object[0]));
            srcentryidDataSet = QueryServiceHelper.queryDataSet((String)"srcentryidBuildVirtualData", (String)entityKey, (String)selectFields.toString(), (QFilter[])new QFilter[]{srcentryidFilter}, null);
            JoinDataSet joinDataSet = srcinsentryidDataSet.join(srcentryidDataSet, JoinType.LEFT);
            joinDataSet.on("srcinsentryid", "srcentryid");
            joinDataSet.select(VIRTUAL_SELECTS, ACT_SELECTS);
            unionData = joinDataSet.finish();
            dataCols = ORM.create().toPlainDynamicObjectCollection(unionData);
        }
        finally {
            if (null != srcinsentryidDataSet) {
                srcinsentryidDataSet.close();
            }
            if (null != srcentryidDataSet) {
                srcentryidDataSet.close();
            }
            if (null != unionData) {
                unionData.close();
            }
        }
        if (dataCols.size() == 0) {
            return entryId_dataMap;
        }
        for (DynamicObject dataCol : dataCols) {
            Object srcInsEntryId = dataCol.get("srcinsentryid");
            if (null == srcInsEntryId || srcInsEntryId.toString().trim().length() == 0) continue;
            entryId_dataMap.put(String.valueOf(dataCol.get("entryid")), dataCol);
        }
        return entryId_dataMap;
    }

    public static void buildVirtualData(IDataModel model, String entityKey, String entryKey) {
        String srcBillType;
        DynamicObjectCollection cols = model.getEntryEntity(entryKey);
        if (cols == null || cols.size() == 0) {
            return;
        }
        ArrayList<String> poEntryIdList = new ArrayList<String>();
        for (DynamicObject col : cols) {
            srcBillType = col.getString("srcbilltype4");
            if (!entityKey.equals(srcBillType)) continue;
            poEntryIdList.add(col.getString("poentryid4"));
        }
        Map<String, DynamicObject> entryId_dataMap = HandCheckUtil.getEntryIdDataMap(entityKey, poEntryIdList);
        if (entryId_dataMap == null || entryId_dataMap.size() == 0) {
            return;
        }
        model.beginInit();
        for (int i = 0; i < cols.size(); ++i) {
            Object rcvOrg;
            String entryId;
            DynamicObject data;
            srcBillType = ((DynamicObject)cols.get(i)).getString("srcbilltype4");
            if (!entityKey.equals(srcBillType) || null == (data = entryId_dataMap.get(entryId = ((DynamicObject)cols.get(i)).getString("entryid4"))) || null == (rcvOrg = data.get("rcvorg")) || rcvOrg.toString().equals("0")) continue;
            model.setValue("invorg4", rcvOrg, i);
            model.setValue("actbillno4", data.get("billno"), i);
        }
        model.endInit();
    }

    public static void writeBackSrcBill(DynamicObject[] checkObjs, String operate, String entryKey, String suffix) {
        ArrayList<Long> negativeBillIdList = new ArrayList<Long>(1024);
        ArrayList<Long> billIdList = new ArrayList<Long>();
        ArrayList<Long> entryIdList = new ArrayList<Long>();
        HashMap<Long, BigDecimal> confirmQtyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> confirmAmtMap = new HashMap<Long, BigDecimal>();
        HashSet<String> srcBillTypeSet = new HashSet<String>();
        for (DynamicObject checkObj : checkObjs) {
            negativeBillIdList.clear();
            billIdList.clear();
            entryIdList.clear();
            confirmQtyMap.clear();
            confirmAmtMap.clear();
            srcBillTypeSet.clear();
            DynamicObjectCollection entrys = checkObj.getDynamicObjectCollection(entryKey);
            for (DynamicObject entry : entrys) {
                String srcBillIdStr = entry.getString("srcbillid" + suffix);
                String srcEntryIdStr = entry.getString("srcentryid" + suffix);
                String srcBillType = entry.getString("srcbilltype" + suffix);
                if (!CheckUtils.isPurInstock((String)srcBillType) && !CheckUtils.isPurReciept((String)srcBillType) || null == srcBillType || srcBillType.isEmpty()) continue;
                srcBillTypeSet.add(entry.getString("srcbilltype" + suffix));
                if (srcBillIdStr != null && !srcBillIdStr.trim().isEmpty()) {
                    billIdList.add(Long.valueOf(srcBillIdStr));
                }
                if (srcEntryIdStr == null || srcEntryIdStr.trim().isEmpty()) continue;
                Long srcEntryId = Long.valueOf(srcEntryIdStr);
                entryIdList.add(srcEntryId);
                BigDecimal qty = BigDecimal.ZERO;
                BigDecimal taxAmount = BigDecimal.ZERO;
                taxAmount = CommonUtil.getBigDecimalPro((Object)entry.get("taxamount" + suffix)).abs();
                qty = CommonUtil.getBigDecimalPro((Object)entry.get("qty" + suffix)).abs();
                if (CommonUtil.getBigDecimalPro((Object)entry.get("qty" + suffix)).compareTo(BigDecimal.ZERO) < 0) {
                    negativeBillIdList.add(Long.valueOf(srcBillIdStr));
                }
                if (confirmQtyMap.get(srcEntryId) != null) {
                    confirmQtyMap.put(srcEntryId, qty.add((BigDecimal)confirmQtyMap.get(srcEntryId)));
                } else {
                    confirmQtyMap.put(srcEntryId, qty);
                }
                if (confirmAmtMap.get(srcEntryId) != null) {
                    confirmAmtMap.put(srcEntryId, taxAmount.add((BigDecimal)confirmAmtMap.get(srcEntryId)));
                    continue;
                }
                confirmAmtMap.put(srcEntryId, taxAmount);
            }
            for (String srcBillType : srcBillTypeSet) {
                BatchCheckUtil.writeBackSrcBill(srcBillType, billIdList, entryIdList, confirmQtyMap, confirmAmtMap, operate, negativeBillIdList);
            }
        }
    }

    public static Map<String, Object> getVerifyRowMessage(List<DynamicObject> cols, String suffix) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        if (ApiConfigUtil.hasCQScmConfig()) {
            HashSet<Long> acceptEntryIds = new HashSet<Long>(cols.size());
            HashSet<Long> acceptBillIds = new HashSet<Long>(cols.size());
            HashSet<Long> rcvEntryIds = new HashSet<Long>(cols.size());
            HashSet<Long> rcvBillIds = new HashSet<Long>(cols.size());
            HashSet<Long> inEntryIds = new HashSet<Long>(cols.size());
            HashSet<Long> inBillIds = new HashSet<Long>(cols.size());
            HashSet<Long> pmomInEntryIds = new HashSet<Long>(cols.size());
            HashSet<Long> pmomInBillIds = new HashSet<Long>(cols.size());
            HashSet<Long> returnEntryIds = new HashSet<Long>(cols.size());
            HashSet<Long> returnBillIds = new HashSet<Long>(cols.size());
            HashSet<Long> recReturnEntryIds = new HashSet<Long>(cols.size());
            HashSet<Long> recReturnBillIds = new HashSet<Long>(cols.size());
            HashMap<Long, Long> verifyEntryIdsOfSrcEntryid = new HashMap<Long, Long>(cols.size());
            for (DynamicObject obj : cols) {
                DynamicObject value;
                String srcbilltype = obj.getString("srcbilltype" + suffix);
                DynamicProperty linetype1 = obj.getDynamicObjectType().getProperty("linetype" + suffix);
                if (!StringUtils.isNotBlank((CharSequence)srcbilltype)) continue;
                String inOrRcvEntryId = obj.getString("srcentryid" + suffix);
                String inOrRecBillId = obj.getString("srcbillid" + suffix);
                String entryid = obj.getString("entryid" + suffix);
                DynamicObject businesstype_in3 = obj.getDynamicObject("businesstype_in" + suffix);
                if (HandCheckUtil.checkIsGoodsBizType(businesstype_in3)) continue;
                if ("pur_receipt".equals(srcbilltype) || "scp_receipt".equals(srcbilltype)) {
                    if (linetype1 != null) {
                        value = (DynamicObject)linetype1.getValue((Object)obj);
                        if (value != null && value.getBoolean("acceptance")) {
                            if (StringUtils.isNotBlank((CharSequence)inOrRcvEntryId)) {
                                acceptEntryIds.add(Long.valueOf(inOrRcvEntryId));
                            }
                            if (StringUtils.isNotBlank((CharSequence)inOrRecBillId)) {
                                acceptBillIds.add(Long.valueOf(inOrRecBillId));
                            }
                        } else {
                            if (StringUtils.isNotBlank((CharSequence)inOrRcvEntryId)) {
                                rcvEntryIds.add(Long.valueOf(inOrRcvEntryId));
                            }
                            if (StringUtils.isNotBlank((CharSequence)inOrRecBillId)) {
                                rcvBillIds.add(Long.valueOf(inOrRecBillId));
                            }
                        }
                    } else {
                        if (StringUtils.isNotBlank((CharSequence)inOrRcvEntryId)) {
                            rcvEntryIds.add(Long.valueOf(inOrRcvEntryId));
                        }
                        if (StringUtils.isNotBlank((CharSequence)inOrRecBillId)) {
                            rcvBillIds.add(Long.valueOf(inOrRecBillId));
                        }
                    }
                } else if ("pur_instock".equals(srcbilltype) || "scp_instock".equals(srcbilltype)) {
                    if (BussinessTypeUtils.checkOmBussinessType(businesstype_in3)) {
                        if (StringUtils.isNotBlank((CharSequence)inOrRcvEntryId)) {
                            pmomInEntryIds.add(Long.valueOf(inOrRcvEntryId));
                        }
                        if (StringUtils.isNotBlank((CharSequence)inOrRecBillId)) {
                            pmomInBillIds.add(Long.valueOf(inOrRecBillId));
                        }
                    } else {
                        if (StringUtils.isNotBlank((CharSequence)inOrRcvEntryId)) {
                            inEntryIds.add(Long.valueOf(inOrRcvEntryId));
                        }
                        if (StringUtils.isNotBlank((CharSequence)inOrRecBillId)) {
                            inBillIds.add(Long.valueOf(inOrRecBillId));
                        }
                    }
                } else if ("pur_return".equals(srcbilltype) || "scp_return".equals(srcbilltype)) {
                    if (StringUtils.isNotBlank((CharSequence)inOrRcvEntryId)) {
                        returnEntryIds.add(Long.valueOf(inOrRcvEntryId));
                    }
                    if (StringUtils.isNotBlank((CharSequence)inOrRecBillId)) {
                        returnBillIds.add(Long.valueOf(inOrRecBillId));
                    }
                } else if ("pur_receipt_return".equals(srcbilltype) || "scp_return_receipt".equals(srcbilltype)) {
                    if (linetype1 != null) {
                        value = (DynamicObject)linetype1.getValue((Object)obj);
                        if (value != null && value.getBoolean("acceptance")) {
                            if (StringUtils.isNotBlank((CharSequence)inOrRcvEntryId)) {
                                acceptEntryIds.add(Long.valueOf(inOrRcvEntryId));
                            }
                            if (StringUtils.isNotBlank((CharSequence)inOrRecBillId)) {
                                acceptBillIds.add(Long.valueOf(inOrRecBillId));
                            }
                        } else {
                            if (StringUtils.isNotBlank((CharSequence)inOrRcvEntryId)) {
                                recReturnEntryIds.add(Long.valueOf(inOrRcvEntryId));
                            }
                            if (StringUtils.isNotBlank((CharSequence)inOrRecBillId)) {
                                recReturnBillIds.add(Long.valueOf(inOrRecBillId));
                            }
                        }
                    } else {
                        if (StringUtils.isNotBlank((CharSequence)inOrRcvEntryId)) {
                            recReturnEntryIds.add(Long.valueOf(inOrRcvEntryId));
                        }
                        if (StringUtils.isNotBlank((CharSequence)inOrRecBillId)) {
                            recReturnBillIds.add(Long.valueOf(inOrRecBillId));
                        }
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)entryid) || !StringUtils.isNotBlank((CharSequence)inOrRcvEntryId)) continue;
                verifyEntryIdsOfSrcEntryid.put(Long.valueOf(entryid), Long.valueOf(inOrRcvEntryId));
            }
            if (!rcvEntryIds.isEmpty() && !rcvBillIds.isEmpty()) {
                HandCheckUtil.verifyUpdateResultMessage(resultMap, "im_purreceivebill", rcvBillIds);
                HandCheckUtil.cosmicUpdateResultMessage(resultMap, "im_purreceivebill", rcvBillIds, rcvEntryIds, verifyEntryIdsOfSrcEntryid);
            }
            if (!acceptEntryIds.isEmpty() && !acceptBillIds.isEmpty()) {
                HandCheckUtil.verifyUpdateResultMessage(resultMap, "pm_puracceptbill", acceptBillIds);
                HandCheckUtil.cosmicUpdateResultMessage(resultMap, "pm_puracceptbill", acceptBillIds, acceptEntryIds, verifyEntryIdsOfSrcEntryid);
            }
            if (!inBillIds.isEmpty() && !inEntryIds.isEmpty()) {
                HandCheckUtil.verifyUpdateResultMessage(resultMap, "im_purinbill", inBillIds);
                HandCheckUtil.cosmicUpdateResultMessage(resultMap, "im_purinbill", inBillIds, inEntryIds, verifyEntryIdsOfSrcEntryid);
            }
            if (!pmomInBillIds.isEmpty() && !pmomInEntryIds.isEmpty()) {
                HandCheckUtil.verifyUpdateResultMessage(resultMap, "im_mdc_omcmplinbill", pmomInBillIds);
                HandCheckUtil.cosmicUpdateResultMessage(resultMap, "im_mdc_omcmplinbill", pmomInBillIds, pmomInEntryIds, verifyEntryIdsOfSrcEntryid);
            }
            if (!returnBillIds.isEmpty() && !returnEntryIds.isEmpty()) {
                HandCheckUtil.verifyUpdateResultMessage(resultMap, "im_purinbill", returnBillIds);
                HandCheckUtil.cosmicUpdateResultMessage(resultMap, "im_purinbill", returnBillIds, returnEntryIds, verifyEntryIdsOfSrcEntryid);
            }
            if (recReturnBillIds.isEmpty() && !recReturnEntryIds.isEmpty()) {
                HandCheckUtil.verifyUpdateResultMessage(resultMap, "im_purreceivebill", recReturnBillIds);
                HandCheckUtil.cosmicUpdateResultMessage(resultMap, "im_purreceivebill", recReturnBillIds, recReturnEntryIds, verifyEntryIdsOfSrcEntryid);
            }
        }
        return resultMap;
    }

    private static void verifyUpdateResultMessage(Map<String, Object> resultMap, String entityNumber, Set<Long> billIds) {
        try {
            Boolean verifyStatus = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"CheckVerifyResultService", (String)"isVerifying", (Object[])new Object[]{entityNumber, billIds});
            if (verifyStatus.booleanValue()) {
                resultMap.put("succed", Boolean.FALSE);
                String message = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u8d26\u5355\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c", (String)"HandCheckUtil_1", (String)"scm-common", (Object[])new Object[0]);
                resultMap.put("message", message);
            }
        }
        catch (Exception e) {
            resultMap.put("succed", Boolean.FALSE);
            String message = ResManager.loadKDString((String)"\u68c0\u67e5\u6570\u636e\u662f\u5426\u53ef\u4ee5\u751f\u6210\u5bf9\u8d26\u5355\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"HandCheckUtil_0", (String)"scm-common", (Object[])new Object[0]);
            resultMap.put("message", message);
        }
    }

    private static void cosmicUpdateResultMessage(Map<String, Object> resultMap, String entityNumber, Set<Long> billIds, Set<Long> entryIds, Map<Long, Long> verifyEntryIds) {
        String message = ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u8d26\u5355\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c", (String)"HandCheckUtil_1", (String)"scm-common", (Object[])new Object[0]);
        log.info("kd.scm.common.util.check.HandCheckUtil.cosmicUpdateResultMessage#billIds" + billIds);
        log.info("kd.scm.common.util.check.HandCheckUtil.cosmicUpdateResultMessage#entryIds" + entryIds);
        log.info("kd.scm.common.util.check.HandCheckUtil.cosmicUpdateResultMessage#verifyEntryIds" + verifyEntryIds);
        List revRowList = BFTrackerServiceHelper.loadTargetRowIds((String)entityNumber, (String)"billentry", (Long[])billIds.toArray(new Long[0]), (Long[])entryIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        if (revRowList.size() >= entryIds.size() && !revRowList.isEmpty()) {
            for (BFRow bfRow : revRowList) {
                if (!entryIds.contains(bfRow.getSId().getEntryId())) continue;
                Long checkSEntry = verifyEntryIds.get(bfRow.getId().getEntryId());
                Long sEntryId = bfRow.getSId().getEntryId();
                if (checkSEntry != null && !checkSEntry.equals(sEntryId)) {
                    resultMap.put("succed", Boolean.FALSE);
                    resultMap.put("message", message);
                    continue;
                }
                if (checkSEntry == null || !checkSEntry.equals(sEntryId)) continue;
                resultMap.put("succed", Boolean.TRUE);
                resultMap.put("message", "");
            }
        } else {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", message);
        }
    }

    private static boolean checkIsGoodsBizType(DynamicObject bizType) {
        if (!Objects.isNull(bizType) && StringUtils.isNotBlank((CharSequence)bizType.getString("number"))) {
            return bizType.getString("number").startsWith("140");
        }
        return false;
    }
}

