/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.common.util.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CheckUtils;

public class RelateInvoiceWriteBackUtil {
    public static final Boolean ADD_OP = Boolean.TRUE;
    public static final Boolean DEL_OP = Boolean.FALSE;
    public static final String FROM_CHECK_OP = "from_check_op";
    public static final String FROM_INVOICE_OP = "from_invoice_op";
    private static Log log = LogFactory.getLog(RelateInvoiceWriteBackUtil.class);

    public static void writeBackInvoiceAmtAndQty(List<DynamicObject> dyoList, Boolean flag, String srcOp) {
        if (null == dyoList || 0 == dyoList.size()) {
            log.info("method:RelateInvoiceWriteBackUtil.writeBackInvoiceAmtAndQty dyoList is null");
            return;
        }
        HashMap<String, Map<String, BigDecimal>> claimMap = new HashMap<String, Map<String, BigDecimal>>(8);
        for (DynamicObject dyo : dyoList) {
            DynamicObjectCollection cols;
            Object srcEntryId;
            DynamicObjectCollection dyoCol;
            HashMap inOrRevMap = new HashMap(1024);
            String entityKey = dyo.getDataEntityType().getName();
            String entryEntityName = "entryentity1";
            boolean isPurCheckFlag = false;
            if (null != entityKey && "pur_check".equals(entityKey)) {
                entryEntityName = "materialentry";
                isPurCheckFlag = true;
            }
            if (null == (dyoCol = dyo.getDynamicObjectCollection(entryEntityName)) || dyoCol.size() == 0) continue;
            ArrayList<Object> srcEntryIds = new ArrayList<Object>(1024);
            ArrayList<String> existCheckEntryIds = new ArrayList<String>(1024);
            String proIndex = isPurCheckFlag ? "" : "1";
            for (Object temp : dyoCol) {
                BigDecimal oldInvoiceEntryTaxAmount;
                String srcBillType = temp.getString("srcbilltype" + proIndex);
                if (StringUtils.isEmpty((CharSequence)srcBillType)) continue;
                srcEntryId = temp.getString("srcentryid" + proIndex);
                if (CheckUtils.isPurInstock((String)srcBillType) || CheckUtils.isPurReciept((String)srcBillType)) {
                    BigDecimal oldInvoiceEntryQty;
                    BigDecimal invoiceQty = temp.getBigDecimal("qty" + proIndex);
                    srcEntryIds.add(srcEntryId);
                    HashMap<Object, BigDecimal> inOrRevEntryMap = (HashMap<Object, BigDecimal>)inOrRevMap.get(srcBillType);
                    if (null == inOrRevEntryMap) {
                        inOrRevEntryMap = new HashMap<Object, BigDecimal>(1024);
                    }
                    oldInvoiceEntryQty = null == (oldInvoiceEntryQty = (BigDecimal)inOrRevEntryMap.get(srcEntryId)) ? invoiceQty : oldInvoiceEntryQty.add(invoiceQty);
                    inOrRevEntryMap.put(srcEntryId, oldInvoiceEntryQty);
                    inOrRevMap.put(srcBillType, inOrRevEntryMap);
                    continue;
                }
                if (!"pur_claim".equals(srcBillType) && !"scp_claim".equals(srcBillType)) continue;
                String srcbillid = temp.getString("srcBillId" + proIndex);
                BigDecimal actchecktaxamount = temp.getBigDecimal("actchecktaxamount").abs();
                HashMap<Object, BigDecimal> claimEntryMap = (HashMap<Object, BigDecimal>)claimMap.get(srcbillid);
                if (null == claimEntryMap) {
                    claimEntryMap = new HashMap<Object, BigDecimal>(8);
                }
                oldInvoiceEntryTaxAmount = null == (oldInvoiceEntryTaxAmount = (BigDecimal)claimEntryMap.get(srcEntryId)) ? actchecktaxamount : oldInvoiceEntryTaxAmount.add(actchecktaxamount);
                claimEntryMap.put(srcEntryId, oldInvoiceEntryTaxAmount);
                claimMap.put(srcbillid, claimEntryMap);
            }
            if (StringUtils.isNotBlank((CharSequence)srcOp) && FROM_INVOICE_OP.equals(srcOp) && null != (cols = QueryServiceHelper.query((String)"pur_check", (String)"materialentry.srcentryid srcentryid", (QFilter[])new QFilter[]{new QFilter("materialentry.srcentryid", "in", srcEntryIds)})) && cols.size() > 0) {
                Object temp;
                temp = cols.iterator();
                while (temp.hasNext()) {
                    DynamicObject temp2 = (DynamicObject)temp.next();
                    srcEntryId = temp2.get("srcentryid");
                    if (null == srcEntryId) continue;
                    existCheckEntryIds.add(srcEntryId.toString());
                }
            }
            RelateInvoiceWriteBackUtil.writeBackPurClaim(claimMap, flag, srcOp);
            for (Map.Entry tempMap : inOrRevMap.entrySet()) {
                RelateInvoiceWriteBackUtil.writeBack((String)tempMap.getKey(), (HashMap)tempMap.getValue(), existCheckEntryIds, flag);
            }
        }
    }

    private static void writeBack(String entityKey, HashMap<String, BigDecimal> writeBackMap, List<String> unWriteList, Boolean flag) {
        Set idList;
        QFilter filter;
        String queryStr;
        DynamicObject[] dyoList;
        if (StringUtils.isEmpty((CharSequence)entityKey)) {
            log.info("RelateInvoiceWriteBackUtil.writeBack method failed to execute, cause by empty entityKey");
            return;
        }
        if (null == writeBackMap || writeBackMap.size() == 0) {
            log.info("RelateInvoiceWriteBackUtil.writeBack method failed to execute, cause by empty writeBackMap");
            return;
        }
        Set<String> ids = writeBackMap.keySet();
        if (null != unWriteList && unWriteList.size() > 0) {
            ids.removeAll(unWriteList);
        }
        if (null == (dyoList = BusinessDataServiceHelper.load((String)entityKey, (String)(queryStr = "billno,billstatus,materialentry.id, materialentry.qty,materialentry.suminvoiceqty"), (QFilter[])new QFilter[]{filter = new QFilter("materialentry.id", "in", idList = ids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet()))})) || dyoList.length == 0) {
            log.info("RelateInvoiceWriteBackUtil.writeBack method failed to execute, cause by empty db query result");
            return;
        }
        for (DynamicObject temp : dyoList) {
            DynamicObjectCollection cols = temp.getDynamicObjectCollection("materialentry");
            if (null == cols || cols.size() == 0) continue;
            for (DynamicObject col : cols) {
                BigDecimal oldQty = col.getBigDecimal("suminvoiceqty");
                BigDecimal totalQty = col.getBigDecimal("qty").abs();
                String entryId = col.getString("id");
                BigDecimal originalQty = writeBackMap.get(entryId);
                if (null == originalQty || originalQty.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal qty = BigDecimal.ZERO;
                qty = originalQty.abs();
                if (ADD_OP.equals(flag)) {
                    if (null != qty) {
                        oldQty = oldQty.add(qty);
                    }
                } else if (DEL_OP.equals(flag)) {
                    if (null != qty) {
                        oldQty = oldQty.subtract(qty);
                    }
                    if (oldQty.compareTo(BigDecimal.ZERO) < 0) {
                        oldQty = BigDecimal.ZERO;
                    }
                }
                if (totalQty.compareTo(oldQty) < 0) continue;
                col.set("suminvoiceqty", (Object)oldQty);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dyoList);
    }

    private static void writeBackPurClaim(Map<String, Map<String, BigDecimal>> claimMap, Boolean flag, String srcOp) {
        DynamicObject[] dyoList;
        if (CollectionUtils.isEmpty(claimMap)) {
            log.info("RelateInvoiceWriteBackUtil.writeBack method failed to execute, cause by empty claimMap");
            return;
        }
        Set ids = claimMap.keySet().stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", ids);
        String queryStr = "id,billno,billstatus,sumtaxamount,checksumtaxamount,invsumtaxamount,materialentry.id,materialentry.claimtaxamount,materialentry.checktaxamount,materialentry.invoicetaxamount";
        for (DynamicObject temp : dyoList = BusinessDataServiceHelper.load((String)"pur_claim", (String)queryStr, (QFilter[])new QFilter[]{filter})) {
            BigDecimal claimtaxamount;
            BigDecimal originalEntryAmount;
            String entryId;
            BigDecimal sumtaxamount;
            String idStr = temp.getString("id");
            Map<String, BigDecimal> writeBackMap = claimMap.get(idStr);
            DynamicObjectCollection cols = temp.getDynamicObjectCollection("materialentry");
            BigDecimal originalAmount = BigDecimal.ZERO;
            Collection<BigDecimal> values = writeBackMap.values();
            for (BigDecimal decimal : values) {
                originalAmount = originalAmount.add(decimal);
            }
            if (null == originalAmount || originalAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            if (StringUtils.isNotBlank((CharSequence)srcOp) && FROM_CHECK_OP.equals(srcOp)) {
                BigDecimal oldCheckSumTaxAmount = temp.getBigDecimal("checksumtaxamount");
                sumtaxamount = temp.getBigDecimal("sumtaxamount");
                oldCheckSumTaxAmount = RelateInvoiceWriteBackUtil.calTaxAmount(flag, originalAmount, oldCheckSumTaxAmount, sumtaxamount);
                temp.set("checksumtaxamount", (Object)oldCheckSumTaxAmount);
                for (DynamicObject col : cols) {
                    entryId = col.getString("id");
                    originalEntryAmount = writeBackMap.get(entryId);
                    if (null == originalEntryAmount || originalEntryAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal oldChecktaxamount = col.getBigDecimal("checktaxamount");
                    claimtaxamount = col.getBigDecimal("claimtaxamount");
                    oldChecktaxamount = RelateInvoiceWriteBackUtil.calTaxAmount(flag, originalEntryAmount, oldChecktaxamount, claimtaxamount);
                    col.set("checktaxamount", (Object)oldChecktaxamount);
                }
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)srcOp) || !FROM_INVOICE_OP.equals(srcOp)) continue;
            BigDecimal oldInvSumTaxAmount = temp.getBigDecimal("invsumtaxamount");
            sumtaxamount = temp.getBigDecimal("sumtaxamount");
            oldInvSumTaxAmount = RelateInvoiceWriteBackUtil.calTaxAmount(flag, originalAmount, oldInvSumTaxAmount, sumtaxamount);
            temp.set("invsumtaxamount", (Object)oldInvSumTaxAmount);
            for (DynamicObject col : cols) {
                entryId = col.getString("id");
                originalEntryAmount = writeBackMap.get(entryId);
                if (null == originalEntryAmount || originalEntryAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal oldInvoiceTaxAmount = col.getBigDecimal("invoicetaxamount");
                claimtaxamount = col.getBigDecimal("claimtaxamount");
                oldInvoiceTaxAmount = RelateInvoiceWriteBackUtil.calTaxAmount(flag, originalEntryAmount, oldInvoiceTaxAmount, claimtaxamount);
                col.set("invoicetaxamount", (Object)oldInvoiceTaxAmount);
            }
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dyoList);
    }

    private static BigDecimal calTaxAmount(Boolean flag, BigDecimal originalAmount, BigDecimal oldCheckSumTaxAmount, BigDecimal sumtaxamount) {
        if (ADD_OP.equals(flag)) {
            if (null != oldCheckSumTaxAmount) {
                oldCheckSumTaxAmount = oldCheckSumTaxAmount.add(originalAmount);
            }
            if (null != oldCheckSumTaxAmount && sumtaxamount.compareTo(oldCheckSumTaxAmount) <= 0) {
                oldCheckSumTaxAmount = sumtaxamount;
            }
        } else if (DEL_OP.equals(flag)) {
            if (null != oldCheckSumTaxAmount) {
                oldCheckSumTaxAmount = oldCheckSumTaxAmount.subtract(originalAmount);
            }
            if (null != oldCheckSumTaxAmount && oldCheckSumTaxAmount.compareTo(BigDecimal.ZERO) < 0) {
                oldCheckSumTaxAmount = BigDecimal.ZERO;
            }
        }
        return oldCheckSumTaxAmount;
    }
}

